/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.hyperimage.client.HIWebServiceManagerInterface;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.HIClientGUI;

public abstract class HIRuntime {
    private static final String clientVersion = "3.1";
    private static final String minorRev = "9";
    public static boolean betaWarningDisplayed = true;
    public static final int MAX_GROUP_ITEMS = 100;
    public static final long MINIMUM_FREE_MEMORY = 0x500000L;
    public static boolean OAUTHMode = false;
    public static final Locale[] supportedLanguages = new Locale[]{new Locale("de"), new Locale("en")};
    private static Locale guiLanguage = supportedLanguages[0];
    private static HIWebServiceManagerInterface manager;
    private static HIClientGUI gui;
    private static String clipboard;

    public static void displayFatalErrorAndExit(String message) {
        JOptionPane.showMessageDialog(null, "FATAL ERROR!\n" + message, "HyperImage Client: Fatal Error", 0);
        System.out.println(message);
        System.exit(1);
    }

    public static HIClientGUI getGui() {
        return gui;
    }

    public static void setGui(HIClientGUI gui) {
        HIRuntime.gui = gui;
    }

    public static HIWebServiceManagerInterface getManager() {
        return manager;
    }

    public static void setManager(HIWebServiceManagerInterface manager) {
        HIRuntime.manager = manager;
    }

    public static void copyToClipboard(String contents) {
        clipboard = contents;
    }

    public static String pasteFromClipboard() {
        return clipboard;
    }

    public static void emptyClipboard() {
        clipboard = null;
    }

    public static boolean isClipboardEmpty() {
        if (clipboard == null) {
            return true;
        }
        return clipboard.length() == 0;
    }

    public static String getClientVersion() {
        return "3.1.9";
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file);
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static String getMD5HashString(byte[] inputData) {
        String hashString = "";
        char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(inputData);
            byte[] digest = md5.digest();
            int i = 0;
            while (i < digest.length) {
                int curNum = digest[i];
                if (curNum < 0) {
                    curNum += 256;
                }
                hashString = String.valueOf(hashString) + hexTable[curNum / 16] + hexTable[curNum % 16];
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("MD5 not supported by current Java VM!");
            System.exit(1);
        }
        return hashString;
    }

    public static int getModifierKey() {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") != -1) {
            return 4;
        }
        return 2;
    }

    public static Locale getGUILanguage() {
        return guiLanguage;
    }

    public static void setGUILanguage(Locale language) {
        guiLanguage = language;
        Messages.updateDefaultLanguage(language);
    }
}

