/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client;

import java.awt.Color;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.HIWebServiceManagerInterface;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.ImageHelper;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HIEditor;
import org.hyperimage.client.ws.HIEditorService;
import org.hyperimage.client.ws.HILogin;
import org.hyperimage.client.ws.HILoginService;
import org.hyperimage.client.ws.HIMaintenanceModeException_Exception;
import org.hyperimage.client.ws.HIParameterException_Exception;
import org.hyperimage.client.ws.HIServiceException_Exception;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiRepository;
import org.hyperimage.client.ws.HiRoles;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiUser;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HIWebServiceManager
implements HIWebServiceManagerInterface {
    private static final String minimumVersionID = "3.0.3";
    private HILoginService loginService;
    private HIEditorService editorService;
    private HILogin loginPort;
    private HIEditor editor;
    private W3CEndpointReference editorRef;
    private HiGroup importGroup = null;
    private HiGroup trashGroup = null;
    private HiProject project = null;
    private HiUser curUser = null;
    private List<HiGroup> projectTags = null;
    private Vector<Color> projectColors;
    private Vector<String> projectPolygons;
    private HashMap<Long, PlanarImage> thumbnailCache;
    private String username;
    private String password;
    private HiRoles curRole = null;
    private HIWebServiceManagerInterface.WSStates state = HIWebServiceManagerInterface.WSStates.OFFLINE;
    private String serverURL;

    public HIWebServiceManager(String serverURL) throws MalformedURLException {
        HIRuntime.setManager(this);
        this.thumbnailCache = new HashMap();
        this.projectColors = new Vector();
        this.projectPolygons = new Vector();
        if (!serverURL.endsWith("/")) {
            serverURL = String.valueOf(serverURL) + "/";
        }
        this.serverURL = serverURL;
        this.loginService = new HILoginService(new URL(String.valueOf(serverURL) + "HILoginService?WSDL"), new QName("http://ws.service.hyperimage.org/", "HILoginService"));
        this.loginPort = this.loginService.getHILoginPort();
        String versionID = this.loginPort.getVersionID();
        System.out.println("Server Version: " + versionID);
        if (versionID.compareTo(minimumVersionID) < 0) {
            JOptionPane.showMessageDialog(null, "FATAL ERROR: Server HI-WebService Version outdated!\n\nReported: " + versionID + "\nNeeded: " + minimumVersionID);
            System.exit(1);
        }
        this.editorService = new HIEditorService(new URL(String.valueOf(serverURL) + "HIEditorService?WSDL"), new QName("http://ws.service.hyperimage.org/", "HIEditorService"));
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public String getEndpointSession() {
        if (this.state == HIWebServiceManagerInterface.WSStates.ONLINE || this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(this.editorRef.toString().getBytes("UTF-8")));
                return doc.getElementsByTagName("jaxws:objectId").item(0).getTextContent();
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(HIWebServiceManager.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean login(String username, String password) throws HIWebServiceException {
        this.username = username;
        this.password = password;
        this.editor = null;
        this.curRole = null;
        this.thumbnailCache.clear();
        try {
            this.editorRef = this.loginPort.authenticate(username, password);
            if (this.editorRef != null) {
                this.editor = (HIEditor)this.editorService.getPort((EndpointReference)this.editorRef, HIEditor.class, new WebServiceFeature[0]);
            }
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        if (this.editor != null) {
            this.curUser = this.getUserByUserName(username);
            this.state = HIWebServiceManagerInterface.WSStates.ONLINE;
            return true;
        }
        return false;
    }

    @Override
    public boolean loginPR(String user, String token, String token_secret, String token_verifier) throws HIWebServiceException {
        this.username = "PR_" + user;
        this.password = "";
        this.editor = null;
        this.curRole = null;
        this.thumbnailCache.clear();
        try {
            this.editorRef = this.loginPort.authenticatePR(token, token_secret, token_verifier, user);
            if (this.editorRef != null) {
                this.editor = (HIEditor)this.editorService.getPort((EndpointReference)this.editorRef, HIEditor.class, new WebServiceFeature[0]);
            }
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        if (this.editor != null) {
            this.curUser = this.getUserByUserName(this.username);
            this.state = HIWebServiceManagerInterface.WSStates.ONLINE;
            return true;
        }
        return false;
    }

    @Override
    public HiUser getCurrentUser() {
        return this.curUser;
    }

    @Override
    public boolean reconnect() throws HIWebServiceException {
        try {
            this.editorRef = this.loginPort.authenticate(this.username, this.password);
            this.editor = (HIEditor)this.editorService.getPort((EndpointReference)this.editorRef, HIEditor.class, new WebServiceFeature[0]);
        }
        catch (HIParameterException_Exception e) {
            e.printStackTrace();
        }
        catch (HIMaintenanceModeException_Exception e) {
            throw new HIWebServiceException(e);
        }
        if (this.editor != null) {
            if (this.setProject(this.project)) {
                this.state = HIWebServiceManagerInterface.WSStates.IN_PROJECT;
                return true;
            }
            this.state = HIWebServiceManagerInterface.WSStates.OFFLINE;
            this.curUser = null;
            this.editor = null;
        }
        this.curUser = null;
        this.state = HIWebServiceManagerInterface.WSStates.OFFLINE;
        return false;
    }

    @Override
    public boolean logout() {
        this.importGroup = null;
        this.trashGroup = null;
        this.project = null;
        this.curRole = null;
        this.curUser = null;
        this.thumbnailCache.clear();
        this.state = HIWebServiceManagerInterface.WSStates.OFFLINE;
        if (this.editor == null) {
            return false;
        }
        return this.loginPort.logout(this.editorRef);
    }

    @Override
    public String getPPGLocation() {
        return this.loginPort.getPPGLocation();
    }

    @Override
    public HiProject getProject() {
        return this.project;
    }

    @Override
    public boolean setProject(HiProject project) throws HIWebServiceException {
        boolean success;
        block20: {
            try {
                String tempSortOrder;
                String projPolygons;
                int n;
                success = this.editor.setProject(project);
                if (!success) break block20;
                this.importGroup = this.editor.getImportGroup();
                this.trashGroup = this.editor.getTrashGroup();
                this.curRole = this.editor.getCurrentRole();
                this.thumbnailCache.clear();
                this.project = project;
                this.state = HIWebServiceManagerInterface.WSStates.IN_PROJECT;
                this.projectColors.removeAllElements();
                this.projectPolygons.removeAllElements();
                this.projectTags = null;
                String projColors = MetadataHelper.findPreferenceValue(project, "colors");
                if (projColors == null) {
                    projColors = this.createPreference("colors", "").getValue();
                }
                if (projColors.length() > 0) {
                    try {
                        String[] stringArray = projColors.split(":");
                        n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String color = stringArray[n2];
                            this.projectColors.addElement(new Color(Integer.parseInt(color.split(",")[0]), Integer.parseInt(color.split(",")[1]), Integer.parseInt(color.split(",")[2])));
                            ++n2;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing color pref!");
                        MetadataHelper.setPreferenceValue(project, "colors", "");
                        this.projectColors.removeAllElements();
                    }
                }
                if ((projPolygons = MetadataHelper.findPreferenceValue(project, "polygons")) == null) {
                    projPolygons = this.createPreference("polygons", "").getValue();
                }
                if (projPolygons.length() > 0) {
                    try {
                        String[] stringArray = projPolygons.split(":");
                        int n3 = stringArray.length;
                        n = 0;
                        while (n < n3) {
                            Object polygon = stringArray[n];
                            this.projectPolygons.addElement((String)polygon);
                            ++n;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing polygon pref!");
                        MetadataHelper.setPreferenceValue(project, "polygons", "");
                        this.projectPolygons.removeAllElements();
                    }
                }
                if ((tempSortOrder = MetadataHelper.findPreferenceValue(project, "templateSortOrder")) == null) {
                    HiFlexMetadataTemplate hiInternalTemplate = null;
                    for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
                        if (template.getNamespacePrefix().compareTo("HIInternal") != 0) continue;
                        hiInternalTemplate = template;
                    }
                    if (hiInternalTemplate != null) {
                        this.project.getTemplates().remove(hiInternalTemplate);
                        this.project.getTemplates().add(hiInternalTemplate);
                    }
                    String initSortOrder = "";
                    int i = 0;
                    while (i < this.project.getTemplates().size()) {
                        initSortOrder = String.valueOf(initSortOrder) + "," + this.project.getTemplates().get(i).getId();
                        ++i;
                    }
                    if (initSortOrder.length() > 0) {
                        initSortOrder = initSortOrder.substring(1);
                    }
                    tempSortOrder = this.createPreference("templateSortOrder", initSortOrder).getValue();
                }
                if (tempSortOrder.length() > 0) {
                    this.sortTemplates(tempSortOrder);
                }
                for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
                    this.sortTemplate(template);
                }
            }
            catch (HIServiceException_Exception e) {
                e.printStackTrace();
                return false;
            }
            catch (HIMaintenanceModeException_Exception e) {
                throw new HIWebServiceException(e);
            }
        }
        return success;
    }

    private void sortTemplates(String sortOrder) {
        if (this.project == null || sortOrder == null || sortOrder.length() == 0) {
            return;
        }
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String setIDString = stringArray[n2];
            try {
                long setID = Long.parseLong(setIDString);
                int setIndex = -1;
                int i = 0;
                while (i < this.project.getTemplates().size()) {
                    if (this.project.getTemplates().get(i).getId() == setID) {
                        setIndex = i;
                    }
                    ++i;
                }
                if (setIndex >= 0) {
                    if (setIndex != index) {
                        HiFlexMetadataTemplate template = this.project.getTemplates().get(setIndex);
                        this.project.getTemplates().remove(setIndex);
                        this.project.getTemplates().add(index, template);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private void sortTemplate(HiFlexMetadataTemplate template) {
        if (template == null || template.getSortOrder() == null) {
            return;
        }
        int index = 0;
        String[] stringArray = template.getSortOrder().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String setIDString = stringArray[n2];
            try {
                long setID = Long.parseLong(setIDString);
                int setIndex = -1;
                int i = 0;
                while (i < template.getEntries().size()) {
                    if (template.getEntries().get(i).getId() == setID) {
                        setIndex = i;
                    }
                    ++i;
                }
                if (setIndex >= 0) {
                    if (setIndex != index) {
                        HiFlexMetadataSet set = template.getEntries().get(setIndex);
                        template.getEntries().remove(setIndex);
                        template.getEntries().add(index, set);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    @Override
    public Vector<Color> getProjectColors() {
        return this.projectColors;
    }

    @Override
    public Vector<String> getProjectPolygons() {
        return this.projectPolygons;
    }

    @Override
    public HiRoles getCurrentRole() {
        return this.curRole;
    }

    @Override
    public HIEditor getWSPort() {
        return this.editor;
    }

    @Override
    public boolean isConnected() {
        return this.editor != null;
    }

    @Override
    public HiGroup getImportGroup() {
        return this.importGroup;
    }

    @Override
    public HiGroup getTrashGroup() {
        return this.trashGroup;
    }

    @Override
    public HIWebServiceManagerInterface.WSStates getState() {
        return this.state;
    }

    @Override
    public void setReconnect() {
        this.state = HIWebServiceManagerInterface.WSStates.RECONNECT;
    }

    public static byte[] getBytesFromFile(File file) {
        byte[] bytes = null;
        try {
            FileInputStream is = new FileInputStream(file);
            if (file.length() > Integer.MAX_VALUE) {
                throw new IOException("File too big!");
            }
            bytes = new byte[(int)file.length()];
            int numRead = ((InputStream)is).read(bytes);
            if (numRead < bytes.length) {
                throw new IOException("Error reading file!");
            }
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return bytes;
    }

    @Override
    public void refreshProject() throws HIWebServiceException {
        try {
            this.project = this.editor.getProject();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        String tempSortOrder = MetadataHelper.findPreferenceValue(this.project, "templateSortOrder");
        if (tempSortOrder != null) {
            this.sortTemplates(tempSortOrder);
        }
        for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
            this.sortTemplate(template);
        }
    }

    @Override
    public String getVersionID() throws HIWebServiceException {
        try {
            return this.editor.getVersionID();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    private String serializeProjectColorsPreference() {
        String colors = "";
        for (Color color : this.projectColors) {
            String colorString = String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
            colors = colors.length() == 0 ? colorString : String.valueOf(colors) + ":" + colorString;
        }
        return colors;
    }

    private String serializeProjectPolygonsPreference() {
        String polygons = "";
        for (String polygonString : this.projectPolygons) {
            polygons = polygons.length() == 0 ? polygonString : String.valueOf(polygons) + ":" + polygonString;
        }
        return polygons;
    }

    @Override
    public void addProjectColor(Color color) throws HIWebServiceException {
        for (Color projColor : this.projectColors) {
            if (projColor.getRed() != color.getRed() || projColor.getGreen() != color.getGreen() || projColor.getBlue() != color.getBlue()) continue;
            return;
        }
        this.projectColors.add(color);
        HiPreference colorPref = MetadataHelper.findPreference(this.project, "colors");
        colorPref.setValue(this.serializeProjectColorsPreference());
        this.updatePreference(colorPref);
    }

    @Override
    public void removeProjectColor(Color color) throws HIWebServiceException {
        Color foundColor = null;
        for (Color projColor : this.projectColors) {
            if (projColor.getRed() != color.getRed() || projColor.getGreen() != color.getGreen() || projColor.getBlue() != color.getBlue()) continue;
            foundColor = projColor;
        }
        if (foundColor == null) {
            return;
        }
        this.projectColors.remove(foundColor);
        HiPreference colorPref = MetadataHelper.findPreference(this.project, "colors");
        colorPref.setValue(this.serializeProjectColorsPreference());
        this.updatePreference(colorPref);
    }

    @Override
    public void updateProjectColors() throws HIWebServiceException {
        HiPreference colorPref = MetadataHelper.findPreference(this.project, "colors");
        colorPref.setValue(this.serializeProjectColorsPreference());
        this.updatePreference(colorPref);
    }

    @Override
    public void addProjectPolygon(String polygonModel) throws HIWebServiceException {
        if (polygonModel.length() > 0) {
            polygonModel = String.valueOf(RelativePolygon.getModelType(RelativePolygon.HiPolygonTypes.HI_USERDESIGN)) + polygonModel.substring(1);
        }
        for (String polygon : this.projectPolygons) {
            if (polygon.compareTo(polygonModel) != 0) continue;
            return;
        }
        this.projectPolygons.add(polygonModel);
        HiPreference polygonPref = MetadataHelper.findPreference(this.project, "polygons");
        polygonPref.setValue(this.serializeProjectPolygonsPreference());
        this.updatePreference(polygonPref);
    }

    @Override
    public void removeProjectPolygon(String polygonModel) throws HIWebServiceException {
        if (polygonModel.length() > 0) {
            polygonModel = String.valueOf(RelativePolygon.getModelType(RelativePolygon.HiPolygonTypes.HI_USERDESIGN)) + polygonModel.substring(1);
        }
        String foundPolygon = null;
        for (String polygon : this.projectPolygons) {
            if (polygon.compareTo(polygonModel) != 0) continue;
            foundPolygon = polygon;
        }
        if (foundPolygon == null) {
            return;
        }
        this.projectPolygons.remove(foundPolygon);
        HiPreference polygonPref = MetadataHelper.findPreference(this.project, "polygons");
        polygonPref.setValue(this.serializeProjectPolygonsPreference());
        this.updatePreference(polygonPref);
    }

    @Override
    public byte[] getImageAsBitstream(HiView view, HiImageSizes size) throws HIWebServiceException {
        try {
            return this.editor.getImage(view.getId(), size);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public PlanarImage getImage(HiView view, HiImageSizes size) throws HIWebServiceException {
        return this.getImage(view.getId(), size, true);
    }

    @Override
    public PlanarImage getImage(HiQuickInfo info, HiImageSizes size) throws HIWebServiceException {
        PlanarImage image = null;
        if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
            image = this.getImage(info.getRelatedID(), size, true);
        } else if (info.getContentType() == HiBaseTypes.HI_VIEW) {
            image = this.getImage(info.getBaseID(), size, true);
        } else if (info.getContentType() == HiBaseTypes.HI_LAYER) {
            image = this.getImage(info.getBaseID(), size, false);
        }
        return image;
    }

    @Override
    public PlanarImage getImage(long viewID, HiImageSizes size, boolean cacheImage) throws HIWebServiceException {
        PlanarImage image = null;
        if (size == HiImageSizes.HI_THUMBNAIL) {
            image = this.thumbnailCache.get(viewID);
        }
        if (image == null) {
            try {
                image = ImageHelper.convertByteArrayToPlanarImage(this.editor.getImage(viewID, size));
                if (size == HiImageSizes.HI_THUMBNAIL && cacheImage) {
                    this.thumbnailCache.put(viewID, image);
                }
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        return image;
    }

    @Override
    public RenderableImage getRenderableImage(long viewID) throws HIWebServiceException {
        RenderableImage image = null;
        try {
            image = ImageHelper.convertByteArrayToRenderableImage(this.editor.getImage(viewID, HiImageSizes.HI_FULL));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        return image;
    }

    @Override
    public HiPreference createPreference(String key, String value) throws HIWebServiceException {
        try {
            HiPreference pref = this.editor.createPreference(key, value);
            if (this.project != null) {
                this.project.getPreferences().add(pref);
            }
            return pref;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updatePreference(long prefID, String value) throws HIWebServiceException {
        HiPreference projPref;
        block7: {
            if (this.project == null) {
                return false;
            }
            try {
                projPref = null;
                for (HiPreference pref : this.project.getPreferences()) {
                    if (pref.getId() != prefID) continue;
                    projPref = pref;
                }
                if (projPref != null) break block7;
                return false;
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        boolean prefUpdated = this.editor.updatePreference(prefID, value);
        if (prefUpdated) {
            projPref.setValue(value);
            if (projPref.getKey().compareTo("templateSortOrder") == 0) {
                this.sortTemplates(value);
            }
        }
        return prefUpdated;
    }

    @Override
    public boolean updatePreference(HiPreference pref) throws HIWebServiceException {
        return this.updatePreference(pref.getId(), pref.getValue());
    }

    @Override
    public boolean deletePreference(long prefID) throws HIWebServiceException {
        HiPreference projPref;
        block6: {
            if (this.project == null) {
                return false;
            }
            try {
                projPref = null;
                for (HiPreference pref : this.project.getPreferences()) {
                    if (pref.getId() != prefID) continue;
                    projPref = pref;
                }
                if (projPref != null) break block6;
                return false;
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        boolean prefDeleted = this.editor.deletePreference(prefID);
        if (prefDeleted) {
            this.project.getPreferences().remove(projPref);
        }
        return prefDeleted;
    }

    @Override
    public boolean deletePreference(HiPreference pref) throws HIWebServiceException {
        return this.deletePreference(pref.getId());
    }

    @Override
    public boolean addLanguageToProject(String language) throws HIWebServiceException {
        try {
            boolean languageAdded = this.editor.adminAddLanguageToProject(language);
            if (languageAdded) {
                this.project = this.editor.getProject();
            }
            return languageAdded;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeLanguageFromProject(String language) throws HIWebServiceException {
        try {
            boolean languageRemoved = this.editor.adminRemoveLanguageFromProject(language);
            if (languageRemoved) {
                this.project = this.editor.getProject();
            }
            return languageRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiRepository> getRepositories() throws HIWebServiceException {
        List<HiRepository> repositories = null;
        try {
            repositories = this.editor.getRepositories();
            return repositories;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiRepository createRepository(HiRepository newRepository) throws HIWebServiceException {
        HiRepository userRepos = null;
        try {
            userRepos = this.editor.adminCreateRepository(newRepository);
            return userRepos;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteRepository(HiRepository repository) throws HIWebServiceException {
        try {
            return this.editor.adminDeleteRepository(repository);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addTemplateToProject(HiFlexMetadataTemplate template) throws HIWebServiceException {
        try {
            boolean templateAdded = this.editor.adminAddTemplateToProject(template);
            if (templateAdded) {
                this.refreshProject();
            }
            return templateAdded;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateTemplate(HiFlexMetadataTemplate template, String templateURI, String templateURL) throws HIWebServiceException {
        try {
            boolean templateUpdated = this.editor.adminUpdateTemplate(template.getId(), templateURI, templateURL);
            if (templateUpdated) {
                this.refreshProject();
            }
            return templateUpdated;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateTemplateSortOrder(HiFlexMetadataTemplate template, String sortOrder) throws HIWebServiceException {
        try {
            boolean templateUpdated = this.editor.adminUpdateTemplateSortOrder(template.getId(), sortOrder);
            if (templateUpdated) {
                this.refreshProject();
            }
            return templateUpdated;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeTemplateFromProject(HiFlexMetadataTemplate template) throws HIWebServiceException {
        if (template == null) {
            return false;
        }
        try {
            boolean templateRemoved = this.editor.adminRemoveTemplateFromProject(template.getId());
            if (templateRemoved) {
                this.refreshProject();
            }
            return templateRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiFlexMetadataSet addSetToTemplate(HiFlexMetadataTemplate template, String tagName, boolean isRichText) throws HIWebServiceException {
        if (template == null) {
            return null;
        }
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        try {
            HiFlexMetadataSet newSet = this.editor.adminAddSetToTemplate(template.getId(), tagName, isRichText);
            if (newSet != null) {
                this.refreshProject();
                return newSet;
            }
            return null;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeSetFromTemplate(HiFlexMetadataTemplate template, HiFlexMetadataSet set) throws HIWebServiceException {
        if (template == null) {
            return false;
        }
        if (set == null) {
            return false;
        }
        try {
            boolean setRemoved = this.editor.adminRemoveSetFromTemplate(template.getId(), set.getId());
            if (setRemoved) {
                this.refreshProject();
            }
            return setRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiFlexMetadataName createSetDisplayName(HiFlexMetadataSet set, String lang, String displayName) throws HIWebServiceException {
        if (set == null) {
            return null;
        }
        if (lang == null || lang.length() == 0) {
            return null;
        }
        try {
            HiFlexMetadataName newName = this.editor.adminCreateSetDisplayName(set.getId(), lang, displayName);
            if (newName != null) {
                this.refreshProject();
                return newName;
            }
            return null;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateSetDisplayName(HiFlexMetadataSet set, String lang, String displayName) throws HIWebServiceException {
        if (set == null) {
            return;
        }
        if (lang == null || lang.length() == 0) {
            return;
        }
        try {
            this.editor.adminUpdateSetDisplayName(set.getId(), lang, displayName);
            this.refreshProject();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addUserToProject(long userID, HiRoles role) throws HIWebServiceException {
        try {
            return this.editor.adminAddUserToProject(userID, role);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addUserToProject(HiUser user, HiRoles role) throws HIWebServiceException {
        return this.addUserToProject(user.getId(), role);
    }

    @Override
    public boolean addUserToProject(long userID, long projectID, HiRoles role) throws HIWebServiceException {
        if (this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT && this.project.getId() == projectID) {
            return this.addUserToProject(userID, role);
        }
        try {
            return this.editor.sysopAddUserToProject(userID, projectID, role);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addUserToProject(HiUser user, HiProject project, HiRoles role) throws HIWebServiceException {
        if (this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT && this.project.getId() == project.getId()) {
            return this.addUserToProject(user.getId(), role);
        }
        return this.addUserToProject(user.getId(), project.getId(), role);
    }

    @Override
    public HiUser getUserByID(long userID) throws HIWebServiceException {
        try {
            return this.editor.adminGetUserByID(userID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiUser getUserByUserName(String userName) throws HIWebServiceException {
        try {
            return this.editor.adminGetUserByUserName(userName);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeUserFromProject(long userID) throws HIWebServiceException {
        try {
            boolean userRemoved = this.editor.adminRemoveUserFromProject(userID);
            if (userRemoved && userID == this.curUser.getId()) {
                this.state = HIWebServiceManagerInterface.WSStates.ONLINE;
                this.importGroup = null;
                this.trashGroup = null;
                this.project = null;
                this.curRole = null;
                this.thumbnailCache.clear();
            }
            return userRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeUserFromProject(HiUser user) throws HIWebServiceException {
        return this.removeUserFromProject(user.getId());
    }

    @Override
    public boolean removeUserFromProject(long userID, long projectID) throws HIWebServiceException {
        if (this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT && this.project.getId() == projectID) {
            return this.removeUserFromProject(userID);
        }
        try {
            return this.editor.sysopRemoveUserFromProject(userID, projectID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeUserFromProject(HiUser user, HiProject project) throws HIWebServiceException {
        return this.removeUserFromProject(user.getId(), project.getId());
    }

    @Override
    public boolean setProjectRole(long userID, HiRoles role) throws HIWebServiceException {
        try {
            boolean roleSet = this.editor.adminSetProjectRole(userID, role);
            if (roleSet && userID == this.curUser.getId()) {
                this.curRole = role;
            }
            return roleSet;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean setProjectRole(HiUser user, HiRoles role) throws HIWebServiceException {
        return this.setProjectRole(user.getId(), role);
    }

    @Override
    public boolean removeFromGroup(long baseID, long groupID) throws HIWebServiceException {
        try {
            return this.editor.removeFromGroup(baseID, groupID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeFromGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        return this.removeFromGroup(base.getId(), group.getId());
    }

    @Override
    public boolean copyToGroup(long baseID, long groupID) throws HIWebServiceException {
        try {
            return this.editor.copyToGroup(baseID, groupID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean copyToGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        return this.copyToGroup(base.getId(), group.getId());
    }

    @Override
    public boolean addToGroup(long baseID, long groupID) throws HIWebServiceException {
        return this.copyToGroup(baseID, groupID);
    }

    @Override
    public boolean addToGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        return this.copyToGroup(base.getId(), group.getId());
    }

    @Override
    public HiFlexMetadataRecord createFlexMetadataRecord(long baseID, String language) throws HIWebServiceException {
        try {
            return this.editor.createFlexMetadataRecord(baseID, language);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiFlexMetadataRecord createFlexMetadataRecord(HiBase base, String language) throws HIWebServiceException {
        return this.createFlexMetadataRecord(base.getId(), language);
    }

    @Override
    public HiGroup createGroup() throws HIWebServiceException {
        return this.createGroup(null);
    }

    @Override
    public HiGroup createGroup(String uuid) throws HIWebServiceException {
        try {
            return this.editor.createGroup(uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiGroup> getTags() throws HIWebServiceException {
        if (this.projectTags == null) {
            try {
                this.projectTags = this.editor.getTagGroups();
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        return this.projectTags;
    }

    @Override
    public ArrayList<HiGroup> getTagsForBaseElement(long baseID) throws HIWebServiceException {
        List<Long> baseTagIDs;
        ArrayList<HiGroup> baseTags = new ArrayList<HiGroup>();
        if (this.projectTags == null) {
            this.getTags();
        }
        try {
            baseTagIDs = this.editor.getTagIDsForBase(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        for (Long tagID : baseTagIDs) {
            for (HiGroup tag : this.projectTags) {
                if (tag.getId() != tagID.longValue()) continue;
                baseTags.add(tag);
            }
        }
        return baseTags;
    }

    @Override
    public ArrayList<HiGroup> getTagsForBaseElement(HiBase base) throws HIWebServiceException {
        return this.getTagsForBaseElement(base.getId());
    }

    @Override
    public long getTagCountForElement(long baseID) throws HIWebServiceException {
        if (this.projectTags == null) {
            this.getTags();
        }
        try {
            return this.editor.getTagCountForBase(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public long getTagCountForElement(HiBase base) throws HIWebServiceException {
        return this.getTagCountForElement(base.getId());
    }

    @Override
    public HiGroup createTagGroup() throws HIWebServiceException {
        return this.createTagGroup(null);
    }

    @Override
    public HiGroup createTagGroup(String uuid) throws HIWebServiceException {
        try {
            HiGroup newTag = this.editor.createTagGroup(uuid);
            if (newTag != null && this.projectTags != null) {
                this.projectTags.add(newTag);
            }
            return newTag;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiInscription createInscription(long objectID) throws HIWebServiceException {
        return this.createInscription(objectID, null);
    }

    @Override
    public HiInscription createInscription(long objectID, String uuid) throws HIWebServiceException {
        try {
            return this.editor.createInscription(objectID, uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiInscription createInscription(HiObject object, String uuid) throws HIWebServiceException {
        return this.createInscription(object.getId(), uuid);
    }

    @Override
    public HiInscription createInscription(HiObject object) throws HIWebServiceException {
        return this.createInscription(object.getId());
    }

    @Override
    public HiLayer createLayer(long viewID, int red, int green, int blue, float opacity) throws HIWebServiceException {
        return this.createLayer(viewID, red, green, blue, opacity, null);
    }

    @Override
    public HiLayer createLayer(long viewID, int red, int green, int blue, float opacity, String uuid) throws HIWebServiceException {
        try {
            return this.editor.createLayer(viewID, red, green, blue, opacity, uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiLayer createLayer(HiView view, int red, int green, int blue, float opacity, String uuid) throws HIWebServiceException {
        return this.createLayer(view.getId(), red, green, blue, opacity, uuid);
    }

    @Override
    public HiLayer createLayer(HiView view, int red, int green, int blue, float opacity) throws HIWebServiceException {
        return this.createLayer(view.getId(), red, green, blue, opacity);
    }

    @Override
    public boolean setLayerLink(long layerID, long linkID) throws HIWebServiceException {
        try {
            return this.editor.setLayerLink(layerID, linkID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean setLayerLink(HiLayer layer, HiBase link) throws HIWebServiceException {
        return this.setLayerLink(layer.getId(), link.getId());
    }

    @Override
    public boolean removeLayerLink(long layerID) throws HIWebServiceException {
        try {
            return this.editor.removeLayerLink(layerID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeLayerLink(HiLayer layer) throws HIWebServiceException {
        return this.removeLayerLink(layer.getId());
    }

    @Override
    public HiObject createObject() throws HIWebServiceException {
        return this.createObject(null);
    }

    @Override
    public HiObject createObject(String uuid) throws HIWebServiceException {
        try {
            return this.editor.createObject(uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiText createText() throws HIWebServiceException {
        return this.createText(null);
    }

    @Override
    public HiText createText(String uuid) throws HIWebServiceException {
        try {
            return this.editor.createText(uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiLightTable createLightTable(String title, String xml) throws HIWebServiceException {
        return this.createLightTable(title, xml, null);
    }

    @Override
    public HiLightTable createLightTable(String title, String xml, String uuid) throws HIWebServiceException {
        try {
            return this.editor.createLightTable(title, xml, uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateLightTable(HiLightTable lightTable) throws HIWebServiceException {
        try {
            return this.editor.updateLightTable(lightTable);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public Hiurl createURL(String url, String title, String lastAccess) throws HIWebServiceException {
        return this.createURL(url, title, lastAccess, null);
    }

    @Override
    public Hiurl createURL(String url, String title, String lastAccess, String uuid) throws HIWebServiceException {
        try {
            return this.editor.createURL(url, title, lastAccess, uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, byte[] data) throws HIWebServiceException {
        return this.createView(objectID, filename, repositoryIDString, data, null);
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, byte[] data, String uuid) throws HIWebServiceException {
        try {
            return this.editor.createView(objectID, filename, repositoryIDString, data, uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiView createView(HiObject object, String filename, String repositoryIDString, byte[] data, String uuid) throws HIWebServiceException {
        return this.createView(object.getId(), filename, repositoryIDString, data, uuid);
    }

    @Override
    public HiView createView(HiObject object, File file) throws HIWebServiceException {
        return this.createView(object, file, null);
    }

    @Override
    public HiView createView(HiObject object, File file, String uuid) throws HIWebServiceException {
        byte[] data = HIWebServiceManager.getBytesFromFile(file);
        return this.createView(object.getId(), file.getName(), "[HIEditor 3.0 - Direct Import]", data, uuid);
    }

    @Override
    public boolean updateContentOwner(long objectID, long contentID) throws HIWebServiceException {
        try {
            return this.editor.updateContentOwner(objectID, contentID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateContentOwner(HiObject object, HiObjectContent content) throws HIWebServiceException {
        if (this.updateContentOwner(object.getId(), content.getId())) {
            object.getViews().add(content);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteFromProject(long baseID) throws HIWebServiceException {
        try {
            boolean success = this.editor.deleteFromProject(baseID);
            if (success && this.project.getStartObjectInfo() != null && this.project.getStartObjectInfo().getBaseID() == baseID) {
                this.project.setStartObjectInfo(null);
            }
            return success;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteFromProject(HiBase base) throws HIWebServiceException {
        return this.deleteFromProject(base.getId());
    }

    @Override
    public boolean deleteGroup(long groupID) throws HIWebServiceException {
        try {
            return this.editor.deleteGroup(groupID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteGroup(HiGroup group) throws HIWebServiceException {
        boolean success = this.deleteGroup(group.getId());
        if (success && group.getType() == GroupTypes.HIGROUP_TAG && this.projectTags != null) {
            this.projectTags.remove(group);
        }
        return success;
    }

    @Override
    public HiBase getBaseElement(String uuid) throws HIWebServiceException {
        try {
            return this.editor.getBaseElementByUUID(uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiBase getBaseElement(long baseID) throws HIWebServiceException {
        try {
            return this.editor.getBaseElement(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiBase getBaseElement(HiBase base) throws HIWebServiceException {
        return this.getBaseElement(base.getId());
    }

    @Override
    public List<HiText> getProjectTextElements() throws HIWebServiceException {
        try {
            return this.editor.getProjectTextElements();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiLightTable> getProjectLightTableElements() throws HIWebServiceException {
        try {
            return this.editor.getProjectLightTableElements();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(long baseID) throws HIWebServiceException {
        try {
            return this.editor.getBaseQuickInfo(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(HiBase base) throws HIWebServiceException {
        return this.getBaseQuickInfo(base.getId());
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(String uuid) throws HIWebServiceException {
        try {
            return this.editor.getBaseQuickInfoByUUID(uuid);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiQuickInfo getContentInfo(HiQuickInfo content) throws HIWebServiceException {
        return this.getBaseQuickInfo(content.getBaseID());
    }

    @Override
    public List<HiQuickInfo> getGroupContentQuickInfo(long groupID) throws HIWebServiceException {
        try {
            return this.editor.getGroupContentQuickInfo(groupID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiQuickInfo> getGroupContents(HiGroup group) throws HIWebServiceException {
        return this.getGroupContentQuickInfo(group.getId());
    }

    @Override
    public List<HiGroup> getGroups() throws HIWebServiceException {
        try {
            return this.sortGroups(this.editor.getGroups());
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    private List<HiGroup> sortGroups(List<HiGroup> groups) {
        int index = 0;
        String[] stringArray = MetadataHelper.findPreferenceValue(this.getProject(), "groupSortOrder").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < groups.size()) {
                    if (groups.get(i).getId() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiGroup group = groups.get(contentIndex);
                        groups.remove(contentIndex);
                        groups.add(index, group);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        return groups;
    }

    @Override
    public List<HiProject> getProjects() throws HIWebServiceException {
        try {
            return this.editor.getProjects();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean moveToGroup(long baseID, long fromGroupID, long toGroupID) throws HIWebServiceException {
        try {
            return this.editor.moveToGroup(baseID, fromGroupID, toGroupID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean moveToGroup(HiBase base, HiGroup fromGroup, HiGroup toGroup) throws HIWebServiceException {
        return this.moveToGroup(base.getId(), fromGroup.getId(), toGroup.getId());
    }

    @Override
    public boolean moveToTrash(long baseID) throws HIWebServiceException {
        try {
            return this.editor.moveToTrash(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean moveToTrash(HiBase base) throws HIWebServiceException {
        return this.moveToTrash(base.getId());
    }

    @Override
    public boolean removeLayer(long layerID) throws HIWebServiceException {
        try {
            return this.editor.removeLayer(layerID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeLayer(HiLayer layer) throws HIWebServiceException {
        return this.removeLayer(layer.getId());
    }

    @Override
    public boolean setDefaultView(long objectID, long contentID) throws HIWebServiceException {
        try {
            return this.editor.setDefaultView(objectID, contentID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean setDefaultView(HiObject object, HiObjectContent content) throws HIWebServiceException {
        return this.setDefaultView(object.getId(), content.getId());
    }

    @Override
    public boolean updateFlexMetadataRecord(HiFlexMetadataRecord record) throws HIWebServiceException {
        try {
            return this.editor.updateFlexMetadataRecord(record);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiFlexMetadataRecord> getFlexMetadataRecords(long baseID) throws HIWebServiceException {
        try {
            return this.editor.getFlexMetadataRecords(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiFlexMetadataRecord> getFlexMetadataRecords(HiBase base) throws HIWebServiceException {
        return this.getFlexMetadataRecords(base.getId());
    }

    @Override
    public boolean updateFlexMetadataRecords(List<HiFlexMetadataRecord> records) throws HIWebServiceException {
        try {
            return this.editor.updateFlexMetadataRecords(records);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateGroupProperties(long groupID, boolean visible) throws HIWebServiceException {
        try {
            return this.editor.updateGroupProperties(groupID, visible);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateGroupProperties(HiGroup group, boolean visible) throws HIWebServiceException {
        return this.updateGroupProperties(group.getId(), visible);
    }

    @Override
    public void updateGroupSortOrder(long groupID, String sortOrder) throws HIWebServiceException {
        try {
            this.editor.updateGroupSortOrder(groupID, sortOrder);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateGroupSortOrder(HiGroup group, String sortOrder) throws HIWebServiceException {
        this.updateGroupSortOrder(group.getId(), sortOrder);
        group.setSortOrder(sortOrder);
    }

    @Override
    public boolean updateLayerProperties(long layerID, int red, int green, int blue, float opacity, String polygons) throws HIWebServiceException {
        try {
            return this.editor.updateLayerProperties(layerID, red, green, blue, opacity, polygons);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateLayerProperties(HiLayer layer, int red, int green, int blue, float opacity, String polygons) throws HIWebServiceException {
        return this.updateLayerProperties(layer.getId(), red, green, blue, opacity, polygons);
    }

    @Override
    public void updateViewSortOrder(long viewID, String sortOrder) throws HIWebServiceException {
        try {
            this.editor.updateViewSortOrder(viewID, sortOrder);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateViewSortOrder(HiView view, String sortOrder) throws HIWebServiceException {
        this.updateViewSortOrder(view.getId(), sortOrder);
        view.setSortOrder(sortOrder);
    }

    @Override
    public void updateObjectSortOrder(long objectID, String sortOrder) throws HIWebServiceException {
        try {
            this.editor.updateObjectSortOrder(objectID, sortOrder);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateObjectSortOrder(HiObject object, String sortOrder) throws HIWebServiceException {
        this.updateObjectSortOrder(object.getId(), sortOrder);
        object.setSortOrder(sortOrder);
    }

    @Override
    public boolean updateProject(String languageID, String title) throws HIWebServiceException {
        try {
            boolean updated = this.editor.updateProjectMetadata(languageID, title);
            if (updated) {
                this.project = this.editor.getProject();
            }
            return updated;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateProjectStartElement(long baseID) throws HIWebServiceException {
        try {
            boolean success = this.editor.updateProjectStartElement(baseID);
            if (success) {
                this.project = this.editor.getProject();
            }
            return success;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateProjectStartElement(HiBase base) throws HIWebServiceException {
        return this.updateProjectStartElement(base.getId());
    }

    @Override
    public boolean updateProjectDefaultLanguage(String language) throws HIWebServiceException {
        try {
            boolean success = this.editor.updateProjectDefaultLanguage(language);
            if (success) {
                this.project = this.editor.getProject();
            }
            return success;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateURL(Hiurl url) throws HIWebServiceException {
        try {
            return this.editor.updateURL(url);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void removeDefaultView(long objectID) throws HIWebServiceException {
        try {
            this.editor.removeDefaultView(objectID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void removeDefaultView(HiObject object) throws HIWebServiceException {
        this.removeDefaultView(object.getId());
    }

    @Override
    public boolean updateUser(long userID, String firstName, String lastName, String email) throws HIWebServiceException {
        try {
            return this.editor.updateUser(userID, firstName, lastName, email);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateUser(HiUser user, String firstName, String lastName, String email) throws HIWebServiceException {
        return this.updateUser(user.getId(), firstName, lastName, email);
    }

    @Override
    public boolean updateUser(String firstName, String lastName, String email) throws HIWebServiceException {
        return this.updateUser(this.curUser.getId(), firstName, lastName, email);
    }

    @Override
    public boolean updateUser(HiUser user) throws HIWebServiceException {
        return this.updateUser(user.getId(), user.getFirstName(), user.getLastName(), user.getEmail());
    }

    @Override
    public boolean updateUserPassword(long userID, String password) throws HIWebServiceException {
        try {
            return this.editor.updateUserPassword(userID, password);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateUserPassword(HiUser user, String password) throws HIWebServiceException {
        return this.updateUserPassword(user.getId(), password);
    }

    @Override
    public boolean updatePassword(String password) throws HIWebServiceException {
        return this.updateUserPassword(this.curUser.getId(), password);
    }

    @Override
    public HiProject createProject(String adminUsername, String defaultLanguage) throws HIWebServiceException {
        try {
            return this.editor.sysopCreateProject(adminUsername, defaultLanguage);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiProject createProject(HiUser adminUser, String defaultLanguage) throws HIWebServiceException {
        return this.createProject(adminUser.getUserName(), defaultLanguage);
    }

    @Override
    public void updateProjectQuota(long projectID, long quota) throws HIWebServiceException {
        try {
            this.editor.sysopUpdateProjectQuota(projectID, quota);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateProjectQuota(HiProject project, long quota) throws HIWebServiceException {
        this.updateProjectQuota(project.getId(), quota);
    }

    @Override
    public HiUser createUser(String firstName, String lastName, String userName, String password, String email) throws HIWebServiceException {
        try {
            return this.editor.sysopCreateUser(firstName, lastName, userName, password, email);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiRoles getRoleInProject(long userID, long projectID) throws HIWebServiceException {
        try {
            return this.editor.adminGetRoleInProject(userID, projectID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiRoles getRoleInProject(HiUser user, HiProject project) throws HIWebServiceException {
        return this.getRoleInProject(user.getId(), project.getId());
    }

    @Override
    public boolean deleteProject(long projectID) throws HIWebServiceException {
        try {
            return this.editor.sysopDeleteProject(projectID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteProject(HiProject project) throws HIWebServiceException {
        return this.deleteProject(project.getId());
    }

    @Override
    public boolean deleteUser(long userID) throws HIWebServiceException {
        try {
            return this.editor.sysopDeleteUser(userID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteUser(HiUser user) throws HIWebServiceException {
        return this.deleteUser(user.getId());
    }

    @Override
    public List<HiProject> getProjectsForUser(long userID) throws HIWebServiceException {
        if (userID == this.curUser.getId()) {
            return this.getProjects();
        }
        try {
            return this.editor.sysopGetProjectsForUser(userID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiProject> getProjectsForUser(HiUser user) throws HIWebServiceException {
        if (user.getId() == this.curUser.getId()) {
            return this.getProjects();
        }
        return this.getProjectsForUser(user.getId());
    }

    @Override
    public List<HiProject> getProjects(HiUser user) throws HIWebServiceException {
        if (user.getId() == this.curUser.getId()) {
            return this.getProjects();
        }
        return this.getProjectsForUser(user);
    }

    @Override
    public List<HiUser> getUsers() throws HIWebServiceException {
        try {
            return this.editor.sysopGetUsers();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsersAsAdmin() throws HIWebServiceException {
        try {
            return this.editor.adminGetUsers();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getProjectUsers() throws HIWebServiceException {
        try {
            return this.editor.adminGetProjectUsers();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsersForProject(long projectID) throws HIWebServiceException {
        try {
            return this.editor.sysopGetUsersForProject(projectID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsersForProject(HiProject project) throws HIWebServiceException {
        return this.getUsersForProject(project.getId());
    }

    @Override
    public List<HiQuickInfo> simpleSearch(String text, String language) throws HIWebServiceException {
        try {
            return this.editor.simpleSearch(text, language);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiQuickInfo> fieldSearch(List<String> fields, List<String> contents, String language) throws HIWebServiceException {
        try {
            return this.editor.fieldSearch(fields, contents, language);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void rebuildSearchIndex() throws HIWebServiceException {
        try {
            this.editor.rebuildSearchIndex();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, File uploadFile, String uuid) throws HIWebServiceException {
        return null;
    }

    @Override
    public boolean deleteTagGroup(long tagID) throws HIWebServiceException {
        return false;
    }

    @Override
    public boolean deleteTagGroup(HiGroup tag) throws HIWebServiceException {
        return false;
    }

    @Override
    public String getClientVersionID() throws HIWebServiceException {
        return null;
    }
}

