/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.YendaLegacyBridgeManager;
import org.hyperimage.client.gui.HIClientGUI;
import org.hyperimage.client.gui.dialogs.ServerSelectionDialog;

public class Main {
    public static boolean SECURE = false;
    public static final File HYPERDIR = new File(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".hyperimage");
    public static final String CACERTS = "hyper_cacerts.jks";
    public static final File KEYSTORE_TGT = new File(HYPERDIR.getAbsoluteFile() + System.getProperty("file.separator") + "hyper_cacerts.jks");
    public static final String KEYSTORE_SRC = new String("/resources/security/hyper_cacerts.jks");
    public static final String KEYSTORE_PASSWD = new String("changeit");
    public static boolean isYendaBridge = false;
    public static String serverURL = "";

    private static void chooseServer() {
        Frame frame = new Frame();
        ServerSelectionDialog svrDlg = new ServerSelectionDialog(frame, true);
        svrDlg.setTitle(Messages.getString("ServerDialog.chooseserver"));
        svrDlg.setLocationRelativeTo(frame);
        svrDlg.setVisible(true);
        serverURL = svrDlg.getURL();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            isYendaBridge = true;
            Main.chooseServer();
        } else if (args[0].equalsIgnoreCase("-yenda") && args.length > 1) {
            isYendaBridge = true;
            serverURL = args[1];
        } else {
            serverURL = args[0];
        }
        SECURE = serverURL.toLowerCase().startsWith("https://") && !SECURE;
        if (SECURE) {
            if (!HYPERDIR.exists()) {
                HYPERDIR.mkdir();
            }
            if (!KEYSTORE_TGT.exists()) {
                InputStream input = Main.class.getResourceAsStream(KEYSTORE_SRC);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(KEYSTORE_TGT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int ch = 0;
                do {
                    try {
                        ch = input.read();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (ch == -1) continue;
                    try {
                        out.write(ch);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } while (ch != -1);
                try {
                    input.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.setProperty("javax.net.ssl.trustStore", KEYSTORE_TGT.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", KEYSTORE_PASSWD);
        }
        System.out.println("Client Version: " + HIRuntime.getClientVersion());
        System.out.println("Server URL: " + serverURL);
        System.out.println("Secure Connection: " + SECURE);
        System.out.println("Yenda Bridge Connection: " + isYendaBridge);
        try {
            if (!serverURL.endsWith("/")) {
                serverURL = String.valueOf(serverURL) + "/";
            }
            serverURL = String.valueOf(serverURL) + "api/legacy/";
            YendaLegacyBridgeManager manager = new YendaLegacyBridgeManager(serverURL);
            HIRuntime.setManager(manager);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HIClientGUI gui = new HIClientGUI();
                    gui.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                HIRuntime.displayFatalErrorAndExit("Network connection failed!\n\nCould not reach server at:\n" + serverURL);
            }
            HIRuntime.displayFatalErrorAndExit("Client Initialization Failed!\n\nReason:" + e.getMessage() + "\n\n" + e.getClass());
        }
    }
}

