/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client;

import java.awt.Color;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.swing.JOptionPane;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.GenericType;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.HIWebServiceManagerInterface;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.util.ImageHelper;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HIEditor;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiRepository;
import org.hyperimage.client.ws.HiRoles;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiUser;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.hyperimage.connector.yenda.YLBaseClientREST;
import org.hyperimage.connector.yenda.YLGroupClientREST;
import org.hyperimage.connector.yenda.YLImageClientREST;
import org.hyperimage.connector.yenda.YLProjectClientREST;
import org.hyperimage.connector.yenda.YLUserClientREST;
import org.hyperimage.connector.yenda.YendaClientREST;
import org.hyperimage.connector.yenda.YendaVersionInfo;

public class YendaHIWebServiceManager
implements HIWebServiceManagerInterface {
    private static final String minimumVersionID = "1.0.0";
    private HiGroup importGroup = null;
    private HiGroup trashGroup = null;
    private HiProject project = null;
    private HiUser curUser = null;
    private List<HiGroup> projectTags = null;
    private Vector<Color> projectColors;
    private Vector<String> projectPolygons;
    private HashMap<Long, PlanarImage> thumbnailCache;
    private String username;
    private String password;
    private HiRoles curRole = null;
    private HIWebServiceManagerInterface.WSStates state = HIWebServiceManagerInterface.WSStates.OFFLINE;
    private String serverURL;
    private YendaClientREST editorService;
    private YLUserClientREST yluserService;
    private YLProjectClientREST ylprojectService;
    private YLGroupClientREST ylgroupService;
    private YLImageClientREST ylimageService;
    private YLBaseClientREST ylbaseService;

    YendaHIWebServiceManager(String serverURL) {
        HIRuntime.setManager(this);
        this.thumbnailCache = new HashMap();
        this.projectColors = new Vector();
        this.projectPolygons = new Vector();
        if (!serverURL.endsWith("/")) {
            serverURL = String.valueOf(serverURL) + "/";
        }
        this.serverURL = serverURL;
        this.editorService = new YendaClientREST(serverURL);
        this.yluserService = new YLUserClientREST(serverURL);
        this.ylprojectService = new YLProjectClientREST(serverURL);
        this.ylgroupService = new YLGroupClientREST(serverURL);
        this.ylimageService = new YLImageClientREST(serverURL);
        this.ylbaseService = new YLBaseClientREST(serverURL);
        String versionID = this.editorService.getVersion(String.class);
        System.out.println("Server Version: " + versionID);
        if (versionID.compareTo(minimumVersionID) < 0) {
            JOptionPane.showMessageDialog(null, "FATAL ERROR: Server Yenda Legacy HI-WebService Version outdated!\n\nReported: " + versionID + "\nNeeded: " + minimumVersionID);
            System.exit(1);
        }
    }

    @Override
    public boolean addLanguageToProject(String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void addProjectColor(Color color) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void addProjectPolygon(String polygonModel) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiFlexMetadataSet addSetToTemplate(HiFlexMetadataTemplate template, String tagName, boolean isRichText) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addTemplateToProject(HiFlexMetadataTemplate template) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addToGroup(long baseID, long groupID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addToGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addUserToProject(long userID, HiRoles role) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addUserToProject(HiUser user, HiRoles role) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addUserToProject(long userID, long projectID, HiRoles role) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean addUserToProject(HiUser user, HiProject project, HiRoles role) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean copyToGroup(long baseID, long groupID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean copyToGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiFlexMetadataRecord createFlexMetadataRecord(long baseID, String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiFlexMetadataRecord createFlexMetadataRecord(HiBase base, String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiGroup createGroup() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiGroup createGroup(String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiInscription createInscription(long objectID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiInscription createInscription(long objectID, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiInscription createInscription(HiObject object, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiInscription createInscription(HiObject object) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiLayer createLayer(long viewID, int red, int green, int blue, float opacity) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiLayer createLayer(long viewID, int red, int green, int blue, float opacity, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiLayer createLayer(HiView view, int red, int green, int blue, float opacity, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiLayer createLayer(HiView view, int red, int green, int blue, float opacity) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiLightTable createLightTable(String title, String xml) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiLightTable createLightTable(String title, String xml, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiObject createObject() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiObject createObject(String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiPreference createPreference(String key, String value) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiProject createProject(String adminUsername, String defaultLanguage) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiProject createProject(HiUser adminUser, String defaultLanguage) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiRepository createRepository(HiRepository newRepository) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiFlexMetadataName createSetDisplayName(HiFlexMetadataSet set, String lang, String displayName) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiGroup createTagGroup() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiGroup createTagGroup(String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiText createText() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiText createText(String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public Hiurl createURL(String url, String title, String lastAccess) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public Hiurl createURL(String url, String title, String lastAccess, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiUser createUser(String firstName, String lastName, String userName, String password, String email) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, byte[] data) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, byte[] data, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiView createView(HiObject object, String filename, String repositoryIDString, byte[] data, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiView createView(HiObject object, File file) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiView createView(HiObject object, File file, String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteFromProject(long baseID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteFromProject(HiBase base) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteGroup(long groupID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteGroup(HiGroup group) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deletePreference(long prefID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deletePreference(HiPreference pref) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteProject(long projectID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteProject(HiProject project) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteRepository(HiRepository repository) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteUser(long userID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean deleteUser(HiUser user) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiQuickInfo> fieldSearch(List<String> fields, List<String> contents, String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiBase getBaseElement(String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiBase getBaseElement(long baseID) throws HIWebServiceException {
        try {
            HiBase element = this.ylbaseService.find(HiBase.class, baseID);
            return element;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiBase getBaseElement(HiBase base) throws HIWebServiceException {
        return this.getBaseElement(base.getId());
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(long baseID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(HiBase base) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(String uuid) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiQuickInfo getContentInfo(HiQuickInfo content) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiRoles getCurrentRole() {
        return this.curRole;
    }

    @Override
    public HiUser getCurrentUser() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getEndpointSession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<HiFlexMetadataRecord> getFlexMetadataRecords(long baseID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiFlexMetadataRecord> getFlexMetadataRecords(HiBase base) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiQuickInfo> getGroupContentQuickInfo(long groupID) throws HIWebServiceException {
        try {
            return this.ylgroupService.findContentsPreview(new GenericType<List<HiQuickInfo>>(){}, String.valueOf(groupID));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiQuickInfo> getGroupContents(HiGroup group) throws HIWebServiceException {
        return this.getGroupContentQuickInfo(group.getId());
    }

    @Override
    public List<HiGroup> getGroups() throws HIWebServiceException {
        try {
            List<HiGroup> groups = this.ylprojectService.findGroups(new GenericType<List<HiGroup>>(){}, String.valueOf(this.project.getId()), "regular");
            for (HiGroup group : groups) {
                group.setType(GroupTypes.HIGROUP_REGULAR);
            }
            return groups;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public PlanarImage getImage(HiView view, HiImageSizes size) throws HIWebServiceException {
        return this.getImage(view.getId(), size, true);
    }

    @Override
    public PlanarImage getImage(HiQuickInfo info, HiImageSizes size) throws HIWebServiceException {
        PlanarImage image = null;
        if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
            image = this.getImage(info.getRelatedID(), size, true);
        } else if (info.getContentType() == HiBaseTypes.HI_VIEW) {
            image = this.getImage(info.getBaseID(), size, true);
        } else if (info.getContentType() == HiBaseTypes.HI_LAYER) {
            image = this.getImage(info.getBaseID(), size, false);
        }
        return image;
    }

    @Override
    public PlanarImage getImage(long viewID, HiImageSizes size, boolean cacheImage) throws HIWebServiceException {
        PlanarImage image = null;
        if (size == HiImageSizes.HI_THUMBNAIL) {
            image = this.thumbnailCache.get(viewID);
        }
        if (image == null) {
            try {
                image = ImageHelper.convertByteArrayToPlanarImage(this.ylimageService.getStoredImageOfSize(byte[].class, String.valueOf(viewID), size.toString()));
                if (size == HiImageSizes.HI_THUMBNAIL && cacheImage) {
                    this.thumbnailCache.put(viewID, image);
                }
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        return image;
    }

    @Override
    public byte[] getImageAsBitstream(HiView view, HiImageSizes size) throws HIWebServiceException {
        try {
            return this.ylimageService.getStoredImageOfSize(byte[].class, String.valueOf(view.getId()), size.toString());
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiGroup getImportGroup() {
        return this.importGroup;
    }

    @Override
    public String getPPGLocation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HiProject getProject() {
        return this.project;
    }

    @Override
    public Vector<Color> getProjectColors() {
        return this.projectColors;
    }

    @Override
    public List<HiLightTable> getProjectLightTableElements() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public Vector<String> getProjectPolygons() {
        return this.projectPolygons;
    }

    @Override
    public List<HiText> getProjectTextElements() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiUser> getProjectUsers() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiProject> getProjects() throws HIWebServiceException {
        try {
            return this.ylprojectService.findUserProjects(new GenericType<List<HiProject>>(){});
        }
        catch (Exception se) {
            System.out.println(se);
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiProject> getProjects(HiUser user) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiProject> getProjectsForUser(long userID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiProject> getProjectsForUser(HiUser user) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public RenderableImage getRenderableImage(long viewID) throws HIWebServiceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<HiRepository> getRepositories() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiRoles getRoleInProject(long userID, long projectID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiRoles getRoleInProject(HiUser user, HiProject project) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public HIWebServiceManagerInterface.WSStates getState() {
        return this.state;
    }

    @Override
    public long getTagCountForElement(long baseID) throws HIWebServiceException {
        try {
            return this.ylbaseService.getTagCountForElement(baseID);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public long getTagCountForElement(HiBase base) throws HIWebServiceException {
        return this.getTagCountForElement(base.getId());
    }

    @Override
    public List<HiGroup> getTags() throws HIWebServiceException {
        try {
            List<HiGroup> groups = this.ylprojectService.findGroups(new GenericType<List<HiGroup>>(){}, String.valueOf(this.project.getId()), "tag");
            for (HiGroup group : groups) {
                group.setType(GroupTypes.HIGROUP_REGULAR);
            }
            return groups;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public ArrayList<HiGroup> getTagsForBaseElement(long baseID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public ArrayList<HiGroup> getTagsForBaseElement(HiBase base) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiGroup getTrashGroup() {
        return this.trashGroup;
    }

    @Override
    public HiUser getUserByID(long userID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiUser getUserByUserName(String userName) throws HIWebServiceException {
        try {
            return this.yluserService.findByName(HiUser.class, userName);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsers() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiUser> getUsersAsAdmin() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiUser> getUsersForProject(long projectID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public List<HiUser> getUsersForProject(HiProject project) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public String getVersionID() throws HIWebServiceException {
        try {
            return this.editorService.getVersion(YendaVersionInfo.class).getVersion();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HIEditor getWSPort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isConnected() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean login(String username, String password) throws HIWebServiceException {
        boolean loginOk;
        block3: {
            this.username = username;
            this.password = password;
            this.curRole = null;
            this.thumbnailCache.clear();
            loginOk = false;
            try {
                this.editorService.setUsernamePassword(username, password);
                this.yluserService.setUsernamePassword(username, password);
                this.ylprojectService.setUsernamePassword(username, password);
                this.ylgroupService.setUsernamePassword(username, password);
                this.ylimageService.setUsernamePassword(username, password);
                this.ylbaseService.setUsernamePassword(username, password);
                this.editorService.isAuthenticated(String.class);
                loginOk = true;
            }
            catch (Exception se) {
                loginOk = false;
                if (se.getClass() == NotAuthorizedException.class) break block3;
                throw new HIWebServiceException(se);
            }
        }
        if (loginOk) {
            this.curUser = this.getUserByUserName(username);
            this.state = HIWebServiceManagerInterface.WSStates.ONLINE;
            return true;
        }
        return false;
    }

    @Override
    public boolean loginPR(String user, String token, String token_secret, String token_verifier) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean logout() {
        this.importGroup = null;
        this.trashGroup = null;
        this.project = null;
        this.curRole = null;
        this.curUser = null;
        this.thumbnailCache.clear();
        this.username = null;
        this.password = null;
        this.state = HIWebServiceManagerInterface.WSStates.OFFLINE;
        return true;
    }

    @Override
    public boolean moveToGroup(long baseID, long fromGroupID, long toGroupID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean moveToGroup(HiBase base, HiGroup fromGroup, HiGroup toGroup) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean moveToTrash(long baseID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean moveToTrash(HiBase base) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void rebuildSearchIndex() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean reconnect() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void refreshProject() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void removeDefaultView(long objectID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void removeDefaultView(HiObject object) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeFromGroup(long baseID, long groupID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeFromGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeLanguageFromProject(String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeLayer(long layerID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeLayer(HiLayer layer) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeLayerLink(long layerID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeLayerLink(HiLayer layer) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void removeProjectColor(Color color) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void removeProjectPolygon(String polygonModel) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeSetFromTemplate(HiFlexMetadataTemplate template, HiFlexMetadataSet set) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeTemplateFromProject(HiFlexMetadataTemplate template) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeUserFromProject(long userID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeUserFromProject(HiUser user) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeUserFromProject(long userID, long projectID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean removeUserFromProject(HiUser user, HiProject project) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean setDefaultView(long objectID, long contentID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean setDefaultView(HiObject object, HiObjectContent content) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean setLayerLink(long layerID, long linkID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean setLayerLink(HiLayer layer, HiBase link) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    private HiRoles parseRole(String role) {
        switch (role) {
            case "ADMIN": {
                return HiRoles.ADMIN;
            }
            case "USER": {
                return HiRoles.USER;
            }
        }
        return HiRoles.GUEST;
    }

    @Override
    public boolean setProject(HiProject project) throws HIWebServiceException {
        boolean success = true;
        try {
            String tempSortOrder;
            String projPolygons;
            int n;
            this.importGroup = this.ylprojectService.findGroups(new GenericType<List<HiGroup>>(){}, String.valueOf(project.getId()), "import").get(0);
            this.importGroup.setType(GroupTypes.HIGROUP_IMPORT);
            this.trashGroup = this.ylprojectService.findGroups(new GenericType<List<HiGroup>>(){}, String.valueOf(project.getId()), "trash").get(0);
            this.trashGroup.setType(GroupTypes.HIGROUP_TRASH);
            this.curRole = this.parseRole(this.yluserService.getRoleForProject(String.class, project.getId()));
            project.setPreferences(this.ylprojectService.findPreferences(new GenericType<List<HiPreference>>(){}, String.valueOf(project.getId())));
            project.setTemplates(this.ylprojectService.findTemplates(new GenericType<List<HiFlexMetadataTemplate>>(){}, String.valueOf(project.getId())));
            this.thumbnailCache.clear();
            this.project = project;
            this.state = HIWebServiceManagerInterface.WSStates.IN_PROJECT;
            this.projectColors.removeAllElements();
            this.projectPolygons.removeAllElements();
            this.projectTags = null;
            String projColors = MetadataHelper.findPreferenceValue(project, "colors");
            if (projColors == null) {
                projColors = this.createPreference("colors", "").getValue();
            }
            if (projColors.length() > 0) {
                try {
                    String[] stringArray = projColors.split(":");
                    n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String color = stringArray[n2];
                        this.projectColors.addElement(new Color(Integer.parseInt(color.split(",")[0]), Integer.parseInt(color.split(",")[1]), Integer.parseInt(color.split(",")[2])));
                        ++n2;
                    }
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Error parsing color pref!");
                    MetadataHelper.setPreferenceValue(project, "colors", "");
                    this.projectColors.removeAllElements();
                }
            }
            if ((projPolygons = MetadataHelper.findPreferenceValue(project, "polygons")) == null) {
                projPolygons = this.createPreference("polygons", "").getValue();
            }
            if (projPolygons.length() > 0) {
                try {
                    String[] stringArray = projPolygons.split(":");
                    int n3 = stringArray.length;
                    n = 0;
                    while (n < n3) {
                        Object polygon = stringArray[n];
                        this.projectPolygons.addElement((String)polygon);
                        ++n;
                    }
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Error parsing polygon pref!");
                    MetadataHelper.setPreferenceValue(project, "polygons", "");
                    this.projectPolygons.removeAllElements();
                }
            }
            if ((tempSortOrder = MetadataHelper.findPreferenceValue(project, "templateSortOrder")) == null) {
                HiFlexMetadataTemplate hiInternalTemplate = null;
                for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
                    if (template.getNamespacePrefix().compareTo("HIInternal") != 0) continue;
                    hiInternalTemplate = template;
                }
                if (hiInternalTemplate != null) {
                    this.project.getTemplates().remove(hiInternalTemplate);
                    this.project.getTemplates().add(hiInternalTemplate);
                }
                String initSortOrder = "";
                int i = 0;
                while (i < this.project.getTemplates().size()) {
                    initSortOrder = String.valueOf(initSortOrder) + "," + this.project.getTemplates().get(i).getId();
                    ++i;
                }
                if (initSortOrder.length() > 0) {
                    initSortOrder = initSortOrder.substring(1);
                }
                tempSortOrder = this.createPreference("templateSortOrder", initSortOrder).getValue();
            }
            tempSortOrder.length();
            for (HiFlexMetadataTemplate hiFlexMetadataTemplate : this.project.getTemplates()) {
            }
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        return success;
    }

    @Override
    public boolean setProjectRole(long userID, HiRoles role) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean setProjectRole(HiUser user, HiRoles role) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void setReconnect() {
    }

    @Override
    public List<HiQuickInfo> simpleSearch(String text, String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateContentOwner(long objectID, long contentID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateContentOwner(HiObject object, HiObjectContent content) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateFlexMetadataRecord(HiFlexMetadataRecord record) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateFlexMetadataRecords(List<HiFlexMetadataRecord> records) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateGroupProperties(long groupID, boolean visible) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateGroupProperties(HiGroup group, boolean visible) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateGroupSortOrder(long groupID, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateGroupSortOrder(HiGroup group, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateLayerProperties(long layerID, int red, int green, int blue, float opacity, String polygons) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateLayerProperties(HiLayer layer, int red, int green, int blue, float opacity, String polygons) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateLightTable(HiLightTable lightTable) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateObjectSortOrder(long objectID, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateObjectSortOrder(HiObject object, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updatePassword(String password) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updatePreference(long prefID, String value) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updatePreference(HiPreference pref) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateProject(String languageID, String title) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateProjectColors() throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateProjectDefaultLanguage(String language) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateProjectQuota(long projectID, long quota) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateProjectQuota(HiProject project, long quota) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateProjectStartElement(long baseID) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateProjectStartElement(HiBase base) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateSetDisplayName(HiFlexMetadataSet set, String lang, String displayName) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateTemplate(HiFlexMetadataTemplate template, String templateURI, String templateURL) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateTemplateSortOrder(HiFlexMetadataTemplate template, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateURL(Hiurl url) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateUser(long userID, String firstName, String lastName, String email) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateUser(HiUser user, String firstName, String lastName, String email) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateUser(String firstName, String lastName, String email) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateUser(HiUser user) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateUserPassword(long userID, String password) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public boolean updateUserPassword(HiUser user, String password) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateViewSortOrder(long viewID, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public void updateViewSortOrder(HiView view, String sortOrder) throws HIWebServiceException {
        throw new HIWebServiceException(new UnsupportedOperationException("Not supported yet."));
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, File uploadFile, String uuid) throws HIWebServiceException {
        return null;
    }

    @Override
    public boolean deleteTagGroup(long tagID) throws HIWebServiceException {
        return false;
    }

    @Override
    public boolean deleteTagGroup(HiGroup tag) throws HIWebServiceException {
        return false;
    }

    @Override
    public String getClientVersionID() throws HIWebServiceException {
        return null;
    }
}

