/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.awt.Color;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.message.GZipEncoder;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.HIWebServiceManagerInterface;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.ImageHelper;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HIEditor;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataName;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiProjectMetadata;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiRepository;
import org.hyperimage.client.ws.HiRoles;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiUser;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;

public class YendaLegacyBridgeManager
implements HIWebServiceManagerInterface {
    private static final String minimumVersionID = "0.5.0";
    private HiGroup importGroup = null;
    private HiGroup trashGroup = null;
    private HiProject project = null;
    private HiUser curUser = null;
    private List<HiGroup> projectTags = null;
    private Vector<Color> projectColors;
    private Vector<String> projectPolygons;
    private HashMap<Long, PlanarImage> thumbnailCache;
    private HIWebServiceManagerInterface.WSStates state = HIWebServiceManagerInterface.WSStates.OFFLINE;
    private String serverURL;
    private String username;
    private String password;
    private HiRoles curRole = null;
    private Client client = ClientBuilder.newClient();
    private WebTarget target;

    YendaLegacyBridgeManager(String serverURL) throws MalformedURLException, HIWebServiceException {
        HIRuntime.setManager(this);
        this.thumbnailCache = new HashMap();
        this.projectColors = new Vector();
        this.projectPolygons = new Vector();
        if (!serverURL.endsWith("/")) {
            serverURL = String.valueOf(serverURL) + "/";
        }
        this.serverURL = serverURL;
        this.client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MultiPartFeature.class)).register(JacksonJsonProvider.class)).sslContext(this.getSSLContext()).build();
        this.client.register(HttpAuthenticationFeature.basicBuilder().credentials("", "").build());
        this.client.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", true);
        this.client.property("jersey.config.client.request.entity.processing", "CHUNKED");
        this.client.property("jersey.config.client.readTimeout", 60000);
        this.target = this.client.target(this.serverURL);
        this.target.register(GZipEncoder.class);
        this.target.register(MultiPartFeature.class);
        String versionID = this.getVersionID();
        System.out.println("Server Version: " + versionID);
        if (versionID.compareTo(minimumVersionID) < 0) {
            JOptionPane.showMessageDialog(null, "FATAL ERROR: Server Yenda Legacy HI-WebService Version outdated!\n\nReported: " + versionID + "\nNeeded: " + minimumVersionID);
            System.exit(1);
        }
    }

    public static byte[] getBytesFromFile(File file) {
        byte[] bytes = null;
        try {
            FileInputStream is = new FileInputStream(file);
            if (file.length() > Integer.MAX_VALUE) {
                throw new IOException("File too big!");
            }
            bytes = new byte[(int)file.length()];
            int numRead = ((InputStream)is).read(bytes);
            if (numRead < bytes.length) {
                throw new IOException("Error reading file!");
            }
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return bytes;
    }

    @Override
    public boolean addLanguageToProject(String language) throws HIWebServiceException {
        try {
            boolean languageAdded = this.target.path("adminAddLanguageToProject/project/" + this.project.getId() + "/language/" + language).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(null).readEntity(Boolean.class);
            if (languageAdded) {
                this.refreshProject();
            }
            return languageAdded;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void addProjectColor(Color color) throws HIWebServiceException {
        for (Color projColor : this.projectColors) {
            if (projColor.getRed() != color.getRed() || projColor.getGreen() != color.getGreen() || projColor.getBlue() != color.getBlue()) continue;
            return;
        }
        this.projectColors.add(color);
        HiPreference colorPref = MetadataHelper.findPreference(this.project, "colors");
        colorPref.setValue(this.serializeProjectColorsPreference());
        this.updatePreference(colorPref);
    }

    @Override
    public void addProjectPolygon(String polygonModel) throws HIWebServiceException {
        if (polygonModel.length() > 0) {
            polygonModel = String.valueOf(RelativePolygon.getModelType(RelativePolygon.HiPolygonTypes.HI_USERDESIGN)) + polygonModel.substring(1);
        }
        for (String polygon : this.projectPolygons) {
            if (polygon.compareTo(polygonModel) != 0) continue;
            return;
        }
        this.projectPolygons.add(polygonModel);
        HiPreference polygonPref = MetadataHelper.findPreference(this.project, "polygons");
        polygonPref.setValue(this.serializeProjectPolygonsPreference());
        this.updatePreference(polygonPref);
    }

    @Override
    public HiFlexMetadataSet addSetToTemplate(HiFlexMetadataTemplate template, String tagName, boolean isRichText) throws HIWebServiceException {
        if (template == null) {
            return null;
        }
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        try {
            HiFlexMetadataSet tmpSet = new HiFlexMetadataSet();
            tmpSet.setRichText(isRichText);
            tmpSet.setTagname(tagName);
            HiFlexMetadataSet newSet = this.target.path("adminAddSetToTemplate/template/" + template.getId()).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(tmpSet, "application/json")).readEntity(HiFlexMetadataSet.class);
            if (newSet != null) {
                this.refreshProject();
                return newSet;
            }
            return null;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addTemplateToProject(HiFlexMetadataTemplate template) throws HIWebServiceException {
        try {
            boolean templateAdded = this.target.path("adminAddTemplateToProject/project/" + this.project.getId()).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(template, "application/json")).readEntity(Boolean.class);
            if (templateAdded) {
                this.refreshProject();
            }
            return templateAdded;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addToGroup(long baseID, long groupID) throws HIWebServiceException {
        return this.copyToGroup(baseID, groupID);
    }

    @Override
    public boolean addToGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        return this.copyToGroup(base.getId(), group.getId());
    }

    @Override
    public boolean addUserToProject(long userID, HiRoles role) throws HIWebServiceException {
        try {
            return this.target.path("adminAddUserToProject/project/" + this.project.getId() + "/user/" + userID + "/role/" + (Object)((Object)role)).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.text("")).readEntity(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addUserToProject(HiUser user, HiRoles role) throws HIWebServiceException {
        return this.addUserToProject(user.getId(), role);
    }

    @Override
    public boolean addUserToProject(long userID, long projectID, HiRoles role) throws HIWebServiceException {
        if (this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT && this.project.getId() == projectID) {
            return this.addUserToProject(userID, role);
        }
        try {
            return this.target.path("sysopAddUserToProject/project/" + projectID + "/user/" + userID + "/role/" + (Object)((Object)role)).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.text("")).readEntity(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean addUserToProject(HiUser user, HiProject project, HiRoles role) throws HIWebServiceException {
        if (this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT && this.project.getId() == project.getId()) {
            return this.addUserToProject(user.getId(), role);
        }
        return this.addUserToProject(user.getId(), project.getId(), role);
    }

    @Override
    public boolean copyToGroup(long baseID, long groupID) throws HIWebServiceException {
        try {
            boolean groupItemAdded = this.target.path("copyToGroup/" + baseID + "/to/" + groupID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(Boolean.class);
            return groupItemAdded;
        }
        catch (Exception se) {
            se.printStackTrace();
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean copyToGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        return this.copyToGroup(base.getId(), group.getId());
    }

    @Override
    public HiFlexMetadataRecord createFlexMetadataRecord(long baseID, String language) throws HIWebServiceException {
        try {
            return this.target.path("createFlexMetadataRecord/" + baseID + "/language/" + language).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.text("")).readEntity(HiFlexMetadataRecord.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiFlexMetadataRecord createFlexMetadataRecord(HiBase base, String language) throws HIWebServiceException {
        return this.createFlexMetadataRecord(base.getId(), language);
    }

    @Override
    public HiGroup createGroup() throws HIWebServiceException {
        return this.createGroup(UUID.randomUUID().toString());
    }

    @Override
    public HiGroup createGroup(String uuid) throws HIWebServiceException {
        try {
            return this.target.path("createGroup/project/" + this.project.getId() + "/uuid/" + uuid).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.text("")).readEntity(HiGroup.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiInscription createInscription(long objectID) throws HIWebServiceException {
        return this.createInscription(objectID, UUID.randomUUID().toString());
    }

    @Override
    public HiInscription createInscription(long objectID, String uuid) throws HIWebServiceException {
        try {
            return this.target.path("createInscription/object/" + objectID + "/uuid/" + uuid).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(Entity.text(""), "application/json")).readEntity(HiInscription.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiInscription createInscription(HiObject object, String uuid) throws HIWebServiceException {
        return this.createInscription(object.getId(), uuid);
    }

    @Override
    public HiInscription createInscription(HiObject object) throws HIWebServiceException {
        return this.createInscription(object.getId());
    }

    @Override
    public HiLayer createLayer(long viewID, int red, int green, int blue, float opacity) throws HIWebServiceException {
        return this.createLayer(viewID, red, green, blue, opacity, UUID.randomUUID().toString());
    }

    @Override
    public HiLayer createLayer(long viewID, int red, int green, int blue, float opacity, String uuid) throws HIWebServiceException {
        try {
            HiLayer tmpLayer = new HiLayer();
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            tmpLayer.setRed(red);
            tmpLayer.setGreen(green);
            tmpLayer.setBlue(blue);
            tmpLayer.setOpacity(opacity);
            tmpLayer.setUUID(uuid);
            return this.target.path("createLayer/" + viewID).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(tmpLayer, "application/json")).readEntity(HiLayer.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiLayer createLayer(HiView view, int red, int green, int blue, float opacity, String uuid) throws HIWebServiceException {
        return this.createLayer(view.getId(), red, green, blue, opacity, uuid);
    }

    @Override
    public HiLayer createLayer(HiView view, int red, int green, int blue, float opacity) throws HIWebServiceException {
        return this.createLayer(view.getId(), red, green, blue, opacity);
    }

    @Override
    public HiLightTable createLightTable(String title, String xml) throws HIWebServiceException {
        return this.createLightTable(title, xml, UUID.randomUUID().toString());
    }

    @Override
    public HiLightTable createLightTable(String title, String xml, String uuid) throws HIWebServiceException {
        try {
            HiLightTable tmpLT = new HiLightTable();
            tmpLT.setTitle(title);
            tmpLT.setXml(xml);
            tmpLT.setUUID(uuid);
            return this.target.path("createLightTable/" + this.project.getId()).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(tmpLT, "application/json")).readEntity(HiLightTable.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiObject createObject() throws HIWebServiceException {
        return this.createObject(UUID.randomUUID().toString());
    }

    @Override
    public HiObject createObject(String uuid) throws HIWebServiceException {
        try {
            return this.target.path("createObject/project/" + this.project.getId() + "/uuid/" + uuid).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(Entity.text(""), "application/json")).readEntity(HiObject.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiPreference createPreference(String key, String value) throws HIWebServiceException {
        try {
            HiPreference pref = new HiPreference();
            pref.setKey(key);
            pref.setValue(value);
            pref = this.target.path("createPreference/project/" + this.project.getId()).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(pref, "application/json")).readEntity(HiPreference.class);
            if (this.project != null) {
                this.project.getPreferences().add(pref);
            }
            return pref;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiProject createProject(String adminUsername, String defaultLanguage) throws HIWebServiceException {
        try {
            return this.target.path("sysopCreateProject/" + adminUsername + "/language/" + defaultLanguage).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(Entity.text(""), "application/json")).readEntity(HiProject.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiProject createProject(HiUser adminUser, String defaultLanguage) throws HIWebServiceException {
        return this.createProject(adminUser.getUserName(), defaultLanguage);
    }

    @Override
    public HiRepository createRepository(HiRepository newRepository) throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("no longer supported"));
    }

    @Override
    public HiFlexMetadataName createSetDisplayName(HiFlexMetadataSet set, String lang, String displayName) throws HIWebServiceException {
        if (set == null) {
            return null;
        }
        if (lang == null || lang.length() == 0) {
            return null;
        }
        try {
            HiFlexMetadataName tmpName = new HiFlexMetadataName();
            tmpName.setLanguage(lang);
            tmpName.setDisplayName(displayName);
            HiFlexMetadataName newName = this.target.path("adminCreateSetDisplayName/set/" + set.getId()).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(tmpName, "application/json")).readEntity(HiFlexMetadataName.class);
            if (newName != null) {
                this.refreshProject();
                return newName;
            }
            return null;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiGroup createTagGroup() throws HIWebServiceException {
        return this.createTagGroup(UUID.randomUUID().toString());
    }

    @Override
    public HiGroup createTagGroup(String uuid) throws HIWebServiceException {
        try {
            HiGroup newTag = this.target.path("createTagGroup/project/" + this.project.getId() + "/uuid/" + uuid).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(Entity.text(""), "application/json")).readEntity(HiGroup.class);
            if (newTag != null && this.projectTags != null) {
                this.projectTags.add(newTag);
            }
            return newTag;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiText createText() throws HIWebServiceException {
        return this.createText(UUID.randomUUID().toString());
    }

    @Override
    public HiText createText(String uuid) throws HIWebServiceException {
        try {
            return this.target.path("createText/project/" + this.project.getId() + "/uuid/" + uuid).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(Entity.text(""), "application/json")).readEntity(HiText.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public Hiurl createURL(String url, String title, String lastAccess) throws HIWebServiceException {
        return this.createURL(url, title, lastAccess, UUID.randomUUID().toString());
    }

    @Override
    public Hiurl createURL(String url, String title, String lastAccess, String uuid) throws HIWebServiceException {
        try {
            Hiurl tmpURL = new Hiurl();
            tmpURL.setUrl(url);
            tmpURL.setTitle(title);
            tmpURL.setLastAccess(lastAccess);
            tmpURL.setUUID(uuid);
            Hiurl newURL = this.target.path("createURL/" + this.project.getId()).request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(tmpURL, "application/json")).readEntity(Hiurl.class);
            return newURL;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiUser createUser(String firstName, String lastName, String userName, String newPass, String email) throws HIWebServiceException {
        try {
            HiUser tmpUser = new HiUser();
            tmpUser.setFirstName(firstName);
            tmpUser.setLastName(lastName);
            tmpUser.setUserName(userName);
            tmpUser.setPassword(newPass);
            tmpUser.setEmail(email);
            return this.target.path("sysopCreateUser").request("application/json").accept("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(tmpUser, "application/json")).readEntity(HiUser.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, byte[] data) throws HIWebServiceException {
        return this.createView(objectID, filename, repositoryIDString, data, UUID.randomUUID().toString());
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, File uploadFile, String uuid) throws HIWebServiceException {
        MultiPart multiPart = new MultiPart();
        multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
        FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("file", uploadFile, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        multiPart.bodyPart(fileDataBodyPart);
        Response r = null;
        try {
            r = this.target.path("createView/object/" + objectID + "/filename/" + filename + "/repository/" + repositoryIDString + "/uuid/" + uuid).request(MediaType.APPLICATION_JSON_TYPE).property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(Entity.entity(multiPart, "multipart/form-data"));
            HiView view = null;
            if (r.getStatus() != 200) {
                throw new Exception(r.readEntity(String.class));
            }
            view = r.readEntity(HiView.class);
            multiPart.close();
            return view;
        }
        catch (Exception se) {
            try {
                multiPart.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiView createView(HiObject object, String filename, String repositoryIDString, byte[] data, String uuid) throws HIWebServiceException {
        return this.createView(object.getId(), filename, repositoryIDString, data, uuid);
    }

    @Override
    public HiView createView(HiObject object, File file) throws HIWebServiceException {
        return this.createView(object, file, UUID.randomUUID().toString());
    }

    @Override
    public HiView createView(HiObject object, File file, String uuid) throws HIWebServiceException {
        byte[] data = YendaLegacyBridgeManager.getBytesFromFile(file);
        return this.createView(object.getId(), file.getName(), "[HIEditor 3.0 - Direct Import]", data, uuid);
    }

    @Override
    public HiView createView(long objectID, String filename, String repositoryIDString, byte[] data, String uuid) throws HIWebServiceException {
        return null;
    }

    @Override
    public boolean deleteFromProject(long baseID) throws HIWebServiceException {
        try {
            boolean success = this.target.path("deleteFromProject/project/" + this.project.getId() + "/base/" + baseID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
            if (success && this.project.getStartObjectInfo() != null && this.project.getStartObjectInfo().getBaseID() == baseID) {
                this.project.setStartObjectInfo(null);
            }
            return success;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteFromProject(HiBase base) throws HIWebServiceException {
        return this.deleteFromProject(base.getId());
    }

    @Override
    public boolean deleteGroup(long groupID) throws HIWebServiceException {
        try {
            return this.target.path("deleteGroup/" + groupID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteGroup(HiGroup group) throws HIWebServiceException {
        boolean success = this.deleteGroup(group.getId());
        if (success && group.getType() == GroupTypes.HIGROUP_TAG && this.projectTags != null) {
            this.projectTags.remove(group);
        }
        return success;
    }

    @Override
    public boolean deleteTagGroup(long tagID) throws HIWebServiceException {
        try {
            return this.target.path("deleteTagGroup/" + tagID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteTagGroup(HiGroup tag) throws HIWebServiceException {
        boolean success = this.deleteTagGroup(tag.getId());
        if (success && tag.getType() == GroupTypes.HIGROUP_TAG && this.projectTags != null) {
            this.projectTags.remove(tag);
        }
        return success;
    }

    @Override
    public boolean deletePreference(long prefID) throws HIWebServiceException {
        HiPreference projPref;
        block6: {
            if (this.project == null) {
                return false;
            }
            try {
                projPref = null;
                for (HiPreference pref : this.project.getPreferences()) {
                    if (pref.getId() != prefID) continue;
                    projPref = pref;
                }
                if (projPref != null) break block6;
                return false;
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        boolean prefDeleted = this.target.path("deletePreference/" + prefID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        if (prefDeleted) {
            this.project.getPreferences().remove(projPref);
        }
        return prefDeleted;
    }

    @Override
    public boolean deletePreference(HiPreference pref) throws HIWebServiceException {
        return this.deletePreference(pref.getId());
    }

    @Override
    public boolean deleteProject(long projectID) throws HIWebServiceException {
        try {
            return this.target.path("sysopDeleteProject/" + projectID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteProject(HiProject project) throws HIWebServiceException {
        return this.deleteProject(project.getId());
    }

    @Override
    public boolean deleteRepository(HiRepository repository) throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("not longer supported"));
    }

    @Override
    public boolean deleteUser(long userID) throws HIWebServiceException {
        try {
            return this.target.path("sysopDeleteUser/" + userID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean deleteUser(HiUser user) throws HIWebServiceException {
        return this.deleteUser(user.getId());
    }

    @Override
    public List<HiQuickInfo> fieldSearch(List<String> fields, List<String> contents, String language) throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("not yet supported"));
    }

    @Override
    public HiBase getBaseElement(String uuid) throws HIWebServiceException {
        if (this.project == null) {
            return null;
        }
        try {
            return this.target.path("getBaseElementByUUID/project/" + this.project.getId() + "/uuid/" + uuid).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiBase.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiBase getBaseElement(long baseID) throws HIWebServiceException {
        try {
            return this.target.path("getBaseElement/" + baseID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiBase.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiBase getBaseElement(HiBase base) throws HIWebServiceException {
        return this.getBaseElement(base.getId());
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(long baseID) throws HIWebServiceException {
        try {
            return this.target.path("getBaseQuickInfo/" + baseID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiQuickInfo.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(HiBase base) throws HIWebServiceException {
        return this.getBaseQuickInfo(base.getId());
    }

    @Override
    public HiQuickInfo getBaseQuickInfo(String uuid) throws HIWebServiceException {
        try {
            return this.target.path("getBaseQuickInfoByUUID/project/" + this.project.getId() + "/uuid/" + uuid).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiQuickInfo.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiQuickInfo getContentInfo(HiQuickInfo content) throws HIWebServiceException {
        return this.getBaseQuickInfo(content.getBaseID());
    }

    @Override
    public HiRoles getCurrentRole() {
        return this.curRole;
    }

    @Override
    public HiUser getCurrentUser() {
        return this.curUser;
    }

    @Override
    public String getEndpointSession() {
        return null;
    }

    @Override
    public List<HiFlexMetadataRecord> getFlexMetadataRecords(long baseID) throws HIWebServiceException {
        try {
            return this.target.path("getFlexMetadataRecords/" + baseID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiFlexMetadataRecord>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiFlexMetadataRecord> getFlexMetadataRecords(HiBase base) throws HIWebServiceException {
        return this.getFlexMetadataRecords(base.getId());
    }

    @Override
    public List<HiQuickInfo> getGroupContentQuickInfo(long groupID) throws HIWebServiceException {
        try {
            return this.target.path("getGroupContentQuickInfo/" + groupID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiQuickInfo>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiQuickInfo> getGroupContents(HiGroup group) throws HIWebServiceException {
        return this.getGroupContentQuickInfo(group.getId());
    }

    @Override
    public List<HiGroup> getGroups() throws HIWebServiceException {
        try {
            return this.sortGroups(this.target.path("getGroups/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiGroup>>(){}));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    private List<HiGroup> sortGroups(List<HiGroup> groups) {
        int index = 0;
        if (MetadataHelper.findPreferenceValue(this.getProject(), "groupSortOrder") == null) {
            return groups;
        }
        String[] stringArray = MetadataHelper.findPreferenceValue(this.getProject(), "groupSortOrder").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long contentID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < groups.size()) {
                    if (groups.get(i).getId() == contentID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HiGroup group = groups.get(contentIndex);
                        groups.remove(contentIndex);
                        groups.add(index, group);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        return groups;
    }

    @Override
    public PlanarImage getImage(HiView view, HiImageSizes size) throws HIWebServiceException {
        return this.getImage(view.getId(), size, true);
    }

    @Override
    public PlanarImage getImage(HiQuickInfo info, HiImageSizes size) throws HIWebServiceException {
        PlanarImage image = null;
        if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
            image = this.getImage(info.getRelatedID(), size, true);
        } else if (info.getContentType() == HiBaseTypes.HI_VIEW) {
            image = this.getImage(info.getBaseID(), size, true);
        } else if (info.getContentType() == HiBaseTypes.HI_LAYER) {
            image = this.getImage(info.getBaseID(), size, false);
        }
        return image;
    }

    @Override
    public PlanarImage getImage(long viewID, HiImageSizes size, boolean cacheImage) throws HIWebServiceException {
        PlanarImage image = null;
        if (size == HiImageSizes.HI_THUMBNAIL) {
            image = this.thumbnailCache.get(viewID);
        }
        if (image == null) {
            try {
                Response r = this.target.path("getImage/" + viewID + "/" + size.toString()).request("image/jpeg").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get();
                image = ImageHelper.convertByteArrayToPlanarImage(r.readEntity(byte[].class));
                if (size == HiImageSizes.HI_THUMBNAIL && cacheImage) {
                    this.thumbnailCache.put(viewID, image);
                }
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        return image;
    }

    @Override
    public byte[] getImageAsBitstream(HiView view, HiImageSizes size) throws HIWebServiceException {
        try {
            return this.target.path("getImage/" + view.getId() + "/" + size.toString()).request("image/jpeg").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(byte[].class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiGroup getImportGroup() {
        if (this.importGroup != null) {
            return this.importGroup;
        }
        this.importGroup = this.target.path("getImportGroup/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiGroup.class);
        return this.importGroup;
    }

    @Override
    public String getPPGLocation() {
        return null;
    }

    @Override
    public HiProject getProject() {
        return this.project;
    }

    @Override
    public Vector<Color> getProjectColors() {
        return this.projectColors;
    }

    private void sortTemplates(String sortOrder) {
        if (this.project == null || sortOrder == null || sortOrder.length() == 0) {
            return;
        }
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String setIDString = stringArray[n2];
            try {
                long setID = Long.parseLong(setIDString);
                int setIndex = -1;
                int i = 0;
                while (i < this.project.getTemplates().size()) {
                    if (this.project.getTemplates().get(i).getId() == setID) {
                        setIndex = i;
                    }
                    ++i;
                }
                if (setIndex >= 0) {
                    if (setIndex != index) {
                        HiFlexMetadataTemplate template = this.project.getTemplates().get(setIndex);
                        this.project.getTemplates().remove(setIndex);
                        this.project.getTemplates().add(index, template);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private void sortTemplate(HiFlexMetadataTemplate template) {
        if (template == null || template.getSortOrder() == null) {
            return;
        }
        int index = 0;
        String[] stringArray = template.getSortOrder().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String setIDString = stringArray[n2];
            try {
                long setID = Long.parseLong(setIDString);
                int setIndex = -1;
                int i = 0;
                while (i < template.getEntries().size()) {
                    if (template.getEntries().get(i).getId() == setID) {
                        setIndex = i;
                    }
                    ++i;
                }
                if (setIndex >= 0) {
                    if (setIndex != index) {
                        HiFlexMetadataSet set = template.getEntries().get(setIndex);
                        template.getEntries().remove(setIndex);
                        template.getEntries().add(index, set);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    @Override
    public List<HiLightTable> getProjectLightTableElements() throws HIWebServiceException {
        try {
            return this.target.path("getProjectLightTableElements/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiLightTable>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public Vector<String> getProjectPolygons() {
        return this.projectPolygons;
    }

    @Override
    public List<HiText> getProjectTextElements() throws HIWebServiceException {
        try {
            return this.target.path("getProjectTextElements/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiText>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getProjectUsers() throws HIWebServiceException {
        try {
            return this.target.path("adminGetProjectUsers/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiUser>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiProject> getProjects() throws HIWebServiceException {
        try {
            return this.target.path("getProjects").request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiProject>>(){});
        }
        catch (Exception se) {
            se.printStackTrace();
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiProject> getProjects(HiUser user) throws HIWebServiceException {
        if (user.getId() == this.curUser.getId()) {
            return this.getProjects();
        }
        return this.getProjectsForUser(user);
    }

    @Override
    public List<HiProject> getProjectsForUser(long userID) throws HIWebServiceException {
        if (userID == this.curUser.getId()) {
            return this.getProjects();
        }
        try {
            return this.target.path("sysopGetProjectsForUser/" + userID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiProject>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiProject> getProjectsForUser(HiUser user) throws HIWebServiceException {
        if (user.getId() == this.curUser.getId()) {
            return this.getProjects();
        }
        return this.getProjectsForUser(user.getId());
    }

    @Override
    public RenderableImage getRenderableImage(long viewID) throws HIWebServiceException {
        RenderableImage image = null;
        try {
            image = ImageHelper.convertByteArrayToRenderableImage(this.target.path("getImage/" + viewID + "/" + HiImageSizes.HI_FULL.toString()).request("image/jpeg").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(byte[].class));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        return image;
    }

    @Override
    public List<HiRepository> getRepositories() throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("no longer supported"));
    }

    @Override
    public HiRoles getRoleInProject(long userID, long projectID) throws HIWebServiceException {
        try {
            String roleType;
            switch (roleType = this.target.path("adminGetRoleInProject/user/" + userID + "/project/" + projectID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(String.class)) {
                case "ADMIN": {
                    return HiRoles.ADMIN;
                }
                case "USER": {
                    return HiRoles.USER;
                }
                case "GUEST": {
                    return HiRoles.GUEST;
                }
            }
            return null;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiRoles getRoleInProject(HiUser user, HiProject project) throws HIWebServiceException {
        return this.getRoleInProject(user.getId(), project.getId());
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public HIWebServiceManagerInterface.WSStates getState() {
        return this.state;
    }

    @Override
    public long getTagCountForElement(long baseID) throws HIWebServiceException {
        if (this.projectTags == null) {
            this.getTags();
        }
        try {
            return this.target.path("getTagCountForBase/" + baseID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(Long.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public long getTagCountForElement(HiBase base) throws HIWebServiceException {
        return this.getTagCountForElement(base.getId());
    }

    @Override
    public List<HiGroup> getTags() throws HIWebServiceException {
        if (this.projectTags == null) {
            try {
                this.projectTags = this.target.path("getTagGroups/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiGroup>>(){});
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        return this.projectTags;
    }

    @Override
    public ArrayList<HiGroup> getTagsForBaseElement(long baseID) throws HIWebServiceException {
        List<Long> baseTagIDs;
        ArrayList<HiGroup> baseTags = new ArrayList<HiGroup>();
        if (this.projectTags == null) {
            this.getTags();
        }
        try {
            baseTagIDs = this.target.path("getTagIDsForBase/" + baseID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<Long>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        for (Long tagID : baseTagIDs) {
            for (HiGroup tag : this.projectTags) {
                if (tag.getId() != tagID.longValue()) continue;
                baseTags.add(tag);
            }
        }
        return baseTags;
    }

    @Override
    public ArrayList<HiGroup> getTagsForBaseElement(HiBase base) throws HIWebServiceException {
        return this.getTagsForBaseElement(base.getId());
    }

    @Override
    public HiGroup getTrashGroup() {
        if (this.trashGroup != null) {
            return this.trashGroup;
        }
        this.trashGroup = this.target.path("getTrashGroup/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiGroup.class);
        return this.trashGroup;
    }

    @Override
    public HiUser getUserByID(long userID) throws HIWebServiceException {
        try {
            return this.target.path("adminGetUserByID/" + userID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiUser.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HiUser getUserByUserName(String userName) throws HIWebServiceException {
        try {
            return this.target.path("adminGetUserByUserName/" + userName).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiUser.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsers() throws HIWebServiceException {
        try {
            return this.target.path("sysopGetUsers").request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiUser>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsersAsAdmin() throws HIWebServiceException {
        try {
            return this.target.path("adminGetUsers").request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiUser>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsersForProject(long projectID) throws HIWebServiceException {
        try {
            return this.target.path("sysopGetUsersForProject/" + projectID).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiUser>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public List<HiUser> getUsersForProject(HiProject project) throws HIWebServiceException {
        return this.getUsersForProject(project.getId());
    }

    @Override
    public String getVersionID() throws HIWebServiceException {
        try {
            return this.target.path("getVersionID").request("text/plain").property("jersey.config.client.http.auth.basic.username", "").property("jersey.config.client.http.auth.basic.password", "").get(String.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public String getClientVersionID() throws HIWebServiceException {
        try {
            return this.target.path("getClientVersionID").request("text/plain").property("jersey.config.client.http.auth.basic.username", "").property("jersey.config.client.http.auth.basic.password", "").get(String.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public HIEditor getWSPort() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean login(String username, String password) throws HIWebServiceException {
        boolean loginOk;
        block3: {
            this.username = username;
            this.password = password;
            this.curRole = null;
            this.thumbnailCache.clear();
            loginOk = false;
            try {
                HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic(username, password);
                this.target.register(feature);
                this.target.path("authenticate").request("application/json").property("jersey.config.client.http.auth.basic.username", username).property("jersey.config.client.http.auth.basic.password", password).get(String.class);
                loginOk = true;
            }
            catch (Exception se) {
                System.out.println(se);
                loginOk = false;
                if (se.getClass() == NotAuthorizedException.class) break block3;
                throw new HIWebServiceException(se);
            }
        }
        if (loginOk) {
            this.curUser = this.getUserByUserName(username);
            this.state = HIWebServiceManagerInterface.WSStates.ONLINE;
            return true;
        }
        return false;
    }

    @Override
    public boolean loginPR(String user, String token, String token_secret, String token_verifier) throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("no longer supported"));
    }

    @Override
    public boolean logout() {
        return false;
    }

    @Override
    public boolean moveToGroup(long baseID, long fromGroupID, long toGroupID) throws HIWebServiceException {
        try {
            return this.target.path("moveToGroup/" + baseID + "/from/" + fromGroupID + "/to/" + toGroupID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean moveToGroup(HiBase base, HiGroup fromGroup, HiGroup toGroup) throws HIWebServiceException {
        return this.moveToGroup(base.getId(), fromGroup.getId(), toGroup.getId());
    }

    @Override
    public boolean moveToTrash(long baseID) throws HIWebServiceException {
        try {
            return this.target.path("moveToTrash/" + baseID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean moveToTrash(HiBase base) throws HIWebServiceException {
        return this.moveToTrash(base.getId());
    }

    @Override
    public void rebuildSearchIndex() throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("not yet supported"));
    }

    @Override
    public boolean reconnect() throws HIWebServiceException {
        return true;
    }

    @Override
    public void refreshProject() throws HIWebServiceException {
        try {
            this.project = this.target.path("getProject/" + this.project.getId()).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(HiProject.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
        String tempSortOrder = MetadataHelper.findPreferenceValue(this.project, "templateSortOrder");
        if (tempSortOrder != null) {
            this.sortTemplates(tempSortOrder);
        }
        for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
            this.sortTemplate(template);
        }
    }

    @Override
    public void removeDefaultView(long objectID) throws HIWebServiceException {
        try {
            this.target.path("removeDefaultView/object/" + objectID).request().property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void removeDefaultView(HiObject object) throws HIWebServiceException {
        this.removeDefaultView(object.getId());
    }

    @Override
    public boolean removeFromGroup(long baseID, long groupID) throws HIWebServiceException {
        try {
            return this.target.path("removeFromGroup/" + baseID + "/group/" + groupID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeFromGroup(HiBase base, HiGroup group) throws HIWebServiceException {
        return this.removeFromGroup(base.getId(), group.getId());
    }

    @Override
    public boolean removeLanguageFromProject(String language) throws HIWebServiceException {
        try {
            boolean languageRemoved = this.target.path("adminRemoveLanguageFromProject/project/" + this.project.getId() + "/language/" + language).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
            if (languageRemoved) {
                this.project = this.getProject();
            }
            return languageRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeLayer(long layerID) throws HIWebServiceException {
        try {
            return this.target.path("removeLayer/" + layerID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeLayer(HiLayer layer) throws HIWebServiceException {
        return this.removeLayer(layer.getId());
    }

    @Override
    public boolean removeLayerLink(long layerID) throws HIWebServiceException {
        try {
            return this.target.path("removeLayerLink/" + layerID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeLayerLink(HiLayer layer) throws HIWebServiceException {
        return this.removeLayerLink(layer.getId());
    }

    @Override
    public void removeProjectColor(Color color) throws HIWebServiceException {
        Color foundColor = null;
        for (Color projColor : this.projectColors) {
            if (projColor.getRed() != color.getRed() || projColor.getGreen() != color.getGreen() || projColor.getBlue() != color.getBlue()) continue;
            foundColor = projColor;
        }
        if (foundColor == null) {
            return;
        }
        this.projectColors.remove(foundColor);
        HiPreference colorPref = MetadataHelper.findPreference(this.project, "colors");
        colorPref.setValue(this.serializeProjectColorsPreference());
        this.updatePreference(colorPref);
    }

    @Override
    public void removeProjectPolygon(String polygonModel) throws HIWebServiceException {
        if (polygonModel.length() > 0) {
            polygonModel = String.valueOf(RelativePolygon.getModelType(RelativePolygon.HiPolygonTypes.HI_USERDESIGN)) + polygonModel.substring(1);
        }
        String foundPolygon = null;
        for (String polygon : this.projectPolygons) {
            if (polygon.compareTo(polygonModel) != 0) continue;
            foundPolygon = polygon;
        }
        if (foundPolygon == null) {
            return;
        }
        this.projectPolygons.remove(foundPolygon);
        HiPreference polygonPref = MetadataHelper.findPreference(this.project, "polygons");
        polygonPref.setValue(this.serializeProjectPolygonsPreference());
        this.updatePreference(polygonPref);
    }

    @Override
    public boolean removeSetFromTemplate(HiFlexMetadataTemplate template, HiFlexMetadataSet set) throws HIWebServiceException {
        if (template == null) {
            return false;
        }
        if (set == null) {
            return false;
        }
        try {
            boolean setRemoved = this.target.path("adminRemoveSetFromTemplate/" + set.getId()).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
            if (setRemoved) {
                this.refreshProject();
            }
            return setRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeTemplateFromProject(HiFlexMetadataTemplate template) throws HIWebServiceException {
        if (template == null) {
            return false;
        }
        try {
            boolean templateRemoved = this.target.path("adminRemoveTemplateFromProject/" + template.getId()).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
            if (templateRemoved) {
                this.refreshProject();
            }
            return templateRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeUserFromProject(long userID) throws HIWebServiceException {
        try {
            boolean userRemoved = this.target.path("adminRemoveUserFromProject/project/" + this.project.getId() + "/user/" + userID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
            if (userRemoved && userID == this.curUser.getId()) {
                this.state = HIWebServiceManagerInterface.WSStates.ONLINE;
                this.importGroup = null;
                this.trashGroup = null;
                this.project = null;
                this.curRole = null;
                this.thumbnailCache.clear();
            }
            return userRemoved;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeUserFromProject(HiUser user) throws HIWebServiceException {
        return this.removeUserFromProject(user.getId());
    }

    @Override
    public boolean removeUserFromProject(long userID, long projectID) throws HIWebServiceException {
        if (this.state == HIWebServiceManagerInterface.WSStates.IN_PROJECT && this.project.getId() == projectID) {
            return this.removeUserFromProject(userID);
        }
        try {
            return this.target.path("sysopRemoveUserFromProject/project/" + this.project.getId() + "/user/" + userID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).delete(Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean removeUserFromProject(HiUser user, HiProject project) throws HIWebServiceException {
        return this.removeUserFromProject(user.getId(), project.getId());
    }

    @Override
    public boolean setDefaultView(long objectID, long contentID) throws HIWebServiceException {
        try {
            return this.target.path("setDefaultView/object/" + objectID + "/content/" + contentID).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean setDefaultView(HiObject object, HiObjectContent content) throws HIWebServiceException {
        return this.setDefaultView(object.getId(), content.getId());
    }

    @Override
    public boolean setLayerLink(long layerID, long linkID) throws HIWebServiceException {
        try {
            return this.target.path("setLayerLink/layer/" + layerID + "/link/" + linkID).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean setLayerLink(HiLayer layer, HiBase link) throws HIWebServiceException {
        return this.setLayerLink(layer.getId(), link.getId());
    }

    private HiRoles mapRole(String role) {
        if (role == null) {
            return null;
        }
        switch (role) {
            case "ADMIN": {
                return HiRoles.ADMIN;
            }
            case "USER": {
                return HiRoles.USER;
            }
            case "GUEST": {
                return HiRoles.GUEST;
            }
        }
        return null;
    }

    @Override
    public boolean setProject(HiProject project) throws HIWebServiceException {
        boolean success;
        block21: {
            try {
                String tempSortOrder;
                String projPolygons;
                int n;
                String role;
                block22: {
                    success = true;
                    if (!success) break block21;
                    this.project = project;
                    this.importGroup = null;
                    this.trashGroup = null;
                    this.importGroup = this.getImportGroup();
                    this.trashGroup = this.getTrashGroup();
                    role = null;
                    try {
                        role = this.target.path("getCurrentRole/" + project.getId()).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(String.class);
                    }
                    catch (Exception ex) {
                        if (this.curUser.getUserName().compareTo("sysop") == 0) break block22;
                        throw ex;
                    }
                }
                this.curRole = this.mapRole(role);
                this.thumbnailCache.clear();
                this.state = HIWebServiceManagerInterface.WSStates.IN_PROJECT;
                this.projectColors.removeAllElements();
                this.projectPolygons.removeAllElements();
                this.projectTags = null;
                String projColors = MetadataHelper.findPreferenceValue(project, "colors");
                if (projColors == null) {
                    projColors = this.createPreference("colors", "").getValue();
                }
                if (projColors.length() > 0) {
                    try {
                        String[] stringArray = projColors.split(":");
                        n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String color = stringArray[n2];
                            this.projectColors.addElement(new Color(Integer.parseInt(color.split(",")[0]), Integer.parseInt(color.split(",")[1]), Integer.parseInt(color.split(",")[2])));
                            ++n2;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing color pref!");
                        MetadataHelper.setPreferenceValue(project, "colors", "");
                        this.projectColors.removeAllElements();
                    }
                }
                if ((projPolygons = MetadataHelper.findPreferenceValue(project, "polygons")) == null) {
                    projPolygons = this.createPreference("polygons", "").getValue();
                }
                if (projPolygons.length() > 0) {
                    try {
                        String[] stringArray = projPolygons.split(":");
                        int n3 = stringArray.length;
                        n = 0;
                        while (n < n3) {
                            Object polygon = stringArray[n];
                            this.projectPolygons.addElement((String)polygon);
                            ++n;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Error parsing polygon pref!");
                        MetadataHelper.setPreferenceValue(project, "polygons", "");
                        this.projectPolygons.removeAllElements();
                    }
                }
                if ((tempSortOrder = MetadataHelper.findPreferenceValue(project, "templateSortOrder")) == null) {
                    HiFlexMetadataTemplate hiInternalTemplate = null;
                    for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
                        if (template.getNamespacePrefix().compareTo("HIInternal") != 0) continue;
                        hiInternalTemplate = template;
                    }
                    if (hiInternalTemplate != null) {
                        this.project.getTemplates().remove(hiInternalTemplate);
                        this.project.getTemplates().add(hiInternalTemplate);
                    }
                    String initSortOrder = "";
                    int i = 0;
                    while (i < this.project.getTemplates().size()) {
                        initSortOrder = String.valueOf(initSortOrder) + "," + this.project.getTemplates().get(i).getId();
                        ++i;
                    }
                    if (initSortOrder.length() > 0) {
                        initSortOrder = initSortOrder.substring(1);
                    }
                    tempSortOrder = this.createPreference("templateSortOrder", initSortOrder).getValue();
                }
                if (tempSortOrder.length() > 0) {
                    for (HiFlexMetadataTemplate template : this.project.getTemplates()) {
                        this.sortTemplate(template);
                    }
                }
            }
            catch (Exception e) {
                throw new HIWebServiceException(e);
            }
        }
        return success;
    }

    @Override
    public boolean setProjectRole(long userID, HiRoles role) throws HIWebServiceException {
        try {
            boolean roleSet = this.target.path("adminSetProjectRole/project/" + this.project.getId() + "/user/" + userID + "/role/" + role.toString()).request().accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""), Boolean.class);
            if (roleSet && userID == this.curUser.getId()) {
                this.curRole = role;
            }
            return roleSet;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean setProjectRole(HiUser user, HiRoles role) throws HIWebServiceException {
        return this.setProjectRole(user.getId(), role);
    }

    @Override
    public void setReconnect() {
    }

    @Override
    public List<HiQuickInfo> simpleSearch(String text, String language) throws HIWebServiceException {
        try {
            return this.target.path("simpleSearch/project/" + this.project.getId() + "/text/" + text + "/language/" + language).request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(new GenericType<List<HiQuickInfo>>(){});
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateContentOwner(long objectID, long contentID) throws HIWebServiceException {
        try {
            return this.target.path("updateContentOwner/object/" + objectID + "/content/" + contentID).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateContentOwner(HiObject object, HiObjectContent content) throws HIWebServiceException {
        if (this.updateContentOwner(object.getId(), content.getId())) {
            object.getViews().add(content);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateFlexMetadataRecord(HiFlexMetadataRecord record) throws HIWebServiceException {
        try {
            return this.target.path("updateFlexMetadataRecord").request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(record, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateFlexMetadataRecords(List<HiFlexMetadataRecord> records) throws HIWebServiceException {
        try {
            return this.target.path("updateFlexMetadataRecords").request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(records, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateGroupProperties(long groupID, boolean visible) throws HIWebServiceException {
        throw new HIWebServiceException(new Exception("no longer supported"));
    }

    @Override
    public boolean updateGroupProperties(HiGroup group, boolean visible) throws HIWebServiceException {
        return this.updateGroupProperties(group.getId(), visible);
    }

    @Override
    public void updateGroupSortOrder(long groupID, String sortOrder) throws HIWebServiceException {
        try {
            this.target.path("updateGroupSortOrder/group/" + groupID + "/sortorder/" + sortOrder).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateGroupSortOrder(HiGroup group, String sortOrder) throws HIWebServiceException {
        this.updateGroupSortOrder(group.getId(), sortOrder);
        group.setSortOrder(sortOrder);
    }

    @Override
    public boolean updateLayerProperties(long layerID, int red, int green, int blue, float opacity, String polygons) throws HIWebServiceException {
        try {
            HiLayer tmpLayer = new HiLayer();
            tmpLayer.setId(layerID);
            tmpLayer.setRed(red);
            tmpLayer.setGreen(green);
            tmpLayer.setBlue(blue);
            tmpLayer.setOpacity(opacity);
            tmpLayer.setPolygons(polygons);
            return this.target.path("updateLayerProperties").request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(tmpLayer, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateLayerProperties(HiLayer layer, int red, int green, int blue, float opacity, String polygons) throws HIWebServiceException {
        return this.updateLayerProperties(layer.getId(), red, green, blue, opacity, polygons);
    }

    @Override
    public boolean updateLightTable(HiLightTable lightTable) throws HIWebServiceException {
        try {
            return this.target.path("updateLightTable").request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(lightTable, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateObjectSortOrder(long objectID, String sortOrder) throws HIWebServiceException {
        try {
            this.target.path("updateObjectSortOrder/object/" + objectID + "/sortorder/" + sortOrder).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateObjectSortOrder(HiObject object, String sortOrder) throws HIWebServiceException {
        this.updateObjectSortOrder(object.getId(), sortOrder);
        object.setSortOrder(sortOrder);
    }

    @Override
    public boolean updatePassword(String password) throws HIWebServiceException {
        return this.updateUserPassword(this.curUser.getId(), password);
    }

    @Override
    public boolean updatePreference(long prefID, String value) throws HIWebServiceException {
        HiPreference projPref;
        block7: {
            if (this.project == null) {
                return false;
            }
            try {
                projPref = null;
                for (HiPreference pref : this.project.getPreferences()) {
                    if (pref.getId() != prefID) continue;
                    projPref = pref;
                }
                if (projPref != null) break block7;
                return false;
            }
            catch (Exception se) {
                throw new HIWebServiceException(se);
            }
        }
        boolean prefUpdated = this.target.path("updatePreference/pref/" + prefID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(value, "application/json"), Boolean.class);
        if (prefUpdated) {
            projPref.setValue(value);
            if (projPref.getKey().compareTo("templateSortOrder") == 0) {
                this.sortTemplates(value);
            }
        }
        return prefUpdated;
    }

    @Override
    public boolean updatePreference(HiPreference pref) throws HIWebServiceException {
        return this.updatePreference(pref.getId(), pref.getValue());
    }

    @Override
    public boolean updateProject(String languageID, String title) throws HIWebServiceException {
        try {
            HiProjectMetadata md = new HiProjectMetadata();
            md.setId(this.project.getId());
            md.setTitle(title);
            md.setLanguageID(languageID);
            boolean updated = this.target.path("updateProjectMetadata/" + this.project.getId()).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(md, "application/json"), Boolean.class);
            if (updated) {
                this.refreshProject();
            }
            return updated;
        }
        catch (Exception se) {
            se.printStackTrace();
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateProjectColors() throws HIWebServiceException {
        HiPreference colorPref = MetadataHelper.findPreference(this.project, "colors");
        colorPref.setValue(this.serializeProjectColorsPreference());
        this.updatePreference(colorPref);
    }

    @Override
    public boolean updateProjectDefaultLanguage(String language) throws HIWebServiceException {
        try {
            boolean success = this.target.path("updateProjectDefaultLanguage/project/" + this.project.getId() + "/language/" + language).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""), Boolean.class);
            if (success) {
                this.refreshProject();
            }
            return success;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateProjectQuota(long projectID, long quota) throws HIWebServiceException {
        try {
            this.target.path("sysopUpdateProjectQuota/project/" + this.project.getId() + "/quota/" + quota).request().property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).post(null);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateProjectQuota(HiProject project, long quota) throws HIWebServiceException {
        this.updateProjectQuota(project.getId(), quota);
    }

    @Override
    public boolean updateProjectStartElement(long baseID) throws HIWebServiceException {
        try {
            boolean success = this.target.path("updateProjectStartElement/project/" + this.project.getId() + "/base/" + baseID).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""), Boolean.class);
            if (success) {
                this.project = this.getProject();
            }
            return success;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateProjectStartElement(HiBase base) throws HIWebServiceException {
        return this.updateProjectStartElement(base.getId());
    }

    @Override
    public void updateSetDisplayName(HiFlexMetadataSet set, String lang, String displayName) throws HIWebServiceException {
        if (set == null) {
            return;
        }
        if (lang == null || lang.length() == 0) {
            return;
        }
        try {
            HiFlexMetadataName tmpName = new HiFlexMetadataName();
            tmpName.setLanguage(lang);
            tmpName.setDisplayName(displayName);
            this.target.path("adminUpdateSetDisplayName/set/" + set.getId()).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(tmpName, "application/json"));
            this.refreshProject();
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateTemplate(HiFlexMetadataTemplate template, String templateURI, String templateURL) throws HIWebServiceException {
        try {
            boolean templateUpdated = this.target.path("adminUpdateTemplate/template/" + template.getId() + "/templateURI/" + templateURI + "/templateURL/" + templateURL).request().property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(Boolean.class);
            if (templateUpdated) {
                this.refreshProject();
            }
            return templateUpdated;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateTemplateSortOrder(HiFlexMetadataTemplate template, String sortOrder) throws HIWebServiceException {
        try {
            boolean templateUpdated = this.target.path("adminUpdateTemplateSortOrder/" + template.getId()).request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(sortOrder, "application/json"), Boolean.class);
            if (templateUpdated) {
                this.refreshProject();
            }
            return templateUpdated;
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateURL(Hiurl url) throws HIWebServiceException {
        try {
            return this.target.path("updateURL").request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(url, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateUser(long userID, String firstName, String lastName, String email) throws HIWebServiceException {
        try {
            HiUser tmpUser = new HiUser();
            tmpUser.setId(userID);
            tmpUser.setFirstName(firstName);
            tmpUser.setLastName(lastName);
            tmpUser.setEmail(email);
            tmpUser.setPassword("");
            return this.target.path("updateUser").request("application/json").accept("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(tmpUser, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateUser(HiUser user, String firstName, String lastName, String email) throws HIWebServiceException {
        return this.updateUser(user.getId(), firstName, lastName, email);
    }

    @Override
    public boolean updateUser(String firstName, String lastName, String email) throws HIWebServiceException {
        return this.updateUser(this.curUser.getId(), firstName, lastName, email);
    }

    @Override
    public boolean updateUser(HiUser user) throws HIWebServiceException {
        return this.updateUser(user.getId(), user.getFirstName(), user.getLastName(), user.getEmail());
    }

    @Override
    public boolean updateUserPassword(long userID, String newpass) throws HIWebServiceException {
        try {
            return this.target.path("updateUserPassword/" + userID).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.entity(newpass, "application/json"), Boolean.class);
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public boolean updateUserPassword(HiUser user, String password) throws HIWebServiceException {
        return this.updateUserPassword(user.getId(), password);
    }

    @Override
    public void updateViewSortOrder(long viewID, String sortOrder) throws HIWebServiceException {
        try {
            this.target.path("updateViewSortOrder/view/" + viewID + "/sortorder/" + sortOrder).request("text/plain").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).method("PATCH", Entity.text(""));
        }
        catch (Exception se) {
            throw new HIWebServiceException(se);
        }
    }

    @Override
    public void updateViewSortOrder(HiView view, String sortOrder) throws HIWebServiceException {
        this.updateViewSortOrder(view.getId(), sortOrder);
        view.setSortOrder(sortOrder);
    }

    private SSLContext getSSLContext() {
        X509TrustManager x509 = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, new TrustManager[]{x509}, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return ctx;
    }

    private String serializeProjectColorsPreference() {
        String colors = "";
        for (Color color : this.projectColors) {
            String colorString = String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
            colors = colors.length() == 0 ? colorString : String.valueOf(colors) + ":" + colorString;
        }
        return colors;
    }

    private String serializeProjectPolygonsPreference() {
        String polygons = "";
        for (String polygonString : this.projectPolygons) {
            polygons = polygons.length() == 0 ? polygonString : String.valueOf(polygons) + ":" + polygonString;
        }
        return polygons;
    }
}

