/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.views.AccountSettingsView;
import org.hyperimage.client.ws.HiUser;

public class AccountSettings
extends HIComponent
implements ActionListener {
    private AccountSettingsView settingsView;
    private HiUser user;

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.setTitle(Messages.getString("AccountSettings.ACCOUNTSETTINGS"));
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges();
    }

    public AccountSettings(HiUser user) {
        super(Messages.getString("AccountSettings.ACCOUNTSETTINGS"), Messages.getString("AccountSettings.ACCOUNT"));
        this.user = user;
        this.settingsView = new AccountSettingsView(user);
        this.views.add(this.settingsView);
        this.settingsView.getUpdateButton().addActionListener(this);
        this.settingsView.getCancelButton().addActionListener(this);
    }

    private void saveNewPassword() {
        if (this.settingsView.hasPasswordChanges()) {
            String password = this.settingsView.getNewPassword();
            if (password.length() < 6) {
                HIRuntime.getGui().displayInfoDialog(Messages.getString("AccountSettings.CHANGEPASSWORD"), Messages.getString("AccountSettings.NEWPWD6CHARS"));
                this.settingsView.resetPassword();
            } else {
                try {
                    HIRuntime.getManager().updateUserPassword(this.user, password);
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("AccountSettings.CHANGEPASSWORD"), Messages.getString("AccountSettings.PWDCHANGESUCCESSFUL"));
                    this.settingsView.resetPassword();
                }
                catch (HIWebServiceException wse) {
                    this.settingsView.resetPassword();
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
            }
        }
    }

    private void saveMetadataChanges() {
        if (this.settingsView.hasMetadataChanges()) {
            this.settingsView.syncMetadataChanges();
            try {
                HIRuntime.getManager().updateUser(this.user);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
    }

    private boolean askToSaveOrCancelChanges() {
        if ((this.settingsView.hasMetadataChanges() || this.settingsView.hasMetadataChanges()) && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = JOptionPane.showConfirmDialog(HIRuntime.getGui(), Messages.getString("AccountSettings.SAVEACCOUNTCHANGES"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
                this.saveNewPassword();
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("update") && (this.settingsView.hasMetadataChanges() || this.settingsView.hasPasswordChanges())) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            this.saveMetadataChanges();
            this.saveNewPassword();
        }
        if (e.getActionCommand().equalsIgnoreCase("cancel")) {
            this.settingsView.getUpdateButton().removeActionListener(this);
            this.settingsView.getCancelButton().removeActionListener(this);
            HIRuntime.getGui().deregisterComponent(this, true);
        }
    }
}

