/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.views.FeedbackView;
import org.hyperimage.client.util.MetadataHelper;

public class FeedbackModule
extends HIComponent
implements ActionListener {
    private FeedbackView feedbackView = new FeedbackView();
    private String feedback;

    public FeedbackModule(boolean isBug) {
        super("Feedback / Bug Report", "Feedback");
        if (isBug) {
            this.feedbackView.setFeedbackOption(1);
        }
        this.views.add(this.feedbackView);
        this.feedbackView.getFeedbackButton().addActionListener(this);
    }

    public FeedbackModule() {
        this(false);
    }

    private void addLine(String line) {
        this.feedback = String.valueOf(this.feedback) + line + "\n";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.feedbackView.getText().length() <= 0) {
            return;
        }
        try {
            PrintWriter writer;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            this.feedback = "";
            this.addLine("Type            : " + this.feedbackView.getType());
            this.addLine("User            : " + HIRuntime.getManager().getCurrentUser().getLastName() + ", " + HIRuntime.getManager().getCurrentUser().getFirstName() + " (" + HIRuntime.getManager().getCurrentUser().getUserName() + ") " + HIRuntime.getManager().getCurrentUser().getEmail());
            this.addLine("Project         : P" + HIRuntime.getManager().getProject().getId() + " - " + MetadataHelper.findValue(HIRuntime.getManager().getProject(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
            this.addLine("Client Version  : " + HIRuntime.getClientVersion());
            this.addLine("Service URL     : " + HIRuntime.getManager().getServerURL());
            try {
                this.addLine("Service Version : " + HIRuntime.getManager().getVersionID());
            }
            catch (HIWebServiceException e3) {
                // empty catch block
            }
            this.addLine("Client OS       : " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            this.addLine("Java Version    : " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
            if (HIRuntime.getGui().getLastWSError() == null) {
                this.addLine("Last WS Error   : -none-");
            } else {
                HIWebServiceException lastWSError = HIRuntime.getGui().getLastWSError();
                this.addLine("Last WS Error   : " + lastWSError.getCause().getMessage() + " (" + (Object)((Object)lastWSError.getErrorType()) + ")");
                this.addLine("");
                this.addLine("Stack Trace");
                this.addLine("-----------");
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                writer = new PrintWriter(byteStream);
                lastWSError.getCause().printStackTrace(writer);
                writer.close();
                this.addLine(new String(byteStream.toByteArray()));
            }
            this.addLine("");
            this.addLine("Message");
            this.addLine("-------");
            this.feedback = String.valueOf(this.feedback) + this.feedbackView.getText();
            this.feedback = String.valueOf(this.feedback) + "\n\n";
            this.feedback = URLEncoder.encode(this.feedback, "UTF-8");
            URL url = new URL("https://hyperimage.cms.hu-berlin.de/2.0/wstart/provideFeedback.php");
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            writer = new PrintWriter(connection.getOutputStream());
            writer.write("raw_fb=" + this.feedback);
            writer.close();
            connection.connect();
            String response = connection.getResponseMessage();
            if (response.compareTo("OK") == 0) {
                HIRuntime.getGui().clearLastWSError();
                HIRuntime.getGui().displayInfoDialog("Feedback gesendet", "Vielen Dank f\u00fcr Ihr Feedback!\n\nIhre Nachricht wurde an die HyperImage Entwickler gesendet.");
            } else {
                HIRuntime.getGui().displayInfoDialog("Feedback Fehlgeschlagen", "Leider konnte Ihr Feedback aufgrund eines Systemfehlers nicht gesendet werden.\nBitte versuchen Sie es sp\u00e4ter erneut.\n\nSollte das Problem bestehen bleiben wenden Sie sich bitte per mail an die Entwickler.\n\nVielen Dank!");
            }
            connection.disconnect();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            HIRuntime.getGui().displayInfoDialog("Feedback Fehlgeschlagen", "Leider konnte Ihr Feedback aufgrund eines Systemfehlers nicht gesendet werden.\nBitte versuchen Sie es sp\u00e4ter erneut.\n\nSollte das Problem bestehen bleiben wenden Sie sich bitte per mail an die Entwickler.\n\nVielen Dank!");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            HIRuntime.getGui().displayInfoDialog("Feedback Fehlgeschlagen", "Leider konnte Ihr Feedback aufgrund eines Systemfehlers nicht gesendet werden.\nBitte versuchen Sie es sp\u00e4ter erneut.\n\nSollte das Problem bestehen bleiben wenden Sie sich bitte per mail an die Entwickler.\n\nVielen Dank!");
        }
        HIRuntime.getGui().deregisterComponent(this, false);
    }
}

