/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.views.GenericMetadataEditorView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;

public class GenericMetadataEditor
extends HIComponent
implements ActionListener {
    protected GenericMetadataEditorView editorView;
    private HiBase base;

    public GenericMetadataEditor(HiText text) {
        super(String.valueOf(Messages.getString("GenericMetadataEditor.0")) + " (" + (text.getUUID() == null ? "T" + text.getId() : text.getUUID()) + ")", Messages.getString("GenericMetadataEditor.3"));
        this.base = text;
        this.editorView = new GenericMetadataEditorView(text, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.initEditor();
    }

    public GenericMetadataEditor(HiInscription inscription) {
        super(String.valueOf(Messages.getString("GenericMetadataEditor.4")) + " (" + (inscription.getUUID() == null ? "I" + inscription.getId() : inscription.getUUID()) + ")", Messages.getString("GenericMetadataEditor.7"));
        this.base = inscription;
        this.editorView = new GenericMetadataEditorView(inscription, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.initEditor();
    }

    public GenericMetadataEditor(Hiurl url) {
        super(String.valueOf(Messages.getString("GenericMetadataEditor.8")) + " (" + (url.getUUID() == null ? "U" + url.getId() : url.getUUID()) + ")", Messages.getString("GenericMetadataEditor.11"));
        this.base = url;
        this.editorView = new GenericMetadataEditorView(url, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.initEditor();
    }

    public GenericMetadataEditor(HiView view) {
        super(String.valueOf(Messages.getString("GenericMetadataEditor.12")) + " (" + (view.getUUID() == null ? "V" + view.getId() : view.getUUID()) + ")", Messages.getString("GenericMetadataEditor.15"));
        this.base = view;
        this.editorView = new GenericMetadataEditorView(view, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.initEditor();
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        if (this.base instanceof HiText) {
            this.setTitle(String.valueOf(Messages.getString("GenericMetadataEditor.0")) + " (T" + this.base.getId() + ")");
        }
        if (this.base instanceof HiInscription) {
            this.setTitle(String.valueOf(Messages.getString("GenericMetadataEditor.4")) + " (I" + this.base.getId() + ")");
        }
        if (this.base instanceof Hiurl) {
            this.setTitle(String.valueOf(Messages.getString("GenericMetadataEditor.8")) + " (U" + this.base.getId() + ")");
        }
        if (this.base instanceof HiView) {
            this.setTitle(String.valueOf(Messages.getString("GenericMetadataEditor.12")) + " (V" + this.base.getId() + ")");
        }
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        if (message == HIComponent.HIMessageTypes.ENTITY_CHANGED && this.base.getId() == base.getId()) {
            this.editorView.resetChanges();
        }
        if (message == HIComponent.HIMessageTypes.LANGUAGE_ADDED || message == HIComponent.HIMessageTypes.LANGUAGE_REMOVED) {
            if (this.base == null) {
                return;
            }
            if (this.base instanceof Hiurl || this.base instanceof HiLightTable) {
                return;
            }
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                List<HiFlexMetadataRecord> records = HIRuntime.getManager().getFlexMetadataRecords(this.base);
                while (this.base.getMetadata().size() > 0) {
                    this.base.getMetadata().remove(0);
                }
                for (HiFlexMetadataRecord record : records) {
                    this.base.getMetadata().add(record);
                }
                this.base.setTimestamp(new Date().getTime());
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
            this.editorView.updateMetadata();
        }
    }

    private void initEditor() {
        this.editorView.getSaveButton().addActionListener(this);
        this.editorView.getResetButton().addActionListener(this);
        this.views.add(this.editorView);
    }

    @Override
    public HiBase getBaseElement() {
        return this.base;
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges();
    }

    private void saveMetadataChanges() {
        if (this.editorView.hasChanges() && HIRuntime.getGui().checkEditAbility(false)) {
            this.editorView.syncChanges();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                if (!(this.base instanceof Hiurl)) {
                    HIRuntime.getManager().updateFlexMetadataRecords(MetadataHelper.resolveMetadataRecords(this.base));
                } else {
                    HIRuntime.getManager().updateURL((Hiurl)this.base);
                }
                this.base.setTimestamp(new Date().getTime());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.editorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.base, this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
    }

    private boolean askToSaveOrCancelChanges() {
        if (this.editorView.hasChanges() && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = HIRuntime.getGui().displayUserChoiceDialog(Messages.getString("GenericMetadataEditor.16"), Messages.getString("GenericMetadataEditor.17"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("save") && this.editorView.hasChanges() && HIRuntime.getGui().checkEditAbility(false)) {
            this.saveMetadataChanges();
        }
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.editorView.resetChanges();
        }
    }
}

