/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.components.SearchModule;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.GroupTransferable;
import org.hyperimage.client.gui.dnd.LayerTransferable;
import org.hyperimage.client.gui.dnd.ObjectContentTransferable;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.gui.lists.GroupContentsCellRenderer;
import org.hyperimage.client.gui.lists.GroupContentsList;
import org.hyperimage.client.gui.lists.GroupListCellRenderer;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.GroupContentsView;
import org.hyperimage.client.gui.views.GroupListView;
import org.hyperimage.client.gui.views.GroupPropertyEditorView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.util.WSImageLoaderThread;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiView;

public class GroupBrowser
extends HIComponent
implements ListSelectionListener,
ActionListener,
MouseListener {
    private GroupListView groupListView;
    private GroupContentsView groupContentsView;
    private GroupPropertyEditorView metadataEditorView;
    private HIGroupContentLoader contentLoader;
    private HIComponent browser = this;
    private GroupContentsList.HI_ListDisplayStyles userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.ICON_STYLE;
    private GroupContentsTransferHandler groupContentsHandler;

    public GroupBrowser() {
        this(HIRuntime.getManager().getImportGroup());
    }

    public GroupBrowser(HiGroup group) {
        super(Messages.getString("GroupBrowser.17"), Messages.getString("GroupBrowser.18"));
        this.groupListView = new GroupListView(HIRuntime.getManager().getImportGroup(), HIRuntime.getManager().getTrashGroup(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.groupContentsView = new GroupContentsView();
        this.metadataEditorView = new GroupPropertyEditorView();
        this.contentLoader = new HIGroupContentLoader();
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            this.groupListView.setGroups(HIRuntime.getManager().getGroups());
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
        }
        HIRuntime.getGui().startIndicatingServiceActivity();
        this.groupListView.getList().setEnabled(false);
        this.groupContentsView.prepareElementLoading();
        if (group == null) {
            group = HIRuntime.getManager().getImportGroup();
        }
        if (group.getId() != HIRuntime.getManager().getImportGroup().getId()) {
            int groupIndex = -1;
            int i = 0;
            while (i < this.groupListView.getList().getModel().getSize()) {
                if (((HiGroup)this.groupListView.getList().getModel().getElementAt(i)).getId() == group.getId()) {
                    groupIndex = i;
                    group = (HiGroup)this.groupListView.getList().getModel().getElementAt(i);
                }
                ++i;
            }
            if (groupIndex == -1) {
                group = HIRuntime.getManager().getImportGroup();
            } else {
                this.groupListView.getList().setSelectedIndex(groupIndex);
            }
        }
        this.groupContentsView.setCurrentGroup(group);
        this.metadataEditorView.setGroup(group, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.metadataEditorView.setTagCount(HIRuntime.getGui().getTagCountForElement(group));
        this.contentLoader.loadGroup(group);
        HIRuntime.getGui().stopIndicatingServiceActivity();
        this.updateTitle();
        this.groupContentsHandler = new GroupContentsTransferHandler(this);
        this.groupContentsView.getContentsList().setTransferHandler(this.groupContentsHandler);
        this.groupListView.getList().setTransferHandler(new GroupTransferHandler(this));
        this.metadataEditorView.getSaveButton().addActionListener(this);
        this.metadataEditorView.getResetButton().addActionListener(this);
        this.groupContentsView.getContentsList().addMouseListener(this);
        this.groupContentsView.getListStyleButton().addActionListener(this);
        this.groupContentsView.optionsButton.addActionListener(this);
        this.groupContentsView.setMenuActionListener(this);
        this.groupListView.getList().addListSelectionListener(this);
        this.groupListView.attachActionListeners(this);
        this.groupListView.getList().addMouseListener(this);
        this.views.add(this.groupListView);
        this.views.add(this.groupContentsView);
        this.views.add(this.metadataEditorView);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        if (this.groupContentsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.groupContentsView.getListStyleButton().setToolTipText(Messages.getString("GroupBrowser.77"));
        } else {
            this.groupContentsView.getListStyleButton().setToolTipText(Messages.getString("GroupBrowser.78"));
        }
        this.updateTitle();
    }

    @Override
    public HiBase getBaseElement() {
        if (this.groupListView.getList().getModel().getSize() > 0 && this.groupListView.getList().getSelectedIndex() >= 0) {
            return (HiGroup)this.groupListView.getList().getSelectedValue();
        }
        return null;
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        HiGroup changedGroup;
        if (message == HIComponent.HIMessageTypes.LANGUAGE_ADDED || message == HIComponent.HIMessageTypes.LANGUAGE_REMOVED) {
            DefaultListModel model = (DefaultListModel)this.groupListView.getList().getModel();
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                int i = 1;
                while (i < model.getSize() - 1) {
                    HiGroup group = (HiGroup)model.get(i);
                    List<HiFlexMetadataRecord> records = HIRuntime.getManager().getFlexMetadataRecords(group);
                    while (group.getMetadata().size() > 0) {
                        group.getMetadata().remove(0);
                    }
                    for (HiFlexMetadataRecord record : records) {
                        group.getMetadata().add(record);
                    }
                    ++i;
                }
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
            this.metadataEditorView.setGroup(this.groupListView.getCurrentGroup(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
            this.metadataEditorView.setTagCount(HIRuntime.getGui().getTagCountForElement(this.groupListView.getCurrentGroup()));
        }
        if (message == HIComponent.HIMessageTypes.ENTITY_CHANGED) {
            if (base instanceof HiGroup) {
                this.groupListView.updateGroup((HiGroup)base);
                if (this.groupListView.getCurrentGroup().getId() == base.getId()) {
                    this.metadataEditorView.setGroup((HiGroup)base, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                    this.metadataEditorView.setTagCount(HIRuntime.getGui().getTagCountForElement((HiGroup)base));
                }
            }
            for (HiQuickInfo content : this.groupContentsView.getContents()) {
                if (content.getBaseID() != base.getId() && content.getRelatedID() != base.getId()) continue;
                try {
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    HiQuickInfo newInfo = HIRuntime.getManager().getContentInfo(content);
                    this.groupContentsView.updateQuickInfo(newInfo);
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                    this.loadContentPreview(newInfo);
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                }
            }
        }
        if (message == HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED && ((changedGroup = (HiGroup)base).getId() == this.groupListView.getCurrentGroup().getId() || this.groupListView.getCurrentGroup().getType() != GroupTypes.HIGROUP_REGULAR)) {
            this.groupListView.getList().setEnabled(false);
            this.groupContentsView.prepareElementLoading();
            this.contentLoader.loadGroup(this.groupListView.getCurrentGroup());
        }
        if (message == HIComponent.HIMessageTypes.CONTENT_MOVED_TO_TRASH || message == HIComponent.HIMessageTypes.MOVED_TO_TRASH) {
            this.groupListView.getList().setEnabled(false);
            this.groupContentsView.prepareElementLoading();
            this.contentLoader.loadGroup(this.groupListView.getCurrentGroup());
        }
        if (message == HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED) {
            this.groupListView.getList().setEnabled(false);
            this.groupContentsView.prepareElementLoading();
            this.contentLoader.loadGroup(this.groupListView.getCurrentGroup());
            ((GroupListCellRenderer)this.groupListView.getList().getCellRenderer()).setDefaultLang(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
            this.groupListView.getList().repaint();
        }
        if ((message == HIComponent.HIMessageTypes.ENTITY_ADDED || message == HIComponent.HIMessageTypes.ENTITY_REMOVED) && base instanceof HiGroup) {
            try {
                this.groupListView.setGroups(HIRuntime.getManager().getGroups());
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (message == HIComponent.HIMessageTypes.GROUP_SORTORDER_CHANGED) {
            try {
                this.groupListView.setGroups(HIRuntime.getManager().getGroups());
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (message == HIComponent.HIMessageTypes.GROUPCONTENTS_SORTORDER_CHANGED && base != null) {
            HiGroup group = (HiGroup)base;
            int i = 0;
            while (i < this.groupListView.getList().getModel().getSize()) {
                if (this.groupListView.getGroup(i).getId() == group.getId()) {
                    this.groupListView.getGroup(i).setSortOrder(group.getSortOrder());
                    if (this.groupListView.getGroup(i).getId() == this.groupListView.getCurrentGroup().getId()) {
                        this.groupContentsView.sortContents();
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges();
    }

    public void resetBrowser() {
        this.discardChanges();
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            this.groupListView.resetAllGroups(HIRuntime.getManager().getImportGroup(), HIRuntime.getManager().getTrashGroup(), HIRuntime.getManager().getGroups());
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
        }
    }

    private void saveMetadataChanges() {
        boolean updateMetadata = this.metadataEditorView.hasMetadataChanges();
        if (updateMetadata && HIRuntime.getGui().checkEditAbility(false)) {
            this.metadataEditorView.syncChanges();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateFlexMetadataRecords(this.metadataEditorView.getMetadata());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.groupContentsView.getCurrentGroup(), this);
                this.groupListView.updateContent();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void discardChanges() {
        if (this.metadataEditorView.hasChanges()) {
            this.metadataEditorView.resetChanges();
        }
    }

    private boolean askToSaveOrCancelChanges() {
        if (this.metadataEditorView.hasChanges() && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = JOptionPane.showConfirmDialog(HIRuntime.getGui(), Messages.getString("GroupBrowser.19"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
            }
        }
        return true;
    }

    private HiGroup createGroup() {
        HiGroup newGroup = null;
        if (HIRuntime.getGui().checkEditAbility(false)) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                newGroup = HIRuntime.getManager().createGroup();
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return null;
            }
        }
        return newGroup;
    }

    private void loadContentPreviews() {
        for (HiQuickInfo info : this.groupContentsView.getContents()) {
            this.loadContentPreview(info);
        }
    }

    private void loadContentPreview(HiQuickInfo info) {
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.groupContentsView.getContentsList().getCellRenderer();
        QuickInfoCell cell = renderer.getCellForContent(info);
        if (cell != null && cell.needsPreview()) {
            WSImageLoaderThread thumbLoader = new WSImageLoaderThread();
            long viewID = info.getBaseID();
            boolean cacheImage = true;
            if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
                viewID = info.getRelatedID();
            }
            if (info.getContentType() == HiBaseTypes.HI_LAYER) {
                cacheImage = false;
            }
            thumbLoader.loadImage(viewID, cacheImage, HiImageSizes.HI_THUMBNAIL, cell, this.groupContentsView.getContentsList());
        }
    }

    private boolean updateContentSortOrder() {
        String sortOrder = this.groupContentsView.getSortOrder();
        if (!HIRuntime.getGui().checkEditAbility(true)) {
            return true;
        }
        if (this.groupListView == null || this.groupListView.getCurrentGroup() == null) {
            return false;
        }
        if (this.groupListView.getCurrentGroup().getType() != GroupTypes.HIGROUP_REGULAR) {
            return true;
        }
        if (this.groupListView.getCurrentGroup().getSortOrder().compareTo(sortOrder) != 0) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateGroupSortOrder(this.groupListView.getCurrentGroup(), sortOrder);
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return false;
            }
        }
        return true;
    }

    private void updateTitle() {
        HiGroup group = this.groupListView.getCurrentGroup();
        String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)group, HIRuntime.getManager().getProject().getDefaultLanguage()));
        title = title == null || title.length() == 0 ? (group.getUUID() == null ? "G" + group.getId() : group.getUUID()) : "\"" + title + "\"";
        if (group.getType() == GroupTypes.HIGROUP_REGULAR) {
            this.setTitle(String.valueOf(Messages.getString("GroupBrowser.25")) + " (" + title + ")");
        }
        if (group.getType() == GroupTypes.HIGROUP_IMPORT) {
            this.setTitle(Messages.getString("GroupBrowser.28"));
        }
        if (group.getType() == GroupTypes.HIGROUP_TRASH) {
            this.setTitle(Messages.getString("GroupBrowser.29"));
        }
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.groupListView.getList().getSelectedIndex() == -1) {
            this.groupListView.setSelectedGroup(this.groupContentsView.getCurrentGroup());
        }
        if (this.groupListView.getCurrentGroup().getId() != this.groupContentsView.getCurrentGroup().getId()) {
            if (!this.askToSaveOrCancelChanges()) {
                this.groupListView.setSelectedGroup(this.groupContentsView.getCurrentGroup());
                return;
            }
            this.groupListView.getList().setEnabled(false);
            this.groupContentsView.prepareElementLoading();
            HiGroup group = this.groupListView.getCurrentGroup();
            this.groupContentsView.setCurrentGroup(group);
            this.metadataEditorView.setGroup(group, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
            this.metadataEditorView.setTagCount(HIRuntime.getGui().getTagCountForElement(group));
            if (group != null) {
                this.contentLoader.loadGroup(group);
            }
            this.updateTitle();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] indices;
        if (e.getActionCommand().startsWith("new")) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HiBase newElement = null;
                if (e.getActionCommand().equalsIgnoreCase("newText")) {
                    newElement = HIRuntime.getManager().createText();
                }
                if (e.getActionCommand().equalsIgnoreCase("newURL")) {
                    newElement = HIRuntime.getManager().createURL("", "", "");
                }
                if (e.getActionCommand().equalsIgnoreCase("newLighttable")) {
                    newElement = HIRuntime.getManager().createLightTable("", MetadataHelper.getDefaultLightTableXML());
                }
                if (e.getActionCommand().equalsIgnoreCase("newObject")) {
                    newElement = HIRuntime.getManager().createObject();
                }
                HIRuntime.getManager().copyToGroup(newElement.getId(), this.groupListView.getCurrentGroup().getId());
                HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(newElement.getId());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.groupContentsView.addContent(info);
                this.updateContentSortOrder();
                this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newElement, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, this.groupListView.getCurrentGroup(), this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUPCONTENTS_SORTORDER_CHANGED, this.groupListView.getCurrentGroup(), this);
                HIRuntime.getGui().openContentEditor(info, (HIComponent)this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("groupFromSelection")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            indices = this.groupContentsView.getContentsList().getSelectedIndices();
            HiGroup newGroup = this.createGroup();
            if (newGroup != null) {
                try {
                    String title;
                    String groupTitle = "";
                    HiGroup curGroup = this.groupListView.getCurrentGroup();
                    groupTitle = curGroup.getType() == GroupTypes.HIGROUP_IMPORT ? Messages.getString("GroupBrowser.40") : (curGroup.getType() == GroupTypes.HIGROUP_TRASH ? Messages.getString("GroupBrowser.41") : ((title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)curGroup, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()))) == null || title.length() == 0 ? (curGroup.getUUID() == null ? "G" + curGroup.getId() : curGroup.getUUID()) : title));
                    HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord((HiBase)newGroup, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                    if (record != null) {
                        MetadataHelper.setValue("HIBase", "title", String.valueOf(Messages.getString("GroupBrowser.47")) + " " + groupTitle, record);
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        HIRuntime.getManager().updateFlexMetadataRecord(record);
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                    }
                    String sortOrder = "";
                    int[] nArray = indices;
                    int n = indices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        HiQuickInfo content = this.groupContentsView.getContents().get(index);
                        HIRuntime.getManager().copyToGroup(content.getBaseID(), newGroup.getId());
                        sortOrder = String.valueOf(sortOrder) + "," + content.getBaseID();
                        ++n2;
                    }
                    if (sortOrder.length() > 0) {
                        sortOrder = sortOrder.substring(1);
                    }
                    HIRuntime.getManager().updateGroupSortOrder(newGroup, sortOrder);
                    this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                    this.metadataEditorView.updateContent();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newGroup, this);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, newGroup, this);
                    this.groupListView.setGroups(HIRuntime.getManager().getGroups());
                    this.groupListView.getList().setSelectedIndex(this.groupListView.getList().getModel().getSize() - 2);
                    if (this.groupListView.getCurrentGroup().getType() != GroupTypes.HIGROUP_REGULAR) {
                        this.groupListView.getList().setEnabled(false);
                        this.groupContentsView.prepareElementLoading();
                        this.contentLoader.loadGroup(this.groupListView.getCurrentGroup());
                    }
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("removeSelection")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.52"), String.valueOf(Messages.getString("GroupBrowser.53")) + "\n\n" + Messages.getString("GroupBrowser.55"))) {
                return;
            }
            try {
                indices = this.groupContentsView.getContentsList().getSelectedIndices();
                ArrayList<HiQuickInfo> contentsToRemove = new ArrayList<HiQuickInfo>(indices.length);
                int[] nArray = indices;
                int record = indices.length;
                int curGroup = 0;
                while (curGroup < record) {
                    int index = nArray[curGroup];
                    contentsToRemove.add(this.groupContentsView.getContents().get(index));
                    ++curGroup;
                }
                HIRuntime.getGui().startIndicatingServiceActivity();
                for (HiQuickInfo content : contentsToRemove) {
                    HIRuntime.getManager().removeFromGroup(content.getBaseID(), this.groupListView.getCurrentGroup().getId());
                    this.groupContentsView.removeContent(content);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, this.groupListView.getCurrentGroup(), this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.groupListView.getCurrentGroup(), this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("moveSelectionToTrash")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            boolean deleteFromProject = false;
            if (this.groupListView.getCurrentGroup().getType() == GroupTypes.HIGROUP_TRASH) {
                deleteFromProject = true;
            }
            if (deleteFromProject ? !HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.57"), String.valueOf(Messages.getString("GroupBrowser.58")) + "\n\n" + Messages.getString("GroupBrowser.60")) : !HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.61"), String.valueOf(Messages.getString("GroupBrowser.62")) + "\n\n" + Messages.getString("GroupBrowser.64"))) {
                return;
            }
            try {
                boolean groupsOrLayersInSelection = false;
                int[] indices2 = this.groupContentsView.getContentsList().getSelectedIndices();
                ArrayList<HiQuickInfo> contentsToRemove = new ArrayList<HiQuickInfo>(indices2.length);
                int[] nArray = indices2;
                int n = indices2.length;
                int n3 = 0;
                while (n3 < n) {
                    int index = nArray[n3];
                    HiQuickInfo content = this.groupContentsView.getContents().get(index);
                    if (content.getContentType() == HiBaseTypes.HI_GROUP || content.getContentType() == HiBaseTypes.HI_LAYER) {
                        groupsOrLayersInSelection = true;
                    } else {
                        contentsToRemove.add(content);
                    }
                    ++n3;
                }
                if (groupsOrLayersInSelection) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("GroupBrowser.65"), Messages.getString("GroupBrowser.66"));
                }
                HIRuntime.getGui().startIndicatingServiceActivity();
                for (HiQuickInfo content : contentsToRemove) {
                    if (deleteFromProject) {
                        HIRuntime.getManager().deleteFromProject(content.getBaseID());
                    } else {
                        HIRuntime.getManager().moveToTrash(content.getBaseID());
                        HIRuntime.getGui().notifyItemSentToTrash(content.getBaseID());
                    }
                    this.groupContentsView.removeContent(content);
                }
                HIRuntime.getManager().refreshProject();
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CONTENT_MOVED_TO_TRASH, this.groupListView.getCurrentGroup(), this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.groupListView.getCurrentGroup(), this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("options")) {
            this.groupContentsView.showDefaultPopupMenu();
        } else if (e.getActionCommand().equalsIgnoreCase("create")) {
            HiGroup newGroup = this.createGroup();
            if (newGroup != null) {
                try {
                    this.groupListView.setGroups(HIRuntime.getManager().getGroups());
                    this.groupListView.getList().setSelectedIndex(this.groupListView.getList().getModel().getSize() - 2);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newGroup, this);
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("remove")) {
            if (HIRuntime.getGui().checkEditAbility(false)) {
                if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.70"), String.valueOf(Messages.getString("GroupBrowser.71")) + "\n\n" + Messages.getString("GroupBrowser.73"))) {
                    return;
                }
                this.metadataEditorView.resetChanges();
                boolean groupDeleted = false;
                HiGroup deletedGroup = null;
                try {
                    deletedGroup = this.groupListView.getCurrentGroup();
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    groupDeleted = HIRuntime.getManager().deleteGroup(deletedGroup.getId());
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
                if (groupDeleted) {
                    try {
                        this.groupListView.setGroups(HIRuntime.getManager().getGroups());
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_REMOVED, deletedGroup, this);
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this);
                        return;
                    }
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("save") && this.metadataEditorView.hasChanges()) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            this.saveMetadataChanges();
        }
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.discardChanges();
        }
        if (e.getActionCommand().equalsIgnoreCase("changeListStyle")) {
            if (this.groupContentsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
                this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
                this.userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.LIST_STYLE;
            } else {
                this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.ICON_STYLE);
                this.userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.ICON_STYLE;
            }
        }
    }

    private void setDisplayStyle(GroupContentsList.HI_ListDisplayStyles style) {
        if (this.groupContentsView.getContentsList().getDisplayStyle() == style) {
            return;
        }
        if (style == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.groupContentsView.getContentsList().setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.ICON_STYLE);
            this.groupContentsView.getListStyleButton().setIcon(this.groupContentsView.listStyleIcon);
            this.groupContentsView.getListStyleButton().setToolTipText(Messages.getString("GroupBrowser.77"));
            this.loadContentPreviews();
        } else {
            this.groupContentsView.getContentsList().setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
            this.groupContentsView.getListStyleButton().setIcon(this.groupContentsView.iconStyleIcon);
            this.groupContentsView.getListStyleButton().setToolTipText(Messages.getString("GroupBrowser.78"));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.groupContentsView.getContentsList() && e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.groupListView.getCurrentGroup().getType() != GroupTypes.HIGROUP_TRASH) {
                HiQuickInfo content = this.groupContentsView.getSelectedElement();
                if (content != null) {
                    if (content.getContentType() == HiBaseTypes.HI_GROUP) {
                        int index = -1;
                        int i = 0;
                        while (i < this.groupListView.getList().getModel().getSize()) {
                            if (((HiGroup)this.groupListView.getList().getModel().getElementAt(i)).getId() == content.getBaseID()) {
                                index = i;
                            }
                            ++i;
                        }
                        if (index >= 0) {
                            this.groupListView.getList().setSelectedIndex(index);
                        } else {
                            HIRuntime.getGui().displayInfoDialog(Messages.getString("GroupBrowser.79"), Messages.getString("GroupBrowser.80"));
                        }
                    } else {
                        HIRuntime.getGui().openContentEditor(content, (HIComponent)this);
                    }
                }
            } else {
                HIRuntime.getGui().displayInfoDialog(Messages.getString("GroupBrowser.81"), Messages.getString("GroupBrowser.82"));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.groupListView.getList() && e.isPopupTrigger() && !e.isConsumed()) {
            e.consume();
            this.groupListView.showPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.groupListView.getList() && e.isPopupTrigger() && !e.isConsumed()) {
            e.consume();
            this.groupListView.showPopupMenu(e.getX(), e.getY());
        }
    }

    public class GroupContentsTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -2476221044117676754L;
        private GroupBrowser browser;
        private boolean wasSortAction = false;

        public GroupContentsTransferHandler(GroupBrowser browser) {
            this.browser = browser;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Vector<HiQuickInfo> elements = new Vector<HiQuickInfo>();
            if (c instanceof GroupContentsList) {
                GroupContentsList list = (GroupContentsList)c;
                Object[] objectArray = list.getSelectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    elements.add((HiQuickInfo)object);
                    ++n2;
                }
            }
            return new QuickInfoTransferable(new ContentTransfer(elements, GroupBrowser.this.groupListView.getCurrentGroup(), this.browser));
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return;
            }
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.browser);
            }
            if (t.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                try {
                    ContentTransfer transfer = (ContentTransfer)t.getTransferData(QuickInfoTransferable.quickInfoFlavor);
                    if (!this.wasSortAction && action == 2 && transfer.getTarget() instanceof GroupBrowser) {
                        for (HiQuickInfo content : transfer.getContents()) {
                            GroupBrowser.this.groupContentsView.removeContent(content);
                        }
                        GroupBrowser.this.updateContentSortOrder();
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, GroupBrowser.this.groupListView.getCurrentGroup(), null);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return;
                }
                catch (IOException e) {
                    return;
                }
            }
        }

        private boolean createLink(HiBase base, HiGroup targetGroup, Point location) {
            for (HiQuickInfo content : GroupBrowser.this.groupContentsView.getContents()) {
                if (content.getBaseID() != base.getId()) continue;
                return true;
            }
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().copyToGroup(base, targetGroup);
                HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(base.getId());
                int index = GroupBrowser.this.groupContentsView.getContentsList().locationToIndex(location);
                if (targetGroup.getId() == GroupBrowser.this.groupListView.getCurrentGroup().getId()) {
                    GroupBrowser.this.groupContentsView.addContent(info, index);
                    GroupBrowser.this.updateContentSortOrder();
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                GroupBrowser.this.loadContentPreview(info);
                GroupBrowser.this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                GroupBrowser.this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, targetGroup, this.browser);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, targetGroup, this.browser);
                return true;
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this.browser);
                return false;
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.browser);
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (!(supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(GroupTransferable.groupFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor) || supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor))) {
                return false;
            }
            if (supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && GroupBrowser.this.groupListView.getCurrentGroup().getType() != GroupTypes.HIGROUP_TRASH) {
                supp.setDropAction(1);
                return true;
            }
            if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                supp.setDropAction(0x40000000);
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block17: {
                    transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                    if (transfer != null) break block17;
                    return false;
                }
                try {
                    if (transfer.getSource() instanceof SearchModule) {
                        supp.setDropAction(1);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group.getType() != GroupTypes.HIGROUP_REGULAR) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            HiGroup dropGroup = GroupBrowser.this.groupListView.getCurrentGroup();
            if (!(supp.getComponent() instanceof GroupContentsList)) {
                dropGroup = GroupBrowser.this.groupListView.getGroup(GroupBrowser.this.groupListView.getList().getDropLocation().getIndex());
            }
            if (dropGroup.getType() == GroupTypes.HIGROUP_IMPORT) {
                return false;
            }
            return supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || dropGroup.getType() != GroupTypes.HIGROUP_TRASH;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            this.wasSortAction = false;
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            HiGroup dropGroup = GroupBrowser.this.groupListView.getCurrentGroup();
            if (!(supp.getComponent() instanceof GroupContentsList)) {
                dropGroup = GroupBrowser.this.groupListView.getGroup(GroupBrowser.this.groupListView.getList().getDropLocation().getIndex());
            }
            if (supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && GroupBrowser.this.groupListView.getCurrentGroup().getType() != GroupTypes.HIGROUP_TRASH) {
                try {
                    List files = (List)supp.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Vector<File> importFiles = new Vector<File>();
                    for (File file : files) {
                        if (file.isDirectory() || !file.canRead()) continue;
                        importFiles.addElement(file);
                    }
                    if (importFiles.size() < 1) {
                        return false;
                    }
                    if (System.getProperty("HI.feature.importDisabled") != null) {
                        return false;
                    }
                    long uploadSize = 0L;
                    for (File file : importFiles) {
                        uploadSize += file.length();
                    }
                    if (HIRuntime.getManager().getProject().getQuota() > 0L && HIRuntime.getManager().getProject().getUsed() + uploadSize > HIRuntime.getManager().getProject().getQuota()) {
                        HIRuntime.getGui().displayInfoDialog(Messages.getString("Groupbrowser.quotaexceeded"), Messages.getString("Groupbrowser.quotaexceededmsg"));
                        return false;
                    }
                    if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.4"), String.valueOf(Messages.getString("GroupBrowser.5")) + " " + importFiles.size() + " " + Messages.getString("GroupBrowser.8"))) {
                        return false;
                    }
                    boolean needConversion = false;
                    for (File file : importFiles) {
                        String mimetype = URLConnection.guessContentTypeFromName(file.getName());
                        if (mimetype == null) {
                            mimetype = "application/octet-stream";
                        }
                        if (!mimetype.startsWith("image/") || mimetype.endsWith("/jpeg")) continue;
                        needConversion = true;
                    }
                    if (needConversion && !HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.4"), Messages.getString("GroupBrowser.conversionInfo"))) {
                        return false;
                    }
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    for (File file : importFiles) {
                        try {
                            HiObject importObject = HIRuntime.getManager().createObject();
                            String customExtenstion = "";
                            HiView importview = null;
                            String filename = "import.jpg";
                            try {
                                File importFile = file;
                                filename = file.getName();
                                String mimetype = URLConnection.guessContentTypeFromName(file.getName());
                                if (mimetype == null) {
                                    mimetype = "application/octet-stream";
                                }
                                if (mimetype.startsWith("image/") && !mimetype.endsWith("/jpeg")) {
                                    try {
                                        File tempFile = null;
                                        tempFile = System.getProperty("java.io.tmpdir") != null ? new File(System.getProperty("java.io.tmpdir"), "HIEditor_tempConversion.jpg") : new File(file.getParent(), "HIEditor_tempConversion.jpg");
                                        if (tempFile != null) {
                                            if (tempFile.exists()) {
                                                tempFile.delete();
                                                tempFile.createNewFile();
                                            } else {
                                                tempFile.createNewFile();
                                            }
                                            RenderedOp viewImage = JAI.create("stream", SeekableStream.wrapInputStream(new FileInputStream(file), true));
                                            FileOutputStream outJPEG = new FileOutputStream(tempFile);
                                            JPEGEncodeParam jpegParam = new JPEGEncodeParam();
                                            jpegParam.setQuality(0.9f);
                                            JAI.create("encode", (RenderedImage)viewImage, (Object)outJPEG, (Object)"JPEG", (Object)jpegParam);
                                            outJPEG.close();
                                            importFile = tempFile;
                                            customExtenstion = ".jpg";
                                        }
                                    }
                                    catch (Exception e) {
                                        System.out.println("Image conversion failed!");
                                        System.out.println("FILE: " + file.getName());
                                        e.printStackTrace();
                                    }
                                }
                                importview = HIRuntime.getManager().createView(importObject.getId(), String.valueOf(filename) + customExtenstion, "[HIEditor 3.0 - Direct Import]", importFile, UUID.randomUUID().toString());
                                HIRuntime.getManager().refreshProject();
                            }
                            catch (HIWebServiceException wse) {
                                HIRuntime.getGui().reportError(wse, this.browser);
                                return false;
                            }
                            if (importview == null) {
                                return false;
                            }
                            if (GroupBrowser.this.groupListView.getCurrentGroup().getType() == GroupTypes.HIGROUP_IMPORT) continue;
                            HIRuntime.getManager().copyToGroup(importObject, GroupBrowser.this.groupListView.getCurrentGroup());
                            HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(importObject.getId());
                            int index = GroupBrowser.this.groupContentsView.getContentsList().locationToIndex(supp.getDropLocation().getDropPoint());
                            GroupBrowser.this.groupContentsView.addContent(info, index);
                        }
                        catch (HIWebServiceException wse) {
                            HIRuntime.getGui().reportError(wse, this.browser);
                            return false;
                        }
                    }
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                    GroupBrowser.this.updateContentSortOrder();
                    GroupBrowser.this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                    GroupBrowser.this.metadataEditorView.updateContent();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, GroupBrowser.this.groupListView.getCurrentGroup(), null);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, GroupBrowser.this.groupListView.getCurrentGroup(), null);
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (dropGroup.getType() == GroupTypes.HIGROUP_IMPORT) {
                HIRuntime.getGui().displayInfoDialog(Messages.getString("GroupBrowser.20"), String.valueOf(Messages.getString("GroupBrowser.21")) + "\n" + Messages.getString("GroupBrowser.23"));
                return false;
            }
            if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                    try {
                        HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                        if (group == null) {
                            return false;
                        }
                        if (group.getId() == dropGroup.getId()) {
                            return false;
                        }
                        return this.createLink(group, dropGroup, supp.getDropLocation().getDropPoint());
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                if (supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                    try {
                        HILayer layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                        if (layer == null) {
                            return false;
                        }
                        return this.createLink(layer.getModel(), dropGroup, supp.getDropLocation().getDropPoint());
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                if (supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                    try {
                        HiObjectContent content = (HiObjectContent)supp.getTransferable().getTransferData(ObjectContentTransferable.objecContentFlavor);
                        if (content == null) {
                            return false;
                        }
                        return this.createLink(content, dropGroup, supp.getDropLocation().getDropPoint());
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            } else {
                try {
                    boolean isSearch = false;
                    ContentTransfer transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                    if (transfer.getSourceGroup() == null || transfer.getSource() instanceof SearchModule) {
                        isSearch = true;
                    }
                    transfer.setTarget(this.browser);
                    int insertIndex = GroupBrowser.this.groupContentsView.getContentsList().locationToIndex(supp.getDropLocation().getDropPoint());
                    insertIndex = Math.max(0, insertIndex);
                    insertIndex = Math.min(GroupBrowser.this.groupContentsView.getContentsList().getModel().getSize() - 1, insertIndex);
                    if (!isSearch && transfer.getSourceGroup().getId() == dropGroup.getId() && !(supp.getComponent() instanceof GroupContentsList)) {
                        return false;
                    }
                    if (!isSearch && transfer.getSourceGroup().getId() == dropGroup.getId() && supp.getComponent() instanceof GroupContentsList) {
                        if (transfer.getSource() != this.browser) {
                            return false;
                        }
                        supp.setDropAction(2);
                        this.wasSortAction = true;
                        DefaultListModel model = (DefaultListModel)GroupBrowser.this.groupContentsView.getContentsList().getModel();
                        if (model.getSize() == 0) {
                            return false;
                        }
                        HiQuickInfo reference = new HiQuickInfo();
                        reference.setBaseID(-1L);
                        reference.setTitle("Dummy");
                        model.add(insertIndex, reference);
                        GroupBrowser.this.groupContentsView.getContents().add(insertIndex, reference);
                        for (HiQuickInfo transferContent : transfer.getContents()) {
                            int contentIndex = -1;
                            int i = 0;
                            while (i < model.size()) {
                                if (((HiQuickInfo)model.get(i)).getBaseID() == transferContent.getBaseID()) {
                                    contentIndex = i;
                                }
                                ++i;
                            }
                            if (contentIndex < 0) {
                                model.removeElement(reference);
                                GroupBrowser.this.groupContentsView.getContents().remove(reference);
                                return false;
                            }
                            model.remove(contentIndex);
                            GroupBrowser.this.groupContentsView.getContents().remove(contentIndex);
                        }
                        insertIndex = model.indexOf(reference);
                        int i = transfer.getContents().size() - 1;
                        while (i >= 0) {
                            model.add(insertIndex, transfer.getContents().get(i));
                            GroupBrowser.this.groupContentsView.getContents().add(insertIndex, transfer.getContents().get(i));
                            --i;
                        }
                        model.removeElement(reference);
                        GroupBrowser.this.groupContentsView.getContents().remove(reference);
                        if (!GroupBrowser.this.updateContentSortOrder()) {
                            GroupBrowser.this.groupListView.getList().setEnabled(false);
                            GroupBrowser.this.groupContentsView.prepareElementLoading();
                            GroupBrowser.this.metadataEditorView.setGroup(GroupBrowser.this.groupListView.getCurrentGroup(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                            GroupBrowser.this.metadataEditorView.setTagCount(HIRuntime.getGui().getTagCountForElement(GroupBrowser.this.groupListView.getCurrentGroup()));
                            GroupBrowser.this.contentLoader.loadGroup(GroupBrowser.this.groupListView.getCurrentGroup());
                            return false;
                        }
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUPCONTENTS_SORTORDER_CHANGED, GroupBrowser.this.groupListView.getCurrentGroup(), this.browser);
                        return true;
                    }
                    if (isSearch) {
                        supp.setDropAction(1);
                    } else if (transfer.getSourceGroup().getType() != GroupTypes.HIGROUP_REGULAR) {
                        supp.setDropAction(2);
                    }
                    boolean moveToTrash = false;
                    if (dropGroup.getType() == GroupTypes.HIGROUP_TRASH) {
                        moveToTrash = true;
                    }
                    if (moveToTrash && !HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.11"), String.valueOf(Messages.getString("GroupBrowser.12")) + "\n\n" + Messages.getString("GroupBrowser.14"))) {
                        return false;
                    }
                    boolean groupsOrLayersInSelection = false;
                    try {
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        int i = transfer.getContents().size() - 1;
                        while (i >= 0) {
                            boolean isInGroup = false;
                            if (dropGroup.getId() == GroupBrowser.this.groupListView.getCurrentGroup().getId()) {
                                for (HiQuickInfo content : GroupBrowser.this.groupContentsView.getContents()) {
                                    if (content.getBaseID() != transfer.getContents().get(i).getBaseID()) continue;
                                    isInGroup = true;
                                }
                            }
                            boolean moveOrCopySuccessful = false;
                            if (!moveToTrash) {
                                if (supp.getDropAction() == 2) {
                                    moveOrCopySuccessful = HIRuntime.getManager().moveToGroup(transfer.getContents().get(i).getBaseID(), transfer.getSourceGroup().getId(), dropGroup.getId());
                                } else if (!isInGroup) {
                                    moveOrCopySuccessful = HIRuntime.getManager().copyToGroup(transfer.getContents().get(i).getBaseID(), dropGroup.getId());
                                }
                            } else if (transfer.getContents().get(i).getContentType() != HiBaseTypes.HI_GROUP && transfer.getContents().get(i).getContentType() != HiBaseTypes.HI_LAYER) {
                                moveOrCopySuccessful = HIRuntime.getManager().moveToTrash(transfer.getContents().get(i).getBaseID());
                                if (moveOrCopySuccessful) {
                                    HIRuntime.getGui().notifyItemSentToTrash(transfer.getContents().get(i).getBaseID());
                                }
                            } else {
                                groupsOrLayersInSelection = true;
                            }
                            if (!isInGroup && moveOrCopySuccessful && dropGroup.getId() == GroupBrowser.this.groupListView.getCurrentGroup().getId()) {
                                HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(transfer.getContents().get(i).getBaseID());
                                GroupBrowser.this.loadContentPreview(info);
                                if (moveOrCopySuccessful) {
                                    GroupBrowser.this.groupContentsView.addContent(info, insertIndex);
                                }
                            }
                            --i;
                        }
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                        if (moveToTrash && groupsOrLayersInSelection) {
                            HIRuntime.getGui().displayInfoDialog(Messages.getString("GroupBrowser.15"), Messages.getString("GroupBrowser.16"));
                        }
                        GroupBrowser.this.updateContentSortOrder();
                        GroupBrowser.this.groupListView.getCurrentGroup().setTimestamp(new Date().getTime());
                        GroupBrowser.this.metadataEditorView.updateContent();
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, dropGroup, null);
                        if (dropGroup.getId() != GroupBrowser.this.groupListView.getCurrentGroup().getId()) {
                            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, dropGroup, null);
                        }
                        if (moveToTrash) {
                            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CONTENT_MOVED_TO_TRASH, null, null);
                        }
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this.browser);
                        return false;
                    }
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    }

    public class GroupTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5952319035170447213L;
        private GroupBrowser browser;

        public GroupTransferHandler(GroupBrowser browser) {
            this.browser = browser;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HiGroup group = (HiGroup)((JList)c).getSelectedValue();
            return new GroupTransferable(group);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.browser);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.browser);
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                GroupBrowser.this.groupListView.getList().setDropMode(DropMode.ON_OR_INSERT);
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    return group.getType() == GroupTypes.HIGROUP_REGULAR;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                GroupBrowser.this.groupListView.getList().setDropMode(DropMode.ON);
                if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                    supp.setDropAction(0x40000000);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                supp.setDropAction(0x40000000);
            }
            if (GroupBrowser.this.groupListView.getList().getDropLocation() != null && GroupBrowser.this.groupListView.getList().getDropLocation().isInsert()) {
                HiGroup sortGroup;
                int insertIndex = GroupBrowser.this.groupListView.getList().locationToIndex(supp.getDropLocation().getDropPoint());
                if (insertIndex == 0 || insertIndex == GroupBrowser.this.groupListView.getList().getModel().getSize() - 1) {
                    return false;
                }
                try {
                    sortGroup = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (sortGroup == null) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                DefaultListModel model = (DefaultListModel)GroupBrowser.this.groupListView.getList().getModel();
                int moveIndex = -1;
                int i = 1;
                while (i < model.getSize() - 1) {
                    if (((HiGroup)model.get(i)).getId() == sortGroup.getId()) {
                        moveIndex = i;
                    }
                    ++i;
                }
                if (moveIndex < 0 || moveIndex == insertIndex) {
                    return false;
                }
                GroupBrowser.this.groupListView.getList().removeListSelectionListener(this.browser);
                sortGroup = (HiGroup)model.get(moveIndex);
                model.remove(moveIndex);
                model.insertElementAt(sortGroup, insertIndex);
                GroupBrowser.this.groupListView.getList().setSelectedValue(sortGroup, true);
                GroupBrowser.this.groupListView.getList().addListSelectionListener(this.browser);
                HiPreference groupSortOrderPref = MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "groupSortOrder");
                String sortOrder = "";
                int i2 = 1;
                while (i2 < model.getSize() - 1) {
                    sortOrder = String.valueOf(sortOrder) + "," + ((HiGroup)model.get(i2)).getId();
                    ++i2;
                }
                if (sortOrder.startsWith(",")) {
                    sortOrder = sortOrder.substring(1);
                }
                groupSortOrderPref.setValue(sortOrder);
                HIRuntime.getGui().startIndicatingServiceActivity();
                try {
                    HIRuntime.getManager().updatePreference(groupSortOrderPref);
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this.browser);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_SORTORDER_CHANGED, null, this.browser);
                return true;
            }
            return GroupBrowser.this.groupContentsHandler.importData(supp);
        }
    }

    class HIGroupContentLoader
    implements Runnable {
        private Thread thread = new Thread(this);
        private HiGroup group;

        public void loadGroup(HiGroup group) {
            this.group = group;
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            } else if (this.thread.getState() == Thread.State.TERMINATED) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                while (this.thread.getState() == Thread.State.RUNNABLE) {
                }
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        @Override
        public void run() {
            List<HiQuickInfo> infoList;
            try {
                infoList = HIRuntime.getManager().getGroupContents(this.group);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, GroupBrowser.this.browser);
                GroupBrowser.this.groupContentsView.setContents(null);
                GroupBrowser.this.groupListView.getList().setEnabled(true);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (infoList != null) {
                        if (infoList.size() >= 100) {
                            GroupBrowser.this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
                        } else {
                            GroupBrowser.this.setDisplayStyle(GroupBrowser.this.userSelectedStyle);
                        }
                        GroupBrowser.this.groupContentsView.setContents(infoList);
                    }
                    GroupBrowser.this.groupListView.getList().setEnabled(true);
                    GroupBrowser.this.updateContentSortOrder();
                    if (GroupBrowser.this.groupContentsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
                        GroupBrowser.this.loadContentPreviews();
                    }
                }
            });
        }
    }
}

