/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.hyperimage.client.gui.views.GUIView;
import org.hyperimage.client.ws.HiBase;

public abstract class HIComponent {
    protected String title;
    protected JMenu contextMenu;
    protected JMenuItem windowMenuItem;
    protected ArrayList<GUIView> views = new ArrayList();

    public HIComponent(String title, String menuTitle) {
        this.contextMenu = new JMenu(menuTitle);
        this.windowMenuItem = new JMenuItem(title);
        this.title = title;
    }

    public ArrayList<GUIView> getViews() {
        return this.views;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JMenu getContextMenu() {
        return this.contextMenu;
    }

    public JMenuItem getWindowMenuItem() {
        return this.windowMenuItem;
    }

    public void updateLanguage() {
        for (GUIView view : this.views) {
            view.updateLanguage();
        }
    }

    public HiBase getBaseElement() {
        return null;
    }

    public void receiveMessage(HIMessageTypes message, HiBase base) {
    }

    public int countViews() {
        return this.views.size();
    }

    public boolean requestClose() {
        return true;
    }

    public static enum HIMessageTypes {
        ENTITY_CHANGED,
        ENTITY_ADDED,
        ENTITY_REMOVED,
        GROUP_SORTORDER_CHANGED,
        GROUP_CONTENTS_CHANGED,
        GROUPCONTENTS_SORTORDER_CHANGED,
        CHILD_ADDED,
        CHILD_REMOVED,
        CONTENT_MOVED_TO_TRASH,
        MOVED_TO_TRASH,
        PREFERENCE_MODIFIED,
        LANGUAGE_ADDED,
        LANGUAGE_REMOVED,
        DEFAULT_LANGUAGE_CHANGED,
        TEMPLATE_CHANGED,
        TAG_ADDED,
        TAG_MODIFIED,
        TAG_REMOVED;

    }
}

