/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.components.HIComponent;

public class HIComponentFrame
extends JInternalFrame
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private JSplitPane split2 = null;
    private HIComponent component;

    public HIComponentFrame(HIComponent component) {
        this.component = component;
        this.initFrame();
        this.setDefaultCloseOperation(0);
    }

    public HIComponent getHIComponent() {
        return this.component;
    }

    public void updateTitle() {
        this.setTitle(this.component.getTitle());
    }

    private void initFrame() {
        this.setDropTarget(new DropTarget());
        try {
            this.getDropTarget().addDropTargetListener(this);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        if (this.component.countViews() == 1) {
            this.getContentPane().add(new JScrollPane(this.component.getViews().get(0)));
        } else {
            JSplitPane split = new JSplitPane();
            split.setContinuousLayout(true);
            this.getContentPane().add(split);
            split.setLeftComponent(new JScrollPane(this.component.getViews().get(0)));
            split.setDividerLocation((int)this.component.getViews().get(0).getPreferredSize().getWidth() + 10);
            split.setBorder(null);
            if (this.component.countViews() == 2) {
                split.setRightComponent(new JScrollPane(this.component.getViews().get(1)));
            } else if (this.component.countViews() == 3) {
                this.split2 = new JSplitPane();
                this.split2.setBorder(null);
                this.split2.setContinuousLayout(true);
                this.split2.setOneTouchExpandable(true);
                split.setRightComponent(this.split2);
                this.split2.setLeftComponent(new JScrollPane(this.component.getViews().get(1)));
                this.split2.setDividerLocation((int)this.component.getViews().get(1).getPreferredSize().getWidth() + 10);
                this.split2.setResizeWeight(1.0);
                this.split2.setRightComponent(new JScrollPane(this.component.getViews().get(2)));
            } else {
                System.out.println("GUI ERROR: Components with " + this.component.countViews() + " views are not supported!");
            }
        }
        this.getContentPane().setFocusable(true);
        this.component.getViews().get(0).setFocusable(true);
        this.component.getViews().get(0).setFocusCycleRoot(true);
        this.setTitle(this.component.getTitle());
        this.setResizable(true);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.component.countViews()) {
            width = (int)((double)width + this.component.getViews().get(i).getPreferredSize().getWidth());
            ++i;
        }
        i = 0;
        while (i < this.component.countViews()) {
            height = Math.max(height, (int)this.component.getViews().get(i).getPreferredSize().getHeight());
            ++i;
        }
        this.pack();
        this.setPreferredSize(new Dimension(width + 90, height + 90));
        this.setSize(this.getPreferredSize());
    }

    public void setMetadataVisible(boolean visible) {
        if (this.split2 != null) {
            if (visible) {
                this.split2.setDividerLocation(-1);
            } else {
                this.split2.setDividerLocation(1.0);
            }
        }
    }

    public boolean isMetadataVisible() {
        if (this.split2 == null) {
            return false;
        }
        return this.split2.getDividerLocation() < this.split2.getMaximumDividerLocation();
    }

    public boolean hasMetadataView() {
        return this.split2 != null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.isSelected()) {
            HIRuntime.getGui().focusComponent(this);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

