/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.GroupTransferable;
import org.hyperimage.client.gui.dnd.LayerTransferable;
import org.hyperimage.client.gui.dnd.ObjectContentTransferable;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.gui.lists.LayerListCellRenderer;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.LayerListView;
import org.hyperimage.client.gui.views.LayerPolygonEditorView;
import org.hyperimage.client.gui.views.LayerPropertyEditorView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.util.WSImageLoaderThread;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiView;

public class LayerEditor
extends HIComponent
implements ListSelectionListener,
ActionListener {
    private LayerListView layerListView;
    private LayerPolygonEditorView polygonEditorView;
    private LayerPropertyEditorView propertyEditorView;
    private HiView view;
    private Vector<HILayer> layers;
    private int curLayerIndex = 0;

    public LayerEditor(HiView view, PlanarImage image, long layerID) {
        super(String.valueOf(Messages.getString("LayerEditor.8")) + " (" + (view.getUUID() == null ? "V" + view.getId() : view.getUUID()) + ")", Messages.getString("LayerEditor.11"));
        this.view = view;
        this.layers = new Vector();
        for (HiLayer layer : view.getLayers()) {
            this.layers.addElement(new HILayer(layer, image.getWidth(), image.getHeight()));
        }
        this.sortLayers();
        this.layerListView = new LayerListView(this.layers, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.polygonEditorView = new LayerPolygonEditorView(this.layers, image, HIRuntime.getManager().getProjectPolygons());
        this.polygonEditorView.regenerateNewPolygonMenu(this);
        this.polygonEditorView.getSwitchToPolygonLayerItem().addActionListener(this);
        this.propertyEditorView = new LayerPropertyEditorView(this, HIRuntime.getManager().getProjectColors(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId(), this.layerListView.getLayerList());
        this.propertyEditorView.setSyncView(this.polygonEditorView);
        if (this.layers.size() == 0) {
            this.propertyEditorView.setLayer(null);
            this.polygonEditorView.setUserSelectedLayer(null);
        } else {
            int userLayerIndex = 0;
            if (layerID > 0L && (userLayerIndex = this.displayLayerByID(layerID)) < 0) {
                userLayerIndex = 0;
            }
            this.curLayerIndex = userLayerIndex;
            this.propertyEditorView.setLayer(this.layers.get(userLayerIndex));
            this.polygonEditorView.setUserSelectedLayer(this.layers.get(userLayerIndex));
            if (this.layers.get(userLayerIndex).getModel().getLinkInfo() != null) {
                this.loadLinkPreviewImage(this.layers.get(userLayerIndex).getModel().getLinkInfo(), this.propertyEditorView.getLayerLinkPreview());
            }
        }
        this.updateSortOrder();
        this.views.add(this.layerListView);
        this.views.add(this.polygonEditorView);
        this.views.add(this.propertyEditorView);
        this.layerListView.getLayerList().setTransferHandler(new LayerTransferHandler(this));
        this.propertyEditorView.setLinkTransferHandler(new LinkTransferHandler(this));
        this.layerListView.getLayerList().addListSelectionListener(this);
        this.layerListView.attachActionListeners(this);
        this.polygonEditorView.getAddToLibraryItem().addActionListener(this);
        this.polygonEditorView.getAddLayerItem().addActionListener(this);
        this.propertyEditorView.getSaveButton().addActionListener(this);
        this.propertyEditorView.getResetButton().addActionListener(this);
        this.propertyEditorView.getAddToLibraryButton().addActionListener(this);
        this.propertyEditorView.setPopupMenuListeners(this);
        this.layerListView.getLayerList().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getSource() == LayerEditor.this.layerListView.getLayerList() && e.isPopupTrigger() && !e.isConsumed()) {
                    e.consume();
                    LayerEditor.this.layerListView.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == LayerEditor.this.layerListView.getLayerList() && e.isPopupTrigger() && !e.isConsumed()) {
                    e.consume();
                    LayerEditor.this.layerListView.showPopupMenu(e.getX(), e.getY());
                }
            }
        });
    }

    public LayerEditor(HiView view, PlanarImage image) {
        this(view, image, -1L);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.polygonEditorView.regenerateNewPolygonMenu(this);
        this.updateLayerGUI();
        this.setTitle(String.valueOf(Messages.getString("LayerEditor.8")) + " (V" + this.view.getId() + ")");
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public HiBase getBaseElement() {
        return this.view;
    }

    @Override
    public boolean requestClose() {
        this.polygonEditorView.cleanupPolygons();
        for (HILayer layer : this.layers) {
            HiLayer model = layer.getModel();
            if (!layer.hasPolygonChanges() || !HIRuntime.getGui().checkEditAbility(true)) continue;
            layer.syncPolygonChanges();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateLayerProperties(model.getId(), model.getRed(), model.getGreen(), model.getBlue(), model.getOpacity(), model.getPolygons());
                model.setTimestamp(new Date().getTime());
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return true;
            }
            this.propertyEditorView.updateContent();
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, layer.getModel(), this);
        }
        return this.askToSaveOrCancelChanges();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        if (message == HIComponent.HIMessageTypes.PREFERENCE_MODIFIED) {
            this.polygonEditorView.regenerateNewPolygonMenu(this);
            this.propertyEditorView.regenerateProjectColors();
        }
        if (message == HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED) {
            for (HILayer hILayer : this.layers) {
                if (hILayer.getModel().getLinkInfo() == null) continue;
                HIRuntime.getGui().startIndicatingServiceActivity();
                try {
                    hILayer.getModel().setLinkInfo(HIRuntime.getManager().getBaseQuickInfo(hILayer.getModel().getLinkInfo().getBaseID()));
                    hILayer.getModel().setTimestamp(new Date().getTime());
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            if (this.layers.size() > 0) {
                this.propertyEditorView.updateLayerLink();
                this.loadLinkPreviewImage(((HILayer)this.layerListView.getLayerList().getSelectedValue()).getModel().getLinkInfo(), this.propertyEditorView.getLayerLinkPreview());
            }
            ((LayerListCellRenderer)this.layerListView.getLayerList().getCellRenderer()).setDefaultLang(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
            this.layerListView.getLayerList().repaint();
            this.propertyEditorView.updateContent();
        }
        if (message == HIComponent.HIMessageTypes.ENTITY_CHANGED && this.layers.size() > 0) {
            if (base instanceof HiLayer && base.getId() == this.layers.get(this.curLayerIndex).getModel().getId()) {
                this.layers.get(this.curLayerIndex).getModel().setLinkInfo(((HiLayer)base).getLinkInfo());
                this.propertyEditorView.updateLayerLink();
                this.propertyEditorView.updateContent();
                if (((HiLayer)base).getLinkInfo() != null) {
                    this.loadLinkPreviewImage(((HiLayer)base).getLinkInfo(), this.propertyEditorView.getLayerLinkPreview());
                }
            }
            try {
                void var3_6;
                boolean bl = false;
                while (var3_6 < this.layers.size()) {
                    if (this.layers.get((int)var3_6).getModel().getLinkInfo() != null && this.layers.get((int)var3_6).getModel().getLinkInfo().getBaseID() == base.getId()) {
                        HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(base);
                        this.layers.get((int)var3_6).getModel().setLinkInfo(info);
                        if (var3_6 == this.curLayerIndex) {
                            this.propertyEditorView.updateLayerLink();
                            this.propertyEditorView.updateContent();
                            this.loadLinkPreviewImage(info, this.propertyEditorView.getLayerLinkPreview());
                        }
                    }
                    ++var3_6;
                }
            }
            catch (HIWebServiceException hIWebServiceException) {
                HIRuntime.getGui().reportError(hIWebServiceException, this);
                return;
            }
        }
        if (message == HIComponent.HIMessageTypes.LANGUAGE_ADDED || message == HIComponent.HIMessageTypes.LANGUAGE_REMOVED) {
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                for (HiLayer hiLayer : this.view.getLayers()) {
                    List<HiFlexMetadataRecord> records = HIRuntime.getManager().getFlexMetadataRecords(hiLayer);
                    while (hiLayer.getMetadata().size() > 0) {
                        hiLayer.getMetadata().remove(0);
                    }
                    for (HiFlexMetadataRecord record : records) {
                        hiLayer.getMetadata().add(record);
                    }
                }
            }
            catch (HIWebServiceException hIWebServiceException) {
                HIRuntime.getGui().reportError(hIWebServiceException, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
            this.propertyEditorView.updateMetadataLanguages();
        }
    }

    public int displayLayerByID(long id) {
        int i = 0;
        while (i < this.layerListView.getLayerList().getModel().getSize()) {
            if (((HILayer)this.layerListView.getLayerList().getModel().getElementAt(i)).getModel().getId() == id) {
                this.layerListView.getLayerList().setSelectedIndex(i);
            }
            ++i;
        }
        this.layerListView.getLayerList().scrollRectToVisible(new Rectangle(this.layerListView.getLayerList().indexToLocation(this.layerListView.getLayerList().getSelectedIndex())));
        return this.layerListView.getLayerList().getSelectedIndex();
    }

    private void savePropertyChanges() {
        if (this.layers.size() == 0) {
            return;
        }
        HILayer layer = this.layers.get(this.curLayerIndex);
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return;
        }
        try {
            HiLayer model = layer.getModel();
            if (layer.hasChanges() || layer.hasPolygonChanges()) {
                layer.syncChanges();
                layer.syncPolygonChanges();
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateLayerProperties(model, model.getRed(), model.getGreen(), model.getBlue(), model.getOpacity(), model.getPolygons());
                model.setTimestamp(new Date().getTime());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.propertyEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, layer.getModel(), this);
            }
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return;
        }
    }

    private void saveMetadataChanges() {
        if (this.layers.size() == 0) {
            return;
        }
        HILayer layer = this.layers.get(this.curLayerIndex);
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            HiLayer model = layer.getModel();
            if (this.propertyEditorView.hasMetadataChanges()) {
                this.propertyEditorView.syncMetadataChanges();
                HIRuntime.getManager().updateFlexMetadataRecords(model.getMetadata());
                model.setTimestamp(new Date().getTime());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, layer.getModel(), this);
                this.propertyEditorView.updateContent();
                this.layerListView.repaint();
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return;
        }
    }

    private boolean setLink(long targetID) {
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return false;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            if (!HIRuntime.getManager().setLayerLink(this.layers.get(this.curLayerIndex).getModel().getId(), targetID)) {
                HIRuntime.getGui().stopIndicatingServiceActivity();
                return false;
            }
            HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(targetID);
            this.layers.get(this.curLayerIndex).getModel().setLinkInfo(info);
            this.layers.get(this.curLayerIndex).getModel().setTimestamp(new Date().getTime());
            this.propertyEditorView.updateLayerLink();
            this.propertyEditorView.updateContent();
            this.loadLinkPreviewImage(info, this.propertyEditorView.getLayerLinkPreview());
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.layers.get(this.curLayerIndex).getModel(), this);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.view, this);
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return false;
        }
        HIRuntime.getGui().stopIndicatingServiceActivity();
        return true;
    }

    private void removeLink() {
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            if (HIRuntime.getManager().removeLayerLink(this.layers.get(this.curLayerIndex).getModel().getId())) {
                this.layers.get(this.curLayerIndex).getModel().setLinkInfo(null);
                this.layers.get(this.curLayerIndex).getModel().setTimestamp(new Date().getTime());
                this.propertyEditorView.updateLayerLink();
                this.propertyEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.layers.get(this.curLayerIndex).getModel(), this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.view, this);
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return;
        }
    }

    private void loadLinkPreviewImage(HiQuickInfo info, QuickInfoCell cell) {
        if (cell != null && cell.needsPreview()) {
            WSImageLoaderThread thumbLoader = new WSImageLoaderThread();
            long viewID = info.getBaseID();
            boolean cacheImage = true;
            if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
                viewID = info.getRelatedID();
            }
            if (info.getContentType() == HiBaseTypes.HI_LAYER) {
                cacheImage = false;
            }
            thumbLoader.loadImage(viewID, cacheImage, HiImageSizes.HI_THUMBNAIL, cell, this.propertyEditorView);
        }
    }

    private boolean askToSaveOrCancelChanges() {
        if (this.layers.size() == 0) {
            return true;
        }
        HILayer layer = this.layers.get(this.curLayerIndex);
        if ((this.propertyEditorView.hasMetadataChanges() || layer.hasChanges()) && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = JOptionPane.showConfirmDialog(HIRuntime.getGui(), Messages.getString("LayerEditor.12"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
                this.savePropertyChanges();
            } else {
                layer.resetChanges();
            }
        }
        return true;
    }

    private void updateSortOrder() {
        String sortOrder = this.layerListView.getSortOrder();
        if (!HIRuntime.getGui().checkEditAbility(true)) {
            return;
        }
        if (this.view.getSortOrder().compareTo(sortOrder) != 0) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateViewSortOrder(this.view, sortOrder);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void sortLayers() {
        int index = 0;
        String[] stringArray = this.view.getSortOrder().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long layerID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < this.layers.size()) {
                    if (this.layers.get(i).getModel().getId() == layerID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HILayer layer = this.layers.get(contentIndex);
                        this.layers.remove(contentIndex);
                        this.layers.add(index, layer);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private void updateLayerGUI() {
        this.layerListView.getLayerList().removeListSelectionListener(this);
        this.layerListView.updateLayerList();
        this.layerListView.getLayerList().addListSelectionListener(this);
        this.curLayerIndex = this.layerListView.getLayerList().getSelectedIndex();
        if (this.layers.size() > 0 && this.curLayerIndex == -1) {
            this.curLayerIndex = 0;
            this.layerListView.getLayerList().setSelectedIndex(0);
        }
        if (this.curLayerIndex >= 0) {
            this.propertyEditorView.setLayer(this.layers.get(this.curLayerIndex));
            this.polygonEditorView.setUserSelectedLayer(this.layers.get(this.curLayerIndex));
            if (this.layers.get(this.curLayerIndex).getModel().getLinkInfo() != null) {
                this.loadLinkPreviewImage(this.layers.get(this.curLayerIndex).getModel().getLinkInfo(), this.propertyEditorView.getLayerLinkPreview());
            }
        } else {
            this.propertyEditorView.setLayer(null);
            this.polygonEditorView.setUserSelectedLayer(null);
        }
        this.polygonEditorView.updateMenuOptions();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DefaultListModel model = (DefaultListModel)this.layerListView.getLayerList().getModel();
        if (model.size() > 0) {
            if (this.layerListView.getLayerList().getSelectedIndex() == -1) {
                this.layerListView.getLayerList().setSelectedIndex(this.curLayerIndex);
                return;
            }
            if (this.curLayerIndex != this.layerListView.getLayerList().getSelectedIndex()) {
                if (!this.askToSaveOrCancelChanges()) {
                    this.layerListView.getLayerList().setSelectedIndex(this.curLayerIndex);
                    return;
                }
                this.curLayerIndex = this.layerListView.getLayerList().getSelectedIndex();
                this.propertyEditorView.setLayer(this.layers.get(this.curLayerIndex));
                this.polygonEditorView.setUserSelectedLayer(this.layers.get(this.curLayerIndex));
                if (this.layers.get(this.curLayerIndex).getModel().getLinkInfo() != null) {
                    this.loadLinkPreviewImage(this.layers.get(this.curLayerIndex).getModel().getLinkInfo(), this.propertyEditorView.getLayerLinkPreview());
                }
            }
        } else {
            this.propertyEditorView.setLayer(null);
            this.polygonEditorView.setUserSelectedLayer(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HILayer layer;
        HILayer newHILayer;
        HiLayer newLayer;
        if (e.getActionCommand().equalsIgnoreCase("TO_LIBRARY")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().addProjectPolygon(this.polygonEditorView.getSelectedPolygon().getChangedModel());
                this.polygonEditorView.regenerateNewPolygonMenu(this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("SWITCH_TO_ACTIVE_LAYER")) {
            if (this.layers.size() == 0) {
                return;
            }
            HILayer selectedLayer = this.polygonEditorView.getSelectedLayer();
            if (selectedLayer != null) {
                this.layerListView.getLayerList().setSelectedValue(selectedLayer, true);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("colorToLibrary")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().addProjectColor(this.layers.get(this.curLayerIndex).getColour());
                this.propertyEditorView.regenerateProjectColors();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("visitLink")) {
            if (this.layers.size() == 0) {
                return;
            }
            if (this.layers.get(this.curLayerIndex).getModel().getLinkInfo() != null) {
                HIRuntime.getGui().openContentEditor(this.layers.get(this.curLayerIndex).getModel().getLinkInfo(), (HIComponent)this);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("removeLink")) {
            if (this.layers.size() == 0) {
                return;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            this.removeLink();
        }
        if (e.getActionCommand().equalsIgnoreCase("add")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                newLayer = HIRuntime.getManager().createLayer(this.view, 0, 156, 215, 0.5f);
                this.view.getLayers().add(newLayer);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_ADDED, this.view, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newLayer, this);
                newHILayer = new HILayer(newLayer, this.polygonEditorView.getScaleX(), this.polygonEditorView.getScaleY());
                this.layers.add(newHILayer);
                this.updateSortOrder();
                this.updateLayerGUI();
                this.layerListView.getLayerList().setSelectedValue(newHILayer, true);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
        } else if (e.getActionCommand().equalsIgnoreCase("remove") && this.layerListView.getLayerList().getModel().getSize() > 0 && this.layerListView.getLayerList().getSelectedIndex() >= 0) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("LayerEditor.21"), String.valueOf(Messages.getString("LayerEditor.22")) + "\n\n" + Messages.getString("LayerEditor.24"))) {
                return;
            }
            HIRuntime.getGui().startIndicatingServiceActivity();
            layer = this.layers.get(this.layerListView.getLayerList().getSelectedIndex());
            if (layer != null) {
                try {
                    HIRuntime.getManager().removeLayer(layer.getModel().getId());
                    this.layers.remove(layer);
                    this.view.getLayers().remove(layer.getModel());
                    this.updateSortOrder();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_REMOVED, this.view, this);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_REMOVED, layer.getModel(), this);
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
            }
            this.updateLayerGUI();
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        if (this.layers.size() == 0 && e.getActionCommand().startsWith("ADD_")) {
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                newLayer = HIRuntime.getManager().createLayer(this.view, 0, 156, 215, 0.5f);
                this.view.getLayers().add(newLayer);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_ADDED, this.view, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newLayer, this);
                newHILayer = new HILayer(newLayer, this.polygonEditorView.getScaleX(), this.polygonEditorView.getScaleY());
                this.layers.add(newHILayer);
                this.updateSortOrder();
                this.updateLayerGUI();
                this.layerListView.getLayerList().setSelectedValue(newHILayer, true);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        if (this.layers.size() > 0 && this.layerListView.getLayerList().getSelectedIndex() != -1) {
            layer = this.layers.get(this.curLayerIndex);
            if (e.getActionCommand().startsWith("ADD_")) {
                if (e.getActionCommand().equalsIgnoreCase("ADD_FREEFORM")) {
                    if (this.polygonEditorView.polygonEditorViewCommand.equalsIgnoreCase("deselect")) {
                        this.polygonEditorView.polygonEditorViewCommand = "";
                        return;
                    }
                    this.polygonEditorView.polygonEditorViewCommand = "add_freeform";
                    this.polygonEditorView.setPlaceFirstAnchorMode(true);
                    this.polygonEditorView.updateToolbarButtons();
                } else if (e.getActionCommand().equalsIgnoreCase("ADD_RECTANGLE")) {
                    if (this.polygonEditorView.polygonEditorViewCommand.equalsIgnoreCase("deselect")) {
                        this.polygonEditorView.polygonEditorViewCommand = "";
                        return;
                    }
                    this.polygonEditorView.polygonEditorViewCommand = "add_rectangle";
                    this.polygonEditorView.setPlaceFirstAnchorMode(true);
                    this.polygonEditorView.updateToolbarButtons();
                } else if (e.getActionCommand().equalsIgnoreCase("ADD_FREE")) {
                    if (this.polygonEditorView.polygonEditorViewCommand.equalsIgnoreCase("deselect")) {
                        this.polygonEditorView.polygonEditorViewCommand = "";
                        return;
                    }
                    this.polygonEditorView.polygonEditorViewCommand = "add_free";
                    this.polygonEditorView.setPlaceFirstAnchorMode(true);
                    this.polygonEditorView.updateToolbarButtons();
                } else if (e.getActionCommand().equalsIgnoreCase("ADD_CIRCLE")) {
                    if (this.polygonEditorView.polygonEditorViewCommand.equalsIgnoreCase("deselect")) {
                        this.polygonEditorView.polygonEditorViewCommand = "";
                        return;
                    }
                    this.polygonEditorView.polygonEditorViewCommand = "add_circle";
                    this.polygonEditorView.setPlaceFirstAnchorMode(true);
                    this.polygonEditorView.updateToolbarButtons();
                } else if (e.getActionCommand().equalsIgnoreCase("ADD_ARROW")) {
                    if (this.polygonEditorView.polygonEditorViewCommand.equalsIgnoreCase("deselect")) {
                        this.polygonEditorView.polygonEditorViewCommand = "";
                        return;
                    }
                    this.polygonEditorView.polygonEditorViewCommand = "add_arrow";
                    this.polygonEditorView.setPlaceFirstAnchorMode(true);
                    this.polygonEditorView.updateToolbarButtons();
                } else if (e.getActionCommand().startsWith("ADD_LIB_") && e.getActionCommand().length() > 7) {
                    try {
                        int lib = Integer.parseInt(e.getActionCommand().substring(8));
                        if (lib >= 0 && lib < HIRuntime.getManager().getProjectPolygons().size()) {
                            this.polygonEditorView.addLibraryPolygon(layer, HIRuntime.getManager().getProjectPolygons().get(lib));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (e.getActionCommand().equalsIgnoreCase("save") && (layer.hasChanges() || this.propertyEditorView.hasMetadataChanges() || layer.hasPolygonChanges())) {
                if (!HIRuntime.getGui().checkEditAbility(false)) {
                    return;
                }
                this.saveMetadataChanges();
                this.savePropertyChanges();
            }
            if (e.getActionCommand().equalsIgnoreCase("reset")) {
                layer.resetChanges();
                layer.resetPolygonChanges();
                this.propertyEditorView.resetMetadataChanges();
                this.polygonEditorView.repaintShapes();
                this.propertyEditorView.setLayer(layer);
                if (layer.getModel().getLinkInfo() != null) {
                    this.loadLinkPreviewImage(layer.getModel().getLinkInfo(), this.propertyEditorView.getLayerLinkPreview());
                }
            }
        }
    }

    public class LayerTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 141341015964690677L;
        private LayerEditor editor;

        public LayerTransferHandler(LayerEditor editor) {
            this.editor = editor;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HILayer layer = (HILayer)((JList)c).getSelectedValue();
            return new LayerTransferable(layer);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.editor);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.editor);
            if (!supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            try {
                HILayer layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                boolean belongsToThisList = false;
                for (HILayer viewLayer : LayerEditor.this.layers) {
                    if (viewLayer.getModel().getId() != layer.getModel().getId()) continue;
                    belongsToThisList = true;
                }
                if (belongsToThisList) {
                    supp.setDropAction(2);
                } else {
                    supp.setDropAction(1);
                }
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            HILayer layer;
            block12: {
                if (!this.canImport(supp)) {
                    return false;
                }
                if (!HIRuntime.getGui().checkEditAbility(false)) {
                    return false;
                }
                Transferable t = supp.getTransferable();
                layer = null;
                layer = (HILayer)t.getTransferData(LayerTransferable.layerFlavor);
                if (layer != null) break block12;
                return false;
            }
            try {
                int index = LayerEditor.this.layerListView.getLayerList().locationToIndex(supp.getDropLocation().getDropPoint());
                index = Math.max(0, index);
                index = Math.min(LayerEditor.this.layers.size() - 1, index);
                int listIndex = -1;
                int i = 0;
                while (i < LayerEditor.this.layers.size()) {
                    if (((HILayer)LayerEditor.this.layers.get(i)).getModel().getId() == layer.getModel().getId()) {
                        listIndex = i;
                    }
                    ++i;
                }
                if (listIndex >= 0) {
                    HILayer listLayer = (HILayer)LayerEditor.this.layers.elementAt(listIndex);
                    LayerEditor.this.layers.remove(listIndex);
                    LayerEditor.this.layers.add(index, listLayer);
                    LayerEditor.this.layerListView.updateLayerList();
                    LayerEditor.this.layerListView.getLayerList().setSelectedIndex(index);
                    LayerEditor.this.polygonEditorView.repaintShapes();
                    LayerEditor.this.updateSortOrder();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, LayerEditor.this.view, this.editor);
                } else {
                    try {
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        HiLayer newLayer = HIRuntime.getManager().createLayer(LayerEditor.this.view, layer.getModel().getRed(), layer.getModel().getGreen(), layer.getModel().getBlue(), layer.getModel().getOpacity());
                        LayerEditor.this.view.getLayers().add(newLayer);
                        String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)layer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
                        title = title == null || title.length() == 0 ? String.valueOf(Messages.getString("LayerEditor.2")) + " L" + layer.getModel().getId() : String.valueOf(Messages.getString("LayerEditor.4")) + " " + title;
                        MetadataHelper.setValue("HIBase", "title", title, MetadataHelper.getDefaultMetadataRecord((HiBase)newLayer, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
                        HIRuntime.getManager().updateFlexMetadataRecord(MetadataHelper.getDefaultMetadataRecord((HiBase)newLayer, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
                        newLayer.setPolygons(layer.getModel().getPolygons());
                        HIRuntime.getManager().updateLayerProperties(newLayer, newLayer.getRed(), newLayer.getGreen(), newLayer.getBlue(), newLayer.getOpacity(), newLayer.getPolygons());
                        LayerEditor.this.layers.add(index, new HILayer(newLayer, LayerEditor.this.polygonEditorView.getScaleX(), LayerEditor.this.polygonEditorView.getScaleY()));
                        LayerEditor.this.updateSortOrder();
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                        LayerEditor.this.updateLayerGUI();
                        LayerEditor.this.polygonEditorView.updateScale();
                        LayerEditor.this.polygonEditorView.repaintShapes();
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_ADDED, LayerEditor.this.view, this.editor);
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newLayer, this.editor);
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, LayerEditor.this.view, this.editor);
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this.editor);
                        return false;
                    }
                }
                return true;
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public class LinkTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1392755235239308382L;
        private LayerEditor editor;

        public LinkTransferHandler(LayerEditor editor) {
            this.editor = editor;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (LayerEditor.this.layers.size() == 0) {
                return null;
            }
            return new LayerTransferable((HILayer)LayerEditor.this.layers.get(LayerEditor.this.curLayerIndex));
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.editor);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.editor);
            boolean isLink = false;
            if (LayerEditor.this.layers.size() == 0) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(GroupTransferable.groupFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                isLink = true;
            }
            if (!isLink) {
                return false;
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group.getType() != GroupTypes.HIGROUP_REGULAR) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            supp.setDropAction(0x40000000);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            long targetID = -1L;
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                HiGroup group;
                block26: {
                    group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group != null) break block26;
                    return false;
                }
                try {
                    targetID = group.getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                HILayer layer;
                block28: {
                    block27: {
                        layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                        if (layer != null) break block27;
                        return false;
                    }
                    if (layer.getModel().getId() != ((HILayer)LayerEditor.this.layers.get(LayerEditor.this.curLayerIndex)).getModel().getId()) break block28;
                    return false;
                }
                try {
                    targetID = layer.getModel().getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                HiObjectContent content;
                block29: {
                    content = (HiObjectContent)supp.getTransferable().getTransferData(ObjectContentTransferable.objecContentFlavor);
                    if (content != null) break block29;
                    return false;
                }
                try {
                    targetID = content.getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block32: {
                    block31: {
                        block30: {
                            transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                            if (transfer != null) break block30;
                            return false;
                        }
                        if (transfer.getContents().size() == 1) break block31;
                        return false;
                    }
                    if (transfer.getContents().get(0).getBaseID() != ((HILayer)LayerEditor.this.layers.get(LayerEditor.this.curLayerIndex)).getModel().getId() || transfer.getContents().get(0).getContentType() != HiBaseTypes.HI_LAYER) break block32;
                    return false;
                }
                try {
                    targetID = transfer.getContents().get(0).getBaseID();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            supp.setDropAction(0x40000000);
            if (targetID < 0L) {
                return false;
            }
            return LayerEditor.this.setLink(targetID);
        }
    }
}

