/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.HIClientGUI;
import org.hyperimage.client.gui.views.LightTablePreViewerView;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiLightTable;

public class LightTableEditor
extends HIComponent
implements ActionListener {
    private HiLightTable lightTable;
    LightTablePreViewerView xmlView;
    boolean isValid = false;

    public LightTableEditor(HiLightTable lightTable) {
        super(String.valueOf(Messages.getString("LightTableEditor.0")) + " (" + (lightTable.getUUID() == null ? "X" + lightTable.getId() : lightTable.getUUID()) + ")", Messages.getString("LightTableEditor.2"));
        this.lightTable = lightTable;
        this.xmlView = new LightTablePreViewerView(lightTable);
        this.views.add(this.xmlView);
        this.xmlView.getPreViewerButton().addActionListener(this);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.setTitle(String.valueOf(Messages.getString("LightTableEditor.0")) + " X" + this.lightTable.getId());
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges();
    }

    @Override
    public HiBase getBaseElement() {
        return this.lightTable;
    }

    private void saveChanges() {
        if (this.xmlView.hasChanges() && HIRuntime.getGui().checkEditAbility(false)) {
            this.xmlView.syncChanges();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateLightTable(this.lightTable);
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.lightTable, this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void resetChanges() {
        this.xmlView.resetChanges();
    }

    private boolean askToSaveOrCancelChanges() {
        if (this.xmlView.hasChanges() && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = HIRuntime.getGui().displayUserChoiceDialog(Messages.getString("LightTableEditor.3"), Messages.getString("LightTableEditor.4"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveChanges();
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("open")) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(String.valueOf(HIRuntime.getManager().getServerURL()) + "previewer/?session=" + HIRuntime.getManager().getEndpointSession() + "#X" + this.lightTable.getId()));
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(HIClientGUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            HIRuntime.getGui().deregisterComponent(this, false);
        }
        if (e.getActionCommand().equalsIgnoreCase("save")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (this.xmlView.hasChanges()) {
                this.saveChanges();
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.resetChanges();
        }
    }
}

