/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.ObjectContentCell;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.GroupTransferable;
import org.hyperimage.client.gui.dnd.LayerTransferable;
import org.hyperimage.client.gui.dnd.ObjectContentTransferable;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.gui.lists.ObjectContentsCellRenderer;
import org.hyperimage.client.gui.views.FlexMetadataEditorView;
import org.hyperimage.client.gui.views.ObjectContentEditView;
import org.hyperimage.client.gui.views.ObjectContentsListView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.WSImageLoaderThread;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiLayer;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiView;

public class ObjectEditor
extends HIComponent
implements ActionListener,
ListSelectionListener,
MouseListener {
    private ObjectContentsListView objectContentsListView;
    private ObjectContentEditView objectContentEditView;
    private FlexMetadataEditorView metadataEditorView;
    private int contentIndex = 0;
    private HiObject object;

    public ObjectEditor(HiObject object) {
        this(object, -1L);
    }

    public ObjectEditor(HiObject object, long contentID) {
        super(String.valueOf(Messages.getString("ObjectEditor.4")) + " (" + (object.getUUID() == null ? "O" + object.getId() : object.getUUID()) + ")", Messages.getString("ObjectEditor.7"));
        this.object = object;
        this.objectContentsListView = new ObjectContentsListView(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId(), this.object);
        this.objectContentEditView = new ObjectContentEditView(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.metadataEditorView = new FlexMetadataEditorView(HIRuntime.getManager().getProject().getTemplates(), object, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        if (contentID <= 0L) {
            if (object.getDefaultView() == null && object.getViews().size() > 0) {
                this.objectContentsListView.getContentsList().setSelectedIndex(0);
            }
            if (object.getDefaultView() != null) {
                int i = 0;
                while (i < object.getViews().size()) {
                    if (((HiObjectContent)this.objectContentsListView.getContentsList().getModel().getElementAt(i)).getId() == object.getDefaultView().getId()) {
                        this.objectContentsListView.getContentsList().setSelectedIndex(i);
                    }
                    ++i;
                }
            }
        } else {
            this.displayContentByID(contentID);
            if (object.getViews().size() > 0 && this.objectContentsListView.getContentsList().getSelectedIndex() < 0) {
                this.objectContentsListView.getContentsList().setSelectedIndex(0);
            }
        }
        if (this.objectContentsListView.getContentsList().getModel().getSize() > 0) {
            HiObjectContent content = (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue();
            this.setPreviewContent(content);
            this.contentIndex = this.objectContentsListView.getContentsList().getSelectedIndex();
        }
        this.loadContentPreviews();
        this.updateSortOrder();
        if (!HIRuntime.getGui().checkEditAbility(true)) {
            this.objectContentsListView.getOptionsButton().setEnabled(false);
        }
        this.views.add(this.objectContentsListView);
        this.views.add(this.objectContentEditView);
        this.views.add(this.metadataEditorView);
        this.objectContentsListView.getContentsList().setTransferHandler(new ObjectContentTransferHandler(this));
        this.objectContentEditView.getLayerViewer().setTransferHandler(new LayerHotlinkTransferHandler());
        this.objectContentsListView.getContentsList().addListSelectionListener(this);
        this.metadataEditorView.getSaveButton().addActionListener(this);
        this.metadataEditorView.getResetButton().addActionListener(this);
        this.objectContentsListView.getContentsList().addMouseListener(this);
        this.objectContentEditView.getLayerEditorButton().addActionListener(this);
        this.objectContentEditView.getLayerViewer().attachActionListener(this);
        this.objectContentEditView.getLayerViewer().addMouseListener(this);
        if (HIRuntime.getGui().checkEditAbility(true)) {
            this.objectContentsListView.getOptionsButton().addActionListener(this);
            this.objectContentsListView.setMenuActionListener(this);
        } else {
            this.objectContentsListView.disablePopup();
        }
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.setTitle(String.valueOf(Messages.getString("ObjectEditor.4")) + " (O" + this.object.getId() + ")");
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public HiBase getBaseElement() {
        return this.object;
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges(true);
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        HiObjectContent objContent;
        if (message == HIComponent.HIMessageTypes.ENTITY_CHANGED) {
            if (base instanceof HiView || base instanceof HiInscription) {
                objContent = null;
                if (this.objectContentsListView.getContentsList().getModel().getSize() > 0) {
                    objContent = (HiObjectContent)this.objectContentsListView.getContentsList().getModel().getElementAt(this.contentIndex);
                }
                for (HiObjectContent content : this.object.getViews()) {
                    if (content.getId() != base.getId()) continue;
                    if (content instanceof HiInscription) {
                        this.objectContentsListView.updateRendering((HiInscription)content);
                    }
                    if (objContent == null || objContent.getId() != base.getId()) continue;
                    this.objectContentEditView.updateContent();
                    this.metadataEditorView.updateContent();
                }
            }
            if (base instanceof HiLayer) {
                this.objectContentEditView.updateContent();
            }
        }
        if (message == HIComponent.HIMessageTypes.CHILD_ADDED || message == HIComponent.HIMessageTypes.CHILD_REMOVED) {
            if (base instanceof HiView) {
                objContent = null;
                if (this.objectContentsListView.getContentsList().getModel().getSize() > 0) {
                    objContent = (HiObjectContent)this.objectContentsListView.getContentsList().getModel().getElementAt(this.contentIndex);
                }
                for (HiObjectContent content : this.object.getViews()) {
                    if (content.getId() != base.getId() || objContent == null || objContent.getId() != base.getId()) continue;
                    this.objectContentEditView.updateContent();
                }
            }
            boolean cfr_ignored_0 = base instanceof HiObject;
        }
        if (message == HIComponent.HIMessageTypes.LANGUAGE_ADDED || message == HIComponent.HIMessageTypes.LANGUAGE_REMOVED) {
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                List<HiFlexMetadataRecord> records = HIRuntime.getManager().getFlexMetadataRecords(this.object);
                while (this.object.getMetadata().size() > 0) {
                    this.object.getMetadata().remove(0);
                }
                for (HiFlexMetadataRecord record : records) {
                    this.object.getMetadata().add(record);
                }
                for (HiObjectContent content : this.object.getViews()) {
                    records = HIRuntime.getManager().getFlexMetadataRecords(content);
                    while (content.getMetadata().size() > 0) {
                        content.getMetadata().remove(0);
                    }
                    for (HiFlexMetadataRecord record : records) {
                        content.getMetadata().add(record);
                    }
                }
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
            this.metadataEditorView.updateMetadataLanguages();
            this.objectContentEditView.updateMetadataLanguages();
        }
    }

    public void displayContentByID(long id) {
        int i = 0;
        while (i < this.objectContentsListView.getContentsList().getModel().getSize()) {
            if (((HiObjectContent)this.objectContentsListView.getContentsList().getModel().getElementAt(i)).getId() == id) {
                this.objectContentsListView.getContentsList().setSelectedIndex(i);
            }
            ++i;
        }
        this.objectContentsListView.getContentsList().scrollRectToVisible(new Rectangle(this.objectContentsListView.getContentsList().indexToLocation(this.objectContentsListView.getContentsList().getSelectedIndex())));
    }

    private boolean setLink(long targetID) {
        if (this.objectContentEditView.getLayerViewer().getActiveLayer() == null) {
            return false;
        }
        if (this.object.getViews().size() == 0) {
            return false;
        }
        HILayer layer = this.objectContentEditView.getLayerViewer().getActiveLayer();
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return false;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            if (!HIRuntime.getManager().setLayerLink(layer.getModel().getId(), targetID)) {
                HIRuntime.getGui().stopIndicatingServiceActivity();
                return false;
            }
            HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(targetID);
            layer.getModel().setLinkInfo(info);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, layer.getModel(), this);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue(), this);
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return false;
        }
        HIRuntime.getGui().stopIndicatingServiceActivity();
        HIRuntime.getGui().displayInfoDialog(Messages.getString("ObjectEditor.8"), Messages.getString("ObjectEditor.9"));
        return true;
    }

    private boolean removeLink() {
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return false;
        }
        if (this.objectContentEditView.getLayerViewer().getSelectedLayer() == null) {
            return false;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            if (HIRuntime.getManager().removeLayerLink(this.objectContentEditView.getLayerViewer().getSelectedLayer().getModel().getId())) {
                this.objectContentEditView.getLayerViewer().getSelectedLayer().getModel().setLinkInfo(null);
                this.objectContentEditView.getLayerViewer().repaint();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.objectContentEditView.getLayerViewer().getSelectedLayer().getModel(), this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, (HiBase)this.objectContentsListView.getContentsList().getSelectedValue(), this);
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return false;
        }
        HIRuntime.getGui().displayInfoDialog(Messages.getString("ObjectEditor.10"), Messages.getString("ObjectEditor.11"));
        return true;
    }

    private void updateSortOrder() {
        String sortOrder = this.objectContentsListView.getSortOrder();
        if (!HIRuntime.getGui().checkEditAbility(true)) {
            return;
        }
        if (this.object.getSortOrder().compareTo(sortOrder) != 0) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateObjectSortOrder(this.object, sortOrder);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void openLayerEditor(HiLayer layer) {
        if (this.object.getViews().size() > 0) {
            if (layer == null) {
                HiObjectContent content = (HiObjectContent)this.objectContentsListView.getContentsList().getModel().getElementAt(this.contentIndex);
                if (content instanceof HiView) {
                    HIRuntime.getGui().openLayerEditor((HiView)content);
                }
            } else {
                HIRuntime.getGui().openContentEditor(layer.getId(), (HIComponent)this);
            }
        }
    }

    private boolean askToSaveOrCancelChanges(boolean includeObjectMetadata) {
        if ((this.objectContentEditView.hasChanges() || includeObjectMetadata && this.metadataEditorView.hasChanges()) && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = HIRuntime.getGui().displayUserChoiceDialog(Messages.getString("ObjectEditor.12"), Messages.getString("ObjectEditor.13"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
                if (includeObjectMetadata) {
                    this.saveObjectMetadataChanges();
                }
            }
        }
        return true;
    }

    private void saveMetadataChanges() {
        if (this.objectContentEditView.hasChanges() && HIRuntime.getGui().checkEditAbility(false)) {
            this.objectContentEditView.syncChanges();
            HiObjectContent content = (HiObjectContent)this.objectContentsListView.getContentsList().getModel().getElementAt(this.contentIndex);
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateFlexMetadataRecords(content.getMetadata());
                content.setTimestamp(new Date().getTime());
                this.objectContentEditView.updateStatusBar();
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, content, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.object, this);
                if (content instanceof HiInscription) {
                    this.objectContentsListView.updateRendering((HiInscription)content);
                }
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void saveObjectMetadataChanges() {
        if (this.metadataEditorView.hasChanges() && HIRuntime.getGui().checkEditAbility(false)) {
            this.metadataEditorView.syncChanges();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateFlexMetadataRecords(this.object.getMetadata());
                this.object.setTimestamp(new Date().getTime());
                this.metadataEditorView.updateLanguage();
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.object, this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void loadContentPreviews() {
        ObjectContentsCellRenderer renderer = (ObjectContentsCellRenderer)this.objectContentsListView.getContentsList().getCellRenderer();
        for (HiObjectContent content : this.object.getViews()) {
            ObjectContentCell cell;
            if (!(content instanceof HiView) || (cell = renderer.getCellForContent(content)) == null || !cell.needsPreview()) continue;
            WSImageLoaderThread thumbLoader = new WSImageLoaderThread();
            thumbLoader.loadImage(((HiView)content).getId(), HiImageSizes.HI_THUMBNAIL, cell, this.objectContentsListView.getContentsList());
        }
    }

    private void setPreviewContent(HiObjectContent content) {
        this.objectContentEditView.setContentView(content);
        if (content instanceof HiView && this.objectContentEditView.needsPreview()) {
            WSImageLoaderThread previewLoader = new WSImageLoaderThread();
            previewLoader.loadImage(content.getId(), HiImageSizes.HI_PREVIEW, this.objectContentEditView, this.objectContentEditView.getDisplayPanel());
        } else {
            this.objectContentEditView.updateStatusBar();
        }
    }

    private void addInscription() {
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            HiInscription inscription = HIRuntime.getManager().createInscription(this.object);
            this.object.getViews().add(inscription);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.object, this);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_ADDED, this.object, this);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, inscription, this);
            HIRuntime.getGui().stopIndicatingServiceActivity();
            this.refreshContentList();
            this.updateSortOrder();
            this.objectContentsListView.updateViewCount();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return;
        }
    }

    private void refreshContentList() {
        this.contentIndex = this.objectContentsListView.getContentsList().getSelectedIndex();
        HiObjectContent content = null;
        if (this.contentIndex >= 0) {
            content = (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue();
        }
        this.objectContentsListView.getContentsList().removeListSelectionListener(this);
        this.objectContentsListView.refreshList();
        this.loadContentPreviews();
        if (this.objectContentsListView.getContentsList().getSelectedIndex() >= 0) {
            if (content == null || content.getId() != ((HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue()).getId()) {
                this.contentIndex = this.objectContentsListView.getContentsList().getSelectedIndex();
                content = (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue();
                this.setPreviewContent(content);
            }
        } else {
            this.setPreviewContent(null);
        }
        this.contentIndex = this.objectContentsListView.getContentsList().getSelectedIndex();
        this.objectContentsListView.updateViewCount();
        this.objectContentsListView.getContentsList().addListSelectionListener(this);
    }

    private boolean isDefaultView() {
        if (this.objectContentsListView.getContentsList().getModel().getSize() == 0) {
            return false;
        }
        if (this.object.getDefaultView() == null) {
            return false;
        }
        return this.object.getDefaultView().getId() == ((HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue()).getId();
    }

    private void setDefaultView(HiObjectContent content) {
        HIRuntime.getGui().startIndicatingServiceActivity();
        if (content == null) {
            try {
                HIRuntime.getManager().removeDefaultView(this.object);
                this.object.setDefaultView(null);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.object, this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        try {
            HIRuntime.getManager().setDefaultView(this.object.getId(), content.getId());
            this.object.setDefaultView(content);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.object, this);
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return;
        }
        HIRuntime.getGui().stopIndicatingServiceActivity();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("save")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (this.metadataEditorView.hasChanges()) {
                this.saveObjectMetadataChanges();
            }
            if (this.objectContentEditView.hasChanges()) {
                this.saveMetadataChanges();
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.metadataEditorView.resetChanges();
            this.objectContentEditView.resetChanges();
        }
        if (e.getActionCommand().equalsIgnoreCase("openLinkTarget") && this.objectContentEditView.getLayerViewer().getSelectedLayer() != null && this.objectContentEditView.getLayerViewer().getSelectedLayer().getModel().getLinkInfo() != null) {
            HIRuntime.getGui().openContentEditor(this.objectContentEditView.getLayerViewer().getSelectedLayer().getModel().getLinkInfo(), (HIComponent)this);
        }
        if (e.getActionCommand().equalsIgnoreCase("removeLink") && HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("ObjectEditor.18"), Messages.getString("ObjectEditor.19"))) {
            this.removeLink();
        }
        if (e.getActionCommand().equalsIgnoreCase("editLayers")) {
            this.openLayerEditor(null);
        }
        if (e.getActionCommand().equalsIgnoreCase("editLayer") && this.objectContentEditView.getLayerViewer().getSelectedLayer() != null) {
            this.openLayerEditor(this.objectContentEditView.getLayerViewer().getSelectedLayer().getModel());
        }
        if (e.getActionCommand().equalsIgnoreCase("moveToTrash")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            String message = Messages.getString("ObjectEditor.24");
            if (this.objectContentsListView.getContentsList().getSelectedValue() instanceof HiInscription) {
                message = Messages.getString("ObjectEditor.deleteinscription");
            }
            if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("ObjectEditor.23"), message)) {
                return;
            }
            try {
                HiObjectContent content = (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue();
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().moveToTrash(content.getId());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.object.getViews().remove(content);
                if (this.object.getDefaultView() != null && this.object.getDefaultView().getId() == content.getId()) {
                    this.object.setDefaultView(null);
                }
                this.refreshContentList();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.MOVED_TO_TRASH, content, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_REMOVED, this.object, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.object, this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("options")) {
            this.objectContentsListView.showDefaultPopupMenu();
        }
        if (e.getActionCommand().equalsIgnoreCase("defaultView") && HIRuntime.getGui().checkEditAbility(false) && this.objectContentsListView.getContentsList().getModel().getSize() > 0) {
            HiObjectContent content = (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue();
            if (this.isDefaultView()) {
                this.setDefaultView(null);
            } else {
                this.setDefaultView(content);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("newInscription") && HIRuntime.getGui().checkEditAbility(false)) {
            this.addInscription();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.objectContentsListView.getContentsList().getModel().getSize() > 0) {
            if (this.objectContentsListView.getContentsList().getSelectedIndex() == -1) {
                this.objectContentsListView.setSelectedIndex(this.contentIndex);
                return;
            }
            if (this.contentIndex != this.objectContentsListView.getContentsList().getSelectedIndex()) {
                if (this.objectContentEditView.hasChanges() && HIRuntime.getGui().checkEditAbility(true) && !this.askToSaveOrCancelChanges(false)) {
                    this.objectContentsListView.setSelectedIndex(this.contentIndex);
                    return;
                }
                this.contentIndex = this.objectContentsListView.getContentsList().getSelectedIndex();
                this.objectContentsListView.setSelectedIndex(this.contentIndex);
                HiObjectContent content = (HiObjectContent)this.objectContentsListView.getContentsList().getSelectedValue();
                this.setPreviewContent(content);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getSource() == this.objectContentsListView.getContentsList()) {
                this.openLayerEditor(null);
            }
            if (e.getSource() == this.objectContentEditView.getLayerViewer() && this.objectContentEditView.getLayerViewer().getActiveLayer() != null && this.objectContentEditView.getLayerViewer().getActiveLayer().getModel().getLinkInfo() != null) {
                HIRuntime.getGui().openContentEditor(this.objectContentEditView.getLayerViewer().getActiveLayer().getModel().getLinkInfo(), (HIComponent)this);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public class LayerHotlinkTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -2298227072833126148L;

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return null;
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(ObjectEditor.this);
            if (!ObjectEditor.this.objectContentEditView.getLayerViewer().isVisible()) {
                return false;
            }
            ObjectEditor.this.objectContentEditView.getLayerViewer().setState(supp.getDropLocation().getDropPoint().x, supp.getDropLocation().getDropPoint().y);
            if (ObjectEditor.this.objectContentEditView.getLayerViewer().getActiveLayer() == null) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (!(supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(GroupTransferable.groupFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor))) {
                return false;
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group.getType() != GroupTypes.HIGROUP_REGULAR) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            supp.setDropAction(0x40000000);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            long targetID = -1L;
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                HiGroup group;
                block26: {
                    group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group != null) break block26;
                    return false;
                }
                try {
                    targetID = group.getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                HILayer layer;
                block28: {
                    block27: {
                        layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                        if (layer != null) break block27;
                        return false;
                    }
                    if (layer.getModel().getId() != ObjectEditor.this.objectContentEditView.getLayerViewer().getActiveLayer().getModel().getId()) break block28;
                    return false;
                }
                try {
                    targetID = layer.getModel().getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                HiObjectContent content;
                block29: {
                    content = (HiObjectContent)supp.getTransferable().getTransferData(ObjectContentTransferable.objecContentFlavor);
                    if (content != null) break block29;
                    return false;
                }
                try {
                    targetID = content.getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block32: {
                    block31: {
                        block30: {
                            transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                            if (transfer != null) break block30;
                            return false;
                        }
                        if (transfer.getContents().size() == 1) break block31;
                        return false;
                    }
                    if (transfer.getContents().get(0).getBaseID() != ObjectEditor.this.objectContentEditView.getLayerViewer().getActiveLayer().getModel().getId() || transfer.getContents().get(0).getContentType() != HiBaseTypes.HI_LAYER) break block32;
                    return false;
                }
                try {
                    targetID = transfer.getContents().get(0).getBaseID();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            supp.setDropAction(0x40000000);
            if (targetID < 0L) {
                return false;
            }
            return ObjectEditor.this.setLink(targetID);
        }
    }

    public class ObjectContentTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -2298227072833126148L;
        private ObjectEditor editor;
        private boolean wasSort = false;

        public ObjectContentTransferHandler(ObjectEditor editor) {
            this.editor = editor;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HiObjectContent content = (HiObjectContent)((JList)c).getSelectedValue();
            return new ObjectContentTransferable(content);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return;
            }
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.editor);
            }
            if (action == 2 && !this.wasSort) {
                try {
                    HiObjectContent content = (HiObjectContent)t.getTransferData(ObjectContentTransferable.objecContentFlavor);
                    ObjectEditor.this.object.getViews().remove(content);
                    if (ObjectEditor.this.object.getDefaultView() != null && ObjectEditor.this.object.getDefaultView().getId() == content.getId()) {
                        ObjectEditor.this.object.setDefaultView(null);
                    }
                    ObjectEditor.this.refreshContentList();
                    ObjectEditor.this.updateSortOrder();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_REMOVED, ObjectEditor.this.object, this.editor);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, ObjectEditor.this.object, this.editor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.editor);
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (!supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor) && !supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                return false;
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block9: {
                    block8: {
                        transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                        if (transfer != null) break block8;
                        return false;
                    }
                    if (transfer.getContents().size() == 1) break block9;
                    return false;
                }
                try {
                    return transfer.getContents().get(0).getContentType() == HiBaseTypes.HI_OBJECT;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                HIRuntime.getGui().displayInfoDialog(Messages.getString("ObjectEditor.0"), String.valueOf(Messages.getString("ObjectEditor.1")) + "\n\n" + Messages.getString("ObjectEditor.3"));
                return false;
            }
            Transferable t = supp.getTransferable();
            HiObjectContent content = null;
            try {
                this.wasSort = false;
                content = (HiObjectContent)t.getTransferData(ObjectContentTransferable.objecContentFlavor);
                if (content == null) {
                    return false;
                }
                for (HiObjectContent objContent : ObjectEditor.this.object.getViews()) {
                    if (objContent.getId() != content.getId()) continue;
                    this.wasSort = true;
                }
                supp.setDropAction(2);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            try {
                if (this.wasSort) {
                    int moveIndex = -1;
                    int insertIndex = ObjectEditor.this.objectContentsListView.getContentsList().locationToIndex(supp.getDropLocation().getDropPoint());
                    DefaultListModel model = (DefaultListModel)ObjectEditor.this.objectContentsListView.getContentsList().getModel();
                    int i = 0;
                    while (i < model.getSize()) {
                        if (((HiObjectContent)model.get(i)).getId() == content.getId()) {
                            moveIndex = i;
                        }
                        ++i;
                    }
                    if (moveIndex < 0 || moveIndex == insertIndex) {
                        return false;
                    }
                    HiObjectContent sortContent = (HiObjectContent)model.get(moveIndex);
                    ObjectEditor.this.object.getViews().remove(sortContent);
                    ObjectEditor.this.object.getViews().add(insertIndex, sortContent);
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    ObjectEditor.this.refreshContentList();
                    ObjectEditor.this.updateSortOrder();
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                } else {
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    HIRuntime.getManager().updateContentOwner(ObjectEditor.this.object, content);
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                    TransferHandler.DropLocation loc = supp.getDropLocation();
                    DefaultListModel model = (DefaultListModel)ObjectEditor.this.objectContentsListView.getContentsList().getModel();
                    int index = ObjectEditor.this.objectContentsListView.getContentsList().locationToIndex(loc.getDropPoint());
                    index = Math.max(0, index);
                    model.add(index, content);
                    ObjectEditor.this.refreshContentList();
                    ObjectEditor.this.updateSortOrder();
                    ObjectEditor.this.objectContentsListView.updateViewCount();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CHILD_ADDED, ObjectEditor.this.object, this.editor);
                }
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, ObjectEditor.this.object, this.editor);
                return true;
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this.editor);
                return false;
            }
        }
    }
}

