/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.views.PreferenceManagerView;
import org.hyperimage.client.ws.HiBase;

public class PreferenceManager
extends HIComponent
implements ActionListener,
MouseListener {
    PreferenceManagerView preferenceView = new PreferenceManagerView();

    public PreferenceManager() {
        super(Messages.getString("PreferenceManager.0"), Messages.getString("PreferenceManager.1"));
        this.preferenceView.rebuildPreferenceLists(HIRuntime.getManager().getProjectPolygons(), HIRuntime.getManager().getProjectColors());
        this.views.add(this.preferenceView);
        this.preferenceView.getEdiButton().addActionListener(this);
        this.preferenceView.getRemoveButton().addActionListener(this);
        this.preferenceView.getColorPrefList().addMouseListener(this);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        super.setTitle(Messages.getString("PreferenceManager.0"));
        this.getWindowMenuItem().setText(Messages.getString("PreferenceManager.1"));
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        if (message == HIComponent.HIMessageTypes.PREFERENCE_MODIFIED) {
            this.preferenceView.rebuildPreferenceLists(HIRuntime.getManager().getProjectPolygons(), HIRuntime.getManager().getProjectColors());
        }
    }

    private void editColorAction() {
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return;
        }
        int index = this.preferenceView.getColorPrefList().getSelectedIndex();
        Color newColor = JColorChooser.showDialog(this.preferenceView, Messages.getString("PreferenceManager.2"), HIRuntime.getManager().getProjectColors().get(index));
        if (newColor != null) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().getProjectColors().setElementAt(newColor, index);
                HIRuntime.getManager().updateProjectColors();
                newColor = HIRuntime.getManager().getProjectColors().get(index);
                ((DefaultListModel)this.preferenceView.getColorPrefList().getModel()).setElementAt(newColor, index);
                this.preferenceView.getColorPrefList().repaint();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("edit") && this.preferenceView.getColorPrefList().getSelectedIndex() >= 0) {
            this.editColorAction();
        }
        if (e.getActionCommand().equalsIgnoreCase("remove") && (this.preferenceView.getPolygonPrefList().getSelectedIndex() >= 0 || this.preferenceView.getColorPrefList().getSelectedIndex() >= 0)) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("PreferenceManager.5"), String.valueOf(Messages.getString("PreferenceManager.6")) + "\n\n" + Messages.getString("PreferenceManager.8"))) {
                return;
            }
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                if (this.preferenceView.getPolygonPrefList().getSelectedIndex() >= 0) {
                    HIRuntime.getManager().removeProjectPolygon(HIRuntime.getManager().getProjectPolygons().get(this.preferenceView.getPolygonPrefList().getSelectedIndex()));
                } else if (this.preferenceView.getColorPrefList().getSelectedIndex() >= 0) {
                    HIRuntime.getManager().removeProjectColor(HIRuntime.getManager().getProjectColors().get(this.preferenceView.getColorPrefList().getSelectedIndex()));
                }
                this.preferenceView.rebuildPreferenceLists(HIRuntime.getManager().getProjectPolygons(), HIRuntime.getManager().getProjectColors());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1 && this.preferenceView.getColorPrefList().getSelectedIndex() >= 0) {
            this.editColorAction();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

