/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.GroupTransferable;
import org.hyperimage.client.gui.dnd.LayerTransferable;
import org.hyperimage.client.gui.dnd.LocaleTransferable;
import org.hyperimage.client.gui.dnd.ObjectContentTransferable;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.ProjectSettingsView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.util.WSImageLoaderThread;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HIMaintenanceModeException_Exception;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiPreference;
import org.hyperimage.client.ws.HiProjectMetadata;
import org.hyperimage.client.ws.HiQuickInfo;

public class ProjectSettings
extends HIComponent
implements ActionListener,
MouseListener {
    private ProjectSettingsView settingsView;

    public ProjectSettings() {
        block3: {
            super(Messages.getString("ProjectSettings.20"), Messages.getString("ProjectSettings.21"));
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                HIRuntime.getManager().refreshProject();
            }
            catch (HIWebServiceException e) {
                if (!(e.getCause() instanceof HIMaintenanceModeException_Exception)) break block3;
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().displayMaintenanceDialog(e);
            }
        }
        HIRuntime.getGui().stopIndicatingServiceActivity();
        this.settingsView = new ProjectSettingsView();
        this.views.add(this.settingsView);
        LanguageTransferHandler handler = new LanguageTransferHandler();
        this.settingsView.getAvailableLangList().setTransferHandler(handler);
        this.settingsView.getProjectLangList().setTransferHandler(handler);
        this.settingsView.setLinkTransferHandler(new LinkTransferHandler());
        this.settingsView.updateStartElementLink();
        if (HIRuntime.getManager().getProject().getStartObjectInfo() != null) {
            this.loadLinkPreviewImage(HIRuntime.getManager().getProject().getStartObjectInfo(), this.settingsView.getElementLinkPreview());
        }
        this.settingsView.getDefaultLangComboBox().addActionListener(this);
        this.settingsView.getStartElementList().addMouseListener(this);
        this.settingsView.getSaveButton().addActionListener(this);
        this.settingsView.getResetButton().addActionListener(this);
        this.settingsView.getPreviewFieldComboBox().addActionListener(this);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.setTitle(Messages.getString("ProjectSettings.20"));
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges();
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        if (message == HIComponent.HIMessageTypes.ENTITY_CHANGED || message == HIComponent.HIMessageTypes.CHILD_ADDED || message == HIComponent.HIMessageTypes.CHILD_REMOVED) {
            if (HIRuntime.getManager().getProject().getStartObjectInfo() != null && base.getId() == HIRuntime.getManager().getProject().getStartObjectInfo().getBaseID()) {
                HIRuntime.getGui().startIndicatingServiceActivity();
                try {
                    HIRuntime.getManager().getProject().setStartObjectInfo(HIRuntime.getManager().getBaseQuickInfo(HIRuntime.getManager().getProject().getStartObjectInfo().getBaseID()));
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.settingsView.updateStartElementLink();
                this.loadLinkPreviewImage(HIRuntime.getManager().getProject().getStartObjectInfo(), this.settingsView.getElementLinkPreview());
            }
            this.settingsView.updateQuotaInfo();
        }
        if (message == HIComponent.HIMessageTypes.CONTENT_MOVED_TO_TRASH) {
            this.settingsView.updateStartElementLink();
            if (HIRuntime.getManager().getProject().getStartObjectInfo() != null) {
                this.loadLinkPreviewImage(HIRuntime.getManager().getProject().getStartObjectInfo(), this.settingsView.getElementLinkPreview());
            }
        }
    }

    private boolean setLink(long targetID) {
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return false;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            if (!HIRuntime.getManager().updateProjectStartElement(targetID)) {
                HIRuntime.getGui().stopIndicatingServiceActivity();
                return false;
            }
            HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(targetID);
            HIRuntime.getManager().getProject().setStartObjectInfo(info);
            this.settingsView.updateStartElementLink();
            this.loadLinkPreviewImage(info, this.settingsView.getElementLinkPreview());
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return false;
        }
        HIRuntime.getGui().stopIndicatingServiceActivity();
        return true;
    }

    private void loadLinkPreviewImage(HiQuickInfo info, QuickInfoCell cell) {
        if (cell != null && cell.needsPreview()) {
            WSImageLoaderThread thumbLoader = new WSImageLoaderThread();
            long viewID = info.getBaseID();
            boolean cacheImage = true;
            if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
                viewID = info.getRelatedID();
            }
            if (info.getContentType() == HiBaseTypes.HI_LAYER) {
                cacheImage = false;
            }
            thumbLoader.loadImage(viewID, cacheImage, HiImageSizes.HI_THUMBNAIL, cell, this.settingsView);
        }
    }

    private void updateDefaultLanguageOptions() {
        this.settingsView.getDefaultLangComboBox().removeActionListener(this);
        this.settingsView.updateLanguageOptions();
        this.settingsView.getDefaultLangComboBox().addActionListener(this);
    }

    private boolean askToSaveOrCancelChanges() {
        if (this.settingsView.hasChanges() && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = JOptionPane.showConfirmDialog(HIRuntime.getGui(), Messages.getString("ProjectSettings.4"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
            } else {
                this.settingsView.resetChanges();
            }
        }
        return true;
    }

    private void saveMetadataChanges() {
        if (!HIRuntime.getGui().checkEditAbility(false)) {
            return;
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            if (this.settingsView.hasChanges()) {
                this.settingsView.syncChanges();
                for (HiProjectMetadata metadata : HIRuntime.getManager().getProject().getMetadata()) {
                    HIRuntime.getManager().updateProject(metadata.getLanguageID(), metadata.getTitle());
                }
                HIRuntime.getGui().updateProjectTitle();
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.settingsView.getPreviewFieldComboBox()) {
            HiPreference titlePref = MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "admin.preview.objectTitleField");
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                if (titlePref == null) {
                    HIRuntime.getManager().createPreference("admin.preview.objectTitleField", this.settingsView.getSelectedPreviewField());
                } else {
                    titlePref.setValue(this.settingsView.getSelectedPreviewField());
                    HIRuntime.getManager().updatePreference(titlePref);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED, null, this);
        } else if (e.getActionCommand().equalsIgnoreCase("save")) {
            if (HIRuntime.getGui().checkEditAbility(false) && this.settingsView.hasChanges()) {
                this.saveMetadataChanges();
            }
        } else if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.settingsView.resetChanges();
        } else {
            boolean changeDefLanguage;
            String newDefLangID = MetadataHelper.localeToLangID((Locale)this.settingsView.getDefaultLangComboBox().getSelectedItem());
            if (!newDefLangID.equalsIgnoreCase(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()) && (changeDefLanguage = HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("ProjectSettings.12"), Messages.getString("ProjectSettings.14")))) {
                HIRuntime.getGui().startIndicatingServiceActivity();
                try {
                    if (HIRuntime.getManager().updateProjectDefaultLanguage(newDefLangID)) {
                        this.settingsView.updateStartElementLink();
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED, null, this);
                    }
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            this.settingsView.updateLanguageOptions();
            HIRuntime.getGui().updateProjectTitle();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1 && HIRuntime.getManager().getProject().getStartObjectInfo() != null) {
            HIRuntime.getGui().openContentEditor(HIRuntime.getManager().getProject().getStartObjectInfo(), (HIComponent)this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class LanguageTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 6024246448122451592L;
        boolean wasAdd = false;

        LanguageTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Locale lang = (Locale)((JList)c).getSelectedValue();
            return new LocaleTransferable(lang);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            if (supp.isDataFlavorSupported(LocaleTransferable.localeFlavor)) {
                Locale lang;
                try {
                    lang = (Locale)supp.getTransferable().getTransferData(LocaleTransferable.localeFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                DefaultListModel model = (DefaultListModel)((JList)supp.getComponent()).getModel();
                if (model.contains(lang)) {
                    return false;
                }
                return supp.getComponent() != ProjectSettings.this.settingsView.getAvailableLangList() || ProjectSettings.this.settingsView.getProjectLangList().getModel().getSize() > 1;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            this.wasAdd = false;
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkAdminAbility(false)) {
                return false;
            }
            supp.setDropAction(2);
            if (supp.isDataFlavorSupported(LocaleTransferable.localeFlavor)) {
                Locale lang;
                try {
                    lang = (Locale)supp.getTransferable().getTransferData(LocaleTransferable.localeFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                if (lang.equals(MetadataHelper.langToLocale(HIRuntime.getManager().getProject().getDefaultLanguage()))) {
                    HIRuntime.getGui().displayInfoDialog(Messages.getString("ProjectSettings.0"), Messages.getString("ProjectSettings.1"));
                    return false;
                }
                if (supp.getComponent() == ProjectSettings.this.settingsView.getProjectLangList()) {
                    this.wasAdd = true;
                    boolean proceed = HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("ProjectSettings.2"), String.valueOf(Messages.getString("ProjectSettings.3")) + "\n\n" + Messages.getString("ProjectSettings.5") + "\n" + Messages.getString("ProjectSettings.7") + "\n\n" + Messages.getString("ProjectSettings.9"));
                    if (!proceed) {
                        return false;
                    }
                    proceed = HIRuntime.getGui().saveAllOpenWork();
                    if (!proceed) {
                        return false;
                    }
                    try {
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        boolean languageAdded = HIRuntime.getManager().addLanguageToProject(MetadataHelper.localeToLangID(lang));
                        if (languageAdded) {
                            DefaultListModel model = (DefaultListModel)ProjectSettings.this.settingsView.getProjectLangList().getModel();
                            model.insertElementAt(lang, ProjectSettings.this.settingsView.getProjectLangList().locationToIndex(supp.getDropLocation().getDropPoint()));
                            ProjectSettings.this.updateDefaultLanguageOptions();
                            model = (DefaultListModel)ProjectSettings.this.settingsView.getAvailableLangList().getModel();
                            int removeIndex = model.indexOf(lang);
                            if (removeIndex >= 0) {
                                model.remove(removeIndex);
                            }
                            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.LANGUAGE_ADDED, null, ProjectSettings.this);
                        }
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                        if (languageAdded) {
                            ProjectSettings.this.settingsView.updateStartElementLink();
                        }
                        return languageAdded;
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, ProjectSettings.this);
                        return false;
                    }
                }
                boolean proceed = HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("ProjectSettings.10"), String.valueOf(Messages.getString("ProjectSettings.11")) + "\n\n" + Messages.getString("ProjectSettings.13") + "\n" + Messages.getString("ProjectSettings.15") + "\n" + Messages.getString("ProjectSettings.17") + "\n\n" + Messages.getString("ProjectSettings.19"));
                if (!proceed) {
                    return false;
                }
                proceed = HIRuntime.getGui().saveAllOpenWork();
                if (!proceed) {
                    return false;
                }
                try {
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    boolean languageRemoved = HIRuntime.getManager().removeLanguageFromProject(MetadataHelper.localeToLangID(lang));
                    if (languageRemoved) {
                        DefaultListModel model = (DefaultListModel)ProjectSettings.this.settingsView.getAvailableLangList().getModel();
                        model.insertElementAt(lang, ProjectSettings.this.settingsView.getAvailableLangList().locationToIndex(supp.getDropLocation().getDropPoint()));
                        ProjectSettings.this.updateDefaultLanguageOptions();
                        model = (DefaultListModel)ProjectSettings.this.settingsView.getProjectLangList().getModel();
                        int removeIndex = model.indexOf(lang);
                        if (removeIndex >= 0) {
                            model.remove(removeIndex);
                        }
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.LANGUAGE_REMOVED, null, ProjectSettings.this);
                    }
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                    if (languageRemoved) {
                        ProjectSettings.this.settingsView.updateStartElementLink();
                    }
                    return languageRemoved;
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, ProjectSettings.this);
                    return false;
                }
            }
            return false;
        }
    }

    public class LinkTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1392755235239308382L;

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return null;
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(ProjectSettings.this);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(ProjectSettings.this);
            boolean isLink = false;
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(GroupTransferable.groupFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                isLink = true;
            }
            if (!isLink) {
                return false;
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group.getType() != GroupTypes.HIGROUP_REGULAR) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            supp.setDropAction(0x40000000);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            long targetID = -1L;
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                HiGroup group;
                block24: {
                    group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group != null) break block24;
                    return false;
                }
                try {
                    targetID = group.getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                HILayer layer;
                block25: {
                    layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                    if (layer != null) break block25;
                    return false;
                }
                try {
                    targetID = layer.getModel().getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                HiObjectContent content;
                block26: {
                    content = (HiObjectContent)supp.getTransferable().getTransferData(ObjectContentTransferable.objecContentFlavor);
                    if (content != null) break block26;
                    return false;
                }
                try {
                    targetID = content.getId();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block28: {
                    block27: {
                        transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                        if (transfer != null) break block27;
                        return false;
                    }
                    if (transfer.getContents().size() == 1) break block28;
                    return false;
                }
                try {
                    targetID = transfer.getContents().get(0).getBaseID();
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            supp.setDropAction(0x40000000);
            if (targetID < 0L) {
                return false;
            }
            return ProjectSettings.this.setLink(targetID);
        }
    }
}

