/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dnd.UserTransferable;
import org.hyperimage.client.gui.views.UserManagerView;
import org.hyperimage.client.ws.HiRoles;
import org.hyperimage.client.ws.HiUser;

public class ProjectUsersManager
extends HIComponent {
    private UserManagerView userManagerView;

    public ProjectUsersManager() {
        super(Messages.getString("ProjectUsersManager.0"), Messages.getString("ProjectUsersManager.1"));
        boolean loadingErrorOccurred = false;
        ArrayList<HiUser> projectGuests = new ArrayList<HiUser>();
        ArrayList<HiUser> filteredUsers = new ArrayList<HiUser>();
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            List<HiUser> projectUsers = HIRuntime.getManager().getProjectUsers();
            ArrayList<HiUser> users = new ArrayList<HiUser>(projectUsers.size());
            for (HiUser user : projectUsers) {
                HiRoles role = HIRuntime.getManager().getRoleInProject(user, HIRuntime.getManager().getProject());
                if (role == HiRoles.USER) {
                    users.add(user);
                    continue;
                }
                if (role == HiRoles.GUEST) {
                    projectGuests.add(user);
                    continue;
                }
                filteredUsers.add(user);
            }
            projectUsers = users;
            List<HiUser> systemUsers = HIRuntime.getManager().getUsersAsAdmin();
            ArrayList<HiUser> cleanSystemUsers = new ArrayList<HiUser>(systemUsers.size());
            for (HiUser user : systemUsers) {
                boolean isFilteredUser = false;
                for (HiUser filteredUser : filteredUsers) {
                    if (filteredUser.getId() != user.getId()) continue;
                    isFilteredUser = true;
                }
                if (isFilteredUser) continue;
                cleanSystemUsers.add(user);
            }
            systemUsers = cleanSystemUsers;
            this.userManagerView = new UserManagerView(systemUsers, projectUsers, projectGuests);
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            loadingErrorOccurred = true;
        }
        if (loadingErrorOccurred) {
            this.userManagerView = new UserManagerView(null, null, null);
        }
        this.views.add(this.userManagerView);
        UserTransferHandler handler = new UserTransferHandler(this);
        this.userManagerView.getSystemUsersList().setTransferHandler(handler);
        this.userManagerView.getProjectUsersList().setTransferHandler(handler);
        this.userManagerView.getProjectGuestsList().setTransferHandler(handler);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        super.setTitle(Messages.getString("ProjectUsersManager.0"));
        this.getWindowMenuItem().setText(Messages.getString("ProjectUsersManager.1"));
        HIRuntime.getGui().updateComponentTitle(this);
    }

    public class UserTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -876283873557001866L;
        private boolean userImported = false;
        private HIComponent userManager;

        public UserTransferHandler(HIComponent userManager) {
            this.userManager = userManager;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HiUser user = (HiUser)((JList)c).getSelectedValue();
            return new UserTransferable(user);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (this.userImported && t.isDataFlavorSupported(UserTransferable.userFlavor)) {
                HiUser user;
                try {
                    user = (HiUser)t.getTransferData(UserTransferable.userFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return;
                }
                catch (IOException e) {
                    return;
                }
                DefaultListModel model = (DefaultListModel)((JList)c).getModel();
                if (model.contains(user)) {
                    model.removeElement(user);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            if (supp.isDataFlavorSupported(UserTransferable.userFlavor)) {
                HiUser user;
                try {
                    user = (HiUser)supp.getTransferable().getTransferData(UserTransferable.userFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                DefaultListModel model = (DefaultListModel)((JList)supp.getComponent()).getModel();
                return !model.contains(user);
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            this.userImported = false;
            if (!this.canImport(supp)) {
                return false;
            }
            supp.setDropAction(2);
            if (supp.isDataFlavorSupported(UserTransferable.userFlavor)) {
                HiUser user;
                try {
                    user = (HiUser)supp.getTransferable().getTransferData(UserTransferable.userFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                JList list = (JList)supp.getComponent();
                DefaultListModel model = (DefaultListModel)list.getModel();
                if (model.contains(user)) {
                    return false;
                }
                if (list == ProjectUsersManager.this.userManagerView.getSystemUsersList()) {
                    try {
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        HIRuntime.getManager().removeUserFromProject(user);
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this.userManager);
                        return false;
                    }
                }
                if (list == ProjectUsersManager.this.userManagerView.getProjectUsersList() || list == ProjectUsersManager.this.userManagerView.getProjectGuestsList()) {
                    try {
                        HiRoles role = HiRoles.USER;
                        if (list == ProjectUsersManager.this.userManagerView.getProjectGuestsList()) {
                            role = HiRoles.GUEST;
                        }
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        HIRuntime.getManager().addUserToProject(user, role);
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this.userManager);
                        return false;
                    }
                }
                model.addElement(user);
                this.userImported = true;
                return true;
            }
            return false;
        }
    }
}

