/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.gui.lists.GroupContentsCellRenderer;
import org.hyperimage.client.gui.lists.GroupContentsList;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.SearchResultsView;
import org.hyperimage.client.gui.views.SearchView;
import org.hyperimage.client.util.WSImageLoaderThread;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiQuickInfo;

public class SearchModule
extends HIComponent
implements ActionListener,
MouseListener {
    private HIComponent searchModule = this;
    private SearchView searchView;
    private SearchResultsView resultsView;
    private GroupContentsList.HI_ListDisplayStyles userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.ICON_STYLE;
    private SearchResultLoader resultsLoader = new SearchResultLoader();
    private boolean isSimpleSearch = true;

    public SearchModule() {
        super(Messages.getString("SearchModule.0"), Messages.getString("SearchModule.1"));
        this.searchView = new SearchView(HIRuntime.getManager().getProject().getLanguages(), HIRuntime.getManager().getProject().getDefaultLanguage());
        this.resultsView = new SearchResultsView();
        this.resultsView.setTitle(Messages.getString("SearchModule.2"));
        this.views.add(this.searchView);
        this.views.add(this.resultsView);
        this.resultsView.getContentsList().setTransferHandler(new SearchResultsTransferHandler(this));
        this.searchView.attachListeners(this);
        this.resultsView.getContentsList().addMouseListener(this);
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        if (this.resultsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.resultsView.getListStyleButton().setToolTipText(Messages.getString("SearchModule.10"));
        } else {
            this.resultsView.getListStyleButton().setToolTipText(Messages.getString("SearchModule.11"));
        }
        this.updateTitle(this.isSimpleSearch);
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        if (message == HIComponent.HIMessageTypes.LANGUAGE_ADDED || message == HIComponent.HIMessageTypes.LANGUAGE_REMOVED) {
            this.searchView.rebuildLanguages(HIRuntime.getManager().getProject().getLanguages());
        }
        if (message == HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED) {
            if (this.resultsView.getContents() == null) {
                return;
            }
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                int i = 0;
                while (i < this.resultsView.getContents().size()) {
                    HiQuickInfo info = this.resultsView.getContents().get(i);
                    info = HIRuntime.getManager().getBaseQuickInfo(info.getBaseID());
                    this.resultsView.getContents().set(i, info);
                    ++i;
                }
                this.resultsView.setContents(this.resultsView.getContents());
                this.loadContentPreviews();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
    }

    private void updateTitle(boolean isSimple) {
        this.isSimpleSearch = isSimple;
        String title = this.searchView.getSearchText().trim();
        if (title.length() == 0) {
            title = Messages.getString("SearchModule.3");
        } else if (isSimple) {
            title = String.valueOf(Messages.getString("SearchModule.4")) + " \"" + title + "\"";
        } else {
            title = this.searchView.getFieldSearchText().trim();
            title = String.valueOf(Messages.getString("SearchModule.7")) + " \"" + title + "\"";
        }
        this.setTitle(title);
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    private void setDisplayStyle(GroupContentsList.HI_ListDisplayStyles style) {
        if (this.resultsView.getContentsList().getDisplayStyle() == style) {
            return;
        }
        if (style == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.resultsView.getContentsList().setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.ICON_STYLE);
            this.resultsView.getListStyleButton().setIcon(this.resultsView.iconStyleIcon);
            this.resultsView.getListStyleButton().setToolTipText(Messages.getString("SearchModule.10"));
            this.loadContentPreviews();
        } else {
            this.resultsView.getContentsList().setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
            this.resultsView.getListStyleButton().setIcon(this.resultsView.listStyleIcon);
            this.resultsView.getListStyleButton().setToolTipText(Messages.getString("SearchModule.11"));
        }
    }

    private void loadContentPreviews() {
        for (HiQuickInfo info : this.resultsView.getContents()) {
            this.loadContentPreview(info);
        }
    }

    private void loadContentPreview(HiQuickInfo info) {
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.resultsView.getContentsList().getCellRenderer();
        QuickInfoCell cell = renderer.getCellForContent(info);
        if (cell != null && cell.needsPreview()) {
            WSImageLoaderThread thumbLoader = new WSImageLoaderThread();
            long viewID = info.getBaseID();
            boolean cacheImage = true;
            if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
                viewID = info.getRelatedID();
            }
            if (info.getContentType() == HiBaseTypes.HI_LAYER) {
                cacheImage = false;
            }
            thumbLoader.loadImage(viewID, cacheImage, HiImageSizes.HI_THUMBNAIL, cell, this.resultsView.getContentsList());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.searchView.getSelectedLanguage().compareTo("all") == 0) {
            HIRuntime.getGui().displayInfoDialog(Messages.getString("SearchModule.13"), Messages.getString("SearchModule.14"));
            return;
        }
        if (this.searchView.getSearchText().length() == 0 && this.searchView.getFieldSearchText().length() == 0) {
            return;
        }
        this.searchView.setSearchEnabled(false);
        this.resultsView.prepareElementLoading();
        if (e.getActionCommand().equalsIgnoreCase("simpleSearch") || e.getActionCommand().equalsIgnoreCase("search") && this.searchView.getFieldSearchText().length() == 0) {
            this.updateTitle(true);
            this.resultsLoader.simpleSearch(this.searchView.getSearchText());
        }
        if (e.getActionCommand().equalsIgnoreCase("fieldSearch") || e.getActionCommand().equalsIgnoreCase("search") && this.searchView.getFieldSearchText().length() > 0) {
            this.updateTitle(false);
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(this.searchView.getSearchField());
            ArrayList<String> contents = new ArrayList<String>();
            contents.add(this.searchView.getFieldSearchText());
            this.resultsLoader.fieldSearch(fields, contents);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2 && this.resultsView.getContentsList().getSelectedIndex() >= 0) {
            HiQuickInfo info = (HiQuickInfo)this.resultsView.getContentsList().getSelectedValue();
            HIRuntime.getGui().openContentEditor(info, (HIComponent)this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class SearchResultLoader
    implements Runnable {
        private Thread thread = new Thread(this);
        private boolean isSimple;
        private String text;
        private List<String> fields;
        private List<String> contents;

        public void simpleSearch(String text) {
            this.text = text;
            this.isSimple = true;
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            } else if (this.thread.getState() == Thread.State.TERMINATED) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                while (this.thread.getState() == Thread.State.RUNNABLE) {
                }
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        public void fieldSearch(List<String> fields, List<String> contents) {
            this.fields = fields;
            this.contents = contents;
            this.isSimple = false;
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            } else if (this.thread.getState() == Thread.State.TERMINATED) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                while (this.thread.getState() == Thread.State.RUNNABLE) {
                }
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        @Override
        public void run() {
            List<HiQuickInfo> infoList;
            try {
                infoList = this.isSimple ? HIRuntime.getManager().simpleSearch(this.text, SearchModule.this.searchView.getSelectedLanguage()) : HIRuntime.getManager().fieldSearch(this.fields, this.contents, SearchModule.this.searchView.getSelectedLanguage());
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, SearchModule.this.searchModule);
                SearchModule.this.resultsView.setContents(null);
                SearchModule.this.searchView.setSearchEnabled(true);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (infoList != null) {
                        if (infoList.size() >= 100) {
                            SearchModule.this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
                        } else {
                            SearchModule.this.setDisplayStyle(SearchModule.this.userSelectedStyle);
                        }
                        SearchModule.this.resultsView.setContents(infoList);
                    }
                    SearchModule.this.searchView.setSearchEnabled(true);
                    if (SearchModule.this.resultsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
                        SearchModule.this.loadContentPreviews();
                    }
                }
            });
        }
    }

    class SearchResultsTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5928024106665575189L;
        private SearchModule search;

        public SearchResultsTransferHandler(SearchModule search) {
            this.search = search;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Vector<HiQuickInfo> elements = new Vector<HiQuickInfo>();
            Object[] objectArray = SearchModule.this.resultsView.getContentsList().getSelectedValues();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                elements.add((HiQuickInfo)object);
                ++n2;
            }
            return new QuickInfoTransferable(new ContentTransfer(elements, null, this.search));
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.search);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.search);
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            return false;
        }
    }
}

