/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.GroupBrowser;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.components.SearchModule;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.GroupTransferable;
import org.hyperimage.client.gui.dnd.LayerTransferable;
import org.hyperimage.client.gui.dnd.ObjectContentTransferable;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.gui.lists.GroupContentsCellRenderer;
import org.hyperimage.client.gui.lists.GroupContentsList;
import org.hyperimage.client.gui.lists.GroupListCellRenderer;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.views.TagContentsView;
import org.hyperimage.client.gui.views.TagListView;
import org.hyperimage.client.gui.views.TagMetadataEditorView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.util.WSImageLoaderThread;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiQuickInfo;

public class TagExplorer
extends HIComponent
implements ListSelectionListener,
ActionListener,
MouseListener {
    private TagListView tagListView;
    private TagContentsView tagContentsView;
    private TagMetadataEditorView metadataEditorView;
    private HIGroupContentLoader contentLoader;
    private HIComponent browser = this;
    private GroupContentsList.HI_ListDisplayStyles userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.ICON_STYLE;
    private TagTransferHandler tagContentsHandler;

    public TagExplorer() {
        this(null);
    }

    public TagExplorer(HiGroup tag) {
        super(Messages.getString("TagExplorer.17"), Messages.getString("TagExplorer.18"));
        this.tagListView = new TagListView(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        this.tagContentsView = new TagContentsView();
        this.metadataEditorView = new TagMetadataEditorView();
        this.contentLoader = new HIGroupContentLoader();
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            this.tagListView.setTags(this.sortTags(HIRuntime.getManager().getTags()));
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
        }
        HIRuntime.getGui().startIndicatingServiceActivity();
        this.tagListView.getList().setEnabled(false);
        this.tagContentsView.prepareElementLoading();
        if (tag == null && this.tagListView.getList().getModel().getSize() > 0) {
            tag = (HiGroup)this.tagListView.getList().getModel().getElementAt(0);
        }
        int groupIndex = -1;
        if (tag != null) {
            int i = 0;
            while (i < this.tagListView.getList().getModel().getSize()) {
                if (((HiGroup)this.tagListView.getList().getModel().getElementAt(i)).getId() == tag.getId()) {
                    groupIndex = i;
                    tag = (HiGroup)this.tagListView.getList().getModel().getElementAt(i);
                }
                ++i;
            }
        }
        if (groupIndex == -1) {
            tag = null;
        } else {
            this.tagListView.getList().setSelectedIndex(groupIndex);
        }
        this.tagContentsView.setCurrentTag(tag);
        this.metadataEditorView.setTag(tag, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        if (tag != null) {
            this.contentLoader.loadTag(tag);
        }
        HIRuntime.getGui().stopIndicatingServiceActivity();
        this.updateTitle();
        this.metadataEditorView.getSaveButton().addActionListener(this);
        this.metadataEditorView.getResetButton().addActionListener(this);
        this.tagContentsView.getContentsList().addMouseListener(this);
        this.tagContentsView.getListStyleButton().addActionListener(this);
        this.tagContentsView.optionsButton.addActionListener(this);
        this.tagContentsView.setMenuActionListener(this);
        this.tagListView.getList().addListSelectionListener(this);
        this.tagListView.attachActionListeners(this);
        this.tagListView.getList().addMouseListener(this);
        this.views.add(this.tagListView);
        this.views.add(this.tagContentsView);
        this.views.add(this.metadataEditorView);
    }

    private List<HiGroup> sortTags(List<HiGroup> tags) {
        if (tags == null) {
            return null;
        }
        Collections.sort(tags, new Comparator<HiGroup>(){

            @Override
            public int compare(HiGroup tagOne, HiGroup tagTwo) {
                String titleOne = "";
                String titleTwo = "";
                HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord((HiBase)tagOne, HIRuntime.getManager().getProject().getDefaultLanguage());
                titleOne = record != null ? MetadataHelper.findValue("HIBase", "title", record) : "Tag (" + tagOne.getUUID().split("-")[4] + ")";
                record = MetadataHelper.getDefaultMetadataRecord((HiBase)tagTwo, HIRuntime.getManager().getProject().getDefaultLanguage());
                titleTwo = record != null ? MetadataHelper.findValue("HIBase", "title", record) : "Tag (" + tagTwo.getUUID().split("-")[4] + ")";
                return titleOne.compareTo(titleTwo);
            }
        });
        return tags;
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        if (this.tagContentsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.tagContentsView.getListStyleButton().setToolTipText(Messages.getString("TagExplorer.77"));
        } else {
            this.tagContentsView.getListStyleButton().setToolTipText(Messages.getString("TagExplorer.78"));
        }
        this.updateTitle();
    }

    @Override
    public HiBase getBaseElement() {
        if (this.tagListView.getList().getModel().getSize() > 0 && this.tagListView.getList().getSelectedIndex() >= 0) {
            return (HiGroup)this.tagListView.getList().getSelectedValue();
        }
        return null;
    }

    @Override
    public void receiveMessage(HIComponent.HIMessageTypes message, HiBase base) {
        HiGroup changedGroup;
        if (message == HIComponent.HIMessageTypes.LANGUAGE_ADDED || message == HIComponent.HIMessageTypes.LANGUAGE_REMOVED) {
            DefaultListModel model = (DefaultListModel)this.tagListView.getList().getModel();
            HIRuntime.getGui().startIndicatingServiceActivity();
            try {
                int i = 1;
                while (i < model.getSize() - 1) {
                    HiGroup group = (HiGroup)model.get(i);
                    List<HiFlexMetadataRecord> records = HIRuntime.getManager().getFlexMetadataRecords(group);
                    while (group.getMetadata().size() > 0) {
                        group.getMetadata().remove(0);
                    }
                    for (HiFlexMetadataRecord record : records) {
                        group.getMetadata().add(record);
                    }
                    ++i;
                }
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
            HIRuntime.getGui().stopIndicatingServiceActivity();
            this.metadataEditorView.setTag(this.tagListView.getCurrentTag(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        }
        if (message == HIComponent.HIMessageTypes.ENTITY_CHANGED) {
            if (base instanceof HiGroup) {
                this.tagListView.updateTag((HiGroup)base);
                if (this.tagListView.getCurrentTag().getId() == base.getId()) {
                    this.metadataEditorView.setTag((HiGroup)base, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                }
            }
            for (HiQuickInfo content : this.tagContentsView.getContents()) {
                if (content.getBaseID() != base.getId() && content.getRelatedID() != base.getId()) continue;
                try {
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    HiQuickInfo newInfo = HIRuntime.getManager().getContentInfo(content);
                    this.tagContentsView.updateQuickInfo(newInfo);
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                    this.loadContentPreview(newInfo);
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                }
            }
        }
        if (message == HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED && ((changedGroup = (HiGroup)base).getId() == this.tagListView.getCurrentTag().getId() || this.tagListView.getCurrentTag().getType() != GroupTypes.HIGROUP_REGULAR)) {
            this.tagListView.getList().setEnabled(false);
            this.tagContentsView.prepareElementLoading();
            this.contentLoader.loadTag(this.tagListView.getCurrentTag());
        }
        if (message == HIComponent.HIMessageTypes.CONTENT_MOVED_TO_TRASH || message == HIComponent.HIMessageTypes.MOVED_TO_TRASH) {
            this.tagListView.getList().setEnabled(false);
            this.tagContentsView.prepareElementLoading();
            this.contentLoader.loadTag(this.tagListView.getCurrentTag());
        }
        if (message == HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED) {
            this.tagListView.getList().setEnabled(false);
            this.tagContentsView.prepareElementLoading();
            this.contentLoader.loadTag(this.tagListView.getCurrentTag());
            ((GroupListCellRenderer)this.tagListView.getList().getCellRenderer()).setDefaultLang(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
            this.tagListView.getList().repaint();
        }
        if ((message == HIComponent.HIMessageTypes.ENTITY_ADDED || message == HIComponent.HIMessageTypes.ENTITY_REMOVED) && base instanceof HiGroup) {
            try {
                this.tagListView.setTags(this.sortTags(HIRuntime.getManager().getTags()));
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (message == HIComponent.HIMessageTypes.GROUP_SORTORDER_CHANGED) {
            try {
                this.tagListView.setTags(this.sortTags(HIRuntime.getManager().getTags()));
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (message == HIComponent.HIMessageTypes.GROUPCONTENTS_SORTORDER_CHANGED && base != null) {
            HiGroup group = (HiGroup)base;
            int i = 0;
            while (i < this.tagListView.getList().getModel().getSize()) {
                if (this.tagListView.getTag(i).getId() == group.getId()) {
                    this.tagListView.getTag(i).setSortOrder(group.getSortOrder());
                    if (this.tagListView.getTag(i).getId() == this.tagListView.getCurrentTag().getId()) {
                        this.tagContentsView.sortContents();
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean requestClose() {
        return this.askToSaveOrCancelChanges();
    }

    public void resetBrowser() {
        this.discardChanges();
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            this.tagListView.resetAllTags(this.sortTags(HIRuntime.getManager().getTags()));
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
        }
    }

    private void saveMetadataChanges() {
        boolean updateMetadata = this.metadataEditorView.hasMetadataChanges();
        if (updateMetadata && HIRuntime.getGui().checkEditAbility(false)) {
            this.metadataEditorView.syncChanges();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateFlexMetadataRecords(this.metadataEditorView.getMetadata());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.tagListView.getCurrentTag().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.tagContentsView.getCurrentTag(), this);
                this.tagListView.updateContent();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
    }

    private void discardChanges() {
        if (this.metadataEditorView.hasChanges()) {
            this.metadataEditorView.resetChanges();
        }
    }

    private boolean askToSaveOrCancelChanges() {
        if (this.metadataEditorView.hasChanges() && HIRuntime.getGui().checkEditAbility(true)) {
            int decision = JOptionPane.showConfirmDialog(HIRuntime.getGui(), Messages.getString("TagExplorer.19"));
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                this.saveMetadataChanges();
            }
        }
        return true;
    }

    private HiGroup createTag() {
        HiGroup newTag = null;
        if (HIRuntime.getGui().checkEditAbility(false)) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                newTag = HIRuntime.getManager().createTagGroup();
                if (newTag != null) {
                    this.tagContentsView.setCurrentTag(newTag);
                    this.metadataEditorView.setTag(newTag, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                    this.contentLoader.loadTag(newTag);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return null;
            }
        }
        return newTag;
    }

    private void loadContentPreviews() {
        for (HiQuickInfo info : this.tagContentsView.getContents()) {
            this.loadContentPreview(info);
        }
    }

    private void loadContentPreview(HiQuickInfo info) {
        GroupContentsCellRenderer renderer = (GroupContentsCellRenderer)this.tagContentsView.getContentsList().getCellRenderer();
        QuickInfoCell cell = renderer.getCellForContent(info);
        if (cell != null && cell.needsPreview()) {
            WSImageLoaderThread thumbLoader = new WSImageLoaderThread();
            long viewID = info.getBaseID();
            boolean cacheImage = true;
            if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
                viewID = info.getRelatedID();
            }
            if (info.getContentType() == HiBaseTypes.HI_LAYER) {
                cacheImage = false;
            }
            thumbLoader.loadImage(viewID, cacheImage, HiImageSizes.HI_THUMBNAIL, cell, this.tagContentsView.getContentsList());
        }
    }

    private void updateTitle() {
        HiGroup tag = this.tagListView.getCurrentTag();
        String title = tag != null ? MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)tag, HIRuntime.getManager().getProject().getDefaultLanguage())) : Messages.getString("TagExplorer.noTags");
        title = title == null || title.length() == 0 ? (tag.getUUID() == null ? "G" + tag.getId() : tag.getUUID()) : "\"" + title + "\"";
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tagListView.getList().getSelectedIndex() == -1 && this.tagContentsView.getCurrentTag() != null) {
            this.tagListView.setSelectedTag(this.tagContentsView.getCurrentTag());
        }
        if (this.tagListView.getCurrentTag() == null) {
            this.metadataEditorView.setTag(null, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
        }
        if (this.tagContentsView.getCurrentTag() != null && this.tagListView.getCurrentTag().getId() != this.tagContentsView.getCurrentTag().getId()) {
            if (!this.askToSaveOrCancelChanges()) {
                this.tagListView.setSelectedTag(this.tagContentsView.getCurrentTag());
                return;
            }
            this.tagListView.getList().setEnabled(false);
            this.tagContentsView.prepareElementLoading();
            HiGroup tag = this.tagListView.getCurrentTag();
            this.tagContentsView.setCurrentTag(tag);
            this.metadataEditorView.setTag(tag, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
            if (tag != null) {
                this.contentLoader.loadTag(tag);
            }
            this.updateTitle();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] indices;
        if (e.getActionCommand().equalsIgnoreCase("groupFromSelection")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (this.tagListView.getCurrentTag() == null) {
                return;
            }
            indices = this.tagContentsView.getContentsList().getSelectedIndices();
            HiGroup newGroup = this.createTag();
            if (newGroup != null) {
                try {
                    String tagTitle = "";
                    HiGroup curTag = this.tagListView.getCurrentTag();
                    String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)curTag, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
                    tagTitle = title == null || title.length() == 0 ? (curTag.getUUID() == null ? "Tag " + curTag.getId() : curTag.getUUID()) : title;
                    HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord((HiBase)newGroup, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                    if (record != null) {
                        MetadataHelper.setValue("HIBase", "title", String.valueOf(Messages.getString("TagExplorer.47")) + " " + tagTitle, record);
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        HIRuntime.getManager().updateFlexMetadataRecord(record);
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                    }
                    String sortOrder = "";
                    int[] nArray = indices;
                    int n = indices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        HiQuickInfo content = this.tagContentsView.getContents().get(index);
                        HIRuntime.getManager().copyToGroup(content.getBaseID(), newGroup.getId());
                        sortOrder = String.valueOf(sortOrder) + "," + content.getBaseID();
                        ++n2;
                    }
                    if (sortOrder.length() > 0) {
                        sortOrder = sortOrder.substring(1);
                    }
                    HIRuntime.getManager().updateGroupSortOrder(newGroup, sortOrder);
                    this.tagListView.getCurrentTag().setTimestamp(new Date().getTime());
                    this.metadataEditorView.updateContent();
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newGroup, this);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, newGroup, this);
                    this.tagListView.setTags(this.sortTags(HIRuntime.getManager().getTags()));
                    this.tagListView.getList().setSelectedIndex(this.tagListView.getList().getModel().getSize() - 2);
                    if (this.tagListView.getCurrentTag().getType() != GroupTypes.HIGROUP_REGULAR) {
                        this.tagListView.getList().setEnabled(false);
                        this.tagContentsView.prepareElementLoading();
                        this.contentLoader.loadTag(this.tagListView.getCurrentTag());
                    }
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("removeSelection")) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("TagExplorer.52"), Messages.getString("TagExplorer.53"))) {
                return;
            }
            try {
                indices = this.tagContentsView.getContentsList().getSelectedIndices();
                ArrayList<HiQuickInfo> contentsToRemove = new ArrayList<HiQuickInfo>(indices.length);
                int[] nArray = indices;
                int n = indices.length;
                int n3 = 0;
                while (n3 < n) {
                    int index = nArray[n3];
                    contentsToRemove.add(this.tagContentsView.getContents().get(index));
                    ++n3;
                }
                HIRuntime.getGui().startIndicatingServiceActivity();
                for (HiQuickInfo content : contentsToRemove) {
                    HIRuntime.getManager().removeFromGroup(content.getBaseID(), this.tagListView.getCurrentTag().getId());
                    this.tagContentsView.removeContent(content);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.tagListView.getCurrentTag().setTimestamp(new Date().getTime());
                this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, this.tagListView.getCurrentTag(), this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, this.tagListView.getCurrentTag(), this);
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
                return;
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("options")) {
            this.tagContentsView.showDefaultPopupMenu();
        } else if (e.getActionCommand().equalsIgnoreCase("create")) {
            HiGroup newGroup = this.createTag();
            if (newGroup != null) {
                try {
                    this.tagListView.setTags(this.sortTags(HIRuntime.getManager().getTags()));
                    this.tagListView.getList().setSelectedIndex(this.tagListView.getList().getModel().getSize() - 2);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_ADDED, newGroup, this);
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("remove")) {
            if (HIRuntime.getGui().checkEditAbility(false)) {
                if (!HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("TagExplorer.70"), Messages.getString("TagExplorer.71"))) {
                    return;
                }
                this.metadataEditorView.resetChanges();
                boolean groupDeleted = false;
                HiGroup deletedGroup = null;
                try {
                    deletedGroup = this.tagListView.getCurrentTag();
                    HIRuntime.getGui().startIndicatingServiceActivity();
                    groupDeleted = HIRuntime.getManager().deleteTagGroup(deletedGroup);
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                    return;
                }
                if (groupDeleted) {
                    try {
                        this.tagListView.setTags(this.sortTags(HIRuntime.getManager().getTags()));
                        if (this.tagListView.getCurrentTag() == null) {
                            this.tagContentsView.setCurrentTag(null);
                            this.metadataEditorView.setTag(null, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId());
                        }
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_REMOVED, deletedGroup, this);
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this);
                        return;
                    }
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("save") && this.metadataEditorView.hasChanges()) {
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return;
            }
            this.saveMetadataChanges();
        }
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.discardChanges();
        }
        if (e.getActionCommand().equalsIgnoreCase("changeListStyle")) {
            if (this.tagContentsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
                this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
                this.userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.LIST_STYLE;
            } else {
                this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.ICON_STYLE);
                this.userSelectedStyle = GroupContentsList.HI_ListDisplayStyles.ICON_STYLE;
            }
        }
    }

    private void setDisplayStyle(GroupContentsList.HI_ListDisplayStyles style) {
        if (this.tagContentsView.getContentsList().getDisplayStyle() == style) {
            return;
        }
        if (style == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.tagContentsView.getContentsList().setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.ICON_STYLE);
            this.tagContentsView.getListStyleButton().setIcon(this.tagContentsView.listStyleIcon);
            this.tagContentsView.getListStyleButton().setToolTipText(Messages.getString("TagExplorer.77"));
            this.loadContentPreviews();
        } else {
            this.tagContentsView.getContentsList().setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
            this.tagContentsView.getListStyleButton().setIcon(this.tagContentsView.iconStyleIcon);
            this.tagContentsView.getListStyleButton().setToolTipText(Messages.getString("TagExplorer.78"));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.tagContentsView.getContentsList() && e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.tagListView.getCurrentTag().getType() != GroupTypes.HIGROUP_TRASH) {
                HiQuickInfo content = this.tagContentsView.getSelectedElement();
                if (content != null) {
                    if (content.getContentType() == HiBaseTypes.HI_GROUP) {
                        int index = -1;
                        int i = 0;
                        while (i < this.tagListView.getList().getModel().getSize()) {
                            if (((HiGroup)this.tagListView.getList().getModel().getElementAt(i)).getId() == content.getBaseID()) {
                                index = i;
                            }
                            ++i;
                        }
                        if (index >= 0) {
                            this.tagListView.getList().setSelectedIndex(index);
                        } else {
                            HIRuntime.getGui().displayInfoDialog(Messages.getString("TagExplorer.79"), Messages.getString("GroupBrowser.80"));
                        }
                    } else {
                        HIRuntime.getGui().openContentEditor(content, (HIComponent)this);
                    }
                }
            } else {
                HIRuntime.getGui().displayInfoDialog(Messages.getString("TagExplorer.81"), Messages.getString("TagExplorer.82"));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.tagListView.getList() && e.isPopupTrigger() && !e.isConsumed()) {
            e.consume();
            this.tagListView.showPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.tagListView.getList() && e.isPopupTrigger() && !e.isConsumed()) {
            e.consume();
            this.tagListView.showPopupMenu(e.getX(), e.getY());
        }
    }

    public class GroupContentsTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -2476221044117676754L;
        private GroupBrowser browser;
        private boolean wasSortAction = false;

        public GroupContentsTransferHandler(GroupBrowser browser) {
            this.browser = browser;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Vector<HiQuickInfo> elements = new Vector<HiQuickInfo>();
            if (c instanceof GroupContentsList) {
                GroupContentsList list = (GroupContentsList)c;
                Object[] objectArray = list.getSelectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    elements.add((HiQuickInfo)object);
                    ++n2;
                }
            }
            return new QuickInfoTransferable(new ContentTransfer(elements, TagExplorer.this.tagListView.getCurrentTag(), this.browser));
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return;
            }
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.browser);
            }
            if (t.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                try {
                    ContentTransfer transfer = (ContentTransfer)t.getTransferData(QuickInfoTransferable.quickInfoFlavor);
                    if (!this.wasSortAction && action == 2 && transfer.getTarget() instanceof GroupBrowser) {
                        for (HiQuickInfo content : transfer.getContents()) {
                            TagExplorer.this.tagContentsView.removeContent(content);
                        }
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, TagExplorer.this.tagListView.getCurrentTag(), null);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return;
                }
                catch (IOException e) {
                    return;
                }
            }
        }

        private boolean createLink(HiBase base, HiGroup targetGroup, Point location) {
            for (HiQuickInfo content : TagExplorer.this.tagContentsView.getContents()) {
                if (content.getBaseID() != base.getId()) continue;
                return true;
            }
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().copyToGroup(base, targetGroup);
                HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(base.getId());
                int index = TagExplorer.this.tagContentsView.getContentsList().locationToIndex(location);
                if (targetGroup.getId() == TagExplorer.this.tagListView.getCurrentTag().getId()) {
                    TagExplorer.this.tagContentsView.addContent(info, index);
                }
                HIRuntime.getGui().stopIndicatingServiceActivity();
                TagExplorer.this.loadContentPreview(info);
                TagExplorer.this.tagListView.getCurrentTag().setTimestamp(new Date().getTime());
                TagExplorer.this.metadataEditorView.updateContent();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, targetGroup, this.browser);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, targetGroup, this.browser);
                return true;
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this.browser);
                return false;
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.browser);
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (!(supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(GroupTransferable.groupFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor) || supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor))) {
                return false;
            }
            if (supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && TagExplorer.this.tagListView.getCurrentTag().getType() != GroupTypes.HIGROUP_TRASH) {
                supp.setDropAction(1);
                return true;
            }
            if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                supp.setDropAction(0x40000000);
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block17: {
                    transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                    if (transfer != null) break block17;
                    return false;
                }
                try {
                    if (transfer.getSource() instanceof SearchModule) {
                        supp.setDropAction(1);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group.getType() != GroupTypes.HIGROUP_REGULAR) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            HiGroup dropGroup = TagExplorer.this.tagListView.getCurrentTag();
            if (!(supp.getComponent() instanceof GroupContentsList)) {
                dropGroup = TagExplorer.this.tagListView.getTag(TagExplorer.this.tagListView.getList().getDropLocation().getIndex());
            }
            if (dropGroup.getType() == GroupTypes.HIGROUP_IMPORT) {
                return false;
            }
            return supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || dropGroup.getType() != GroupTypes.HIGROUP_TRASH;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            this.wasSortAction = false;
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            HiGroup dropGroup = TagExplorer.this.tagListView.getCurrentTag();
            if (!(supp.getComponent() instanceof GroupContentsList)) {
                dropGroup = TagExplorer.this.tagListView.getTag(TagExplorer.this.tagListView.getList().getDropLocation().getIndex());
            }
            if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                    try {
                        HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                        if (group == null) {
                            return false;
                        }
                        if (group.getId() == dropGroup.getId()) {
                            return false;
                        }
                        return this.createLink(group, dropGroup, supp.getDropLocation().getDropPoint());
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                if (supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                    try {
                        HILayer layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                        if (layer == null) {
                            return false;
                        }
                        return this.createLink(layer.getModel(), dropGroup, supp.getDropLocation().getDropPoint());
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                if (supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                    try {
                        HiObjectContent content = (HiObjectContent)supp.getTransferable().getTransferData(ObjectContentTransferable.objecContentFlavor);
                        if (content == null) {
                            return false;
                        }
                        return this.createLink(content, dropGroup, supp.getDropLocation().getDropPoint());
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            } else {
                try {
                    boolean isSearch = false;
                    ContentTransfer transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                    if (transfer.getSourceGroup() == null || transfer.getSource() instanceof SearchModule) {
                        isSearch = true;
                    }
                    transfer.setTarget(this.browser);
                    int insertIndex = TagExplorer.this.tagContentsView.getContentsList().locationToIndex(supp.getDropLocation().getDropPoint());
                    insertIndex = Math.max(0, insertIndex);
                    insertIndex = Math.min(TagExplorer.this.tagContentsView.getContentsList().getModel().getSize() - 1, insertIndex);
                    if (!isSearch && transfer.getSourceGroup().getId() == dropGroup.getId() && !(supp.getComponent() instanceof GroupContentsList)) {
                        return false;
                    }
                    if (!isSearch && transfer.getSourceGroup().getId() == dropGroup.getId() && supp.getComponent() instanceof GroupContentsList) {
                        if (transfer.getSource() != this.browser) {
                            return false;
                        }
                        supp.setDropAction(2);
                        this.wasSortAction = true;
                        DefaultListModel model = (DefaultListModel)TagExplorer.this.tagContentsView.getContentsList().getModel();
                        if (model.getSize() == 0) {
                            return false;
                        }
                        HiQuickInfo reference = new HiQuickInfo();
                        reference.setBaseID(-1L);
                        reference.setTitle("Dummy");
                        model.add(insertIndex, reference);
                        TagExplorer.this.tagContentsView.getContents().add(insertIndex, reference);
                        for (HiQuickInfo transferContent : transfer.getContents()) {
                            int contentIndex = -1;
                            int i = 0;
                            while (i < model.size()) {
                                if (((HiQuickInfo)model.get(i)).getBaseID() == transferContent.getBaseID()) {
                                    contentIndex = i;
                                }
                                ++i;
                            }
                            if (contentIndex < 0) {
                                model.removeElement(reference);
                                TagExplorer.this.tagContentsView.getContents().remove(reference);
                                return false;
                            }
                            model.remove(contentIndex);
                            TagExplorer.this.tagContentsView.getContents().remove(contentIndex);
                        }
                        insertIndex = model.indexOf(reference);
                        int i = transfer.getContents().size() - 1;
                        while (i >= 0) {
                            model.add(insertIndex, transfer.getContents().get(i));
                            TagExplorer.this.tagContentsView.getContents().add(insertIndex, transfer.getContents().get(i));
                            --i;
                        }
                        model.removeElement(reference);
                        TagExplorer.this.tagContentsView.getContents().remove(reference);
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUPCONTENTS_SORTORDER_CHANGED, TagExplorer.this.tagListView.getCurrentTag(), this.browser);
                        return true;
                    }
                    if (isSearch) {
                        supp.setDropAction(1);
                    } else if (transfer.getSourceGroup().getType() != GroupTypes.HIGROUP_REGULAR) {
                        supp.setDropAction(2);
                    }
                    boolean moveToTrash = false;
                    if (dropGroup.getType() == GroupTypes.HIGROUP_TRASH) {
                        moveToTrash = true;
                    }
                    if (moveToTrash && !HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("GroupBrowser.11"), String.valueOf(Messages.getString("GroupBrowser.12")) + "\n\n" + Messages.getString("GroupBrowser.14"))) {
                        return false;
                    }
                    boolean groupsOrLayersInSelection = false;
                    try {
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        int i = transfer.getContents().size() - 1;
                        while (i >= 0) {
                            boolean isInGroup = false;
                            if (dropGroup.getId() == TagExplorer.this.tagListView.getCurrentTag().getId()) {
                                for (HiQuickInfo content : TagExplorer.this.tagContentsView.getContents()) {
                                    if (content.getBaseID() != transfer.getContents().get(i).getBaseID()) continue;
                                    isInGroup = true;
                                }
                            }
                            boolean moveOrCopySuccessful = false;
                            if (!moveToTrash) {
                                if (supp.getDropAction() == 2) {
                                    moveOrCopySuccessful = HIRuntime.getManager().moveToGroup(transfer.getContents().get(i).getBaseID(), transfer.getSourceGroup().getId(), dropGroup.getId());
                                } else if (!isInGroup) {
                                    moveOrCopySuccessful = HIRuntime.getManager().copyToGroup(transfer.getContents().get(i).getBaseID(), dropGroup.getId());
                                }
                            } else if (transfer.getContents().get(i).getContentType() != HiBaseTypes.HI_GROUP && transfer.getContents().get(i).getContentType() != HiBaseTypes.HI_LAYER) {
                                moveOrCopySuccessful = HIRuntime.getManager().moveToTrash(transfer.getContents().get(i).getBaseID());
                                if (moveOrCopySuccessful) {
                                    HIRuntime.getGui().notifyItemSentToTrash(transfer.getContents().get(i).getBaseID());
                                }
                            } else {
                                groupsOrLayersInSelection = true;
                            }
                            if (!isInGroup && moveOrCopySuccessful && dropGroup.getId() == TagExplorer.this.tagListView.getCurrentTag().getId()) {
                                HiQuickInfo info = HIRuntime.getManager().getBaseQuickInfo(transfer.getContents().get(i).getBaseID());
                                TagExplorer.this.loadContentPreview(info);
                                if (moveOrCopySuccessful) {
                                    TagExplorer.this.tagContentsView.addContent(info, insertIndex);
                                }
                            }
                            --i;
                        }
                        HIRuntime.getGui().stopIndicatingServiceActivity();
                        if (moveToTrash && groupsOrLayersInSelection) {
                            HIRuntime.getGui().displayInfoDialog(Messages.getString("GroupBrowser.15"), Messages.getString("GroupBrowser.16"));
                        }
                        TagExplorer.this.tagListView.getCurrentTag().setTimestamp(new Date().getTime());
                        TagExplorer.this.metadataEditorView.updateContent();
                        HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.ENTITY_CHANGED, dropGroup, null);
                        if (dropGroup.getId() != TagExplorer.this.tagListView.getCurrentTag().getId()) {
                            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.GROUP_CONTENTS_CHANGED, dropGroup, null);
                        }
                        if (moveToTrash) {
                            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.CONTENT_MOVED_TO_TRASH, null, null);
                        }
                    }
                    catch (HIWebServiceException wse) {
                        HIRuntime.getGui().reportError(wse, this.browser);
                        return false;
                    }
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    }

    class HIGroupContentLoader
    implements Runnable {
        private Thread thread = new Thread(this);
        private HiGroup tag;

        public void loadTag(HiGroup tag) {
            this.tag = tag;
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            } else if (this.thread.getState() == Thread.State.TERMINATED) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                while (this.thread.getState() == Thread.State.RUNNABLE) {
                }
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        @Override
        public void run() {
            List<HiQuickInfo> infoList;
            try {
                infoList = this.tag != null ? HIRuntime.getManager().getGroupContents(this.tag) : null;
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, TagExplorer.this.browser);
                TagExplorer.this.tagContentsView.setContents(null);
                TagExplorer.this.tagListView.getList().setEnabled(true);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (infoList != null) {
                        if (infoList.size() >= 100) {
                            TagExplorer.this.setDisplayStyle(GroupContentsList.HI_ListDisplayStyles.LIST_STYLE);
                        } else {
                            TagExplorer.this.setDisplayStyle(TagExplorer.this.userSelectedStyle);
                        }
                        TagExplorer.this.tagContentsView.setContents(infoList);
                    }
                    TagExplorer.this.tagListView.getList().setEnabled(true);
                    if (TagExplorer.this.tagContentsView.getContentsList().getDisplayStyle() == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
                        TagExplorer.this.loadContentPreviews();
                    }
                }
            });
        }
    }

    public class TagTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5952319035170447213L;
        private TagExplorer browser;

        public TagTransferHandler(TagExplorer browser) {
            this.browser = browser;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HiGroup tag = (HiGroup)((JList)c).getSelectedValue();
            return new GroupTransferable(tag);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.browser);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.browser);
            if (!HIRuntime.getGui().checkEditAbility(true)) {
                return false;
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                TagExplorer.this.tagListView.getList().setDropMode(DropMode.ON_OR_INSERT);
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    return group.getType() == GroupTypes.HIGROUP_TAG;
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                TagExplorer.this.tagListView.getList().setDropMode(DropMode.ON);
                if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                    supp.setDropAction(0x40000000);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRuntime.getGui().checkEditAbility(false)) {
                return false;
            }
            if (!supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                supp.setDropAction(0x40000000);
            }
            return TagExplorer.this.tagContentsHandler.importData(supp);
        }
    }
}

