/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dialogs.EditTagDialog;
import org.hyperimage.client.gui.views.TagManagerView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;

public class TagManager
extends HIComponent
implements ActionListener {
    private TagManagerView tagManagerView;
    private List<HiGroup> tags;
    private EditTagDialog editTagDialog;

    public TagManager() {
        super(Messages.getString("TagManager.title"), Messages.getString("TagManager.menuTitle"));
        this.loadTags();
        this.sortTags();
        this.editTagDialog = new EditTagDialog(HIRuntime.getGui());
        this.tagManagerView = new TagManagerView(this.tags);
        this.views.add(this.tagManagerView);
        this.tagManagerView.getAddButton().addActionListener(this);
        this.tagManagerView.getRemoveButton().addActionListener(this);
        this.tagManagerView.getEditButton().addActionListener(this);
    }

    private void sortTags() {
        if (this.tags == null) {
            return;
        }
        Collections.sort(this.tags, new Comparator<HiGroup>(){

            @Override
            public int compare(HiGroup tagOne, HiGroup tagTwo) {
                String titleOne = "";
                String titleTwo = "";
                HiFlexMetadataRecord record = MetadataHelper.getDefaultMetadataRecord((HiBase)tagOne, HIRuntime.getManager().getProject().getDefaultLanguage());
                titleOne = record != null ? MetadataHelper.findValue("HIBase", "title", record) : "Tag (" + tagOne.getUUID().split("-")[4] + ")";
                record = MetadataHelper.getDefaultMetadataRecord((HiBase)tagTwo, HIRuntime.getManager().getProject().getDefaultLanguage());
                titleTwo = record != null ? MetadataHelper.findValue("HIBase", "title", record) : "Tag (" + tagTwo.getUUID().split("-")[4] + ")";
                return titleOne.compareTo(titleTwo);
            }
        });
    }

    private void loadTags() {
        HIRuntime.getGui().startIndicatingServiceActivity();
        try {
            this.tags = HIRuntime.getManager().getTags();
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
        }
    }

    private void updateSelectedTag(HiGroup tag) {
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            HIRuntime.getManager().updateFlexMetadataRecords(tag.getMetadata());
            this.tagManagerView.updateList();
            HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TAG_ADDED, tag, this);
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean removeTag;
        if (e.getActionCommand().compareTo("addTag") == 0) {
            HiGroup newTag = null;
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                newTag = HIRuntime.getManager().createTagGroup();
                for (HiFlexMetadataRecord record : newTag.getMetadata()) {
                    MetadataHelper.setValue("HIBase", "title", "Tag (" + newTag.getUUID().split("-")[4] + ")", record);
                }
                HIRuntime.getManager().updateFlexMetadataRecords(newTag.getMetadata());
                this.tagManagerView.updateList();
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TAG_ADDED, newTag, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
            if (newTag != null) {
                this.editTagDialog.setTag(newTag);
                this.editTagDialog.setVisible(true);
                if (this.editTagDialog.saveSelected()) {
                    this.updateSelectedTag(newTag);
                }
                this.tagManagerView.updateList();
            }
        }
        if (e.getActionCommand().compareTo("editTag") == 0) {
            this.editTagDialog.setTag(this.tagManagerView.getSelectedTag());
            this.editTagDialog.setVisible(true);
            if (this.editTagDialog.saveSelected()) {
                this.updateSelectedTag(this.tagManagerView.getSelectedTag());
            }
        }
        if (e.getActionCommand().compareTo("removeTag") == 0 && (removeTag = HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("TagManagerView.deleteTag"), String.valueOf(Messages.getString("TagManagerView.warning")) + ": " + Messages.getString("TagManagerView.removeNote") + "\n\n" + Messages.getString("TagManagerView.continueNote")))) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HiGroup tag = this.tagManagerView.getSelectedTag();
                boolean success = HIRuntime.getManager().deleteTagGroup(tag);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TAG_REMOVED, tag, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
                this.tagManagerView.updateList();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
    }
}

