/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.components;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.dialogs.AddTemplateDialog;
import org.hyperimage.client.gui.dialogs.AddTemplateFieldDialog;
import org.hyperimage.client.gui.dialogs.EditTemplateDialog;
import org.hyperimage.client.gui.dialogs.EditTemplateFieldDialog;
import org.hyperimage.client.gui.dnd.TemplateFieldTransferable;
import org.hyperimage.client.gui.dnd.TemplateTransferable;
import org.hyperimage.client.gui.views.TemplateFieldsView;
import org.hyperimage.client.gui.views.TemplateSetView;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiPreference;

public class TemplateEditor
extends HIComponent
implements ListSelectionListener,
ActionListener {
    private TemplateSetView templateSetView = new TemplateSetView(HIRuntime.getManager().getProject().getTemplates());
    private TemplateFieldsView templateFieldsView = new TemplateFieldsView(this.templateSetView.getSelectedTemplate());
    private AddTemplateDialog addTemplateDialog = new AddTemplateDialog(HIRuntime.getGui());
    private EditTemplateDialog editTemplateDialog = new EditTemplateDialog(HIRuntime.getGui());
    private AddTemplateFieldDialog addTemplateFieldDialog = new AddTemplateFieldDialog(HIRuntime.getGui());
    private EditTemplateFieldDialog editTemplateFieldDialog = new EditTemplateFieldDialog(HIRuntime.getGui());

    public TemplateEditor() {
        super(Messages.getString("TemplateEditor.PROJEKT_TEMPLATES"), Messages.getString("TemplateEditor.TEMPLATEEDITOR"));
        this.views.add(this.templateSetView);
        this.views.add(this.templateFieldsView);
        this.templateSetView.getTemplateList().setTransferHandler(new TemplateTransferHandler(this));
        this.templateFieldsView.getFieldsList().setTransferHandler(new TemplateFieldTransferHandler(this));
        this.templateSetView.getTemplateList().addListSelectionListener(this);
        this.templateSetView.getAddButton().addActionListener(this);
        this.templateSetView.getRemoveButton().addActionListener(this);
        this.templateSetView.getEditButton().addActionListener(this);
        this.templateFieldsView.getAddButton().addActionListener(this);
        this.templateFieldsView.getRemoveButton().addActionListener(this);
        this.templateFieldsView.getEditButton().addActionListener(this);
        this.updateLanguage();
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.addTemplateDialog.updateLanguage();
        this.addTemplateFieldDialog.updateLanguage();
        this.editTemplateDialog.updateLanguage();
        this.editTemplateFieldDialog.updateLanguage();
        this.setTitle(Messages.getString("TemplateEditor.PROJEKT_TEMPLATES"));
        this.getWindowMenuItem().setText(this.getTitle());
        HIRuntime.getGui().updateComponentTitle(this);
    }

    private boolean updateTemplateSortOrder() {
        if (!HIRuntime.getGui().checkAdminAbility(true)) {
            return false;
        }
        String sortOrder = "";
        int i = 0;
        while (i < this.templateSetView.getTemplateList().getModel().getSize()) {
            HiFlexMetadataTemplate template = (HiFlexMetadataTemplate)this.templateSetView.getTemplateList().getModel().getElementAt(i);
            sortOrder = String.valueOf(sortOrder) + "," + template.getId();
            ++i;
        }
        if (sortOrder.length() > 0) {
            sortOrder = sortOrder.substring(1);
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            HiPreference tempSortOrderPref = MetadataHelper.findPreference(HIRuntime.getManager().getProject(), "templateSortOrder");
            tempSortOrderPref.setValue(sortOrder);
            HIRuntime.getManager().updatePreference(tempSortOrderPref);
            HIRuntime.getGui().stopIndicatingServiceActivity();
            return true;
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return false;
        }
    }

    private boolean updateFieldSortOrder() {
        if (!HIRuntime.getGui().checkAdminAbility(true)) {
            return false;
        }
        String sortOrder = "";
        int i = 0;
        while (i < this.templateFieldsView.getFieldsList().getModel().getSize()) {
            HiFlexMetadataSet set = (HiFlexMetadataSet)this.templateFieldsView.getFieldsList().getModel().getElementAt(i);
            sortOrder = String.valueOf(sortOrder) + "," + set.getId();
            ++i;
        }
        if (sortOrder.length() > 0) {
            sortOrder = sortOrder.substring(1);
        }
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            HIRuntime.getManager().updateTemplateSortOrder(this.templateSetView.getSelectedTemplate(), sortOrder);
            HIRuntime.getGui().stopIndicatingServiceActivity();
            return true;
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, this);
            return false;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.templateSetView.getSelectedTemplate() != null) {
            this.templateFieldsView.setTemplate(this.templateSetView.getSelectedTemplate());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean removeField;
        boolean removeTemplate;
        if (e.getActionCommand().compareTo("addTemplate") == 0 && this.addTemplateDialog.showAddTemplateFieldDialog(HIRuntime.getManager().getProject().getTemplates())) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                if (this.addTemplateDialog.getTemplateChoice().compareTo("dc") == 0) {
                    HIRuntime.getManager().addTemplateToProject(MetadataHelper.getDCTemplateBlueprint());
                }
                if (this.addTemplateDialog.getTemplateChoice().compareTo("dcRichText") == 0) {
                    HiFlexMetadataTemplate dcTemp = MetadataHelper.getDCTemplateBlueprint();
                    for (HiFlexMetadataSet set : dcTemp.getEntries()) {
                        set.setRichText(true);
                    }
                    HIRuntime.getManager().addTemplateToProject(dcTemp);
                }
                if (this.addTemplateDialog.getTemplateChoice().compareTo("cdwa") == 0) {
                    HIRuntime.getManager().addTemplateToProject(MetadataHelper.getCDWALiteTemplateBlueprint());
                }
                if (this.addTemplateDialog.getTemplateChoice().compareTo("cdwaRichText") == 0) {
                    HiFlexMetadataTemplate cdwaTemp = MetadataHelper.getCDWALiteTemplateBlueprint();
                    for (HiFlexMetadataSet set : cdwaTemp.getEntries()) {
                        set.setRichText(true);
                    }
                    HIRuntime.getManager().addTemplateToProject(cdwaTemp);
                }
                if (this.addTemplateDialog.getTemplateChoice().compareTo("vra4RichText") == 0) {
                    HiFlexMetadataTemplate vra4Template = MetadataHelper.getVRACore4TemplateBlueprint();
                    for (HiFlexMetadataSet set : vra4Template.getEntries()) {
                        set.setRichText(true);
                    }
                    HIRuntime.getManager().addTemplateToProject(vra4Template);
                }
                if (this.addTemplateDialog.getTemplateChoice().compareTo("vra4hdlbgRichText") == 0) {
                    HiFlexMetadataTemplate vra4hdlbgTemplate = MetadataHelper.getVRACore4HdlbgExtTemplateBlueprint();
                    for (HiFlexMetadataSet set : vra4hdlbgTemplate.getEntries()) {
                        set.setRichText(true);
                    }
                    HIRuntime.getManager().addTemplateToProject(vra4hdlbgTemplate);
                }
                if (this.addTemplateDialog.getTemplateChoice().compareTo("custom") == 0) {
                    HIRuntime.getManager().addTemplateToProject(MetadataHelper.getCustomTemplateBlueprint());
                }
                this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
        if (e.getActionCommand().compareTo("editTemplate") == 0 && this.templateSetView.getSelectedTemplate() != null && this.templateSetView.getSelectedTemplate().getNamespacePrefix().equalsIgnoreCase("custom") && this.editTemplateDialog.showEditTemplateDialog(this.templateSetView.getSelectedTemplate()) && (this.editTemplateDialog.getChangedURI().compareTo(this.templateSetView.getSelectedTemplate().getNamespaceURI()) != 0 || this.editTemplateDialog.getChangedURL().compareTo(this.templateSetView.getSelectedTemplate().getNamespaceURL()) != 0)) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().updateTemplate(this.templateSetView.getSelectedTemplate(), this.editTemplateDialog.getChangedURI(), this.editTemplateDialog.getChangedURL());
                this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
        if (e.getActionCommand().compareTo("removeTemplate") == 0 && this.templateSetView.getSelectedTemplate() != null && this.templateSetView.getSelectedTemplate().getNamespacePrefix().compareTo("HIInternal") != 0 && (removeTemplate = HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("TemplateEditor.TEMPLATE_LOESCHEN"), String.valueOf(Messages.getString("TemplateEditor.ACHTUNG")) + ": " + Messages.getString("TemplateEditor.TEMPLATE_NOTE") + "\n" + Messages.getString("TemplateEditor.TEMPLATE_NOTE_INFO") + "\n\n" + Messages.getString("TemplateEditor.CONTINUE_NOTE")))) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().removeTemplateFromProject(this.templateSetView.getSelectedTemplate());
                this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
        if (e.getActionCommand().compareTo("addField") == 0 && this.templateSetView.getSelectedTemplate() != null && this.templateSetView.getSelectedTemplate().getNamespacePrefix().equalsIgnoreCase("custom") && this.addTemplateFieldDialog.showAddTemplateFieldDialog(this.templateSetView.getSelectedTemplate())) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().addSetToTemplate(this.templateSetView.getSelectedTemplate(), this.addTemplateFieldDialog.getTagName(), this.addTemplateFieldDialog.isRichText());
                this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
        if (e.getActionCommand().compareTo("removeField") == 0 && this.templateFieldsView.getSelectedSet() != null && this.templateSetView.getSelectedTemplate().getNamespacePrefix().equalsIgnoreCase("custom") && (removeField = HIRuntime.getGui().displayUserYesNoDialog(Messages.getString("TemplateEditor.METADATENFELD_LOESCHEN"), String.valueOf(Messages.getString("TemplateEditor.ACHTUNG")) + ": " + Messages.getString("TemplateEditor.REMOVE_NOTE") + "\n" + Messages.getString("TemplateEditor.REMOVE_NOTE_INFO") + "\n\n" + Messages.getString("TemplateEditor.REMOVE_CONTINUE")))) {
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().removeSetFromTemplate(this.templateSetView.getSelectedTemplate(), this.templateFieldsView.getSelectedSet());
                this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                HIRuntime.getGui().stopIndicatingServiceActivity();
            }
            catch (HIWebServiceException wse) {
                HIRuntime.getGui().reportError(wse, this);
            }
        }
        if (e.getActionCommand().compareTo("editField") == 0 && this.templateFieldsView.getSelectedSet() != null) {
            this.editTemplateFieldDialog.showEditFieldDialog(this.templateFieldsView.getSelectedSet(), this.templateFieldsView.getSelectedScreenLanguage());
            String displayName = MetadataHelper.getTemplateKeyDisplayName(null, this.templateFieldsView.getSelectedSet(), MetadataHelper.localeToLangID(this.templateFieldsView.getSelectedScreenLanguage()));
            if (displayName == null || displayName.length() == 0) {
                displayName = "";
            }
            if (this.editTemplateFieldDialog.getChangedDisplayName().compareTo(displayName) != 0) {
                try {
                    if (!MetadataHelper.setHasDisplayNameEntry(this.templateFieldsView.getSelectedSet(), MetadataHelper.localeToLangID(this.templateFieldsView.getSelectedScreenLanguage()))) {
                        HIRuntime.getManager().createSetDisplayName(this.templateFieldsView.getSelectedSet(), MetadataHelper.localeToLangID(this.templateFieldsView.getSelectedScreenLanguage()), this.editTemplateFieldDialog.getChangedDisplayName());
                    } else {
                        HIRuntime.getGui().startIndicatingServiceActivity();
                        HIRuntime.getManager().updateSetDisplayName(this.templateFieldsView.getSelectedSet(), MetadataHelper.localeToLangID(this.templateFieldsView.getSelectedScreenLanguage()), this.editTemplateFieldDialog.getChangedDisplayName());
                    }
                    this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this);
                    HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this);
                    HIRuntime.getGui().stopIndicatingServiceActivity();
                }
                catch (HIWebServiceException wse) {
                    HIRuntime.getGui().reportError(wse, this);
                }
            }
        }
    }

    public class TemplateFieldTransferHandler
    extends TransferHandler {
        private TemplateEditor editor;

        public TemplateFieldTransferHandler(TemplateEditor editor) {
            this.editor = editor;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HiFlexMetadataSet set = (HiFlexMetadataSet)((JList)c).getSelectedValue();
            return new TemplateFieldTransferable(set);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.editor);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.editor);
            if (!supp.isDataFlavorSupported(TemplateFieldTransferable.fieldFlavor)) {
                return false;
            }
            if (!HIRuntime.getGui().checkAdminAbility(true)) {
                return false;
            }
            try {
                HiFlexMetadataSet set = (HiFlexMetadataSet)supp.getTransferable().getTransferData(TemplateFieldTransferable.fieldFlavor);
                supp.setDropAction(2);
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            int listIndex;
            int index;
            block10: {
                HiFlexMetadataSet set;
                block9: {
                    if (!this.canImport(supp)) {
                        return false;
                    }
                    if (!HIRuntime.getGui().checkAdminAbility(false)) {
                        return false;
                    }
                    Transferable t = supp.getTransferable();
                    set = null;
                    set = (HiFlexMetadataSet)t.getTransferData(TemplateFieldTransferable.fieldFlavor);
                    if (set != null) break block9;
                    return false;
                }
                index = TemplateEditor.this.templateFieldsView.getFieldsList().locationToIndex(supp.getDropLocation().getDropPoint());
                index = Math.max(0, index);
                index = Math.min(TemplateEditor.this.templateFieldsView.getFieldsList().getModel().getSize() - 1, index);
                listIndex = -1;
                int i = 0;
                while (i < TemplateEditor.this.templateFieldsView.getFieldsList().getModel().getSize()) {
                    if (((HiFlexMetadataSet)TemplateEditor.this.templateFieldsView.getFieldsList().getModel().getElementAt(i)).getId() == set.getId()) {
                        listIndex = i;
                    }
                    ++i;
                }
                if (listIndex >= 0) break block10;
                return false;
            }
            try {
                HiFlexMetadataSet listSet = (HiFlexMetadataSet)TemplateEditor.this.templateFieldsView.getFieldsList().getModel().getElementAt(listIndex);
                DefaultListModel model = (DefaultListModel)TemplateEditor.this.templateFieldsView.getFieldsList().getModel();
                model.remove(listIndex);
                model.add(index, listSet);
                TemplateEditor.this.templateFieldsView.getFieldsList().setSelectedIndex(index);
                boolean success = TemplateEditor.this.updateFieldSortOrder();
                TemplateEditor.this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this.editor);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this.editor);
                HIRuntime.getGui().stopIndicatingServiceActivity();
                return success;
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public class TemplateTransferHandler
    extends TransferHandler {
        private TemplateEditor editor;

        public TemplateTransferHandler(TemplateEditor editor) {
            this.editor = editor;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            HiFlexMetadataTemplate template = (HiFlexMetadataTemplate)((JList)c).getSelectedValue();
            return new TemplateTransferable(template);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0) {
                HIRuntime.getGui().focusComponent(this.editor);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            HIRuntime.getGui().focusComponent(this.editor);
            if (!supp.isDataFlavorSupported(TemplateTransferable.templateFlavor)) {
                return false;
            }
            if (!HIRuntime.getGui().checkAdminAbility(true)) {
                return false;
            }
            try {
                HiFlexMetadataTemplate template = (HiFlexMetadataTemplate)supp.getTransferable().getTransferData(TemplateTransferable.templateFlavor);
                supp.setDropAction(2);
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            int listIndex;
            int index;
            block10: {
                HiFlexMetadataTemplate template;
                block9: {
                    if (!this.canImport(supp)) {
                        return false;
                    }
                    if (!HIRuntime.getGui().checkAdminAbility(false)) {
                        return false;
                    }
                    Transferable t = supp.getTransferable();
                    template = null;
                    template = (HiFlexMetadataTemplate)t.getTransferData(TemplateTransferable.templateFlavor);
                    if (template != null) break block9;
                    return false;
                }
                index = TemplateEditor.this.templateSetView.getTemplateList().locationToIndex(supp.getDropLocation().getDropPoint());
                index = Math.max(0, index);
                index = Math.min(TemplateEditor.this.templateSetView.getTemplateList().getModel().getSize() - 1, index);
                listIndex = -1;
                int i = 0;
                while (i < TemplateEditor.this.templateSetView.getTemplateList().getModel().getSize()) {
                    if (((HiFlexMetadataTemplate)TemplateEditor.this.templateSetView.getTemplateList().getModel().getElementAt(i)).getId() == template.getId()) {
                        listIndex = i;
                    }
                    ++i;
                }
                if (listIndex >= 0) break block10;
                return false;
            }
            try {
                HiFlexMetadataTemplate listTemplate = (HiFlexMetadataTemplate)TemplateEditor.this.templateSetView.getTemplateList().getModel().getElementAt(listIndex);
                DefaultListModel model = (DefaultListModel)TemplateEditor.this.templateSetView.getTemplateList().getModel();
                model.removeElementAt(listIndex);
                model.add(index, listTemplate);
                TemplateEditor.this.templateSetView.getTemplateList().setSelectedIndex(index);
                boolean success = TemplateEditor.this.updateTemplateSortOrder();
                TemplateEditor.this.templateSetView.setTemplates(HIRuntime.getManager().getProject().getTemplates());
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.TEMPLATE_CHANGED, null, this.editor);
                HIRuntime.getGui().sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, this.editor);
                HIRuntime.getGui().stopIndicatingServiceActivity();
                return success;
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

