/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.HIWebServiceManagerInterface;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.AccountSettings;
import org.hyperimage.client.components.GenericMetadataEditor;
import org.hyperimage.client.components.GroupBrowser;
import org.hyperimage.client.components.HIComponent;
import org.hyperimage.client.components.HIComponentFrame;
import org.hyperimage.client.components.LayerEditor;
import org.hyperimage.client.components.LightTableEditor;
import org.hyperimage.client.components.ObjectEditor;
import org.hyperimage.client.components.PreferenceManager;
import org.hyperimage.client.components.ProjectSettings;
import org.hyperimage.client.components.ProjectUsersManager;
import org.hyperimage.client.components.SearchModule;
import org.hyperimage.client.components.TagExplorer;
import org.hyperimage.client.components.TagManager;
import org.hyperimage.client.components.TemplateEditor;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.ProgressInfoGlassPane;
import org.hyperimage.client.gui.dialogs.AboutDialog;
import org.hyperimage.client.gui.dialogs.ExportProjectDialog;
import org.hyperimage.client.gui.dialogs.LoginDialog;
import org.hyperimage.client.gui.dialogs.ProjectChooser;
import org.hyperimage.client.gui.dialogs.XMLImportProjectDialog;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HIMaintenanceModeException_Exception;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiBaseTypes;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiImageSizes;
import org.hyperimage.client.ws.HiLightTable;
import org.hyperimage.client.ws.HiObject;
import org.hyperimage.client.ws.HiProject;
import org.hyperimage.client.ws.HiQuickInfo;
import org.hyperimage.client.ws.HiRoles;
import org.hyperimage.client.ws.HiText;
import org.hyperimage.client.ws.HiView;
import org.hyperimage.client.ws.Hiurl;
import org.hyperimage.client.xmlimportexport.PeTAL2Importer;
import org.hyperimage.client.xmlimportexport.PeTAL3Exporter;
import org.hyperimage.client.xmlimportexport.PeTAL3Importer;
import org.hyperimage.client.xmlimportexport.PeTALExporter;
import org.hyperimage.client.xmlimportexport.VRACore4HeidelbergImporter;
import org.hyperimage.client.xmlimportexport.XMLImporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HIClientGUI
extends JFrame
implements WindowListener,
ActionListener,
InternalFrameListener,
HierarchyListener,
ComponentListener {
    private static final long serialVersionUID = -4501582186237572342L;
    private static final String APPNAME = "Yenda - Legacy HyperImage Editor";
    private HIWebServiceManagerInterface manager;
    HiProject project;
    private JMenu debugMenu;
    private HIComponentFrame frontFrame;
    private ProjectChooser projectChooser;
    private LoginDialog loginDialog;
    private ExportProjectDialog exportDialog;
    private XMLImportProjectDialog xmlImportDialog;
    private HIWebServiceException lastWSError;
    Vector<HIComponentFrame> components;
    private boolean serviceActivity;
    private boolean displayingError;
    Cursor waitCursor;
    public JDesktopPane mdiPane;
    public ProgressInfoGlassPane infoGlassPane;
    private JMenuItem aboutMenuItem;
    private JMenuItem administrateProjectPrefsMenuItem;
    private JMenuItem administrateProjectUsersMenuItem;
    private JMenuItem changeProjectMenuItem;
    private JMenuItem showLivePreviewMenuItem;
    private JMenuItem changeUserMenuItem;
    private JMenuItem contentMenuItem;
    private JMenuItem editUserMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuItem exportMenuItem;
    private JMenuItem publicationMenuItem;
    private JMenuItem xmlImportMenuItem;
    private JMenu guiLanguageMenu;
    private JMenuBar guiMenuBar;
    private JMenu helpMenu;
    private JMenuItem feedbackItem;
    private JMenuItem newGroupBrowserMenuItem;
    private JMenuItem searchMenuItem;
    private JMenuItem tagManagerMenuItem;
    private JMenuItem tagExplorerMenuItem;
    private JMenuItem importMenuItem;
    private JMenuItem nextWindowItem;
    private JMenuItem prevWindowItem;
    private JMenu projectMenu;
    private JMenuItem projectSettingsMenuItem;
    private JMenuItem projectTemplatesMenuItem;
    private JMenuItem toggleMetadataViewMenuItem;
    private JMenu toolsMenu;
    private JMenuItem visitWebsiteMenuItem;
    private JMenu windowMenu;
    private JSeparator windowSeparator1;
    private JSeparator windowSeparator2;
    private JMenu popupToolsMenu;
    private JMenuItem popupNewGroupBrowserMenuItem;
    private JMenuItem popupSearchMenuItem;
    private JMenuItem popupTagManagerMenuItem;

    public HIClientGUI() {
        block5: {
            this.frontFrame = null;
            this.lastWSError = null;
            this.serviceActivity = false;
            this.displayingError = false;
            this.mdiPane = new JDesktopPane();
            this.infoGlassPane = new ProgressInfoGlassPane();
            this.manager = HIRuntime.getManager();
            HIRuntime.setGui(this);
            this.components = new Vector();
            this.mdiPane.setBackground(new Color(65, 105, 170));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this);
            try {
                String reqClientVersion = this.manager.getClientVersionID();
                String mainURL = HIRuntime.getManager().getServerURL().substring(0, HIRuntime.getManager().getServerURL().length() - 11);
                System.out.println("Required Client Version: " + reqClientVersion);
                if (HIRuntime.getClientVersion().compareTo(reqClientVersion) >= 0) break block5;
                JOptionPane.showMessageDialog(this, "<html><b>Eine neue Version des Legacy Clients (" + reqClientVersion + ") ist verf\u00fcgbar</b>.<br><br>Bitte laden Sie die neue Version herunter, um fortzufahren:<br><a href=\"" + mainURL + "\">" + mainURL + "</a>", "Neue Client Version " + reqClientVersion, 1);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(mainURL));
                    }
                    catch (IOException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                System.exit(1);
            }
            catch (HIWebServiceException wse) {
                this.reportError(wse, null);
                System.exit(1);
            }
        }
    }

    public LoginDialog getLoginDialog() {
        return this.loginDialog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleLogin() {
        HIRuntime.getManager().logout();
        try {
            if (HIRuntime.OAUTHMode) {
                boolean success = HIRuntime.getManager().loginPR(System.getProperty("jnlp.user"), System.getProperty("jnlp.oauth_token"), System.getProperty("jnlp.oauth_token_secret"), System.getProperty("jnlp.oauth_verifier"));
                if (success) return success;
                HIRuntime.displayFatalErrorAndExit("ERROR: Could not authenticate user using suplied OAUTH / Prometheus credentials!");
                return success;
            }
            this.setTitle("Yenda - Legacy HyperImage Editor " + HIRuntime.getClientVersion());
            this.loginDialog.setInfoLabel(Messages.getString("HIClientGUI.0"), Color.blue);
            boolean loginSelected = this.loginDialog.promptLogin(this.loginDialog.getUserName());
            if (!loginSelected) {
                return false;
            }
            do {
                if (HIRuntime.getManager().login(this.loginDialog.getUserName(), this.loginDialog.getPassword())) {
                    return true;
                }
                this.loginDialog.setInfoLabel(Messages.getString("HIClientGUI.1"), Color.red);
            } while (loginSelected = this.loginDialog.promptLogin(this.loginDialog.getUserName()));
            return false;
        }
        catch (HIWebServiceException e) {
            System.out.println("SERVER SIDE SERVICE EXCEPTION:");
            e.printStackTrace();
            if (e.getCause() instanceof HIMaintenanceModeException_Exception) {
                this.displayMaintenanceDialog(e);
                return this.handleLogin();
            }
            HIRuntime.displayFatalErrorAndExit("WebService Initialization Failed!\n\nReason:" + e.getMessage() + "\n\n" + e.getClass());
            return false;
        }
    }

    public void tryLogoutAndExit() {
        if (this.deregisterAllComponents()) {
            System.out.print("Logout: ");
            System.out.println(HIRuntime.getManager().logout());
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    public void chooseProject() {
        this.setTitle("Yenda - Legacy HyperImage Editor " + HIRuntime.getClientVersion());
        List<HiProject> projects = null;
        try {
            this.startIndicatingServiceActivity();
            projects = HIRuntime.getManager().getProjects();
            this.stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException e) {
            HIRuntime.displayFatalErrorAndExit("Could not get user projects!");
        }
        if (projects.size() == 0) {
            HIRuntime.displayFatalErrorAndExit("User does not belong to any projects!");
        }
        this.project = this.projectChooser.selectProject(projects);
        if (this.project == null) {
            if (HIRuntime.getManager().getProject() == null) {
                this.tryLogoutAndExit();
                System.exit(1);
            } else {
                this.setMenuState();
                return;
            }
        }
        try {
            this.startIndicatingServiceActivity(true);
            System.out.println("Setting Project ID: " + this.project.getId());
            this.manager.setProject(this.project);
            this.stopIndicatingServiceActivity();
            this.updateProjectTitle();
            this.setMenuState();
        }
        catch (HIWebServiceException wse) {
            this.reportError(wse, null);
            return;
        }
    }

    public void updateProjectTitle() {
        this.project = HIRuntime.getManager().getProject();
        String projectTitle = MetadataHelper.findValue(this.project, this.project.getDefaultLanguage().getLanguageId());
        if (projectTitle == null || projectTitle.length() == 0) {
            projectTitle = "Project P" + this.project.getId();
        }
        this.setTitle("Yenda - Legacy HyperImage Editor " + HIRuntime.getClientVersion() + " - " + projectTitle);
    }

    public void triggerProjectUpdate() {
        this.sendMessage(HIComponent.HIMessageTypes.PREFERENCE_MODIFIED, null, null);
        this.sendMessage(HIComponent.HIMessageTypes.LANGUAGE_ADDED, null, null);
        this.sendMessage(HIComponent.HIMessageTypes.DEFAULT_LANGUAGE_CHANGED, null, null);
        this.sendMessage(HIComponent.HIMessageTypes.GROUP_SORTORDER_CHANGED, null, null);
        this.updateProjectTitle();
    }

    public void handleXMLImport() {
        if (!this.checkAdminAbility(false)) {
            return;
        }
        boolean projectIsEmpty = false;
        try {
            if (HIRuntime.getManager().getGroups().size() == 0 && HIRuntime.getManager().getGroupContents(HIRuntime.getManager().getImportGroup()).size() == 0 && HIRuntime.getManager().getGroupContents(HIRuntime.getManager().getTrashGroup()).size() == 0) {
                projectIsEmpty = true;
            }
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().reportError(wse, null);
            return;
        }
        if (!this.xmlImportDialog.displayImportDialog()) {
            this.displayInfoDialog(Messages.getString("HIClientGUI.150"), Messages.getString("HIClientGUI.151"));
            return;
        }
        File importFile = this.xmlImportDialog.getImportXMLFile();
        if (!(importFile != null && importFile.isFile() && importFile.exists() && importFile.canRead())) {
            this.displayInfoDialog(Messages.getString("HIClientGUI.152"), Messages.getString("HIClientGUI.153"));
            return;
        }
        XMLImporter importer = new XMLImporter();
        if (!importer.loadAndValidateXMLFile(importFile)) {
            this.displayInfoDialog(Messages.getString("HIClientGUI.154"), Messages.getString("HIClientGUI.155"));
            return;
        }
        if (importer.isPeTAL2_0()) {
            if (!projectIsEmpty) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.159"), String.valueOf(Messages.getString("HIClientGUI.160")) + "\n\n" + Messages.getString("HIClientGUI.161"));
                return;
            }
            if (!this.xmlImportDialog.isPeTAL_Expected()) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.154"), Messages.getString("HIClientGUI.vraCoreExtendedExpected"));
                return;
            }
            PeTAL2Importer petalImporter = new PeTAL2Importer(importFile, importer.getXMLDocument());
            petalImporter.importXMLToProject();
        } else if (importer.isPeTAL3_0()) {
            if (!this.xmlImportDialog.isPeTAL_Expected()) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.154"), Messages.getString("HIClientGUI.vraCoreExtendedExpected"));
                return;
            }
            PeTAL3Importer petalImporter = new PeTAL3Importer(importFile, importer.getXMLDocument());
            petalImporter.importXMLToProject();
        } else if (importer.isVRA4Hdlbg()) {
            if (!this.xmlImportDialog.isVRA4Hdlbg_Expected()) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.154"), Messages.getString("HIClientGUI.petalExpected"));
                return;
            }
            VRACore4HeidelbergImporter vrahdlbgImporter = new VRACore4HeidelbergImporter(importFile, importer.getXMLDocument());
            vrahdlbgImporter.importXMLToProject();
        } else if (importer.isTamboti()) {
            if (!this.xmlImportDialog.isVRA4Hdlbg_Expected()) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.154"), Messages.getString("HIClientGUI.petalExpected"));
                return;
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(HIClientGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
            Document vraDoc = docBuilder.newDocument();
            Document tambotiDoc = importer.getXMLDocument();
            Node tambotiDocRoot = tambotiDoc.getFirstChild();
            NodeList childNodes = tambotiDocRoot.getChildNodes();
            int i = 0;
            Node vraNode = childNodes.item(i);
            while (!(vraNode instanceof Element)) {
                vraNode = childNodes.item(++i);
            }
            Node node = vraDoc.importNode(vraNode, true);
            vraDoc.appendChild(node);
            VRACore4HeidelbergImporter vrahdlbgImporter = new VRACore4HeidelbergImporter(importFile, vraDoc);
            vrahdlbgImporter.importXMLToProject();
        }
    }

    public void handleExport() {
        if (!this.checkEditAbility(false)) {
            return;
        }
        if (this.exportDialog.displayExportDialog()) {
            if (this.exportDialog.getExportDir() == null) {
                return;
            }
            if (!this.exportDialog.getExportDir().canWrite()) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.8"), Messages.getString("HIClientGUI.9"));
                return;
            }
            final File exportDir = new File(String.valueOf(this.exportDialog.getExportDir().getAbsolutePath()) + File.separatorChar + "PeTAL");
            if (!exportDir.exists()) {
                exportDir.mkdir();
            }
            this.startIndicatingServiceActivity(true);
            this.setMessage(Messages.getString("HIClientGUI.5"));
            new Thread(){

                @Override
                public void run() {
                    Document xml = HIClientGUI.this.exportDialog.isPeTAL3Mode() ? PeTAL3Exporter.getProjectToPeTALXML(HIRuntime.getManager().getProject()) : PeTALExporter.getProjectToPeTALXML(HIRuntime.getManager().getProject());
                    if (xml != null) {
                        File outputFile = new File(String.valueOf(exportDir.getAbsolutePath()) + File.separatorChar + "project.xml");
                        try {
                            outputFile.createNewFile();
                        }
                        catch (IOException ioe) {
                            return;
                        }
                        if (!outputFile.canWrite()) {
                            return;
                        }
                        if (HIClientGUI.this.exportDialog.isPeTAL3Mode()) {
                            PeTAL3Exporter.serializeXMLDocumentToFile(xml, outputFile);
                        } else {
                            PeTALExporter.serializeXMLDocumentToFile(xml, outputFile);
                        }
                    }
                    if (HIClientGUI.this.exportDialog.isExportingBinaries()) {
                        File binaryDir = new File(String.valueOf(exportDir.getAbsolutePath()) + File.separatorChar + "img");
                        if (!binaryDir.exists()) {
                            binaryDir.mkdir();
                        }
                        int progress = -1;
                        float percentage = 0.0f;
                        Vector<HiView> projectViews = HIClientGUI.this.exportDialog.isPeTAL3Mode() ? PeTAL3Exporter.projectViews : PeTALExporter.projectViews;
                        if (projectViews.size() > 0) {
                            percentage = 100.0f / (float)projectViews.size();
                        }
                        int index = 0;
                        while (index < projectViews.size()) {
                            block23: {
                                if (progress != (int)(percentage * (float)index)) {
                                    progress = (int)(percentage * (float)index);
                                    HIClientGUI.this.setProgress(progress);
                                }
                                HiView view = projectViews.get(index);
                                HIClientGUI.this.setMessage(String.valueOf(Messages.getString("HIClientGUI.6")) + " " + (index + 1) + " " + Messages.getString("HIClientGUI.11") + " " + projectViews.size());
                                if (view.getFilename() != null && view.getFilename().length() > 0) {
                                    view.setMimeType(URLConnection.guessContentTypeFromName(view.getFilename()));
                                }
                                if (view.getMimeType() == null) {
                                    view.setMimeType("");
                                }
                                try {
                                    byte[] bitstream;
                                    File destFile = new File(String.valueOf(binaryDir.getAbsolutePath()) + File.separatorChar + "V" + view.getId() + ".original");
                                    boolean exportBinary = true;
                                    if (destFile.exists() && destFile.canRead()) {
                                        bitstream = HIRuntime.getBytesFromFile(destFile);
                                        String hash = HIRuntime.getMD5HashString(bitstream);
                                        if (hash.compareTo(view.getHash()) == 0) {
                                            exportBinary = false;
                                        }
                                        bitstream = null;
                                    }
                                    if (!exportBinary) break block23;
                                    bitstream = HIRuntime.getManager().getImageAsBitstream(view, HiImageSizes.HI_ORIGINAL);
                                    if (bitstream != null) {
                                        String extension = ".original";
                                        if (view.getMimeType().equalsIgnoreCase("image/jpeg")) {
                                            extension = ".jpg";
                                        }
                                        if (view.getMimeType().equalsIgnoreCase("image/png")) {
                                            extension = ".png";
                                        }
                                        FileOutputStream binWriter = HIClientGUI.this.exportDialog.isPeTAL3Mode() ? new FileOutputStream(String.valueOf(binaryDir.getAbsolutePath()) + File.separatorChar + view.getUUID() + extension) : new FileOutputStream(String.valueOf(binaryDir.getAbsolutePath()) + File.separatorChar + "V" + view.getId() + ".original");
                                        binWriter.write(bitstream);
                                        binWriter.close();
                                    } else {
                                        HIRuntime.getGui().displayInfoDialog(Messages.getString("HIClientGUI.12"), String.valueOf(Messages.getString("HIClientGUI.13")) + " V" + view.getId() + " " + Messages.getString("HIClientGUI.16") + "\n\n" + Messages.getString("HIClientGUI.18"));
                                        System.out.println("View not exported because the image is broken or mime detection failed (" + view.getMimeType() + ") - " + view.getFilename() + "!");
                                    }
                                }
                                catch (FileNotFoundException e) {
                                    e.printStackTrace();
                                    HIRuntime.getGui().displayInfoDialog(Messages.getString("HIClientGUI.23"), Messages.getString("HIClientGUI.24"));
                                    break;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    HIRuntime.getGui().displayInfoDialog(Messages.getString("HIClientGUI.25"), Messages.getString("HIClientGUI.26"));
                                    break;
                                }
                                catch (HIWebServiceException wse) {
                                    HIRuntime.getGui().reportError(wse, null);
                                    break;
                                }
                            }
                            ++index;
                        }
                    }
                    HIClientGUI.this.stopIndicatingServiceActivity();
                }
            }.start();
        } else {
            this.displayInfoDialog(Messages.getString("HIClientGUI.27"), Messages.getString("HIClientGUI.28"));
        }
    }

    public long getTagCountForElement(long baseID) {
        if (baseID <= 0L) {
            return 0L;
        }
        long count = 0L;
        try {
            this.startIndicatingServiceActivity();
            count = HIRuntime.getManager().getTagCountForElement(baseID);
            this.stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            this.stopIndicatingServiceActivity();
            HIRuntime.getGui().reportError(wse, null);
        }
        return count;
    }

    public long getTagCountForElement(HiBase base) {
        if (base == null) {
            return 0L;
        }
        return this.getTagCountForElement(base.getId());
    }

    public void createAndShowGUI() {
        Locale[] localeArray = HIRuntime.supportedLanguages;
        int n = HIRuntime.supportedLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            Locale guiLang = localeArray[n2];
            if (Locale.getDefault().getLanguage().compareTo(guiLang.getLanguage()) == 0) {
                HIRuntime.setGUILanguage(guiLang);
            }
            ++n2;
        }
        this.projectChooser = new ProjectChooser(this);
        this.loginDialog = new LoginDialog(this);
        this.exportDialog = new ExportProjectDialog(this);
        this.xmlImportDialog = new XMLImportProjectDialog(this);
        this.initMenus();
        this.setTitle("Yenda - Legacy HyperImage Editor " + HIRuntime.getClientVersion());
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.setMinimumSize(new Dimension(200, 460));
        this.setContentPane(this.mdiPane);
        this.setGlassPane(this.infoGlassPane);
        this.infoGlassPane.setVisible(false);
        this.setVisible(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.waitCursor = null;
        try {
            this.waitCursor = tk.createCustomCursor(ImageIO.read(this.getClass().getResource("/resources/cursors/wait-cursor.png")), new Point(16, 16), "cross-Add");
        }
        catch (Exception e) {
            this.waitCursor = Cursor.getPredefinedCursor(3);
        }
        this.infoGlassPane.setCursor(this.waitCursor);
        this.mdiPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && !e.isConsumed()) {
                    e.consume();
                    HIClientGUI.this.popupToolsMenu.getPopupMenu().show(HIClientGUI.this.mdiPane, e.getX() + 10, e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && !e.isConsumed()) {
                    e.consume();
                    HIClientGUI.this.popupToolsMenu.getPopupMenu().show(HIClientGUI.this.mdiPane, e.getX() + 10, e.getY());
                }
            }
        });
        if (!this.handleLogin()) {
            this.tryLogoutAndExit();
        }
        if (HIRuntime.getClientVersion().contains("beta") && !HIRuntime.betaWarningDisplayed) {
            HIRuntime.betaWarningDisplayed = true;
            JOptionPane.showMessageDialog(this, Messages.getString("HIClientGUI.BetaWarning"), Messages.getString("HIClientGUI.BetaWarningTitle"), 1);
        }
        this.chooseProject();
        this.showDefaultProjectLayout();
    }

    private void initMenus() {
        this.guiMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exportMenuItem = new JMenuItem();
        this.publicationMenuItem = new JMenuItem();
        this.xmlImportMenuItem = new JMenuItem();
        this.guiLanguageMenu = new JMenu();
        this.editUserMenuItem = new JMenuItem();
        this.changeProjectMenuItem = new JMenuItem();
        this.showLivePreviewMenuItem = new JMenuItem();
        this.changeUserMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.projectMenu = new JMenu();
        this.administrateProjectPrefsMenuItem = new JMenuItem();
        this.projectSettingsMenuItem = new JMenuItem();
        this.projectTemplatesMenuItem = new JMenuItem();
        this.administrateProjectUsersMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.newGroupBrowserMenuItem = new JMenuItem();
        this.searchMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.tagManagerMenuItem = new JMenuItem();
        this.tagExplorerMenuItem = new JMenuItem();
        this.windowMenu = new JMenu();
        this.nextWindowItem = new JMenuItem();
        this.prevWindowItem = new JMenuItem();
        this.windowSeparator1 = new JSeparator();
        this.toggleMetadataViewMenuItem = new JMenuItem();
        this.windowSeparator2 = new JSeparator();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.contentMenuItem = new JMenuItem();
        this.visitWebsiteMenuItem = new JMenuItem();
        this.editUserMenuItem.setActionCommand("accountSettings");
        if (System.getProperty("HI.feature.accountSettingsDisabled") == null) {
            this.fileMenu.add(this.editUserMenuItem);
        }
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.guiLanguageMenu);
        this.fileMenu.add(new JSeparator());
        this.changeUserMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, HIRuntime.getModifierKey() + 1));
        this.changeUserMenuItem.setActionCommand("changeUser");
        this.fileMenu.add(this.changeUserMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, HIRuntime.getModifierKey()));
        this.exitMenuItem.setActionCommand("exit");
        this.fileMenu.add(this.exitMenuItem);
        this.guiMenuBar.add(this.fileMenu);
        this.exportMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/export-menu.png")));
        this.exportMenuItem.setActionCommand("exportProject");
        this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, HIRuntime.getModifierKey()));
        this.projectMenu.add(this.exportMenuItem);
        this.publicationMenuItem.setActionCommand("startPubTool");
        this.projectMenu.add(this.publicationMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectSettingsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/preferences-menu.png")));
        this.projectSettingsMenuItem.setActionCommand("projectSettings");
        this.projectSettingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(44, HIRuntime.getModifierKey()));
        this.projectMenu.add(this.projectSettingsMenuItem);
        this.projectMenu.add(new JSeparator());
        this.administrateProjectPrefsMenuItem.setActionCommand("librarySettings");
        this.projectMenu.add(this.administrateProjectPrefsMenuItem);
        this.projectTemplatesMenuItem.setActionCommand("templateEditor");
        if (System.getProperty("HI.feature.templateEditorDisabled") == null) {
            this.projectMenu.add(this.projectTemplatesMenuItem);
        }
        this.administrateProjectUsersMenuItem.setActionCommand("manageProjectUsers");
        if (System.getProperty("HI.feature.manageUsersDisabled") == null) {
            this.projectMenu.add(this.administrateProjectUsersMenuItem);
        }
        this.xmlImportMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/import-menu.png")));
        this.xmlImportMenuItem.setActionCommand("xmlImportProject");
        this.xmlImportMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, HIRuntime.getModifierKey()));
        if (System.getProperty("HI.feature.importDisabled") == null) {
            this.projectMenu.add(this.xmlImportMenuItem);
        }
        this.projectMenu.add(new JSeparator());
        this.showLivePreviewMenuItem.setActionCommand("livePreview");
        this.projectMenu.add(this.showLivePreviewMenuItem);
        this.projectMenu.add(new JSeparator());
        this.changeProjectMenuItem.setActionCommand("changeProject");
        this.projectMenu.add(this.changeProjectMenuItem);
        this.guiMenuBar.add(this.projectMenu);
        this.newGroupBrowserMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, HIRuntime.getModifierKey()));
        this.newGroupBrowserMenuItem.setActionCommand("newBrowser");
        this.toolsMenu.add(this.newGroupBrowserMenuItem);
        this.searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, HIRuntime.getModifierKey()));
        this.searchMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/search-menu.png")));
        this.searchMenuItem.setActionCommand("newSearch");
        this.toolsMenu.add(this.searchMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.tagManagerMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, HIRuntime.getModifierKey()));
        this.tagManagerMenuItem.setActionCommand("tagManager");
        if (System.getProperty("HI.feature.tagsDisabled") == null) {
            this.toolsMenu.add(this.tagManagerMenuItem);
        }
        this.tagExplorerMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, HIRuntime.getModifierKey()));
        this.tagExplorerMenuItem.setActionCommand("tagExplorer");
        if (System.getProperty("HI.feature.tagsDisabled") == null) {
            this.toolsMenu.add(this.tagExplorerMenuItem);
        }
        this.guiMenuBar.add(this.toolsMenu);
        this.nextWindowItem.setActionCommand("nextWindow");
        this.nextWindowItem.setEnabled(false);
        this.nextWindowItem.setAccelerator(KeyStroke.getKeyStroke(160, HIRuntime.getModifierKey()));
        this.windowMenu.add(this.nextWindowItem);
        this.prevWindowItem.setActionCommand("previousWindow");
        this.prevWindowItem.setEnabled(false);
        this.prevWindowItem.setAccelerator(KeyStroke.getKeyStroke(153, HIRuntime.getModifierKey()));
        this.windowMenu.add(this.prevWindowItem);
        this.windowMenu.add(this.windowSeparator1);
        this.toggleMetadataViewMenuItem.setActionCommand("toggleMetadata");
        this.toggleMetadataViewMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, HIRuntime.getModifierKey()));
        this.toggleMetadataViewMenuItem.setEnabled(false);
        this.windowMenu.add(this.toggleMetadataViewMenuItem);
        this.windowMenu.add(this.windowSeparator2);
        this.guiMenuBar.add(this.windowMenu);
        this.aboutMenuItem.setActionCommand("about");
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenu.add(new JSeparator());
        this.contentMenuItem.setActionCommand("openHelp");
        this.helpMenu.add(this.contentMenuItem);
        this.visitWebsiteMenuItem.setActionCommand("visitWebsite");
        this.helpMenu.add(this.visitWebsiteMenuItem);
        this.feedbackItem = new JMenuItem();
        this.feedbackItem.setActionCommand("FEEDBACK");
        this.feedbackItem.addActionListener(this);
        this.guiMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.guiMenuBar);
        this.debugMenu = new JMenu("Debug");
        JMenuItem debugItem = new JMenuItem("GTK Look and Feel");
        debugItem.setActionCommand("GTK");
        debugItem.addActionListener(this);
        this.debugMenu.add(debugItem);
        debugItem = new JMenuItem("System Look and Feel");
        debugItem.setActionCommand("SYSTEM");
        debugItem.addActionListener(this);
        this.debugMenu.add(debugItem);
        this.debugMenu.add(new JSeparator());
        debugItem = new JMenuItem("Perform WS Tests...");
        debugItem.setActionCommand("WS_TEST");
        debugItem.addActionListener(this);
        this.debugMenu.add(debugItem);
        if (HIRuntime.getManager().getServerURL().indexOf("localhost") >= 0) {
            this.guiMenuBar.add(this.debugMenu);
        }
        this.popupToolsMenu = new JMenu();
        this.popupNewGroupBrowserMenuItem = new JMenuItem();
        this.popupNewGroupBrowserMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, HIRuntime.getModifierKey()));
        this.popupNewGroupBrowserMenuItem.setActionCommand("newBrowser");
        this.popupToolsMenu.add(this.popupNewGroupBrowserMenuItem);
        this.popupSearchMenuItem = new JMenuItem();
        this.popupSearchMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, HIRuntime.getModifierKey()));
        this.popupSearchMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/search-menu.png")));
        this.popupSearchMenuItem.setActionCommand("notImplemented");
        this.popupToolsMenu.add(this.popupSearchMenuItem);
        this.popupToolsMenu.add(new JSeparator());
        this.popupTagManagerMenuItem = new JMenuItem();
        this.popupTagManagerMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, HIRuntime.getModifierKey()));
        this.popupTagManagerMenuItem.setActionCommand("tagManager");
        if (System.getProperty("HI.feature.tagsDisabled") == null) {
            this.popupToolsMenu.add(this.popupTagManagerMenuItem);
        }
        this.aboutMenuItem.addActionListener(this);
        this.editUserMenuItem.addActionListener(this);
        this.changeUserMenuItem.addActionListener(this);
        this.changeProjectMenuItem.addActionListener(this);
        this.showLivePreviewMenuItem.addActionListener(this);
        this.exitMenuItem.addActionListener(this);
        this.newGroupBrowserMenuItem.addActionListener(this);
        this.searchMenuItem.addActionListener(this);
        this.importMenuItem.addActionListener(this);
        this.tagManagerMenuItem.addActionListener(this);
        this.tagExplorerMenuItem.addActionListener(this);
        this.exportMenuItem.addActionListener(this);
        this.publicationMenuItem.addActionListener(this);
        this.xmlImportMenuItem.addActionListener(this);
        this.projectSettingsMenuItem.addActionListener(this);
        this.projectTemplatesMenuItem.addActionListener(this);
        this.administrateProjectUsersMenuItem.addActionListener(this);
        this.administrateProjectPrefsMenuItem.addActionListener(this);
        this.prevWindowItem.addActionListener(this);
        this.nextWindowItem.addActionListener(this);
        this.toggleMetadataViewMenuItem.addActionListener(this);
        this.contentMenuItem.addActionListener(this);
        this.visitWebsiteMenuItem.addActionListener(this);
        this.popupNewGroupBrowserMenuItem.addActionListener(this);
        this.popupSearchMenuItem.addActionListener(this);
        this.popupTagManagerMenuItem.addActionListener(this);
        int i = 0;
        while (i < HIRuntime.supportedLanguages.length) {
            JCheckBoxMenuItem langItem = new JCheckBoxMenuItem();
            langItem.setActionCommand("setLang_" + i);
            langItem.addActionListener(this);
            this.guiLanguageMenu.add(langItem);
            ++i;
        }
        this.setMenuText();
    }

    private void setMenuText() {
        this.fileMenu.setText(Messages.getString("HIClientGUI.64"));
        this.editUserMenuItem.setText(Messages.getString("HIClientGUI.65"));
        this.guiLanguageMenu.setText(Messages.getString("HIClientGUI.66"));
        this.changeUserMenuItem.setText(Messages.getString("HIClientGUI.67"));
        this.exitMenuItem.setText(Messages.getString("HIClientGUI.68"));
        this.projectMenu.setText(Messages.getString("HIClientGUI.69"));
        this.exportMenuItem.setText(Messages.getString("HIClientGUI.70"));
        this.publicationMenuItem.setText(Messages.getString("HIClientGUI.publicationmenuitem"));
        this.xmlImportMenuItem.setText(Messages.getString("HIClientGUI.93"));
        this.administrateProjectPrefsMenuItem.setText(Messages.getString("HIClientGUI.71"));
        this.projectSettingsMenuItem.setText(Messages.getString("HIClientGUI.72"));
        this.projectTemplatesMenuItem.setText(Messages.getString("HIClientGUI.73"));
        this.administrateProjectUsersMenuItem.setText(Messages.getString("HIClientGUI.74"));
        this.changeProjectMenuItem.setText(Messages.getString("HIClientGUI.75"));
        this.showLivePreviewMenuItem.setText(Messages.getString("HIClientGUI.203"));
        this.toolsMenu.setText(Messages.getString("HIClientGUI.76"));
        this.newGroupBrowserMenuItem.setText(Messages.getString("HIClientGUI.77"));
        this.searchMenuItem.setText(Messages.getString("HIClientGUI.78"));
        this.importMenuItem.setText(Messages.getString("HIClientGUI.79"));
        this.tagManagerMenuItem.setText(Messages.getString("HIClientGUI.tagManager"));
        this.tagExplorerMenuItem.setText(Messages.getString("HIClientGUI.tagExplorer"));
        this.windowMenu.setText(Messages.getString("HIClientGUI.80"));
        this.nextWindowItem.setText(Messages.getString("HIClientGUI.81"));
        this.prevWindowItem.setText(Messages.getString("HIClientGUI.82"));
        this.toggleMetadataViewMenuItem.setText(Messages.getString("HIClientGUI.83"));
        this.helpMenu.setText(Messages.getString("HIClientGUI.84"));
        this.aboutMenuItem.setText(Messages.getString("HIClientGUI.85"));
        this.contentMenuItem.setText(Messages.getString("HIClientGUI.86"));
        this.visitWebsiteMenuItem.setText(Messages.getString("HIClientGUI.87"));
        this.feedbackItem.setText(Messages.getString("HIClientGUI.88"));
        this.popupNewGroupBrowserMenuItem.setText(this.newGroupBrowserMenuItem.getText());
        this.popupSearchMenuItem.setText(this.searchMenuItem.getText());
        this.popupTagManagerMenuItem.setText(this.tagManagerMenuItem.getText());
        int i = 0;
        while (i < HIRuntime.supportedLanguages.length) {
            Locale guiLang = HIRuntime.supportedLanguages[i];
            JCheckBoxMenuItem langItem = (JCheckBoxMenuItem)this.guiLanguageMenu.getMenuComponent(i);
            langItem.setText(guiLang.getDisplayLanguage());
            langItem.setSelected(guiLang.getLanguage().compareTo(HIRuntime.getGUILanguage().getLanguage()) == 0);
            ++i;
        }
    }

    private void setMenuState() {
        if (this.frontFrame != null) {
            this.toggleMetadataViewMenuItem.setEnabled(this.frontFrame.hasMetadataView());
            if (this.frontFrame.isMetadataVisible()) {
                this.toggleMetadataViewMenuItem.setText(Messages.getString("HIClientGUI.89"));
            } else {
                this.toggleMetadataViewMenuItem.setText(Messages.getString("HIClientGUI.90"));
            }
        } else {
            this.toggleMetadataViewMenuItem.setEnabled(false);
        }
        boolean hasWindows = false;
        if (this.components.size() > 0) {
            hasWindows = true;
        }
        this.nextWindowItem.setEnabled(hasWindows);
        this.prevWindowItem.setEnabled(hasWindows);
        this.exportMenuItem.setEnabled(this.checkEditAbility(true));
        this.xmlImportMenuItem.setEnabled(this.checkAdminAbility(true));
        this.administrateProjectUsersMenuItem.setEnabled(this.checkAdminAbility(true));
        this.projectSettingsMenuItem.setEnabled(this.checkAdminAbility(true));
        this.projectTemplatesMenuItem.setEnabled(this.checkAdminAbility(true));
        this.administrateProjectPrefsMenuItem.setEnabled(this.checkEditAbility(true));
    }

    private HIComponentFrame getFrontMostFrame() {
        return this.frontFrame;
    }

    public void displayNotImplementedDialog() {
        this.displayInfoDialog(Messages.getString("HIClientGUI.91"), Messages.getString("HIClientGUI.92"));
    }

    private void showDefaultProjectLayout() {
        this.registerComponent(new GroupBrowser());
    }

    public int getComponentTypeCount(Class componentClass) {
        int count = 0;
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent().getClass() != componentClass) continue;
            ++count;
        }
        return count;
    }

    public HIComponentFrame getEditingComponentForElement(HiQuickInfo info) {
        if (info.getContentType() == HiBaseTypes.HI_OBJECT) {
            for (HIComponentFrame frame : this.components) {
                if (!(frame.getHIComponent() instanceof ObjectEditor) || frame.getHIComponent().getBaseElement().getId() != info.getBaseID()) continue;
                return frame;
            }
        }
        if (info.getContentType() == HiBaseTypes.HI_VIEW || info.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
            for (HIComponentFrame frame : this.components) {
                if (!(frame.getHIComponent() instanceof ObjectEditor) || frame.getHIComponent().getBaseElement().getId() != info.getRelatedID()) continue;
                return frame;
            }
        }
        if (info.getContentType() == HiBaseTypes.HI_LAYER) {
            for (HIComponentFrame frame : this.components) {
                if (!(frame.getHIComponent() instanceof LayerEditor) || frame.getHIComponent().getBaseElement().getId() != info.getRelatedID()) continue;
                return frame;
            }
        }
        if (info.getContentType() == HiBaseTypes.HI_GROUP) {
            for (HIComponentFrame frame : this.components) {
                if (!(frame.getHIComponent() instanceof GroupBrowser) || frame.getHIComponent().getBaseElement().getId() != info.getBaseID()) continue;
                return frame;
            }
        }
        if (info.getContentType() == HiBaseTypes.HI_TEXT || info.getContentType() == HiBaseTypes.HIURL) {
            for (HIComponentFrame frame : this.components) {
                if (!(frame.getHIComponent() instanceof GenericMetadataEditor) || frame.getHIComponent().getBaseElement().getId() != info.getBaseID()) continue;
                return frame;
            }
        }
        if (info.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
            for (HIComponentFrame frame : this.components) {
                if (!(frame.getHIComponent() instanceof LightTableEditor) || frame.getHIComponent().getBaseElement().getId() != info.getBaseID()) continue;
                return frame;
            }
        }
        return null;
    }

    public boolean focusComponent(HIComponentFrame frame) {
        if (frame == this.frontFrame) {
            return true;
        }
        frame.moveToFront();
        try {
            frame.setSelected(true);
            this.frontFrame = frame;
            this.setMenuState();
        }
        catch (PropertyVetoException e1) {
            return false;
        }
        return true;
    }

    public boolean focusComponent(HIComponent component) {
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent() != component) continue;
            return this.focusComponent(frame);
        }
        return false;
    }

    public void updateComponentTitle(HIComponent sender) {
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent() != sender) continue;
            frame.updateTitle();
        }
    }

    public void registerComponent(final HIComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HIComponentFrame componentFrame = null;
                for (HIComponentFrame regFrame : HIClientGUI.this.components) {
                    if (regFrame.getHIComponent() != component) continue;
                    componentFrame = regFrame;
                }
                if (componentFrame != null) {
                    HIClientGUI.this.focusComponent(componentFrame);
                    return;
                }
                componentFrame = new HIComponentFrame(component);
                componentFrame.setFocusable(true);
                HIClientGUI.this.mdiPane.add((Component)componentFrame, JLayeredPane.DEFAULT_LAYER);
                componentFrame.addInternalFrameListener(HIRuntime.getGui());
                componentFrame.addHierarchyListener(HIRuntime.getGui());
                componentFrame.addComponentListener(HIRuntime.getGui());
                componentFrame.getHIComponent().getWindowMenuItem().addActionListener(HIRuntime.getGui());
                if (component instanceof LayerEditor || component instanceof GroupBrowser) {
                    componentFrame.setSize(HIRuntime.getGui().getContentPane().getSize().width, componentFrame.getSize().height);
                    if (component instanceof GroupBrowser) {
                        componentFrame.setSize(HIRuntime.getGui().getContentPane().getSize().width, componentFrame.getSize().height);
                        componentFrame.setLocation(0, 0 + (1 + HIClientGUI.this.getComponentTypeCount(GroupBrowser.class) * 50));
                    }
                    componentFrame.setMetadataVisible(true);
                } else {
                    componentFrame.setLocation(HIRuntime.getGui().getContentPane().getSize().width / 2 - componentFrame.getSize().width / 2 + HIClientGUI.this.getComponentTypeCount(component.getClass()) * 30, HIRuntime.getGui().getContentPane().getSize().height / 2 - componentFrame.getSize().height / 2 + HIClientGUI.this.getComponentTypeCount(component.getClass()) * 30);
                }
                componentFrame.setVisible(true);
                HIClientGUI.this.focusComponent(componentFrame);
                if (System.getProperty("os.name").toLowerCase().indexOf("mac") != -1) {
                    componentFrame.getInputMap(2).put(KeyStroke.getKeyStroke(87, 4), "closeOnMac");
                    componentFrame.getActionMap().put("closeOnMac", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ((HIComponentFrame)e.getSource()).doDefaultCloseAction();
                        }
                    });
                }
                HIClientGUI.this.components.add(componentFrame);
                HIClientGUI.this.windowMenu.add(componentFrame.getHIComponent().getWindowMenuItem());
                int i = 0;
                while (i < HIClientGUI.this.components.size()) {
                    HIClientGUI.this.components.get(i).getHIComponent().getWindowMenuItem().setActionCommand("showComponent_" + i);
                    ++i;
                }
                HIClientGUI.this.frontFrame = componentFrame;
                HIClientGUI.this.setMenuState();
            }
        });
    }

    public boolean deregisterComponent(HIComponentFrame componentFrame, boolean force) {
        this.focusComponent(componentFrame);
        this.setMenuState();
        if (!force && !componentFrame.getHIComponent().requestClose()) {
            return false;
        }
        componentFrame.removeInternalFrameListener(this);
        componentFrame.removeHierarchyListener(this);
        componentFrame.getHIComponent().getWindowMenuItem().removeActionListener(this);
        componentFrame.removeComponentListener(HIRuntime.getGui());
        if (this.components.size() > 1) {
            int index = this.components.indexOf(componentFrame);
            if (--index < 0) {
                index = this.components.size() - 1;
            }
            this.focusComponent(this.components.get(index));
        }
        componentFrame.setVisible(false);
        this.components.remove(componentFrame);
        componentFrame.dispose();
        this.setMenuState();
        this.windowMenu.remove(componentFrame.getHIComponent().getWindowMenuItem());
        int i = 0;
        while (i < this.components.size()) {
            this.components.get(i).getHIComponent().getWindowMenuItem().setActionCommand("showComponent_" + i);
            ++i;
        }
        return true;
    }

    public boolean deregisterComponent(HIComponent component, boolean force) {
        HIComponentFrame compFrame = null;
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent() != component) continue;
            compFrame = frame;
        }
        if (compFrame != null) {
            return this.deregisterComponent(compFrame, force);
        }
        return false;
    }

    public boolean deregisterAllComponents() {
        while (this.components.size() > 0) {
            if (this.deregisterComponent(this.components.get(this.components.size() - 1), false)) continue;
            this.displayInfoDialog(APPNAME, Messages.getString("HIClientGUI.100"));
            return false;
        }
        return true;
    }

    public boolean saveAllOpenWork() {
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent().requestClose()) continue;
            return false;
        }
        return true;
    }

    public void notifyItemSentToTrash(long baseID) {
        Vector<HIComponentFrame> componentsToDelete = new Vector<HIComponentFrame>();
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent().getBaseElement() == null || frame.getHIComponent().getBaseElement().getId() != baseID) continue;
            componentsToDelete.addElement(frame);
        }
        for (HIComponentFrame frame : componentsToDelete) {
            this.deregisterComponent(frame, true);
        }
    }

    public void sendMessage(HIComponent.HIMessageTypes message, HiBase base, HIComponent sender) {
        for (HIComponentFrame frame : this.components) {
            if (frame.getHIComponent() == sender) continue;
            frame.getHIComponent().receiveMessage(message, base);
        }
    }

    public void openContentEditor(long baseID, HIComponent sender) {
        HiQuickInfo info = null;
        try {
            info = HIRuntime.getManager().getBaseQuickInfo(baseID);
            if (info != null) {
                this.openContentEditor(info, sender);
            }
        }
        catch (HIWebServiceException wse) {
            this.reportError(wse, sender);
            return;
        }
    }

    public void openContentEditor(final HiQuickInfo content, HIComponent sender) {
        HIComponentFrame editingFrame = this.getEditingComponentForElement(content);
        if (editingFrame != null) {
            this.focusComponent(editingFrame);
            if (content.getContentType() == HiBaseTypes.HI_VIEW || content.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
                ((ObjectEditor)editingFrame.getHIComponent()).displayContentByID(content.getBaseID());
            }
            if (content.getContentType() == HiBaseTypes.HI_LAYER) {
                ((LayerEditor)editingFrame.getHIComponent()).displayLayerByID(content.getBaseID());
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                HIClientGUI.this.startIndicatingServiceActivity();
                GenericMetadataEditor editor = null;
                if (content.getContentType() == HiBaseTypes.HI_TEXT) {
                    try {
                        editor = new GenericMetadataEditor((HiText)HIClientGUI.this.manager.getBaseElement(content.getBaseID()));
                        HIClientGUI.this.registerComponent(editor);
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else if (content.getContentType() == HiBaseTypes.HI_VIEW || content.getContentType() == HiBaseTypes.HI_INSCRIPTION) {
                    try {
                        HiObject object = (HiObject)HIClientGUI.this.manager.getBaseElement(content.getRelatedID());
                        ObjectEditor objEditor = new ObjectEditor(object, content.getBaseID());
                        HIClientGUI.this.registerComponent(objEditor);
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else if (content.getContentType() == HiBaseTypes.HI_LAYER) {
                    try {
                        HiView view = (HiView)HIClientGUI.this.manager.getBaseElement(content.getRelatedID());
                        HIClientGUI.this.openLayerEditor(view, content.getBaseID());
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else if (content.getContentType() == HiBaseTypes.HIURL) {
                    try {
                        editor = new GenericMetadataEditor((Hiurl)HIClientGUI.this.manager.getBaseElement(content.getBaseID()));
                        HIClientGUI.this.registerComponent(editor);
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else if (content.getContentType() == HiBaseTypes.HI_LIGHT_TABLE) {
                    try {
                        HiLightTable lightTable = (HiLightTable)HIClientGUI.this.manager.getBaseElement(content.getBaseID());
                        LightTableEditor ltEditor = new LightTableEditor(lightTable);
                        HIClientGUI.this.registerComponent(ltEditor);
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else if (content.getContentType() == HiBaseTypes.HI_OBJECT) {
                    try {
                        System.out.println("--> " + content.getBaseID());
                        HiObject object = (HiObject)HIClientGUI.this.manager.getBaseElement(content.getBaseID());
                        ObjectEditor objEditor = new ObjectEditor(object);
                        HIClientGUI.this.registerComponent(objEditor);
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else if (content.getContentType() == HiBaseTypes.HI_GROUP) {
                    try {
                        HiGroup group = (HiGroup)HIClientGUI.this.manager.getBaseElement(content.getBaseID());
                        GroupBrowser browser = new GroupBrowser(group);
                        HIClientGUI.this.registerComponent(browser);
                    }
                    catch (HIWebServiceException wse) {
                        HIClientGUI.this.reportError(wse, null);
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(HIRuntime.getGui(), "GUI ERROR: Don\u00b4t know how to handle " + (Object)((Object)content.getContentType()) + " (" + content.getBaseID() + ") yet!");
                }
                HIClientGUI.this.stopIndicatingServiceActivity();
            }
        }.start();
    }

    public void openLayerEditor(HiView view) {
        this.openLayerEditor(view, -1L);
    }

    private void openLayerEditor(final HiView view, final long layerID) {
        System.gc();
        long neededMem = view.getWidth() * view.getHeight() * 3;
        System.out.println("total: " + Runtime.getRuntime().totalMemory());
        System.out.println("free: " + Runtime.getRuntime().freeMemory());
        if (Runtime.getRuntime().freeMemory() - neededMem < 0x500000L) {
            boolean choice = this.displayUserYesNoDialog(Messages.getString("HIClientGUI.104"), String.valueOf(Messages.getString("HIClientGUI.105")) + "\n" + Messages.getString("HIClientGUI.107") + " (" + view.getWidth() + "*" + view.getHeight() + " px) " + Messages.getString("HIClientGUI.111") + "\n\n" + Messages.getString("HIClientGUI.113"));
            if (choice) {
                this.displayNotImplementedDialog();
                return;
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                HIClientGUI.this.startIndicatingServiceActivity();
                try {
                    PlanarImage image = HIRuntime.getManager().getImage(view.getId(), HiImageSizes.HI_FULL, true);
                    HIClientGUI.this.stopIndicatingServiceActivity();
                    if (image == null) {
                        HIClientGUI.this.displayInfoDialog(Messages.getString("HIClientGUI.114"), Messages.getString("HIClientGUI.115"));
                        return;
                    }
                    if (layerID > 0L) {
                        HIClientGUI.this.registerComponent(new LayerEditor(view, image, layerID));
                    } else {
                        HIClientGUI.this.registerComponent(new LayerEditor(view, image));
                    }
                    System.gc();
                }
                catch (HIWebServiceException wse) {
                    HIClientGUI.this.reportError(wse, null);
                    return;
                }
            }
        }.start();
    }

    public void setGUIEnabled(boolean enabled) {
        if (this.fileMenu == null) {
            return;
        }
        this.fileMenu.setEnabled(enabled);
        this.projectMenu.setEnabled(enabled);
        this.toolsMenu.setEnabled(enabled);
        this.windowMenu.setEnabled(enabled);
        this.helpMenu.setEnabled(enabled);
    }

    public void startIndicatingServiceActivity() {
        this.startIndicatingServiceActivity(false);
    }

    public void startIndicatingServiceActivity(boolean showImmediately) {
        if (this.serviceActivity) {
            return;
        }
        this.serviceActivity = true;
        this.mdiPane.setCursor(this.waitCursor);
        HIRuntime.getGui().setGUIEnabled(false);
        this.setMessage(Messages.getString("HIClientGUI.20"));
        if (showImmediately) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (HIClientGUI.this.serviceActivity) {
                        HIClientGUI.this.infoGlassPane.setVisible(true);
                    }
                }
            });
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (HIClientGUI.this.serviceActivity) {
                                (this).HIClientGUI.this.infoGlassPane.setVisible(true);
                            }
                        }
                    });
                }
            }.start();
        }
    }

    public void setProgress(int progress) {
        this.infoGlassPane.setProgress(progress);
    }

    public void setMessage(String message) {
        this.infoGlassPane.setMessage(message);
    }

    public void stopIndicatingServiceActivity() {
        if (!this.serviceActivity) {
            return;
        }
        this.mdiPane.setCursor(Cursor.getDefaultCursor());
        this.serviceActivity = false;
        if (HIRuntime.getGui() != null) {
            HIRuntime.getGui().setGUIEnabled(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HIClientGUI.this.infoGlassPane.setVisible(false);
            }
        });
    }

    public int displayUserChoiceDialog(String title, String message) {
        return JOptionPane.showConfirmDialog(this, message, title, 1);
    }

    public boolean displayUserYesNoDialog(String title, String message) {
        int answer = JOptionPane.showConfirmDialog(this, message, title, 0, 2);
        return answer == 0;
    }

    public void displayInfoDialog(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public void displayReconnectDialog() {
        block17: {
            if (HIRuntime.getManager().getState() != HIWebServiceManagerInterface.WSStates.RECONNECT) {
                HIRuntime.getManager().setReconnect();
                int answer = 0;
                if (HIRuntime.OAUTHMode) {
                    this.displayInfoDialog(Messages.getString("HIClientGUI.117"), Messages.getString("HIClientGUI.116"));
                    this.tryLogoutAndExit();
                } else {
                    answer = JOptionPane.showConfirmDialog(this, Messages.getString("HIClientGUI.116"), Messages.getString("HIClientGUI.117"), 2);
                }
                if (answer == 0) {
                    try {
                        if (HIRuntime.getManager().reconnect()) break block17;
                        if (this.deregisterAllComponents()) {
                            if (!this.handleLogin()) {
                                this.tryLogoutAndExit();
                            } else {
                                this.chooseProject();
                                this.showDefaultProjectLayout();
                            }
                            break block17;
                        }
                        System.exit(1);
                    }
                    catch (HIWebServiceException wse) {
                        this.reportError(wse, null);
                        if (this.deregisterAllComponents()) {
                            if (!this.handleLogin()) {
                                this.tryLogoutAndExit();
                            } else {
                                this.chooseProject();
                                this.showDefaultProjectLayout();
                            }
                            break block17;
                        }
                        System.exit(1);
                    }
                } else if (this.deregisterAllComponents()) {
                    if (!this.handleLogin()) {
                        this.tryLogoutAndExit();
                    } else {
                        this.chooseProject();
                        this.showDefaultProjectLayout();
                    }
                } else {
                    System.exit(1);
                }
            }
        }
    }

    public void displayMaintenanceDialog(HIWebServiceException wse) {
        HIRuntime.getGui().displayInfoDialog(Messages.getString("HIClientGUI.118"), "<html>" + Messages.getString("HIClientGUI.120") + "<br><br>" + "<b>" + Messages.getString("HIClientGUI.123") + "</b><br>" + wse.getCause().getMessage() + "</html>");
    }

    public void clearLastWSError() {
        this.lastWSError = null;
    }

    public HIWebServiceException getLastWSError() {
        return this.lastWSError;
    }

    public void reportError(HIWebServiceException wse, HIComponent sender) {
        this.serviceActivity = true;
        this.stopIndicatingServiceActivity();
        this.lastWSError = wse;
        if (!this.displayingError) {
            if (wse.getErrorType() == HIWebServiceException.HIerrorTypes.RECONNECT) {
                this.displayReconnectDialog();
            } else if (wse.getErrorType() == HIWebServiceException.HIerrorTypes.MAINTENANCE) {
                this.displayMaintenanceDialog(wse);
                this.displayingError = false;
                while (this.components.size() > 0) {
                    this.deregisterComponent(this.components.get(0), true);
                }
                if (!this.handleLogin()) {
                    this.tryLogoutAndExit();
                    System.exit(1);
                } else {
                    this.chooseProject();
                    this.showDefaultProjectLayout();
                }
            } else {
                wse.getCause().printStackTrace();
                JOptionPane.showMessageDialog(this, "Web Service Error: " + wse.getCause().getClass() + "\n\nReason: " + wse.getCause().getMessage() + "\n");
            }
        }
        this.displayingError = false;
    }

    public boolean checkEditAbility(boolean silent) {
        if (HIRuntime.getManager().getCurrentRole() == HiRoles.GUEST) {
            if (!silent) {
                JOptionPane.showMessageDialog(HIRuntime.getGui(), Messages.getString("HIClientGUI.128"), Messages.getString("HIClientGUI.129"), 0);
            }
            return false;
        }
        return true;
    }

    public boolean checkAdminAbility(boolean silent) {
        if (HIRuntime.getManager().getCurrentRole() != HiRoles.ADMIN) {
            if (!silent) {
                JOptionPane.showMessageDialog(HIRuntime.getGui(), Messages.getString("HIClientGUI.130"), Messages.getString("HIClientGUI.131"), 0);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("notImplemented")) {
            this.displayNotImplementedDialog();
        }
        if (e.getActionCommand().equalsIgnoreCase("about")) {
            new AboutDialog(this).setVisible(true);
        }
        if (e.getActionCommand().equalsIgnoreCase("accountSettings")) {
            if (this.getComponentTypeCount(AccountSettings.class) > 0) {
                for (HIComponentFrame frame2 : this.components) {
                    if (!(frame2.getHIComponent() instanceof AccountSettings)) continue;
                    this.focusComponent(frame2);
                }
            } else {
                this.registerComponent(new AccountSettings(HIRuntime.getManager().getCurrentUser()));
            }
        }
        if (e.getActionCommand().startsWith("setLang_")) {
            int index = Integer.parseInt(e.getActionCommand().substring(8));
            HIRuntime.setGUILanguage(HIRuntime.supportedLanguages[index]);
            this.setMenuText();
            for (HIComponentFrame hIComponentFrame : this.components) {
                hIComponentFrame.getHIComponent().updateLanguage();
            }
            this.setMenuState();
        }
        if (e.getActionCommand().equalsIgnoreCase("exit") && this.displayUserYesNoDialog(Messages.getString("HIClientGUI.2"), Messages.getString("HIClientGUI.138"))) {
            this.tryLogoutAndExit();
        }
        if (e.getActionCommand().equalsIgnoreCase("changeUser") && this.displayUserYesNoDialog(Messages.getString("HIClientGUI.140"), Messages.getString("HIClientGUI.141")) && this.deregisterAllComponents()) {
            if (!this.handleLogin()) {
                this.tryLogoutAndExit();
            } else {
                this.chooseProject();
                this.showDefaultProjectLayout();
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("xmlImportProject")) {
            this.handleXMLImport();
        }
        if (e.getActionCommand().equalsIgnoreCase("exportProject")) {
            this.handleExport();
        }
        if (e.getActionCommand().equalsIgnoreCase("projectSettings")) {
            if (this.getComponentTypeCount(ProjectSettings.class) > 0) {
                for (HIComponentFrame frame : this.components) {
                    if (!(frame.getHIComponent() instanceof ProjectSettings)) continue;
                    this.focusComponent(frame);
                }
            } else {
                this.registerComponent(new ProjectSettings());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("templateEditor")) {
            if (this.getComponentTypeCount(TemplateEditor.class) > 0) {
                for (HIComponentFrame frame : this.components) {
                    if (!(frame.getHIComponent() instanceof TemplateEditor)) continue;
                    this.focusComponent(frame);
                }
            } else {
                if (this.getComponentTypeCount(ObjectEditor.class) > 0) {
                    boolean closeObjectEditors = this.displayUserYesNoDialog(Messages.getString("HIClientGUI.200"), String.valueOf(Messages.getString("HIClientGUI.201")) + "\n\n" + Messages.getString("HIClientGUI.202"));
                    if (closeObjectEditors) {
                        Vector<HIComponentFrame> vector = new Vector<HIComponentFrame>();
                        for (HIComponentFrame hIComponentFrame : this.components) {
                            if (!(hIComponentFrame.getHIComponent() instanceof ObjectEditor)) continue;
                            vector.addElement(hIComponentFrame);
                        }
                        while (vector.size() > 0) {
                            if (!this.deregisterComponent((HIComponentFrame)vector.get(0), false)) {
                                return;
                            }
                            vector.remove(0);
                        }
                    } else {
                        return;
                    }
                }
                this.registerComponent(new TemplateEditor());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("librarySettings")) {
            if (this.getComponentTypeCount(PreferenceManager.class) > 0) {
                for (HIComponentFrame frame5 : this.components) {
                    if (!(frame5.getHIComponent() instanceof PreferenceManager)) continue;
                    this.focusComponent(frame5);
                }
            } else {
                this.registerComponent(new PreferenceManager());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("manageProjectUsers")) {
            HIComponentFrame userManagerFrame = null;
            for (HIComponentFrame hIComponentFrame : this.components) {
                if (!(hIComponentFrame.getHIComponent() instanceof ProjectUsersManager)) continue;
                userManagerFrame = hIComponentFrame;
            }
            if (userManagerFrame == null) {
                this.registerComponent(new ProjectUsersManager());
            } else {
                this.focusComponent(userManagerFrame);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("startPubTool") && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(String.valueOf(this.manager.getServerURL().replaceFirst("\\/api\\/", "/app/")) + "publication/?project=" + this.manager.getProject().getId() + "&lang=" + HIRuntime.getGUILanguage().getLanguage().toLowerCase()));
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(HIClientGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("livePreview") && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(String.valueOf(this.manager.getServerURL().replaceFirst("\\/api\\/legacy\\/", "/app/")) + "previewer/?project=" + this.manager.getProject().getId() + "&token=" + MetadataHelper.findPreferenceValue(this.manager.getProject(), "admin.publication.token")));
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(HIClientGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("changeProject") && this.displayUserYesNoDialog(Messages.getString("HIClientGUI.3"), Messages.getString("HIClientGUI.147")) && this.deregisterAllComponents()) {
            this.chooseProject();
            this.showDefaultProjectLayout();
        }
        if (e.getActionCommand().equalsIgnoreCase("newBrowser")) {
            this.registerComponent(new GroupBrowser());
        }
        if (e.getActionCommand().equalsIgnoreCase("newSearch")) {
            this.registerComponent(new SearchModule());
        }
        if (e.getActionCommand().equalsIgnoreCase("tagManager")) {
            if (this.getComponentTypeCount(TagManager.class) > 0) {
                for (HIComponentFrame frame6 : this.components) {
                    if (!(frame6.getHIComponent() instanceof TagManager)) continue;
                    this.focusComponent(frame6);
                }
            } else {
                this.registerComponent(new TagManager());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("tagExplorer")) {
            if (this.getComponentTypeCount(TagExplorer.class) > 0) {
                for (HIComponentFrame frame7 : this.components) {
                    if (!(frame7.getHIComponent() instanceof TagExplorer)) continue;
                    this.focusComponent(frame7);
                }
            } else {
                this.registerComponent(new TagExplorer());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("nextWindow") && this.getFrontMostFrame() != null && this.components.size() > 0) {
            int index = this.components.indexOf(this.getFrontMostFrame());
            if (++index >= this.components.size()) {
                index = 0;
            }
            HIComponentFrame hIComponentFrame = this.components.get(index);
            this.focusComponent(hIComponentFrame);
        }
        if (e.getActionCommand().equalsIgnoreCase("previousWindow") && this.getFrontMostFrame() != null && this.components.size() > 0) {
            int index = this.components.indexOf(this.getFrontMostFrame());
            if (--index < 0) {
                index = this.components.size() - 1;
            }
            HIComponentFrame hIComponentFrame = this.components.get(index);
            this.focusComponent(hIComponentFrame);
        }
        if (e.getActionCommand().equalsIgnoreCase("toggleMetadata") && this.getFrontMostFrame() != null) {
            this.getFrontMostFrame().setMetadataVisible(!this.getFrontMostFrame().isMetadataVisible());
            this.setMenuState();
        }
        if (e.getActionCommand().startsWith("showComponent_")) {
            int index = Integer.parseInt(e.getActionCommand().substring(14));
            HIComponentFrame hIComponentFrame = this.components.get(index);
            this.focusComponent(hIComponentFrame);
            this.setMenuState();
        }
        if (e.getActionCommand().equalsIgnoreCase("visitWebsite")) {
            try {
                Desktop.getDesktop().browse(new URI("http://hyperimage.sourceforge.net/"));
            }
            catch (Exception e1) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.10"), String.valueOf(Messages.getString("HIClientGUI.14")) + "\n\n" + Messages.getString("HIClientGUI.21") + "\n" + "http://hyperimage.sourceforge.net/");
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("openHelp")) {
            try {
                Desktop.getDesktop().browse(new URI("http://manual.hyperimage.ws/"));
            }
            catch (Exception e1) {
                this.displayInfoDialog(Messages.getString("HIClientGUI.10"), String.valueOf(Messages.getString("HIClientGUI.14")) + "\n\n" + Messages.getString("HIClientGUI.21") + "\n" + "http://hyperimage.sourceforge.net/");
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("WS_TEST")) {
            System.out.println("starting tests...");
            this.startIndicatingServiceActivity();
            try {
                HiFlexMetadataTemplate template = null;
                for (HiFlexMetadataTemplate hiFlexMetadataTemplate : HIRuntime.getManager().getProject().getTemplates()) {
                    if (!hiFlexMetadataTemplate.getNamespacePrefix().startsWith("dc")) continue;
                    template = hiFlexMetadataTemplate;
                }
                if (template != null) {
                    void var3_28;
                    System.out.println("removing...");
                    Object var3_27 = null;
                    for (HiFlexMetadataSet hiFlexMetadataSet : template.getEntries()) {
                        if (!hiFlexMetadataSet.getTagname().equalsIgnoreCase("media")) continue;
                        HiFlexMetadataSet hiFlexMetadataSet2 = hiFlexMetadataSet;
                    }
                    if (var3_28 != null) {
                        HIRuntime.getManager().removeSetFromTemplate(template, (HiFlexMetadataSet)var3_28);
                    }
                }
            }
            catch (HIWebServiceException wse) {
                this.reportError(wse, null);
            }
            this.stopIndicatingServiceActivity();
            System.out.println("finished tests");
        }
        if (e.getActionCommand().equalsIgnoreCase("GTK")) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e1) {
                e1.printStackTrace();
            }
            SwingUtilities.updateComponentTreeUI(this);
        } else if (e.getActionCommand().equalsIgnoreCase("SYSTEM")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.displayUserYesNoDialog(Messages.getString("HIClientGUI.4"), Messages.getString("HIClientGUI.163"))) {
            this.tryLogoutAndExit();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        HIComponentFrame compFrame = (HIComponentFrame)e.getSource();
        if (!this.deregisterComponent(compFrame, false)) {
            return;
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        HIComponentFrame frame;
        this.frontFrame = frame = (HIComponentFrame)e.getSource();
        this.setMenuState();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (e.getComponent().getBounds().y < 0) {
            e.getComponent().setBounds(e.getComponent().getBounds().x, 0, e.getComponent().getBounds().width, e.getComponent().getBounds().height);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

