/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.components.HIComponentFrame;
import org.hyperimage.client.gui.HITextFieldControl;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.gui.dnd.GroupTransferable;
import org.hyperimage.client.gui.dnd.LayerTransferable;
import org.hyperimage.client.gui.dnd.ObjectContentTransferable;
import org.hyperimage.client.gui.dnd.QuickInfoTransferable;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.HIRichTextChunk;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiView;
import org.jdesktop.layout.GroupLayout;

public class HIRichTextFieldControl
extends HITextFieldControl
implements ActionListener,
CaretListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2129200508769763069L;
    final UndoManager undo = new UndoManager();
    private JToggleButton boldButton;
    private JToggleButton italicButton;
    private JToggleButton underlineButton;
    private JToggleButton regularButton;
    private JToggleButton subscriptButton;
    private JToggleButton superscriptButton;
    private JToggleButton literalButton;
    private ButtonGroup styleButtonGroup;
    private JButton linkButton;
    private JTextField linkField;
    private JPanel linkPanel;
    private JTextPane textPane;
    private JScrollPane textPaneScroll;
    private ImageIcon linkIcon;
    private String fieldTitle;
    private TitledBorder fieldBorder;
    private StyledDocument document;
    private Style regularStyle;
    private Style boldStyle;
    private Style italicStyle;
    private Style underlineStyle;
    private Style linkStyle;
    private Style subscriptStyle;
    private Style superscriptStyle;
    private Style literalStyle;
    private static final String LINK_TARGET_ATTR = "target";
    private int stylePos = 0;
    private JToggleButton buttonState;
    private Style styleState;
    private boolean isOnLink = false;

    public HIRichTextFieldControl(String fieldTitle) {
        this.fieldTitle = fieldTitle;
        this.initComponents();
        this.updateLanguage();
        LinkTransferHandler handler = new LinkTransferHandler();
        this.linkField.setTransferHandler(handler);
        this.textPane.setTransferHandler(handler);
        this.textPane.addMouseListener(this);
        this.textPane.addMouseMotionListener(this);
    }

    @Override
    public String getText() {
        HIRichText richText = new HIRichText();
        String linkTarget = null;
        String styleName = this.getCharacterStyleName(0);
        int startPos = 0;
        int endPos = 1;
        while (startPos < this.document.getLength()) {
            styleName = this.getCharacterStyleName(startPos);
            linkTarget = this.getCharacterLinkTarget(startPos);
            while (styleName.compareTo(this.getCharacterStyleName(endPos)) == 0 && linkTarget.compareTo(this.getCharacterLinkTarget(endPos)) == 0) {
                if (++endPos < this.document.getLength()) continue;
                endPos = this.document.getLength();
                break;
            }
            try {
                styleName = this.getCharacterStyleName(startPos);
                linkTarget = this.getCharacterLinkTarget(startPos);
                String text = this.document.getText(startPos, endPos - startPos);
                if (styleName.compareTo("bold") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.BOLD, text);
                } else if (styleName.compareTo("italic") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.ITALIC, text);
                } else if (styleName.compareTo("underline") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.UNDERLINE, text);
                } else if (styleName.compareTo("subscript") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.SUBSCRIPT, text);
                } else if (styleName.compareTo("superscript") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.SUPERSCRIPT, text);
                } else if (styleName.compareTo("literal") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.LITERAL, text);
                } else if (styleName.compareTo("link") == 0) {
                    richText.addChunk(HIRichTextChunk.chunkTypes.LINK, text, linkTarget);
                } else {
                    richText.addChunk(HIRichTextChunk.chunkTypes.REGULAR, text);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            startPos = endPos;
        }
        return richText.getModel();
    }

    @Override
    public void setText(String modelText) {
        HIRichText richText = new HIRichText(modelText);
        try {
            this.document.remove(0, this.document.getLength());
            for (HIRichTextChunk chunk : richText.getChunks()) {
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.BOLD) {
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.boldStyle);
                    continue;
                }
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.ITALIC) {
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.italicStyle);
                    continue;
                }
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.UNDERLINE) {
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.underlineStyle);
                    continue;
                }
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.SUBSCRIPT) {
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.subscriptStyle);
                    continue;
                }
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.SUPERSCRIPT) {
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.superscriptStyle);
                    continue;
                }
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.LITERAL) {
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.literalStyle);
                    continue;
                }
                if (chunk.getChunkType() == HIRichTextChunk.chunkTypes.LINK) {
                    int startPos = this.document.getLength();
                    this.document.insertString(this.document.getLength(), chunk.getValue(), this.regularStyle);
                    this.markAsLink(startPos, chunk.getValue().length(), chunk.getRef());
                    continue;
                }
                this.document.insertString(this.document.getLength(), chunk.getValue(), this.regularStyle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textPane.setCaretPosition(this.document.getLength());
    }

    @Override
    public void setEditable(boolean editable) {
        this.textPane.setEditable(editable);
        this.textPane.setEnabled(editable);
        this.linkField.setEnabled(editable);
        this.boldButton.setEnabled(editable);
        this.italicButton.setEnabled(editable);
        this.underlineButton.setEnabled(editable);
        this.subscriptButton.setEnabled(editable);
        this.superscriptButton.setEnabled(editable);
        this.literalButton.setEnabled(editable);
        if (editable) {
            this.linkField.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.linkField.setBorder(BorderFactory.createLineBorder(Color.gray));
        }
        if (!editable) {
            this.textPane.setText("");
            this.linkField.setText("");
            this.linkButton.setEnabled(false);
        }
    }

    @Override
    public void updateTitle(String title) {
        this.fieldBorder.setTitle(title);
        this.repaint();
        this.doLayout();
    }

    private void addUndoRedoAbility(JTextPane textPane, int modifierMask) {
        textPane.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                HIRichTextFieldControl.this.undo.addEdit(evt.getEdit());
            }
        });
        textPane.getActionMap().put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (HIRichTextFieldControl.this.undo.canUndo()) {
                        HIRichTextFieldControl.this.undo.undo();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textPane.getInputMap().put(KeyStroke.getKeyStroke(90, modifierMask), "Undo");
        textPane.getActionMap().put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (HIRichTextFieldControl.this.undo.canRedo()) {
                        HIRichTextFieldControl.this.undo.redo();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        textPane.getInputMap().put(KeyStroke.getKeyStroke(90, modifierMask + 1), "Redo");
    }

    private void updateStyleStateByName(String styleName) {
        this.buttonState = this.regularButton;
        this.styleState = this.regularStyle;
        if (styleName.compareTo("bold") == 0) {
            this.styleState = this.boldStyle;
            this.buttonState = this.boldButton;
        } else if (styleName.compareTo("italic") == 0) {
            this.styleState = this.italicStyle;
            this.buttonState = this.italicButton;
        } else if (styleName.compareTo("underline") == 0) {
            this.styleState = this.underlineStyle;
            this.buttonState = this.underlineButton;
        } else if (styleName.compareTo("subscript") == 0) {
            this.styleState = this.subscriptStyle;
            this.buttonState = this.subscriptButton;
        } else if (styleName.compareTo("superscript") == 0) {
            this.styleState = this.superscriptStyle;
            this.buttonState = this.superscriptButton;
        } else if (styleName.compareTo("literal") == 0) {
            this.styleState = this.literalStyle;
            this.buttonState = this.literalButton;
        } else {
            this.styleState = this.regularStyle;
            this.buttonState = this.regularButton;
        }
        this.buttonState.setSelected(true);
    }

    private void markAsLink(int startPos, int length, String linkTarget) {
        int i = startPos;
        while (i <= startPos + length) {
            if (this.getCharacterStyleName(i).compareTo("linkEmpty") == 0) {
                try {
                    this.document.remove(i, 1);
                    --length;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.linkStyle.addAttribute(LINK_TARGET_ATTR, linkTarget);
        this.document.setCharacterAttributes(startPos, length, this.linkStyle, true);
    }

    private void createLink(String altTitle, String targetID) {
        int selection = Math.abs(this.textPane.getSelectionEnd() - this.textPane.getSelectionStart());
        int startPos = Math.min(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd());
        if (selection != 0) {
            this.markAsLink(startPos, selection, targetID);
        } else {
            try {
                this.document.insertString(startPos, altTitle, this.regularStyle);
                this.markAsLink(startPos, altTitle.length(), targetID);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.textPane.requestFocus();
    }

    private String getCharacterStyleName(int pos) {
        return (String)this.document.getCharacterElement(pos).getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    private String getCharacterLinkTarget(int pos) {
        String linkTarget = (String)this.document.getCharacterElement(pos).getAttributes().getAttribute(LINK_TARGET_ATTR);
        if (linkTarget == null) {
            return "";
        }
        return linkTarget;
    }

    private int getLinkStartPos(int pos) {
        return this.getLinkStartPos(pos, this.getCharacterLinkTarget(pos));
    }

    private int getLinkStartPos(int pos, String linkTarget) {
        int startPos = pos;
        Element element = this.document.getCharacterElement(pos);
        startPos = this.getCharacterStyleName(pos).compareTo("link") == 0 && linkTarget.compareTo(this.getCharacterLinkTarget(pos)) == 0 ? (startPos > 0 ? this.getLinkStartPos(element.getStartOffset() - 1) : element.getStartOffset()) : ++startPos;
        return startPos;
    }

    private int getLinkEndPos(int pos) {
        return this.getLinkEndPos(pos, this.getCharacterLinkTarget(pos));
    }

    private int getLinkEndPos(int pos, String linkTarget) {
        int endPos = pos;
        Element element = this.document.getCharacterElement(pos);
        endPos = this.getCharacterStyleName(pos).compareTo("link") == 0 && linkTarget.compareTo(this.getCharacterLinkTarget(pos)) == 0 ? (endPos < this.document.getLength() ? this.getLinkEndPos(element.getEndOffset() + 1) : element.getEndOffset()) : --endPos;
        return endPos;
    }

    public void updateLanguage() {
        this.boldButton.setToolTipText(Messages.getString("HIRichTextFieldControl.BOLDTEXT"));
        this.italicButton.setToolTipText(Messages.getString("HIRichTextFieldControl.ITALICSTEXT"));
        this.underlineButton.setToolTipText(Messages.getString("HIRichTextFieldControl.UNDERLINEDTEXT"));
        this.subscriptButton.setToolTipText(Messages.getString("HIRichTextFieldControl.SUBSCRIPTTEXT"));
        this.superscriptButton.setToolTipText(Messages.getString("HIRichTextFieldControl.SUPERSCRIPTTEXT"));
        this.literalButton.setToolTipText(Messages.getString("HIRichTextFieldControl.LITERALTEXT"));
        this.linkButton.setToolTipText(Messages.getString("HIRichTextFieldControl.REMOVELINK"));
    }

    private void initComponents() {
        this.styleButtonGroup = new ButtonGroup();
        this.boldButton = new JToggleButton();
        this.italicButton = new JToggleButton();
        this.underlineButton = new JToggleButton();
        this.subscriptButton = new JToggleButton();
        this.superscriptButton = new JToggleButton();
        this.literalButton = new JToggleButton();
        this.regularButton = new JToggleButton();
        this.textPaneScroll = new JScrollPane();
        this.textPane = new JTextPane();
        this.linkPanel = new JPanel();
        this.linkField = new JTextField();
        this.linkButton = new JButton();
        this.linkIcon = new ImageIcon(this.getClass().getResource("/resources/icons/link.png"));
        this.buttonState = this.regularButton;
        ((AbstractDocument)this.textPane.getDocument()).setDocumentFilter(new HIRichDocumentFilter());
        InputMap inputMap = this.textPane.getInputMap();
        ActionMap actionMap = this.textPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(66, HIRuntime.getModifierKey()), "SET_BOLD");
        actionMap.put("SET_BOLD", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRichTextFieldControl.this.doStyleAction(HIRichTextFieldControl.this.boldButton);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(73, HIRuntime.getModifierKey()), "SET_ITALIC");
        actionMap.put("SET_ITALIC", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRichTextFieldControl.this.doStyleAction(HIRichTextFieldControl.this.italicButton);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(85, HIRuntime.getModifierKey()), "SET_UNDERLINE");
        actionMap.put("SET_UNDERLINE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HIRichTextFieldControl.this.doStyleAction(HIRichTextFieldControl.this.underlineButton);
            }
        });
        this.addUndoRedoAbility(this.textPane, HIRuntime.getModifierKey());
        this.boldButton.setActionCommand("group_boldButton");
        this.boldButton.addActionListener(this);
        this.italicButton.setActionCommand("group_italicButton");
        this.italicButton.addActionListener(this);
        this.underlineButton.setActionCommand("group_underlineButton");
        this.underlineButton.addActionListener(this);
        this.subscriptButton.setActionCommand("group_subscriptButton");
        this.subscriptButton.addActionListener(this);
        this.superscriptButton.setActionCommand("group_superscriptButton");
        this.superscriptButton.addActionListener(this);
        this.literalButton.setActionCommand("group_literalButton");
        this.literalButton.addActionListener(this);
        this.linkButton.addActionListener(this);
        this.linkButton.setActionCommand("removeLink");
        this.regularButton.setActionCommand("group_regularButton");
        this.textPane.addCaretListener(this);
        this.fieldBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.fieldTitle);
        this.setBorder(this.fieldBorder);
        this.styleButtonGroup.add(this.boldButton);
        this.boldButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/bold.png")));
        this.boldButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/bold-active.png")));
        this.boldButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/bold-disabled.png")));
        this.boldButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.boldButton.setPreferredSize(new Dimension(24, 24));
        this.styleButtonGroup.add(this.italicButton);
        this.italicButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/italic.png")));
        this.italicButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/italic-active.png")));
        this.italicButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/italic-disabled.png")));
        this.italicButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.italicButton.setPreferredSize(new Dimension(24, 24));
        this.styleButtonGroup.add(this.underlineButton);
        this.underlineButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/underline.png")));
        this.underlineButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/underline-active.png")));
        this.underlineButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/underline-disabled.png")));
        this.underlineButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.underlineButton.setPreferredSize(new Dimension(24, 24));
        this.styleButtonGroup.add(this.subscriptButton);
        this.subscriptButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/subscript.png")));
        this.subscriptButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/subscript-active.png")));
        this.subscriptButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/subscript-disabled.png")));
        this.subscriptButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.subscriptButton.setPreferredSize(new Dimension(24, 24));
        this.styleButtonGroup.add(this.superscriptButton);
        this.superscriptButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/superscript.png")));
        this.superscriptButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/superscript-active.png")));
        this.superscriptButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/superscript-disabled.png")));
        this.superscriptButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.superscriptButton.setPreferredSize(new Dimension(24, 24));
        this.styleButtonGroup.add(this.literalButton);
        this.literalButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/literal.png")));
        this.literalButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/literal-active.png")));
        this.literalButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/literal-disabled.png")));
        this.literalButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.literalButton.setPreferredSize(new Dimension(24, 24));
        this.styleButtonGroup.add(this.regularButton);
        this.textPane.setBackground(Color.white);
        this.textPaneScroll.setViewportView(this.textPane);
        this.linkField.setEditable(false);
        this.linkField.setBorder(BorderFactory.createLineBorder(Color.black));
        this.linkField.setPreferredSize(new Dimension(200, 24));
        this.linkButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/removeLink.png")));
        this.linkButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/icons/removeLink-active.png")));
        this.linkButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/resources/icons/removeLink-disabled.png")));
        this.linkButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.linkButton.setPreferredSize(new Dimension(24, 24));
        this.linkButton.setEnabled(false);
        GroupLayout linkPanelLayout = new GroupLayout(this.linkPanel);
        this.linkPanel.setLayout(linkPanelLayout);
        linkPanelLayout.setHorizontalGroup(linkPanelLayout.createParallelGroup(1).add(linkPanelLayout.createSequentialGroup().addContainerGap().add(this.linkButton, -2, -1, -2).addPreferredGap(0).add(this.linkField, -1, 254, Short.MAX_VALUE).addContainerGap()));
        linkPanelLayout.setVerticalGroup(linkPanelLayout.createParallelGroup(1).add(linkPanelLayout.createParallelGroup(3).add(this.linkButton, -2, -1, -2).add(this.linkField, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(6, 6, 6).add(layout.createParallelGroup(1).add(this.boldButton, -2, -1, -2).add(this.italicButton, -2, -1, -2).add(this.subscriptButton, -2, -1, -2).add(this.superscriptButton, -2, -1, -2).add(this.underlineButton, -2, -1, -2).add(this.literalButton, -2, -1, -2)).addPreferredGap(0).add(this.textPaneScroll).addContainerGap()).add(2, this.linkPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.boldButton, -2, -1, -2).add(0, 0, 0).add(this.italicButton, -2, -1, -2).add(0, 0, 0).add(this.underlineButton, -2, -1, -2).add(4, 4, 4).add(this.superscriptButton, -2, -1, -2).add(0, 0, 0).add(this.subscriptButton, -2, -1, -2).add(4, 4, 4).add(this.literalButton, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add(this.textPaneScroll)).addPreferredGap(0).add(this.linkPanel, -2, -1, -2).addContainerGap()));
        if (System.getProperty("HI.feature.advancedEditorDisabled") != null) {
            this.subscriptButton.setVisible(false);
            this.superscriptButton.setVisible(false);
            this.literalButton.setVisible(false);
        }
        this.initStyles();
    }

    private void initStyles() {
        this.document = this.textPane.getStyledDocument();
        StyleContext styleContext = new StyleContext();
        this.regularStyle = this.document.addStyle("regular", styleContext.getStyle("default"));
        this.document.setLogicalStyle(0, this.regularStyle);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (Arrays.asList(fonts).contains("Aegyptus")) {
            StyleConstants.setFontFamily(this.regularStyle, "Aegyptus");
            StyleConstants.setFontSize(this.regularStyle, 16);
        } else {
            StyleConstants.setFontFamily(this.regularStyle, "SansSerif");
        }
        StyleConstants.setBold(this.regularStyle, false);
        StyleConstants.setItalic(this.regularStyle, false);
        StyleConstants.setUnderline(this.regularStyle, false);
        StyleConstants.setSubscript(this.regularStyle, false);
        StyleConstants.setSuperscript(this.regularStyle, false);
        this.boldStyle = this.document.addStyle("bold", null);
        StyleConstants.setBold(this.boldStyle, true);
        StyleConstants.setItalic(this.boldStyle, false);
        StyleConstants.setUnderline(this.boldStyle, false);
        StyleConstants.setSubscript(this.boldStyle, false);
        StyleConstants.setSuperscript(this.boldStyle, false);
        this.italicStyle = this.document.addStyle("italic", null);
        StyleConstants.setItalic(this.italicStyle, true);
        StyleConstants.setBold(this.italicStyle, false);
        StyleConstants.setUnderline(this.italicStyle, false);
        StyleConstants.setSubscript(this.italicStyle, false);
        StyleConstants.setSuperscript(this.italicStyle, false);
        this.underlineStyle = this.document.addStyle("underline", null);
        StyleConstants.setItalic(this.underlineStyle, false);
        StyleConstants.setBold(this.underlineStyle, false);
        StyleConstants.setUnderline(this.underlineStyle, true);
        StyleConstants.setSubscript(this.underlineStyle, false);
        StyleConstants.setSuperscript(this.underlineStyle, false);
        this.subscriptStyle = this.document.addStyle("subscript", null);
        StyleConstants.setItalic(this.subscriptStyle, false);
        StyleConstants.setBold(this.subscriptStyle, false);
        StyleConstants.setUnderline(this.subscriptStyle, false);
        StyleConstants.setSubscript(this.subscriptStyle, true);
        StyleConstants.setSuperscript(this.subscriptStyle, false);
        this.superscriptStyle = this.document.addStyle("superscript", null);
        StyleConstants.setItalic(this.superscriptStyle, false);
        StyleConstants.setBold(this.superscriptStyle, false);
        StyleConstants.setUnderline(this.superscriptStyle, false);
        StyleConstants.setSubscript(this.superscriptStyle, false);
        StyleConstants.setSuperscript(this.superscriptStyle, true);
        this.literalStyle = this.document.addStyle("literal", null);
        StyleConstants.setItalic(this.literalStyle, false);
        StyleConstants.setBold(this.literalStyle, true);
        StyleConstants.setUnderline(this.literalStyle, false);
        StyleConstants.setSubscript(this.literalStyle, false);
        StyleConstants.setSuperscript(this.literalStyle, false);
        StyleConstants.setBackground(this.literalStyle, new Color(240, 240, 240));
        StyleConstants.setFontFamily(this.literalStyle, "monospaced");
        StyleConstants.setForeground(this.literalStyle, new Color(38, 115, 4));
        this.linkStyle = this.document.addStyle("link", null);
        StyleConstants.setUnderline(this.linkStyle, true);
        StyleConstants.setForeground(this.linkStyle, Color.BLUE);
        StyleConstants.setSubscript(this.linkStyle, false);
        StyleConstants.setSuperscript(this.linkStyle, false);
        this.styleState = this.regularStyle;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selection = Math.abs(this.textPane.getSelectionEnd() - this.textPane.getSelectionStart());
        int startPos = Math.min(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd());
        if (e.getActionCommand().startsWith("group_")) {
            this.doStyleAction((JToggleButton)e.getSource());
        } else if (e.getActionCommand().equalsIgnoreCase("removeLink") && this.linkField.getText().length() > 0) {
            startPos = this.getLinkStartPos(this.stylePos);
            selection = this.getLinkEndPos(this.stylePos) - startPos;
            this.document.setCharacterAttributes(startPos, selection, this.regularStyle, true);
            this.textPane.setSelectionStart(startPos);
            this.textPane.setSelectionEnd(startPos + selection);
            this.textPane.requestFocus();
        }
    }

    private void doStyleAction(JToggleButton source) {
        int selection = Math.abs(this.textPane.getSelectionEnd() - this.textPane.getSelectionStart());
        int startPos = Math.min(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd());
        if (source == this.buttonState) {
            this.updateStyleStateByName("regular");
        } else if (source == this.boldButton) {
            this.updateStyleStateByName("bold");
        } else if (source == this.italicButton) {
            this.updateStyleStateByName("italic");
        } else if (source == this.underlineButton) {
            this.updateStyleStateByName("underline");
        } else if (source == this.subscriptButton) {
            this.updateStyleStateByName("subscript");
        } else if (source == this.superscriptButton) {
            this.updateStyleStateByName("superscript");
        } else if (source == this.literalButton) {
            this.updateStyleStateByName("literal");
        } else {
            this.updateStyleStateByName("regular");
        }
        if (selection != 0) {
            this.document.setCharacterAttributes(startPos, selection, this.styleState, true);
        }
        if (this.textPane.getCaretPosition() == this.textPane.getText().length() && this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == 0 && this.getCharacterStyleName(this.textPane.getCaretPosition() - 1).compareTo("link") == 0) {
            this.updateStyleStateByName("regular");
            try {
                this.document.insertString(this.textPane.getCaretPosition(), " ", this.regularStyle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.textPane.requestFocus();
    }

    private void updateCaretGUI(int dot, int mark) {
        String styleName;
        int selection = Math.abs(mark - dot);
        int startPos = Math.min(dot, mark);
        int stopPos = startPos + selection;
        if (selection == 0) {
            styleName = this.getCharacterStyleName(startPos - 1);
            this.stylePos = startPos - 1;
            this.updateStyleStateByName(styleName);
        } else {
            styleName = this.getCharacterStyleName(startPos);
            this.stylePos = startPos;
            int i = startPos;
            while (i < stopPos) {
                if (this.getCharacterStyleName(i) != styleName) {
                    this.updateStyleStateByName("regular");
                    return;
                }
                ++i;
            }
            this.updateStyleStateByName(styleName);
        }
        this.isOnLink = false;
        if (styleName.startsWith("link")) {
            this.isOnLink = true;
            if (selection == 0) {
                --startPos;
            }
            this.linkField.setText(this.getCharacterLinkTarget(startPos));
        } else {
            this.linkField.setText("");
        }
        this.setLinkState();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateCaretGUI(e.getDot(), e.getMark());
    }

    private void setLinkState() {
        boolean enabled = true;
        if (this.linkField.getText().length() == 0) {
            if (!this.isOnLink) {
                enabled = false;
            } else if (!this.isOnLink && this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == 0) {
                enabled = false;
            }
        }
        this.linkButton.setEnabled(enabled);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int pos = this.textPane.viewToModel(e.getPoint());
        if (e.getButton() == 1 && e.getClickCount() == 2 && this.linkButton.isEnabled() && this.getCharacterStyleName(pos).startsWith("link")) {
            try {
                long linkID = Long.parseLong(this.getCharacterLinkTarget(pos).substring(1));
                HIRuntime.getGui().openContentEditor(linkID, null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getCharacterStyleName(this.textPane.viewToModel(e.getPoint())).startsWith("link")) {
            this.textPane.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.textPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    class HIRichDocumentFilter
    extends DocumentFilter {
        HIRichDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(fb, offs, str, a);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            AttributeSet as = HIRichTextFieldControl.this.document.getCharacterElement(offset - 1).getAttributes();
            if (HIRichTextFieldControl.this.getCharacterStyleName(offset - 1).compareTo("linkEmpty") == 0 && as.containsAttribute(StyleConstants.IconAttribute, HIRichTextFieldControl.this.linkIcon) && offset > 0) {
                HIRichTextFieldControl.this.linkStyle.addAttribute(HIRichTextFieldControl.LINK_TARGET_ATTR, HIRichTextFieldControl.this.getCharacterLinkTarget(offset - 1));
                HIRichTextFieldControl.this.document.remove(offset - 1, 1);
                super.replace(fb, offset - 1, length, text, HIRichTextFieldControl.this.linkStyle);
                return;
            }
            if (HIRichTextFieldControl.this.textPane.getSelectionEnd() - HIRichTextFieldControl.this.textPane.getSelectionStart() == 0 && !HIRichTextFieldControl.this.getCharacterStyleName(offset - 1).startsWith("link")) {
                super.replace(fb, offset, length, text, HIRichTextFieldControl.this.styleState);
            } else {
                super.replace(fb, offset, length, text, attrs);
            }
        }
    }

    public class LinkTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1392755235239308382L;

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new StringSelection(HIRichTextFieldControl.this.textPane.getSelectedText());
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int action) {
            if (action == 0 && HIRichTextFieldControl.this.getRootPane().getParent() instanceof HIComponentFrame) {
                HIRuntime.getGui().focusComponent((HIComponentFrame)HIRichTextFieldControl.this.getRootPane().getParent());
            }
            if (action == 2) {
                HIRichTextFieldControl.this.textPane.replaceSelection("");
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport supp) {
            if (HIRichTextFieldControl.this.getRootPane().getParent() instanceof HIComponentFrame) {
                HIRuntime.getGui().focusComponent((HIComponentFrame)HIRichTextFieldControl.this.getRootPane().getParent());
            }
            boolean isLink = false;
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor) || supp.isDataFlavorSupported(LayerTransferable.layerFlavor) || supp.isDataFlavorSupported(GroupTransferable.groupFlavor) || supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                isLink = true;
            }
            if (!isLink && !supp.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            if (!HIRichTextFieldControl.this.textPane.isEditable() || !HIRichTextFieldControl.this.textPane.isEnabled()) {
                return false;
            }
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                try {
                    HiGroup group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group.getType() != GroupTypes.HIGROUP_REGULAR) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (isLink) {
                supp.setDropAction(0x40000000);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport supp) {
            if (!this.canImport(supp)) {
                return false;
            }
            if (!HIRichTextFieldControl.this.textPane.isEditable() || !HIRichTextFieldControl.this.textPane.isEnabled()) {
                return false;
            }
            String targetID = null;
            String altTitle = null;
            if (supp.isDataFlavorSupported(GroupTransferable.groupFlavor)) {
                HiGroup group;
                block35: {
                    group = (HiGroup)supp.getTransferable().getTransferData(GroupTransferable.groupFlavor);
                    if (group != null) break block35;
                    return false;
                }
                try {
                    targetID = group.getUUID();
                    altTitle = String.valueOf(Messages.getString("HIRichTextFieldControl.LINKTO")) + (String)supp.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    supp.setDropAction(0x40000000);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(LayerTransferable.layerFlavor)) {
                HILayer layer;
                block36: {
                    layer = (HILayer)supp.getTransferable().getTransferData(LayerTransferable.layerFlavor);
                    if (layer != null) break block36;
                    return false;
                }
                try {
                    targetID = layer.getModel().getUUID();
                    altTitle = String.valueOf(Messages.getString("HIRichTextFieldControl.LINKTO")) + (String)supp.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    supp.setDropAction(0x40000000);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(ObjectContentTransferable.objecContentFlavor)) {
                HiObjectContent content;
                block37: {
                    content = (HiObjectContent)supp.getTransferable().getTransferData(ObjectContentTransferable.objecContentFlavor);
                    if (content != null) break block37;
                    return false;
                }
                try {
                    targetID = content instanceof HiView ? content.getUUID() : content.getUUID();
                    altTitle = String.valueOf(Messages.getString("HIRichTextFieldControl.LINKTO")) + (String)supp.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    supp.setDropAction(0x40000000);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (supp.isDataFlavorSupported(QuickInfoTransferable.quickInfoFlavor)) {
                ContentTransfer transfer;
                block39: {
                    block38: {
                        transfer = (ContentTransfer)supp.getTransferable().getTransferData(QuickInfoTransferable.quickInfoFlavor);
                        if (transfer != null) break block38;
                        return false;
                    }
                    if (transfer.getContents().size() == 1) break block39;
                    return false;
                }
                try {
                    targetID = transfer.getContents().get(0).getUUID();
                    altTitle = String.valueOf(Messages.getString("HIRichTextFieldControl.LINKTO")) + (String)supp.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    supp.setDropAction(0x40000000);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (targetID != null) {
                supp.setDropAction(0x40000000);
            }
            if (targetID == null && supp.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    altTitle = (String)supp.getTransferable().getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (targetID == null && altTitle == null) {
                return false;
            }
            if (targetID != null) {
                if (altTitle == null) {
                    altTitle = Messages.getString("HIRichTextFieldControl.LINK");
                }
                HIRichTextFieldControl.this.createLink(altTitle, targetID);
                int selection = Math.abs(HIRichTextFieldControl.this.textPane.getSelectionEnd() - HIRichTextFieldControl.this.textPane.getSelectionStart());
                int startPos = Math.min(HIRichTextFieldControl.this.textPane.getSelectionStart(), HIRichTextFieldControl.this.textPane.getSelectionEnd());
                if (selection == 0) {
                    selection = altTitle.length();
                    startPos -= selection;
                }
                HIRichTextFieldControl.this.textPane.setSelectionStart(startPos);
                HIRichTextFieldControl.this.textPane.setSelectionEnd(startPos + selection);
                HIRichTextFieldControl.this.updateCaretGUI(startPos, startPos + selection);
            } else {
                int startPos = Math.min(HIRichTextFieldControl.this.textPane.getSelectionStart(), HIRichTextFieldControl.this.textPane.getSelectionEnd());
                try {
                    HIRichTextFieldControl.this.document.insertString(startPos, altTitle, HIRichTextFieldControl.this.regularStyle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

