/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import com.sun.media.jai.widget.DisplayJAI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.List;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.ImageHelper;
import org.hyperimage.client.util.LoadableImage;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiLayer;

public class LayerViewerControl
extends DisplayJAI
implements LoadableImage,
HierarchyBoundsListener {
    private static final long serialVersionUID = -8628438088116965512L;
    private boolean needsPreview = true;
    private boolean displayLayers = false;
    private List<HiLayer> modelLayers;
    private Vector<HILayer> layers = new Vector();
    private HILayer activeLayer = null;
    private HILayer selectedLayer = null;
    private PlanarImage image = null;
    private static final BasicStroke solidStroke = new BasicStroke(1.0f);
    private GeneralPath combinedPath;
    private float curScale = 1.0f;
    private boolean isDragAndDrop = false;
    JPopupMenu popupMenu;
    JMenuItem titleMenuItem;
    JMenuItem visitLinkMenuItem;
    JMenuItem editLayerMenuItem;
    JSeparator separator;
    JMenuItem removeLinkMenuItem;

    public LayerViewerControl() {
        this.addMouseMotionListener(this);
        this.set(JAI.create("url", this.getClass().getResource("/resources/hyperimage-preview_loading.png")));
        this.initMenus();
        this.updateLanguage();
        this.addHierarchyBoundsListener(this);
        this.addMouseListener(this);
    }

    public void setPreviewLoading() {
        this.needsPreview = true;
    }

    public void updateLanguage() {
        this.visitLinkMenuItem.setText(Messages.getString("LayerViewerControl.18"));
        this.editLayerMenuItem.setText(Messages.getString("LayerViewerControl.20"));
        this.removeLinkMenuItem.setText(Messages.getString("LayerViewerControl.22"));
    }

    public void initLayers(List<HiLayer> modelLayers, String sortOrder) {
        int scaleX = 400;
        int scaleY = 400;
        this.modelLayers = modelLayers;
        this.layers.removeAllElements();
        this.combinedPath = new GeneralPath();
        this.combinedPath.setWindingRule(0);
        for (HiLayer modelLayer : this.modelLayers) {
            this.layers.add(new HILayer(modelLayer, scaleX, scaleY));
        }
        this.sortLayers(sortOrder);
        if (this.needsPreview()) {
            this.displayLayers = false;
            this.set(JAI.create("url", this.getClass().getResource("/resources/hyperimage-preview_loading.png")));
        } else {
            this.scalePreviewImage();
        }
    }

    public HILayer getActiveLayer() {
        if (this.displayLayers) {
            return this.activeLayer;
        }
        return null;
    }

    public HILayer getSelectedLayer() {
        if (this.displayLayers) {
            return this.selectedLayer;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.displayLayers) {
            Graphics2D g2d = (Graphics2D)g;
            int count = this.layers.size() - 1;
            while (count >= 0) {
                HILayer layer = this.layers.get(count);
                this.combinedPath.reset();
                for (RelativePolygon polygon : layer.getRelativePolygons()) {
                    if (!polygon.isClosed()) continue;
                    this.combinedPath.append(polygon.getPolygonPath(), false);
                }
                if (layer == this.activeLayer) {
                    int opacity = layer.getColour().getAlpha() + 100;
                    if (opacity > 255) {
                        opacity = 255;
                    }
                    opacity = 255;
                    Color selColor = new Color(layer.getColour().getRed(), layer.getColour().getGreen(), layer.getColour().getBlue(), opacity);
                    g2d.setColor(selColor);
                } else {
                    g2d.setColor(layer.getColour());
                }
                g2d.fill(this.combinedPath);
                for (RelativePolygon polygon : layer.getRelativePolygons()) {
                    g2d.setStroke(solidStroke);
                    if (layer == this.activeLayer) {
                        if (this.isDragAndDrop) {
                            g2d.setColor(Color.white);
                        } else {
                            g2d.setColor(Color.black);
                        }
                    } else {
                        g2d.setColor(layer.getColour().darker());
                    }
                    g2d.draw(polygon.getPolygonPath());
                }
                --count;
            }
        }
    }

    @Override
    public boolean needsPreview() {
        return this.needsPreview;
    }

    @Override
    public void setPreviewImage(PlanarImage image) {
        if (image != null) {
            this.set(image);
            this.image = image;
            this.curScale = 1.0f;
            this.displayLayers = true;
            this.needsPreview = false;
            this.updateScale();
        } else {
            RenderedOp errorImage = JAI.create("url", this.getClass().getResource("/resources/icons/preview-loaderror.png"));
            this.set(errorImage);
            this.needsPreview = false;
        }
    }

    public void attachActionListener(ActionListener listener) {
        this.visitLinkMenuItem.addActionListener(listener);
        this.editLayerMenuItem.addActionListener(listener);
        this.removeLinkMenuItem.addActionListener(listener);
    }

    private void showPopupMenu(int x, int y) {
        if (this.displayLayers) {
            this.setMenuState();
            this.popupMenu.show(this, x, y);
        }
    }

    private void setMenuState() {
        String title = "";
        if (this.activeLayer != null && ((title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)this.activeLayer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()))) == null || title.length() == 0)) {
            title = "L" + this.activeLayer.getModel().getId();
        }
        if (this.activeLayer == null || this.activeLayer.getModel().getLinkInfo() == null) {
            this.visitLinkMenuItem.setVisible(false);
            this.editLayerMenuItem.setVisible(this.activeLayer != null);
            this.editLayerMenuItem.setEnabled(HIRuntime.getGui().checkEditAbility(true));
            this.removeLinkMenuItem.setVisible(false);
            this.separator.setVisible(false);
            if (this.activeLayer == null) {
                this.titleMenuItem.setText(Messages.getString("LayerViewerControl.10"));
            } else {
                this.titleMenuItem.setText(String.valueOf(Messages.getString("LayerViewerControl.11")) + " \"" + title + "\" " + Messages.getString("LayerViewerControl.14"));
            }
        } else {
            this.titleMenuItem.setText(String.valueOf(Messages.getString("LayerViewerControl.15")) + " \"" + title + "\"");
            this.visitLinkMenuItem.setVisible(true);
            this.editLayerMenuItem.setEnabled(true);
            this.editLayerMenuItem.setVisible(this.activeLayer != null);
            this.editLayerMenuItem.setEnabled(HIRuntime.getGui().checkEditAbility(true));
            this.removeLinkMenuItem.setVisible(true);
            this.removeLinkMenuItem.setEnabled(HIRuntime.getGui().checkEditAbility(true));
            this.separator.setVisible(true);
        }
    }

    private void initMenus() {
        this.popupMenu = new JPopupMenu();
        this.titleMenuItem = new JMenuItem();
        this.titleMenuItem.setEnabled(false);
        this.popupMenu.add(this.titleMenuItem);
        this.popupMenu.add(new JSeparator());
        this.visitLinkMenuItem = new JMenuItem();
        this.visitLinkMenuItem.setActionCommand("openLinkTarget");
        this.popupMenu.add(this.visitLinkMenuItem);
        this.editLayerMenuItem = new JMenuItem();
        this.editLayerMenuItem.setActionCommand("editLayer");
        this.popupMenu.add(this.editLayerMenuItem);
        this.separator = new JSeparator();
        this.popupMenu.add(this.separator);
        this.removeLinkMenuItem = new JMenuItem();
        this.removeLinkMenuItem.setActionCommand("removeLink");
        this.popupMenu.add(this.removeLinkMenuItem);
    }

    private void sortLayers(String sortOrder) {
        int index = 0;
        String[] stringArray = sortOrder.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentIDString = stringArray[n2];
            try {
                long layerID = Long.parseLong(contentIDString);
                int contentIndex = -1;
                int i = 0;
                while (i < this.layers.size()) {
                    if (this.layers.get(i).getModel().getId() == layerID) {
                        contentIndex = i;
                    }
                    ++i;
                }
                if (contentIndex >= 0) {
                    if (contentIndex != index) {
                        HILayer layer = this.layers.get(contentIndex);
                        this.layers.remove(contentIndex);
                        this.layers.add(index, layer);
                        ++index;
                    } else {
                        ++index;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private void scalePreviewImage() {
        if (this.displayLayers) {
            PlanarImage scaledImage = ImageHelper.scaleImageTo(this.image, (double)this.curScale);
            this.set(scaledImage);
            for (HILayer layer : this.layers) {
                layer.setScale(scaledImage.getWidth(), scaledImage.getHeight());
            }
        }
    }

    private void setViewingState(int x, int y, boolean isDragAndDrop) {
        if (this.popupMenu.isVisible()) {
            return;
        }
        HILayer oldLayerState = this.activeLayer;
        this.isDragAndDrop = isDragAndDrop;
        this.activeLayer = null;
        int count = this.layers.size() - 1;
        while (count >= 0) {
            HILayer layer = this.layers.get(count);
            for (RelativePolygon polygon : layer.getRelativePolygons()) {
                if (!polygon.getPolygonPath().contains(x, y)) continue;
                this.activeLayer = layer;
            }
            --count;
        }
        if (oldLayerState != this.activeLayer) {
            if (!isDragAndDrop) {
                if (this.activeLayer != null && this.activeLayer.getModel().getLinkInfo() != null) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            if (this.activeLayer == null) {
                this.setToolTipText("");
            } else {
                String infoText = "";
                infoText = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)this.activeLayer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
                if (infoText == null || infoText.length() == 0) {
                    infoText = "L" + this.activeLayer.getModel().getId();
                }
                String comment = new HIRichText(MetadataHelper.findValue("HIBase", "comment", MetadataHelper.getDefaultMetadataRecord((HiBase)this.activeLayer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()))).getHTMLModel();
                comment = comment.replaceAll("<[/]?html>", "");
                infoText = "<html><b>" + Messages.getString("LayerViewerControl.0") + ": " + infoText + "</b><br><br>" + comment + "</html>";
                this.setToolTipText(infoText);
            }
            this.repaint();
        }
    }

    public void setState(int x, int y) {
        this.setViewingState(x, y, true);
    }

    private void updateScale() {
        int scale;
        int width = this.getSize().width;
        int height = this.getSize().height;
        int max = Math.max(this.image.getWidth(), this.image.getHeight());
        float relScale = (float)(max + (scale = Math.min(width - this.image.getWidth(), height - this.image.getHeight()))) / (float)max;
        if (relScale != this.curScale) {
            this.curScale = relScale;
            this.scalePreviewImage();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setViewingState(e.getX(), e.getY(), false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setViewingState(e.getX(), e.getY(), false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.popupMenu.isVisible()) {
            return;
        }
        this.activeLayer = null;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setViewingState(e.getX(), e.getY(), false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setViewingState(e.getX(), e.getY(), false);
        if (e.getSource() == this && e.isPopupTrigger() && !e.isConsumed()) {
            e.consume();
            this.selectedLayer = this.activeLayer;
            this.showPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setViewingState(e.getX(), e.getY(), false);
        if (e.getSource() == this && e.isPopupTrigger() && !e.isConsumed()) {
            e.consume();
            this.selectedLayer = this.activeLayer;
            this.showPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void ancestorMoved(HierarchyEvent e) {
    }

    @Override
    public void ancestorResized(HierarchyEvent e) {
        if (this.displayLayers) {
            this.updateScale();
        }
    }
}

