/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.HIRichTextFieldControl;
import org.hyperimage.client.gui.JEnrichedTextField;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.gui.TagsButton;
import org.hyperimage.client.gui.dialogs.HIBaseTagsEditorDialog;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.jdesktop.layout.GroupLayout;

public class MetadataEditorControl
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5224350099908280006L;
    private HIRichTextFieldControl annotationRichTextControl;
    private JComboBox languageComboBox;
    private JLabel languageLabel;
    private JTextField sourceField;
    private JPanel sourcePanel;
    private JEnrichedTextField titleField;
    private JPanel titlePanel;
    private JPanel metadataPanel;
    private TitledBorder metadataBorder = null;
    private TitledBorder titleBorder = null;
    private TitledBorder sourceBorder = null;
    private JPanel controlPanel;
    private ResetButton resetButton;
    private SaveButton saveButton;
    private TagsButton tagsButton;
    private JLabel idLabel;
    private String titleKey;
    private String sourceKey;
    private String contentKey;
    private String titleName;
    private String sourceName;
    private String contentName;
    private boolean titleEnabled = true;
    private boolean sourceEnabled = true;
    private boolean contentEnabled = true;
    private boolean tagsEnabled = true;
    private List<HiFlexMetadataRecord> metadata;
    private String defLang;
    private Vector<String> languageKeys;
    private long baseID;
    private Vector<String> titleMetadata = new Vector();
    private Vector<String> sourceMetadata = new Vector();
    private Vector<String> contentMetadata = new Vector();
    private int curLangIndex = 0;
    private int defLangIndex = 0;
    private boolean hasChanges = false;

    public MetadataEditorControl(String titleKey, String titleName, String sourceKey, String sourceName, String contentKey, String contentName) {
        this(titleKey, titleName, sourceKey, sourceName, contentKey, contentName, true);
    }

    public MetadataEditorControl(String titleKey, String titleName, String sourceKey, String sourceName, String contentKey, String contentName, boolean tagsEnabled) {
        this.titleKey = titleKey;
        this.titleName = titleName;
        this.sourceKey = sourceKey;
        this.sourceName = sourceName;
        this.contentKey = contentKey;
        this.contentName = contentName;
        this.tagsEnabled = tagsEnabled;
        this.languageKeys = new Vector();
        this.initComponents();
        if (titleKey == null) {
            this.titleEnabled = false;
        }
        this.titlePanel.setVisible(this.titleEnabled);
        if (sourceKey == null) {
            this.sourceEnabled = false;
        }
        this.sourcePanel.setVisible(this.sourceEnabled);
        if (contentKey == null) {
            this.contentEnabled = false;
        }
        this.annotationRichTextControl.setVisible(this.contentEnabled);
    }

    public void updateLanguage(String titleName, String sourceName, String contentName) {
        this.metadataBorder.setTitle(Messages.getString("MetadataEditorControl.16"));
        this.metadataPanel.repaint();
        this.languageLabel.setText(Messages.getString("MetadataEditorControl.18"));
        if (this.titleEnabled) {
            this.titleBorder.setTitle(titleName);
        }
        if (this.sourceEnabled) {
            this.sourceBorder.setTitle(sourceName);
        }
        this.annotationRichTextControl.updateTitle(contentName);
        this.annotationRichTextControl.updateLanguage();
        this.saveButton.setToolTipText(Messages.getString("MetadataEditorControl.1"));
        this.resetButton.setToolTipText(Messages.getString("MetadataEditorControl.2"));
        this.tagsButton.setToolTipText(Messages.getString("MetadataEditorControl.tagButtonTooltip"));
        this.buildLanguages();
    }

    public void setBaseID(long baseID) {
        this.baseID = baseID;
    }

    public void setTagCount(long count) {
        this.tagsButton.setCount((int)count);
    }

    public void setMetadata(List<HiFlexMetadataRecord> metadata, String defLang) {
        this.metadata = metadata;
        this.defLang = defLang;
        this.buildLanguages();
        this.titleMetadata.removeAllElements();
        this.sourceMetadata.removeAllElements();
        this.contentMetadata.removeAllElements();
        for (String lang : this.languageKeys) {
            if (this.titleEnabled) {
                this.titleMetadata.addElement(MetadataHelper.findValue("HIBase", this.titleKey, MetadataHelper.getDefaultMetadataRecord(metadata, lang)));
            }
            if (this.sourceEnabled) {
                this.sourceMetadata.addElement(MetadataHelper.findValue("HIBase", this.sourceKey, MetadataHelper.getDefaultMetadataRecord(metadata, lang)));
            }
            if (!this.contentEnabled) continue;
            this.contentMetadata.addElement(MetadataHelper.findValue("HIBase", this.contentKey, MetadataHelper.getDefaultMetadataRecord(metadata, lang)));
        }
        if (metadata != null) {
            this.setEditable(true);
            this.setMetadataFields();
        } else {
            this.setEditable(false);
        }
        this.hasChanges = false;
    }

    public void setIdLabel(String id) {
        this.idLabel.setText("ID: " + id);
    }

    public void setTimeLabel(String time) {
        this.idLabel.setText(String.valueOf(Messages.getString("HIClientGUI.lastChanged")) + ": " + time);
    }

    public void setHeading(String heading) {
        TitledBorder border = (TitledBorder)this.metadataPanel.getBorder();
        border.setTitle(heading);
    }

    public void setMultiLanguage(boolean multiLanguage) {
        this.languageComboBox.setVisible(multiLanguage);
        this.languageLabel.setVisible(multiLanguage);
    }

    public List<HiFlexMetadataRecord> getMetadata() {
        return this.metadata;
    }

    public void setEmptyText(String emptyText) {
        this.titleField.setEmptyText(emptyText);
    }

    public boolean hasChanges() {
        if (this.metadata == null) {
            return false;
        }
        this.syncToBuffer();
        if (!this.hasChanges && this.entryModified()) {
            this.hasChanges = true;
        }
        return this.hasChanges;
    }

    public void syncChanges() {
        if (this.metadata != null && this.hasChanges()) {
            int i = 0;
            while (i < this.languageKeys.size()) {
                if (this.titleEnabled) {
                    MetadataHelper.setValue("HIBase", this.titleKey, this.titleMetadata.get(i), MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i)));
                }
                if (this.sourceEnabled) {
                    MetadataHelper.setValue("HIBase", this.sourceKey, this.sourceMetadata.get(i), MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i)));
                }
                if (this.contentEnabled) {
                    MetadataHelper.setValue("HIBase", this.contentKey, this.contentMetadata.get(i), MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i)));
                }
                ++i;
            }
            this.hasChanges = false;
        }
    }

    public void resetChanges() {
        if (this.metadata != null) {
            int i = 0;
            while (i < this.languageKeys.size()) {
                if (this.titleEnabled) {
                    this.titleMetadata.setElementAt(MetadataHelper.findValue("HIBase", this.titleKey, MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i))), i);
                }
                if (this.sourceEnabled) {
                    this.sourceMetadata.setElementAt(MetadataHelper.findValue("HIBase", this.sourceKey, MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i))), i);
                }
                if (this.contentEnabled) {
                    this.contentMetadata.setElementAt(MetadataHelper.findValue("HIBase", this.contentKey, MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i))), i);
                }
                ++i;
            }
            this.hasChanges = false;
            this.setMetadataFields();
        }
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public JButton getTagsButton() {
        return this.tagsButton;
    }

    public JPanel getMetadataPanel() {
        return this.metadataPanel;
    }

    private void setMetadataFields() {
        if (this.metadata != null && this.metadata.size() > 0) {
            if (this.titleEnabled) {
                this.titleField.setText(this.titleMetadata.elementAt(this.curLangIndex));
            }
            if (this.sourceEnabled) {
                this.sourceField.setText(this.sourceMetadata.elementAt(this.curLangIndex));
            }
            if (this.contentEnabled) {
                this.annotationRichTextControl.setText(this.contentMetadata.elementAt(this.curLangIndex));
            }
        }
    }

    private void buildLanguages() {
        this.languageComboBox.removeActionListener(this);
        this.languageKeys.removeAllElements();
        this.languageComboBox.removeAllItems();
        if (this.metadata != null) {
            for (HiFlexMetadataRecord record : this.metadata) {
                this.languageKeys.addElement(record.getLanguage());
                if (record.getLanguage().compareTo(this.defLang) == 0) {
                    this.defLangIndex = this.languageKeys.size() - 1;
                }
                this.languageComboBox.addItem(MetadataHelper.langToLocale(record.getLanguage()).getDisplayLanguage());
            }
            if (this.languageComboBox.getModel().getSize() > this.defLangIndex) {
                this.languageComboBox.setSelectedIndex(this.defLangIndex);
            }
            this.curLangIndex = this.defLangIndex;
        } else {
            this.languageComboBox.addItem(Messages.getString("MetadataEditorControl.10"));
        }
        this.languageComboBox.addActionListener(this);
    }

    private void setEditable(boolean editable) {
        this.titleField.setEnabled(editable);
        this.titleField.setEditable(editable);
        this.sourceField.setEnabled(editable);
        this.sourceField.setEditable(editable);
        this.annotationRichTextControl.setEditable(editable);
        this.saveButton.setEnabled(editable);
        this.resetButton.setEnabled(editable);
        this.tagsButton.setEnabled(editable);
        if (!editable) {
            this.titleField.setText("");
            this.sourceField.setText("");
        }
    }

    private boolean entryModified() {
        if (this.metadata != null) {
            int i = 0;
            while (i < this.languageKeys.size()) {
                if (this.titleEnabled && this.titleMetadata != null && this.titleMetadata.get(i) != null && this.titleMetadata.get(i).compareTo(MetadataHelper.findValue("HIBase", this.titleKey, MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i)))) != 0) {
                    return true;
                }
                if (this.sourceEnabled && this.sourceMetadata != null && this.sourceMetadata.get(i) != null && this.sourceMetadata.get(i).compareTo(MetadataHelper.findValue("HIBase", this.sourceKey, MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i)))) != 0) {
                    return true;
                }
                if (this.contentEnabled && this.contentMetadata != null && this.contentMetadata.get(i) != null && this.contentMetadata.get(i).compareTo(MetadataHelper.findValue("HIBase", this.contentKey, MetadataHelper.getDefaultMetadataRecord(this.metadata, this.languageKeys.get(i)))) != 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void syncToBuffer() {
        if (this.metadata != null) {
            if (this.titleEnabled) {
                this.titleMetadata.setElementAt(this.titleField.getText(), this.curLangIndex);
            }
            if (this.sourceEnabled) {
                this.sourceMetadata.setElementAt(this.sourceField.getText(), this.curLangIndex);
            }
            if (this.contentEnabled) {
                this.contentMetadata.setElementAt(this.annotationRichTextControl.getText(), this.curLangIndex);
            }
        }
    }

    private void initComponents() {
        this.metadataPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleField = new JEnrichedTextField();
        this.sourcePanel = new JPanel();
        this.sourceField = new JTextField();
        this.annotationRichTextControl = new HIRichTextFieldControl(this.contentName);
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.controlPanel = new JPanel();
        this.idLabel = new JLabel();
        this.resetButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.tagsButton = new TagsButton();
        this.metadataBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("MetadataEditorControl.16"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.metadataPanel.setBorder(this.metadataBorder);
        this.titleBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), this.titleName);
        this.titlePanel.setBorder(this.titleBorder);
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(1).add(titlePanelLayout.createSequentialGroup().addContainerGap().add(this.titleField, -1, 260, Short.MAX_VALUE).addContainerGap()));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(1).add(titlePanelLayout.createSequentialGroup().add(this.titleField, -2, 28, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.sourceBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), this.sourceName);
        this.sourcePanel.setBorder(this.sourceBorder);
        GroupLayout sourcePanelLayout = new GroupLayout(this.sourcePanel);
        this.sourcePanel.setLayout(sourcePanelLayout);
        sourcePanelLayout.setHorizontalGroup(sourcePanelLayout.createParallelGroup(1).add(sourcePanelLayout.createSequentialGroup().addContainerGap().add(this.sourceField, -1, 260, Short.MAX_VALUE).addContainerGap()));
        sourcePanelLayout.setVerticalGroup(sourcePanelLayout.createParallelGroup(1).add(this.sourceField, -2, -1, -2));
        this.languageLabel.setText(Messages.getString("MetadataEditorControl.18"));
        GroupLayout metadataPanelLayout = new GroupLayout(this.metadataPanel);
        this.metadataPanel.setLayout(metadataPanelLayout);
        metadataPanelLayout.setHorizontalGroup(metadataPanelLayout.createParallelGroup(1).add(this.titlePanel, -1, -1, Short.MAX_VALUE).add(2, metadataPanelLayout.createSequentialGroup().addContainerGap(90, Short.MAX_VALUE).add(this.languageLabel).addPreferredGap(0).add(this.languageComboBox, -2, 187, -2)).add(this.sourcePanel, -1, -1, Short.MAX_VALUE).add(2, this.annotationRichTextControl, -1, -1, Short.MAX_VALUE));
        metadataPanelLayout.setVerticalGroup(metadataPanelLayout.createParallelGroup(1).add(metadataPanelLayout.createSequentialGroup().add(metadataPanelLayout.createParallelGroup(3).add(this.languageComboBox, -2, -1, -2).add(this.languageLabel)).addPreferredGap(0).add(this.titlePanel, -2, 56, -2).addPreferredGap(0).add(this.sourcePanel, -2, -1, -2).addPreferredGap(0).add(this.annotationRichTextControl, -1, -1, Short.MAX_VALUE)));
        this.idLabel.setText("ID:");
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createSequentialGroup().add(this.resetButton, -2, -1, -2).addPreferredGap(0).add(this.saveButton, -2, -1, -2).addPreferredGap(1).add(this.idLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.tagsButton, -2, 90, -2)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(1).add(controlPanelLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add(controlPanelLayout.createParallelGroup(1).add(2, controlPanelLayout.createParallelGroup(3).add(this.resetButton, -2, -1, -2).add(this.saveButton, -2, -1, -2).add(this.idLabel, -2, 24, -2)).add(2, this.tagsButton, -2, -1, -2)).add(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.controlPanel, -1, -1, Short.MAX_VALUE).add(2, this.metadataPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.metadataPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0, 6, 6).add(this.controlPanel, -2, -1, -2)));
        this.languageComboBox.addActionListener(this);
        this.tagsButton.addActionListener(this);
        this.tagsButton.setCount(1);
        if (System.getProperty("HI.feature.tagsDisabled") != null || !this.tagsEnabled) {
            this.tagsButton.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tagsButton) {
            if (this.baseID > 0L) {
                this.tagsButton.setCount(new HIBaseTagsEditorDialog((Frame)HIRuntime.getGui(), this.baseID).chooseTags());
            }
        } else if (this.metadata != null && this.languageKeys.size() > 0) {
            this.hasChanges();
            this.syncToBuffer();
            this.curLangIndex = this.languageComboBox.getSelectedIndex();
            this.setMetadataFields();
        }
    }
}

