/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import com.sun.media.jai.widget.DisplayJAI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.hyperimage.client.util.LoadableImage;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiView;

public class ObjectContentCell
extends JPanel
implements LoadableImage {
    private static final long serialVersionUID = -3487286832530501690L;
    private boolean isSelected = false;
    private boolean needsPreview = false;
    private DisplayJAI viewPanel;
    private static LineBorder defaultBorder = (LineBorder)BorderFactory.createLineBorder(Color.GRAY, 3);
    private static LineBorder selectedBorder = (LineBorder)BorderFactory.createLineBorder(Color.YELLOW, 3);
    private HiObjectContent content;
    private String defLang;

    public ObjectContentCell(HiObjectContent content, String defLang) {
        this.content = content;
        this.defLang = defLang;
        this.viewPanel = new DisplayJAI();
        this.viewPanel.setPreferredSize(new Dimension(128, 128));
        this.viewPanel.setBorder(null);
        this.viewPanel.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setSize(128, 128);
        this.setPreferredSize(new Dimension(128, 128));
        this.setBackground(Color.LIGHT_GRAY);
        this.setBorder(defaultBorder);
        this.add((Component)this.viewPanel, "Center");
        this.attachPreview();
    }

    @Override
    public boolean needsPreview() {
        return this.needsPreview;
    }

    @Override
    public void setPreviewImage(PlanarImage image) {
        if (this.needsPreview) {
            if (image != null) {
                if (image.getWidth() <= 128 && image.getHeight() <= 128) {
                    int x = (128 - image.getWidth()) / 2;
                    int y = (128 - image.getHeight()) / 2;
                    this.viewPanel.removeAll();
                    this.viewPanel.set(image, x, y);
                    this.needsPreview = false;
                }
            } else {
                RenderedOp errorImage = JAI.create("url", this.getClass().getResource("/resources/icons/preview-loaderror.png"));
                this.viewPanel.removeAll();
                this.viewPanel.set(errorImage);
                this.needsPreview = false;
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        if (selected != this.isSelected) {
            this.isSelected = selected;
            if (this.isSelected) {
                this.setBorder(selectedBorder);
            } else {
                this.setBorder(defaultBorder);
            }
        }
    }

    public boolean attachPreview() {
        boolean found = false;
        if (this.content instanceof HiView) {
            this.needsPreview = true;
        } else {
            JLabel area = new JLabel();
            area.setPreferredSize(new Dimension(128, 128));
            area.setFont(area.getFont().deriveFont(10.0f));
            area.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            area.setBackground(Color.WHITE);
            area.setOpaque(true);
            area.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            String inscription = MetadataHelper.findValue("HIBase", "content", MetadataHelper.getDefaultMetadataRecord((HiBase)this.content, this.defLang));
            inscription = MetadataHelper.richTextToHTML(inscription);
            if (inscription.length() > 128) {
                if ((inscription = inscription.substring(0, 128)).lastIndexOf("<") > inscription.lastIndexOf(">")) {
                    inscription = inscription.substring(0, inscription.lastIndexOf("<") - 1);
                }
                inscription = String.valueOf(inscription) + "...";
            }
            area.setText(inscription);
            this.removeAll();
            this.add((Component)area, "Center");
            this.needsPreview = false;
        }
        if (this.needsPreview) {
            RenderedOp image = JAI.create("url", this.getClass().getResource("/resources/icons/preview-loading.png"));
            this.viewPanel.set(image);
        }
        return found;
    }
}

