/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import com.sun.media.jai.widget.DisplayJAI;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.gui.views.LayerPolygonEditorView;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.model.HIRichText;
import org.hyperimage.client.model.RelativePolygon;
import org.hyperimage.client.util.ImageHelper;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;

public class PolygonEditorControl
extends DisplayJAI
implements PopupMenuListener {
    private static final long serialVersionUID = 584425494646670381L;
    private PlanarImage image;
    private float scale = 1.0f;
    private Vector<HILayer> layers;
    private static final float[] polygonDash = new float[]{4.0f, 4.0f};
    public static final BasicStroke selectStrokeWhite = new BasicStroke(1.0f, 1, 1, 1.0f, polygonDash, 0.0f);
    public static final BasicStroke selectStrokeBlack = new BasicStroke(1.0f, 1, 1, 1.0f, polygonDash, 4.0f);
    public static final BasicStroke activeStrokeWhite = new BasicStroke(2.0f, 1, 1, 1.0f, polygonDash, 0.0f);
    public static final BasicStroke activeStrokeBlack = new BasicStroke(2.0f, 1, 1, 1.0f, polygonDash, 4.0f);
    public static final BasicStroke selectStrokeSolid = new BasicStroke(1.0f);
    public static final BasicStroke activeStrokeSolid = new BasicStroke(2.0f);
    private static TexturePaint openPolygonTexturePaint;
    private Cursor crossAddCursor;
    private Cursor crossRemoveMoveCursor;
    private Cursor crossClosePathCursor;
    private Cursor crossMoveCursor;
    private int dragX = 0;
    private int dragY = 0;
    private int dragAnchor = -1;
    private RelativePolygon.PolygonResizeCorners resizeAnchor = RelativePolygon.PolygonResizeCorners.NONE;
    private int dragLinePoint = -1;
    private boolean anchorCreated = false;
    private boolean foundOpenPolygon = false;
    private RelativePolygon activePolygon;
    private RelativePolygon lastPolygon;
    private RelativePolygon selectedPolygon;
    private GeneralPath combinedPath;
    private Cursor cursorState;
    private Image closePathIcon;
    private HILayer userSelectedLayer = null;
    private boolean highlightLayer = false;
    private JPopupMenu popupMenu;
    public LayerPolygonEditorView view = null;
    private boolean isolationMode;
    private boolean placeFirstAnchorMode;

    public PolygonEditorControl(PlanarImage image, Vector<HILayer> layers) {
        this.image = image;
        this.layers = layers;
        this.selectedPolygon = null;
        this.combinedPath = new GeneralPath();
        this.combinedPath.setWindingRule(0);
        this.isolationMode = false;
        this.placeFirstAnchorMode = false;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            BufferedImage openPolygonTexture = ImageIO.read(this.getClass().getResource("/resources/OpenPolygonTexture.gif"));
            openPolygonTexturePaint = new TexturePaint(openPolygonTexture, new Rectangle2D.Double(0.0, 0.0, 16.0, 16.0));
            this.crossMoveCursor = tk.createCustomCursor(ImageIO.read(this.getClass().getResource("/resources/cursors/cursorMove.png")), new Point(11, 11), "cross-Move");
            this.crossAddCursor = tk.createCustomCursor(ImageIO.read(this.getClass().getResource("/resources/cursors/crossAdd.png")), new Point(13, 13), "cross-Add");
            this.crossRemoveMoveCursor = tk.createCustomCursor(ImageIO.read(this.getClass().getResource("/resources/cursors/crossRemoveOrMove.png")), new Point(13, 13), "cross-RemoveOrMove");
            this.crossClosePathCursor = tk.createCustomCursor(ImageIO.read(this.getClass().getResource("/resources/cursors/crossClosePath.gif")), new Point(12, 12), "cross-ClosePath");
            this.closePathIcon = ImageIO.read(this.getClass().getResource("/resources/icons/closePath.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.popupMenu = new JPopupMenu();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.popupMenu.addPopupMenuListener(this);
        this.set(image);
    }

    public void setIsolationMode(boolean mode) {
        this.isolationMode = mode;
        if (this.getSelectedLayer() != this.userSelectedLayer) {
            this.selectedPolygon = null;
        }
        this.repaint();
    }

    public void setPlaceFirstAnchorMode(boolean mode) {
        this.placeFirstAnchorMode = mode;
    }

    public boolean isResizing() {
        return this.resizeAnchor == RelativePolygon.PolygonResizeCorners.LOWER_RIGHT || this.resizeAnchor == RelativePolygon.PolygonResizeCorners.UPPER_RIGHT;
    }

    public void scaleView(float scale) {
        if (this.scale != scale) {
            this.scale = scale;
            PlanarImage scaledImg = ImageHelper.scaleImageTo(this.image, (double)scale);
            for (HILayer layer : this.layers) {
                layer.setScale(scaledImg.getWidth(), scaledImg.getHeight());
            }
            this.set(scaledImg);
            scaledImg.dispose();
        }
    }

    public boolean containsOpenPolygon() {
        return this.foundOpenPolygon;
    }

    public void addFreeFormPolygon(HILayer layer, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_FREEDESIGN, x, y, 0, 0, null, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(false);
        layer.getRelativePolygons().add(polygon);
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void addFreePolygon(HILayer layer, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_FREEHAND, x, y, 0, 0, null, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(false);
        layer.getRelativePolygons().add(polygon);
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void addRectanglePolygon(HILayer layer, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_RECTANGLE, x, y, 120, 50, null, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(true);
        layer.getRelativePolygons().add(polygon);
        this.selectedPolygon = polygon;
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void addCirclePolygon(HILayer layer, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_CIRCLE, x, y, 60, 120, null, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(true);
        layer.getRelativePolygons().add(polygon);
        this.selectedPolygon = polygon;
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void addArrowPolygon(HILayer layer, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_ARROW, x, y, 160, 120, null, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(true);
        layer.getRelativePolygons().add(polygon);
        this.selectedPolygon = polygon;
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void addLibraryPolygon(HILayer layer, String model, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(RelativePolygon.HiPolygonTypes.HI_USERDESIGN, 0, 0, 0, 0, model, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(true);
        polygon.translate(x - polygon.getPolygonPath().getBounds().x, y - polygon.getPolygonPath().getBounds().y);
        layer.getRelativePolygons().add(polygon);
        this.selectedPolygon = polygon;
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void addPolygon(HILayer layer, String model, int x, int y) {
        this.closeAndCleanupPolygons();
        RelativePolygon polygon = new RelativePolygon(model, (int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
        polygon.setClosed(true);
        polygon.translate(x - polygon.getPolygonPath().getBounds().x, y - polygon.getPolygonPath().getBounds().y);
        layer.getRelativePolygons().add(polygon);
        this.selectedPolygon = polygon;
        this.setViewingState(x, y, false);
        this.repaint();
    }

    public void deleteActivePolygon() {
        if (this.activePolygon != null) {
            HILayer polygonLayer = null;
            for (HILayer layer : this.layers) {
                if (!layer.getRelativePolygons().contains(this.activePolygon)) continue;
                polygonLayer = layer;
            }
            if (polygonLayer != null) {
                polygonLayer.getRelativePolygons().removeElement(this.activePolygon);
                if (this.selectedPolygon == this.activePolygon) {
                    this.selectedPolygon = null;
                }
                this.activePolygon = null;
                this.repaint();
            }
        }
    }

    public void deleteSelectedPolygon() {
        if (this.selectedPolygon != null) {
            HILayer polygonLayer = null;
            for (HILayer layer : this.layers) {
                if (!layer.getRelativePolygons().contains(this.selectedPolygon)) continue;
                polygonLayer = layer;
            }
            if (polygonLayer != null) {
                polygonLayer.getRelativePolygons().removeElement(this.selectedPolygon);
                this.activePolygon = null;
                this.selectedPolygon = null;
                this.repaint();
            }
        }
    }

    public void convertActivePolygonToFreeDesign() {
        if (this.activePolygon != null) {
            this.activePolygon.convertToFreeDesign();
            this.repaint();
        }
    }

    public void setActivePolygonOpen(boolean open) {
        if (this.activePolygon != null) {
            this.closeAndCleanupPolygons();
            if (open) {
                this.view.polygonEditorViewCommand = "add_freeform_open";
                this.placeFirstAnchorMode = true;
            } else {
                this.view.polygonEditorViewCommand = "";
                this.placeFirstAnchorMode = false;
            }
            this.view.updateToolbarButtons();
            this.activePolygon.setClosed(!open);
            this.repaint();
        }
    }

    public void closeAndCleanupPolygons() {
        Vector<RelativePolygon> polygonsToRemove = new Vector<RelativePolygon>();
        for (HILayer dispLayer : this.layers) {
            for (RelativePolygon dispPolygon : dispLayer.getRelativePolygons()) {
                if (!dispPolygon.isClosed()) {
                    dispPolygon.setClosed(true);
                }
                if (dispPolygon.size() >= 3) continue;
                polygonsToRemove.addElement(dispPolygon);
            }
        }
        for (HILayer dispLayer : this.layers) {
            for (RelativePolygon removePolygon : polygonsToRemove) {
                if (!dispLayer.getRelativePolygons().contains(removePolygon)) continue;
                dispLayer.getRelativePolygons().removeElement(removePolygon);
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public HILayer getSelectedLayer() {
        if (this.selectedPolygon == null) {
            return null;
        }
        for (HILayer layer : this.layers) {
            if (!layer.getRelativePolygons().contains(this.selectedPolygon)) continue;
            return layer;
        }
        return null;
    }

    public RelativePolygon getActivePolygon() {
        return this.activePolygon;
    }

    public RelativePolygon getSelectedPolygon() {
        return this.selectedPolygon;
    }

    public void selectActivePolygon() {
        this.selectedPolygon = this.activePolygon;
        this.repaint();
    }

    public void setUserSelectedLayer(HILayer layer) {
        this.userSelectedLayer = layer;
        if (this.isolationMode && this.getSelectedLayer() != this.userSelectedLayer) {
            this.selectedPolygon = null;
        }
        this.repaintShapes();
    }

    public void repaintShapes() {
        this.setViewingState(0, 0, false);
        this.repaint();
    }

    public void updateScale() {
        for (HILayer layer : this.layers) {
            layer.setScale(this.source.getWidth(), this.source.getHeight());
        }
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public Point[] simplifyRadialDist(Point[] points, double epsilon) {
        Point prevPoint = points[0];
        ArrayList<Point> newPoints = new ArrayList<Point>();
        newPoints.add(prevPoint);
        Point point = null;
        int i = 1;
        while (i < points.length) {
            point = points[i];
            if (point.distanceSq(prevPoint) > epsilon) {
                newPoints.add(point);
                prevPoint = point;
            }
            ++i;
        }
        if (!prevPoint.equals(point)) {
            newPoints.add(point);
        }
        return newPoints.toArray(new Point[newPoints.size()]);
    }

    public Point[] simplifyPath(Point[] points, double epsilon) {
        if (this.activePolygon == null || this.activePolygon.getType() != RelativePolygon.HiPolygonTypes.HI_FREEHAND) {
            return points;
        }
        Point firstPoint = points[0];
        Point lastPoint = points[points.length - 1];
        if (points.length < 3) {
            return points;
        }
        int index = -1;
        double dist = 0.0;
        int i = 1;
        while (i < points.length - 1) {
            double cDist = this.findPerpendicularDistance(points[i], firstPoint, lastPoint);
            if (cDist > dist) {
                dist = cDist;
                index = i;
            }
            ++i;
        }
        if (dist > epsilon) {
            Point[] l1 = Arrays.copyOfRange(points, 0, index + 1);
            Point[] l2 = Arrays.copyOfRange(points, index, points.length);
            Point[] r1 = this.simplifyPath(l1, epsilon);
            Point[] r2 = this.simplifyPath(l2, epsilon);
            Point[] rs = PolygonEditorControl.concat(Arrays.copyOfRange(r1, 0, r1.length - 1), r2);
            return rs;
        }
        return new Point[]{firstPoint, lastPoint};
    }

    public double findPerpendicularDistance(Point p, Point p1, Point p2) {
        double x = p1.x;
        double y = p1.y;
        double dx = (double)p2.x - x;
        double dy = (double)p2.y - y;
        if (dx != 0.0 || dy != 0.0) {
            double t = (((double)p.x - x) * dx + ((double)p.y - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x = p2.x;
                y = p2.y;
            } else if (t > 0.0) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = (double)p.x - x;
        dy = (double)p.y - y;
        return dx * dx + dy * dy;
    }

    private void highlightPolygon(Graphics2D g2d, Shape clipShape, Color layerColor, int glowWidth) {
        Composite orgComposite = g2d.getComposite();
        int i = glowWidth;
        while (i >= 2) {
            float opacity = 1.0f / (float)i;
            if (i % 4 != 0) {
                g2d.setColor(Color.white);
            } else {
                g2d.setColor(Color.white);
            }
            g2d.setComposite(AlphaComposite.getInstance(10, opacity));
            g2d.setStroke(new BasicStroke(i));
            g2d.draw(clipShape);
            i -= 2;
        }
        g2d.setComposite(orgComposite);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        int count = this.layers.size() - 1;
        while (count >= 0) {
            HILayer layer = this.layers.get(count);
            this.combinedPath.reset();
            for (RelativePolygon polygon : layer.getRelativePolygons()) {
                if (!polygon.isClosed()) continue;
                this.combinedPath.append(polygon.getPolygonPath(), false);
            }
            if (layer == this.userSelectedLayer && this.highlightLayer && !this.isolationMode) {
                this.highlightPolygon(g2d, this.combinedPath, layer.getSolidColour(), 10);
            }
            g2d.setColor(layer.getColour());
            if (!this.isolationMode || layer == this.userSelectedLayer) {
                g2d.fill(this.combinedPath);
            }
            for (RelativePolygon polygon : layer.getRelativePolygons()) {
                if (!polygon.isClosed()) {
                    Composite orgComposite = g2d.getComposite();
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    if (openPolygonTexturePaint != null) {
                        g2d.setPaint(openPolygonTexturePaint);
                        g2d.fill(polygon.getPolygonPath());
                    }
                    g2d.setComposite(orgComposite);
                }
                if (!this.isolationMode || layer == this.userSelectedLayer) {
                    if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN || polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEHAND) {
                        g2d.setStroke(selectStrokeWhite);
                        g2d.setColor(Color.WHITE);
                        g2d.draw(polygon.getPolygonPath());
                        g2d.setStroke(selectStrokeBlack);
                        g2d.setColor(layer.getColour().darker());
                        g2d.draw(polygon.getPolygonPath());
                    } else {
                        g2d.setStroke(selectStrokeSolid);
                        g2d.setColor(layer.getColour().darker());
                        g2d.draw(polygon.getPolygonPath());
                    }
                } else {
                    g2d.setStroke(selectStrokeSolid);
                    g2d.setColor(layer.getColour().darker());
                    g2d.draw(polygon.getPolygonPath());
                    g2d.setStroke(selectStrokeBlack);
                    g2d.setColor(layer.getColour());
                    g2d.draw(polygon.getPolygonPath());
                }
                if (polygon == this.selectedPolygon) {
                    this.drawResizeFrame(g2d, polygon.getPolygonPath());
                }
                if (polygon != this.activePolygon) continue;
                g2d.setStroke(selectStrokeBlack);
                g2d.setColor(Color.BLACK);
                g2d.draw(polygon.getPolygonPath());
                if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN || polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEHAND) {
                    int i = 0;
                    while (i < polygon.size()) {
                        this.drawAnchor(g2d, layer.getColour(), polygon.getPoint(i), 6);
                        ++i;
                    }
                }
                if (polygon.isClosed() || polygon.size() <= 0) continue;
                g2d.drawImage(this.closePathIcon, polygon.getPoint((int)0).x - 13, polygon.getPoint((int)0).y - 3, 26, 17, null);
                if (polygon.size() <= 1) continue;
                this.drawAnchor(g2d, Color.WHITE, polygon.getPoint(polygon.size() - 1), 6);
            }
            --count;
        }
    }

    private void drawResizeFrame(Graphics2D g2d, GeneralPath polygonPath) {
        Rectangle bounds = polygonPath.getBounds();
        g2d.setStroke(selectStrokeSolid);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(bounds.x - 10, bounds.y - 10, bounds.width + 20, bounds.height + 20);
        g2d.setColor(Color.WHITE);
        g2d.drawRect(bounds.x - 11, bounds.y - 11, bounds.width + 20, bounds.height + 20);
        g2d.drawArc(bounds.x + bounds.width + 4, bounds.y - 15, 10, 10, 0, 360);
        g2d.drawRect(bounds.x + bounds.width + 4, bounds.y + bounds.height + 4, 10, 10);
        g2d.setColor(Color.BLACK);
        g2d.drawArc(bounds.x + bounds.width + 3, bounds.y - 16, 10, 10, 0, 360);
        g2d.drawRect(bounds.x + bounds.width + 3, bounds.y + bounds.height + 3, 10, 10);
    }

    private void drawAnchor(Graphics2D g2d, Color color, Point p, int size) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(p.x - size / 2, p.y - size / 2, size, size);
        g2d.setColor(color);
        g2d.draw3DRect(p.x - size / 2, p.y - size / 2, size, size, true);
        g2d.draw3DRect(p.x - size / 2 + 1, p.y - size / 2 + 1, size - 2, size - 2, true);
    }

    private void setCursorState(int x, int y) {
        if (this.dragAnchor >= 0) {
            this.cursorState = this.crossRemoveMoveCursor;
            if (this.activePolygon != null && this.dragAnchor == 0 && !this.activePolygon.isClosed()) {
                this.cursorState = this.crossClosePathCursor;
            }
        } else {
            this.cursorState = this.dragLinePoint >= 0 ? this.crossAddCursor : (this.activePolygon != null ? Cursor.getPredefinedCursor(12) : (this.resizeAnchor != RelativePolygon.PolygonResizeCorners.NONE ? Cursor.getDefaultCursor() : (this.placeFirstAnchorMode ? Cursor.getPredefinedCursor(1) : this.crossMoveCursor)));
        }
        if (this.activePolygon != null && !this.activePolygon.isClosed() && this.dragAnchor < 0) {
            this.cursorState = this.crossAddCursor;
        }
        if (this.cursorState != this.getCursor()) {
            this.setCursor(this.cursorState);
        }
    }

    private void setViewingState(int x, int y, boolean forceUpdate) {
        if (this.popupMenu.isVisible() && !forceUpdate) {
            return;
        }
        RelativePolygon oldPolygonState = this.activePolygon;
        this.setToolTipText("");
        this.activePolygon = null;
        this.dragAnchor = -1;
        this.resizeAnchor = RelativePolygon.PolygonResizeCorners.NONE;
        this.dragLinePoint = -1;
        this.foundOpenPolygon = false;
        int count = this.layers.size() - 1;
        while (count >= 0) {
            HILayer layer = this.layers.get(count);
            if (!this.isolationMode || layer == this.userSelectedLayer) {
                for (RelativePolygon polygon : layer.getRelativePolygons()) {
                    if (polygon.isClosed()) continue;
                    this.activePolygon = polygon;
                    this.selectedPolygon = null;
                    this.foundOpenPolygon = true;
                }
                if (this.selectedPolygon != null) {
                    Rectangle bounds = this.selectedPolygon.getPolygonPath().getBounds();
                    Rectangle upperLeft = new Rectangle(bounds.x - 15, bounds.y - 15, 10, 10);
                    Rectangle lowerLeft = new Rectangle(bounds.x - 15, bounds.y + bounds.height + 4, 10, 10);
                    Rectangle upperRight = new Rectangle(bounds.x + bounds.width + 4, bounds.y - 15, 10, 10);
                    Rectangle lowerRight = new Rectangle(bounds.x + bounds.width + 4, bounds.y + bounds.height + 4, 10, 10);
                    if (upperLeft.contains(x, y)) {
                        this.resizeAnchor = RelativePolygon.PolygonResizeCorners.UPPER_LEFT;
                    } else if (upperRight.contains(x, y)) {
                        this.resizeAnchor = RelativePolygon.PolygonResizeCorners.UPPER_RIGHT;
                    } else if (lowerLeft.contains(x, y)) {
                        this.resizeAnchor = RelativePolygon.PolygonResizeCorners.LOWER_LEFT;
                    } else if (lowerRight.contains(x, y)) {
                        this.resizeAnchor = RelativePolygon.PolygonResizeCorners.LOWER_RIGHT;
                    }
                }
                for (RelativePolygon polygon : layer.getRelativePolygons()) {
                    boolean isActive = false;
                    if (polygon.isOnAnchor(x, y)) {
                        if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN || polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEHAND) {
                            this.dragAnchor = polygon.getDragAnchor(x, y);
                        }
                        this.activePolygon = polygon;
                        isActive = true;
                    } else if (polygon.isOnLine(x, y)) {
                        if (polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN || polygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEHAND) {
                            this.dragLinePoint = polygon.getLinePoint(x, y);
                        }
                        this.activePolygon = polygon;
                        this.setCursor(this.crossAddCursor);
                        isActive = true;
                    } else if (polygon.getPolygonPath().contains(x, y)) {
                        this.activePolygon = polygon;
                        isActive = true;
                    }
                    if (!isActive) continue;
                    String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)layer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
                    if (title == null || title.length() == 0) {
                        title = MetadataHelper.getDisplayableID(layer.getModel());
                    }
                    String comment = new HIRichText(MetadataHelper.findValue("HIBase", "comment", MetadataHelper.getDefaultMetadataRecord((HiBase)layer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()))).getHTMLModel();
                    comment = comment.replaceAll("<[/]?html>", "");
                    String tooltip = "<html><b>Ebene: " + title + "</b><br><br>" + comment + "</html>";
                    this.setToolTipText(tooltip);
                }
            }
            --count;
        }
        if (oldPolygonState != this.activePolygon) {
            this.repaint();
        }
        this.setCursorState(x, y);
    }

    private void setSelectedPolygon(RelativePolygon polygon) {
        RelativePolygon oldState = this.selectedPolygon;
        if (polygon != this.selectedPolygon && !this.foundOpenPolygon) {
            this.selectedPolygon = polygon;
        }
        if (oldState != this.selectedPolygon) {
            this.repaint();
        }
    }

    private void addAnchorPointToActivePolygon(int insertIndex, int x, int y) {
        if (this.activePolygon == null) {
            return;
        }
        this.activePolygon.insertPointAfter(insertIndex, x, y);
        this.anchorCreated = true;
        this.dragAnchor = insertIndex + 1;
        this.setCursorState(x, y);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setViewingState(e.getX(), e.getY(), false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragX = e.getX();
        this.dragY = e.getY();
        if (e.getButton() == 1 && !e.isPopupTrigger() && this.dragAnchor < 0 && this.activePolygon != null) {
            if (this.dragLinePoint >= 0) {
                this.addAnchorPointToActivePolygon(this.dragLinePoint, e.getX(), e.getY());
            } else if (!this.activePolygon.isClosed()) {
                this.addAnchorPointToActivePolygon(this.activePolygon.size() - 1, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int divX = e.getX() - this.dragX;
        int divY = e.getY() - this.dragY;
        this.dragX = e.getX();
        this.dragY = e.getY();
        if (this.resizeAnchor != RelativePolygon.PolygonResizeCorners.NONE) {
            if (this.resizeAnchor == RelativePolygon.PolygonResizeCorners.LOWER_RIGHT) {
                this.selectedPolygon.transformBy(divX, divY, this.resizeAnchor);
            }
            if (this.resizeAnchor == RelativePolygon.PolygonResizeCorners.UPPER_RIGHT) {
                this.selectedPolygon.transformByAngle((double)divX / 100.0, this.resizeAnchor);
            }
            this.repaint();
        } else {
            this.setSelectedPolygon(this.activePolygon);
            if (this.dragAnchor >= 0) {
                this.activePolygon.movePointTo(this.dragAnchor, e.getX(), e.getY());
                this.repaint();
            } else if (this.activePolygon != null) {
                if (this.activePolygon.isClosed()) {
                    this.activePolygon.translate(divX, divY);
                    this.repaint();
                } else if (this.activePolygon.getPolygonPath().contains(e.getX(), e.getY())) {
                    this.activePolygon.translate(divX, divY);
                    this.repaint();
                }
            }
        }
        if (!(this.activePolygon == null || this.activePolygon.getType() != RelativePolygon.HiPolygonTypes.HI_FREEHAND || this.activePolygon.isClosed() || Math.abs(divX) <= 0 && Math.abs(divY) <= 0)) {
            this.addAnchorPointToActivePolygon(this.activePolygon.size() - 1, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && !this.popupMenu.isVisible()) {
            this.setSelectedPolygon(this.activePolygon);
            if (this.lastPolygon != null && this.lastPolygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN && this.lastPolygon.size() == 2) {
                this.activePolygon = this.lastPolygon;
            }
            if (this.activePolygon != null) {
                if (this.activePolygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEDESIGN && this.activePolygon.size() == 1) {
                    this.addAnchorPointToActivePolygon(this.activePolygon.size() - 1, e.getX(), e.getY());
                    this.lastPolygon = this.activePolygon;
                }
                if (!this.activePolygon.isClosed() && this.dragAnchor < 0) {
                    this.addAnchorPointToActivePolygon(this.activePolygon.size() - 1, e.getX(), e.getY());
                } else if (this.dragAnchor >= 0) {
                    if (!this.activePolygon.isClosed() && this.dragAnchor == 0) {
                        this.activePolygon.setClosed(true);
                        this.dragAnchor = -1;
                        this.setCursorState(e.getX(), e.getY());
                        this.view.polygonEditorViewCommand = "";
                        this.placeFirstAnchorMode = false;
                        this.view.updateToolbarButtons();
                        this.repaint();
                    } else if (!this.anchorCreated && this.activePolygon.size() > 2) {
                        this.activePolygon.removePoint(this.dragAnchor);
                        this.dragAnchor = -1;
                        this.setCursorState(e.getX(), e.getY());
                        this.repaint();
                    }
                }
            }
            this.anchorCreated = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.activePolygon != null && this.activePolygon.getType() == RelativePolygon.HiPolygonTypes.HI_FREEHAND && !this.activePolygon.isClosed()) {
            this.activePolygon.setPoints(this.simplifyPath(this.simplifyRadialDist(this.activePolygon.getPoints(), 6.0), 6.0));
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.highlightLayer = false;
        this.setViewingState(e.getX(), e.getY(), false);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.highlightLayer = true;
        this.repaintShapes();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.getMousePosition() != null) {
            this.setViewingState(this.getMousePosition().x, this.getMousePosition().y, true);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }
}

