/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JProgressBar;

public class ProgressInfoGlassPane
extends JComponent {
    private static final long serialVersionUID = -4790025078584664916L;
    private JProgressBar progressBar;
    private String message = "";
    BufferedImage progressBarImage = null;
    BufferedImage panelImage = null;
    private int paintCount = 0;

    public ProgressInfoGlassPane() {
        this.setDropTarget(new DropTarget());
        this.setFont(new Font("Default", 1, 16));
        this.setLayout(null);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setIndeterminate(true);
        this.add(this.progressBar);
        this.setOpaque(true);
    }

    public void setProgress(int progress) {
        if (progress < 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(progress);
        }
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setValue(0);
            this.paintCount = 0;
        }
        super.setVisible(visible);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.progressBar.setBounds(this.getWidth() / 2 - 175, this.getHeight() / 2 - this.progressBar.getPreferredSize().height / 2, 350, this.progressBar.getPreferredSize().height);
        Graphics2D g2d = (Graphics2D)g;
        ++this.paintCount;
        AlphaComposite newComposite = this.paintCount < 2 ? AlphaComposite.getInstance(3, 0.4f) : AlphaComposite.getInstance(3, 1.0f);
        Composite orgComposite = g2d.getComposite();
        g2d.setComposite(newComposite);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(orgComposite);
        if (this.progressBarImage == null || this.progressBarImage.getWidth() != this.progressBar.getWidth() || this.progressBarImage.getHeight() != this.progressBar.getHeight()) {
            this.progressBarImage = this.getGraphicsConfiguration().createCompatibleImage(this.progressBar.getWidth(), this.progressBar.getHeight());
        }
        Graphics gBar = this.progressBarImage.getGraphics();
        gBar.setClip(this.progressBar.getGraphics().getClip());
        gBar.setColor(Color.white);
        this.progressBar.paint(gBar);
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 2;
        GradientPaint gradient = new GradientPaint(x - 5, y - 5, Color.lightGray, x - 5, y - 5 + this.progressBar.getBounds().height + 10, Color.darkGray);
        g2d.setPaint(gradient);
        g2d.fillRect(x - this.progressBarImage.getWidth() / 2 - 5, y - this.progressBarImage.getHeight() / 2 - 5, this.progressBarImage.getWidth() + 10, this.progressBarImage.getHeight() + 10);
        g2d.drawImage((Image)this.progressBarImage, x - this.progressBarImage.getWidth() / 2, y - this.progressBarImage.getHeight() / 2, null);
        g2d.setColor(Color.black);
        g2d.drawString(this.message, x - this.progressBarImage.getWidth() / 2, y - g.getFontMetrics().getDescent() - 20);
    }
}

