/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class AddTemplateDialog
extends JDialog
implements ActionListener {
    private JLabel infoLabel;
    private ResetButton cancelButton;
    private SaveButton saveButton;
    private JComboBox templateComboBox;
    private JPanel templatePanel;
    private TitledBorder templatePanelBorder;
    private boolean saveButtonClicked = false;
    private List<HiFlexMetadataTemplate> templates;
    private Vector<String> templateChoices = new Vector();

    public AddTemplateDialog(JFrame parent) {
        super(parent);
        this.initComponents();
        this.updateLanguage();
        this.setBounds(parent.getWidth() / 2 - this.getWidth() / 2, parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.templateComboBox.addActionListener(this);
    }

    public void updateLanguage() {
        this.setTitle(Messages.getString("AddTemplateDialog.TEMPLATE_HINZUFUEGEN"));
        this.templatePanelBorder.setTitle(Messages.getString("AddTemplateDialog.TEMPLATE_AUSWAEHLEN"));
        this.templatePanel.repaint();
        this.infoLabel.setText("<html>" + Messages.getString("AddTemplateDialog.HINWEIS") + "</html>");
        this.saveButton.setToolTipText(Messages.getString("AddTemplateDialog.TEMPLATE_HINZUFUEGEN"));
        this.cancelButton.setToolTipText(Messages.getString("AddTemplateDialog.ABBRUCH"));
        this.infoLabel.repaint();
    }

    public boolean showAddTemplateFieldDialog(List<HiFlexMetadataTemplate> templates) {
        this.templates = templates;
        this.saveButtonClicked = false;
        this.initTemplateChoices();
        this.setModal(false);
        this.setVisible(true);
        this.updateLanguage();
        this.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
        return this.saveButtonClicked;
    }

    public String getTemplateChoice() {
        if (this.templateChoices.size() == 0) {
            return "";
        }
        return this.templateChoices.get(this.templateComboBox.getSelectedIndex());
    }

    private void initTemplateChoices() {
        this.templateChoices.removeAllElements();
        this.templateComboBox.removeAllItems();
        boolean dcFound = false;
        boolean cdwaFound = false;
        boolean vra4Found = false;
        boolean vra4HdlbgFound = false;
        boolean customFound = false;
        this.saveButton.setEnabled(true);
        for (HiFlexMetadataTemplate template : this.templates) {
            if (template.getNamespacePrefix().compareTo("dc") == 0) {
                dcFound = true;
            }
            if (template.getNamespacePrefix().compareTo("cdwalite") == 0) {
                cdwaFound = true;
            }
            if (template.getNamespacePrefix().compareTo("vra4") == 0) {
                vra4Found = true;
            }
            if (template.getNamespacePrefix().compareTo("vra4hdlbg") == 0) {
                vra4HdlbgFound = true;
            }
            if (!template.getNamespacePrefix().equalsIgnoreCase("custom")) continue;
            customFound = true;
        }
        if (!dcFound) {
            this.templateChoices.addElement("dc");
            this.templateChoices.addElement("dcRichText");
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.DUBLIN_CORE_LEGACY_SET"));
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.DUBLIN_CORE_LEGACY_SET_RICH_TEXT"));
        }
        if (!cdwaFound) {
            this.templateChoices.addElement("cdwa");
            this.templateChoices.addElement("cdwaRichText");
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.CDWA_LITE"));
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.CDWA_LITE_RICH_TEXT"));
        }
        if (!vra4Found) {
            this.templateChoices.addElement("vra4RichText");
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.VRA_CORE_4_RICH_TEXT"));
        }
        if (!vra4HdlbgFound) {
            this.templateChoices.addElement("vra4hdlbgRichText");
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.VRA_CORE_4_HDLBG_RICH_TEXT"));
        }
        if (!customFound) {
            this.templateChoices.addElement("custom");
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.CUSTOM_EDITIERBAR"));
        }
        if (this.templateComboBox.getItemCount() == 0) {
            this.templateComboBox.addItem(Messages.getString("AddTemplateDialog.KEINE_WEITEREN_TEMPLATES_VERFUEGBAR"));
            this.saveButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.templatePanel = new JPanel();
        this.templateComboBox = new JComboBox();
        this.cancelButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.templatePanelBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.templatePanel.setBorder(this.templatePanelBorder);
        GroupLayout templatePanelLayout = new GroupLayout(this.templatePanel);
        this.templatePanel.setLayout(templatePanelLayout);
        templatePanelLayout.setHorizontalGroup(templatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.templateComboBox, 0, 337, Short.MAX_VALUE).addContainerGap()));
        templatePanelLayout.setVerticalGroup(templatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templatePanelLayout.createSequentialGroup().addComponent(this.templateComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.infoLabel.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.infoLabel, -1, 355, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templatePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cancelButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton, -2, -1, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.templatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.infoLabel, -1, 61, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.saveButton, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.saveButtonClicked = false;
            this.setVisible(false);
        } else if (e.getActionCommand().equalsIgnoreCase("save")) {
            this.saveButtonClicked = true;
            this.setVisible(false);
        }
    }
}

