/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.ws.HiFlexMetadataSet;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class AddTemplateFieldDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private ResetButton cancelButton;
    private SaveButton saveButton;
    private JComboBox fieldTypeComboBox;
    private JPanel fieldTypePanel;
    private TitledBorder fieldTypeBorder;
    private JLabel infoLabel;
    private JPanel tagNamePanel;
    private TitledBorder tagNameBorder;
    private JTextField tagNameTextField;
    private HiFlexMetadataTemplate template;
    private boolean saveButtonClicked = false;

    public AddTemplateFieldDialog(JFrame parent) {
        super(parent);
        this.initComponents();
        this.updateLanguage();
        this.setBounds(parent.getWidth() / 2 - this.getWidth() / 2, parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.tagNameTextField.getDocument().addDocumentListener(this);
    }

    public void updateLanguage() {
        this.setTitle(Messages.getString("AddTemplateFieldDialog.METADATENFELD_HINZUFUEGEN"));
        this.tagNameBorder.setTitle(Messages.getString("AddTemplateFieldDialog.XML_TAGNAME"));
        this.tagNamePanel.repaint();
        this.fieldTypeBorder.setTitle(Messages.getString("AddTemplateFieldDialog.FELDTYP"));
        this.fieldTypePanel.repaint();
        this.fieldTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("AddTemplateFieldDialog.SINGLE_LINE"), Messages.getString("AddTemplateFieldDialog.RICH_TEXT")}));
        this.saveButton.setToolTipText(Messages.getString("AddTemplateFieldDialog.METADATENFELD_HINZUFUEGEN"));
        this.cancelButton.setToolTipText(Messages.getString("AddTemplateFieldDialog.ABBRUCH"));
        this.infoLabel.repaint();
        this.updateButtonState();
    }

    public boolean showAddTemplateFieldDialog(HiFlexMetadataTemplate template) {
        this.template = template;
        this.saveButtonClicked = false;
        this.setModal(false);
        this.setVisible(true);
        this.tagNameTextField.setText("");
        this.fieldTypeComboBox.setSelectedIndex(0);
        this.updateButtonState();
        this.updateLanguage();
        this.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
        return this.saveButtonClicked;
    }

    public String getTagName() {
        return this.tagNameTextField.getText();
    }

    public boolean isRichText() {
        return this.fieldTypeComboBox.getSelectedIndex() == 1;
    }

    private void updateButtonState() {
        this.saveButton.setEnabled(false);
        if (this.tagNameTextField.getText().length() == 0) {
            this.infoLabel.setText("<html><font color='#FF0000'>" + Messages.getString("AddTemplateFieldDialog.HINWEIS_EMPTY") + "</font></html>");
        } else {
            boolean tagExists = false;
            for (HiFlexMetadataSet set : this.template.getEntries()) {
                if (set.getTagname().compareTo(this.tagNameTextField.getText()) != 0) continue;
                tagExists = true;
            }
            if (tagExists) {
                this.infoLabel.setText("<html><font color='#FF0000'>" + Messages.getString("AddTemplateFieldDialog.HINWEIS_EXISTS") + "</font></html>");
            } else if (!this.tagNameTextField.getText().matches("[a-zA-Z][a-zA-Z0-9]*")) {
                this.infoLabel.setText("<html><font color='#FF0000'>" + Messages.getString("AddTemplateFieldDialog.HINWEIS_INVALID") + "</font></html>");
            } else {
                this.saveButton.setEnabled(true);
            }
        }
        if (this.saveButton.isEnabled()) {
            this.infoLabel.setText("<html>" + Messages.getString("AddTemplateFieldDialog.HINWEIS") + "<br>" + Messages.getString("AddTemplateFieldDialog.HINWEIS_HINZUFUEGEN") + "</html>");
        }
    }

    private void initComponents() {
        this.tagNamePanel = new JPanel();
        this.tagNameTextField = new JTextField();
        this.fieldTypePanel = new JPanel();
        this.fieldTypeComboBox = new JComboBox();
        this.infoLabel = new JLabel();
        this.cancelButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.tagNameBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.tagNamePanel.setBorder(this.tagNameBorder);
        GroupLayout tagNamePanelLayout = new GroupLayout(this.tagNamePanel);
        this.tagNamePanel.setLayout(tagNamePanelLayout);
        tagNamePanelLayout.setHorizontalGroup(tagNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tagNamePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tagNameTextField, -1, 271, Short.MAX_VALUE).addContainerGap()));
        tagNamePanelLayout.setVerticalGroup(tagNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tagNamePanelLayout.createSequentialGroup().addComponent(this.tagNameTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.fieldTypeBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.fieldTypePanel.setBorder(this.fieldTypeBorder);
        GroupLayout fieldTypePanelLayout = new GroupLayout(this.fieldTypePanel);
        this.fieldTypePanel.setLayout(fieldTypePanelLayout);
        fieldTypePanelLayout.setHorizontalGroup(fieldTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldTypeComboBox, 0, 271, Short.MAX_VALUE).addContainerGap()));
        fieldTypePanelLayout.setVerticalGroup(fieldTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldTypePanelLayout.createSequentialGroup().addComponent(this.fieldTypeComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.infoLabel.setText("Hinweis: ");
        this.infoLabel.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoLabel, GroupLayout.Alignment.LEADING, -1, 295, Short.MAX_VALUE).addComponent(this.fieldTypePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.tagNamePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancelButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tagNamePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldTypePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel, -1, 128, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.saveButton, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.saveButtonClicked = false;
            this.setVisible(false);
        } else if (e.getActionCommand().equalsIgnoreCase("save")) {
            this.saveButtonClicked = true;
            this.setVisible(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtonState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtonState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtonState();
    }
}

