/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiProjectMetadata;

public class EditTagDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ResetButton cancelButton;
    private JPanel editTagPanel;
    private JPanel tagNamePanel;
    private JComboBox languageComboBox;
    private JLabel languageLabel;
    private SaveButton saveButton;
    private JTextField tagnameTextField;
    private TitledBorder tagNameBorder;
    private HiGroup tag = null;
    private ArrayList<String> languageKeys = new ArrayList();
    private int curLangIndex = 0;
    private int defLangIndex = 0;
    private ArrayList<String> tagMetadata = new ArrayList();
    private boolean saveSelected = false;

    public EditTagDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.updateLanguage();
        this.buildMetadataLanguages();
        this.setBounds(parent.getWidth() / 2 - this.getWidth() / 2, parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public void setTag(HiGroup tag) {
        this.tag = tag;
        this.loadTagData();
    }

    private void buildMetadataLanguages() {
        this.languageComboBox.removeActionListener(this);
        this.languageKeys.clear();
        this.languageComboBox.removeAllItems();
        for (HiProjectMetadata record : HIRuntime.getManager().getProject().getMetadata()) {
            this.languageKeys.add(record.getLanguageID());
            if (record.getLanguageID().compareTo(HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()) == 0) {
                this.defLangIndex = this.languageKeys.size() - 1;
            }
            this.languageComboBox.addItem(MetadataHelper.langToLocale(record.getLanguageID()).getDisplayLanguage());
        }
        if (this.languageComboBox.getModel().getSize() > this.defLangIndex) {
            this.languageComboBox.setSelectedIndex(this.defLangIndex);
        }
        this.curLangIndex = this.defLangIndex;
        this.languageComboBox.addActionListener(this);
        this.loadTagData();
    }

    public void updateLanguage() {
        this.setTitle(Messages.getString("EditTagDialog.edittagname"));
        this.languageLabel.setText(Messages.getString("EditTagDialog.language"));
        this.tagNameBorder.setTitle(Messages.getString("EditTagDialog.tagname"));
        this.tagNamePanel.repaint();
        this.saveButton.setToolTipText(Messages.getString("EditTemplateFieldDialog.AENDERUNGEN_SPEICHERN"));
        this.cancelButton.setToolTipText(Messages.getString("EditTemplateFieldDialog.ABBRUCH"));
    }

    public boolean saveSelected() {
        return this.saveSelected;
    }

    private void loadTagData() {
        if (this.tag != null) {
            this.tagMetadata.clear();
            for (String lang : this.languageKeys) {
                for (HiFlexMetadataRecord rec : this.tag.getMetadata()) {
                    if (rec.getLanguage().compareTo(lang) != 0) continue;
                    this.tagMetadata.add(MetadataHelper.findValue("HIBase", "title", rec));
                }
            }
            this.setTagNameField();
        }
    }

    private void setTagNameField() {
        String name = this.tagMetadata.get(this.curLangIndex);
        if (name == null || name.length() == 0) {
            name = "Tag (" + this.tag.getUUID().split("-")[4] + ")";
            this.tagMetadata.set(this.curLangIndex, name);
        }
        this.tagnameTextField.setText(name);
    }

    private void syncToBuffer() {
        this.tagMetadata.set(this.curLangIndex, this.tagnameTextField.getText());
    }

    private void syncToModel() {
        int i = 0;
        while (i < this.languageKeys.size()) {
            String lang = this.languageKeys.get(i);
            for (HiFlexMetadataRecord rec : this.tag.getMetadata()) {
                if (rec.getLanguage().compareTo(lang) != 0) continue;
                MetadataHelper.setValue("HIBase", "title", this.tagMetadata.get(i), rec);
            }
            ++i;
        }
    }

    private void initComponents() {
        this.editTagPanel = new JPanel();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.saveButton = new SaveButton();
        this.cancelButton = new ResetButton();
        this.tagNamePanel = new JPanel();
        this.tagnameTextField = new JTextField();
        this.setDefaultCloseOperation(0);
        this.languageLabel.setHorizontalAlignment(11);
        this.saveButton.setPreferredSize(new Dimension(24, 24));
        this.cancelButton.setPreferredSize(new Dimension(24, 24));
        this.tagNameBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Tagname", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.tagNamePanel.setBorder(this.tagNameBorder);
        GroupLayout jPanel1Layout = new GroupLayout(this.tagNamePanel);
        this.tagNamePanel.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.tagnameTextField).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.tagnameTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout editTagPanelLayout = new GroupLayout(this.editTagPanel);
        this.editTagPanel.setLayout(editTagPanelLayout);
        editTagPanelLayout.setHorizontalGroup(editTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editTagPanelLayout.createSequentialGroup().addGroup(editTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editTagPanelLayout.createSequentialGroup().addComponent(this.languageLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageComboBox, -2, 199, -2)).addGroup(editTagPanelLayout.createSequentialGroup().addContainerGap().addGroup(editTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editTagPanelLayout.createSequentialGroup().addGap(0, 372, Short.MAX_VALUE).addComponent(this.cancelButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton, -2, -1, -2)).addComponent(this.tagNamePanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        editTagPanelLayout.setVerticalGroup(editTagPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, editTagPanelLayout.createSequentialGroup().addContainerGap().addGroup(editTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageComboBox, -2, -1, -2).addComponent(this.languageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tagNamePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(editTagPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton, -2, -1, -2).addComponent(this.cancelButton, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editTagPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editTagPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.languageComboBox) {
            if (this.languageKeys.size() > 0) {
                this.syncToBuffer();
                this.curLangIndex = this.languageComboBox.getSelectedIndex();
                this.setTagNameField();
            }
        } else {
            if (e.getSource() == this.saveButton) {
                this.syncToBuffer();
                this.syncToModel();
                this.saveSelected = true;
            } else {
                this.saveSelected = false;
            }
            this.setVisible(false);
        }
    }
}

