/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class EditTemplateDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private ResetButton cancelButton;
    private SaveButton saveButton;
    private JLabel infoLabel;
    private JLabel nsPrefixLabel;
    private JPanel templateURIPanel;
    private TitledBorder templateURIBorder;
    private JTextField templateURITextField;
    private JPanel templateURLPanel;
    private TitledBorder templateURLBorder;
    private JTextField templateURLTextField;
    private boolean saveButtonClicked = false;

    public EditTemplateDialog(JFrame parent) {
        super(parent);
        this.initComponents();
        this.updateLanguage();
        this.setBounds(parent.getWidth() / 2 - this.getWidth() / 2, parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.templateURITextField.getDocument().addDocumentListener(this);
        this.templateURLTextField.getDocument().addDocumentListener(this);
    }

    public void updateLanguage() {
        this.setTitle(Messages.getString("EditTemplateDialog.TEMPLATE_BEARBEITEN"));
        this.templateURIBorder.setTitle(Messages.getString("EditTemplateDialog.NAMESPACE_URI"));
        this.templateURIPanel.repaint();
        this.templateURLBorder.setTitle(Messages.getString("EditTemplateDialog.SCHEMA_URL"));
        this.templateURLPanel.repaint();
        this.infoLabel.repaint();
        this.nsPrefixLabel.repaint();
        this.saveButton.setToolTipText(Messages.getString("EditTemplateDialog.AENDERUNGEN_SPEICHERN"));
        this.cancelButton.setToolTipText(Messages.getString("EditTemplateDialog.ABBRUCH"));
        this.updateButtonState();
    }

    public boolean showEditTemplateDialog(HiFlexMetadataTemplate template) {
        this.saveButtonClicked = false;
        this.setModal(false);
        this.setVisible(true);
        this.nsPrefixLabel.setText(String.valueOf(Messages.getString("EditTemplateDialog.PREFIX")) + ": " + template.getNamespacePrefix());
        this.infoLabel.setText("");
        this.templateURITextField.setText(template.getNamespaceURI());
        this.templateURLTextField.setText(template.getNamespaceURL());
        this.updateButtonState();
        this.updateLanguage();
        this.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
        return this.saveButtonClicked;
    }

    public String getChangedURI() {
        return this.templateURITextField.getText();
    }

    public String getChangedURL() {
        return this.templateURLTextField.getText();
    }

    private void updateButtonState() {
        this.saveButton.setEnabled(false);
        this.infoLabel.setText("");
        if (this.templateURITextField.getText().length() == 0 && this.templateURLTextField.getText().length() == 0) {
            this.saveButton.setEnabled(true);
        } else {
            try {
                this.saveButton.setEnabled(true);
                if (this.templateURITextField.getText().length() > 0) {
                    new URI(this.templateURITextField.getText());
                }
                if (this.templateURLTextField.getText().length() > 0) {
                    new URL(this.templateURLTextField.getText());
                }
            }
            catch (URISyntaxException urie) {
                this.infoLabel.setText("<html><font color='#FF0000'>" + Messages.getString("EditTemplateDialog.HINWEIS_URI") + "</font></html>");
                this.saveButton.setEnabled(false);
            }
            catch (MalformedURLException urle) {
                this.infoLabel.setText("<html><font color='#FF0000'>" + Messages.getString("EditTemplateDialog.HINWEIS_URL") + "</font></html>");
                this.saveButton.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.templateURIPanel = new JPanel();
        this.templateURITextField = new JTextField();
        this.templateURLPanel = new JPanel();
        this.templateURLTextField = new JTextField();
        this.infoLabel = new JLabel();
        this.cancelButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.nsPrefixLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.templateURIBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.templateURIPanel.setBorder(this.templateURIBorder);
        GroupLayout templateURIPanelLayout = new GroupLayout(this.templateURIPanel);
        this.templateURIPanel.setLayout(templateURIPanelLayout);
        templateURIPanelLayout.setHorizontalGroup(templateURIPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, templateURIPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.templateURITextField, -1, 467, Short.MAX_VALUE).addContainerGap()));
        templateURIPanelLayout.setVerticalGroup(templateURIPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templateURIPanelLayout.createSequentialGroup().addComponent(this.templateURITextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.templateURLBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.templateURLPanel.setBorder(this.templateURLBorder);
        GroupLayout templateURLPanelLayout = new GroupLayout(this.templateURLPanel);
        this.templateURLPanel.setLayout(templateURLPanelLayout);
        templateURLPanelLayout.setHorizontalGroup(templateURLPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templateURLPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.templateURLTextField, -1, 467, Short.MAX_VALUE).addContainerGap()));
        templateURLPanelLayout.setVerticalGroup(templateURLPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(templateURLPanelLayout.createSequentialGroup().addComponent(this.templateURLTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.infoLabel.setText("Hinweis: ");
        this.infoLabel.setVerticalAlignment(1);
        this.nsPrefixLabel.setText("Prefix: ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.infoLabel, -1, 485, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateURLPanel, -1, -1, Short.MAX_VALUE).addComponent(this.templateURIPanel, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.nsPrefixLabel, -1, 413, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.templateURIPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateURLPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.infoLabel, -1, 62, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.saveButton, -2, -1, -2).addComponent(this.nsPrefixLabel)).addContainerGap()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.saveButtonClicked = false;
            this.setVisible(false);
        } else if (e.getActionCommand().equalsIgnoreCase("save")) {
            this.saveButtonClicked = true;
            this.setVisible(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtonState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtonState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtonState();
    }
}

