/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.ResetButton;
import org.hyperimage.client.gui.SaveButton;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiFlexMetadataSet;

public class EditTemplateFieldDialog
extends JDialog
implements ActionListener {
    private SaveButton saveButton;
    private ResetButton cancelButton;
    private JPanel displayNamePanel;
    private TitledBorder displayNameBorder;
    private JTextField displayNameTextField;
    private JLabel tagInfoLabel;
    private HiFlexMetadataSet set;
    private String displayName;
    private Locale osLang;

    public EditTemplateFieldDialog(JFrame parent) {
        super(parent);
        this.initComponents();
        this.updateLanguage();
        this.setBounds(parent.getWidth() / 2 - this.getWidth() / 2, parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public void updateLanguage() {
        this.setTitle(Messages.getString("EditTemplateFieldDialog.METADATENFELD_BEARBEITEN"));
        this.displayNameBorder.setTitle(Messages.getString("EditTemplateFieldDialog.ANZEIGENAME"));
        this.displayNamePanel.repaint();
        this.saveButton.setToolTipText(Messages.getString("EditTemplateFieldDialog.AENDERUNGEN_SPEICHERN"));
        this.cancelButton.setToolTipText(Messages.getString("EditTemplateFieldDialog.ABBRUCH"));
    }

    public void showEditFieldDialog(HiFlexMetadataSet set, Locale osLang) {
        this.set = set;
        this.osLang = osLang;
        this.displayName = MetadataHelper.getTemplateKeyDisplayName(null, set, MetadataHelper.localeToLangID(osLang));
        if (this.displayName == null || this.displayName.length() == 0) {
            this.displayName = "";
        }
        this.displayNameTextField.setText(this.displayName);
        this.setModal(false);
        this.setVisible(true);
        this.tagInfoLabel.setText(String.valueOf(Messages.getString("EditTemplateFieldDialog.TAG")) + ": " + set.getTagname());
        this.updateLanguage();
        this.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
    }

    public String getChangedDisplayName() {
        return this.displayNameTextField.getText();
    }

    private void initComponents() {
        this.cancelButton = new ResetButton();
        this.saveButton = new SaveButton();
        this.displayNamePanel = new JPanel();
        this.displayNameTextField = new JTextField();
        this.tagInfoLabel = new JLabel();
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.displayNameBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.displayNamePanel.setBorder(this.displayNameBorder);
        GroupLayout displayNamePanelLayout = new GroupLayout(this.displayNamePanel);
        this.displayNamePanel.setLayout(displayNamePanelLayout);
        displayNamePanelLayout.setHorizontalGroup(displayNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(displayNamePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayNameTextField, -1, 462, Short.MAX_VALUE).addContainerGap()));
        displayNamePanelLayout.setVerticalGroup(displayNamePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(displayNamePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayNameTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.tagInfoLabel.setText("Tag:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayNamePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.cancelButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tagInfoLabel, -1, 414, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.displayNamePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.saveButton, -2, -1, -2)).addComponent(this.tagInfoLabel)).addContainerGap()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("reset")) {
            this.displayNameTextField.setText(this.displayName);
            this.setVisible(false);
        } else if (e.getActionCommand().equalsIgnoreCase("save")) {
            this.setVisible(false);
        }
    }
}

