/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.hyperimage.client.Messages;
import org.jdesktop.layout.GroupLayout;

public class ExportProjectDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -5157327724136384906L;
    private ButtonGroup exportFormatButtonGroup;
    private JLabel exportFormatLabel;
    private JRadioButton petal2RadioButton;
    private JRadioButton petal3RadioButton;
    private JButton cancelButton;
    private JCheckBox exportBinariesCheckBox;
    private JButton exportButton;
    private JPanel exportOptionsPanel;
    private JFrame parent;
    private TitledBorder exportOptionsBorder;
    private JLabel exportNoteLabel;
    private JFileChooser exportDirChooser;
    private File exportDir;

    public ExportProjectDialog(JFrame owner) {
        super(owner);
        this.parent = owner;
        this.initComponents();
        this.exportButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void updateLanguage() {
        this.exportOptionsBorder.setTitle(Messages.getString("ExportProjectDialog.1"));
        this.exportBinariesCheckBox.setText(Messages.getString("ExportProjectDialog.3"));
        this.exportButton.setText(Messages.getString("ExportProjectDialog.8"));
        this.cancelButton.setText(Messages.getString("ExportProjectDialog.9"));
        this.setTitle(Messages.getString("ExportProjectDialog.12"));
        this.exportNoteLabel.setText("<html>" + Messages.getString("ExportProjectDialog.17") + "</html>");
        this.exportFormatLabel.setText("Ausgabeformat:");
        this.exportDirChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Messages.getString("ExportProjectDialog.13");
            }
        });
    }

    public boolean displayExportDialog() {
        this.setBounds(this.parent.getWidth() / 2 - this.getWidth() / 2, this.parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.exportDir = null;
        this.updateLanguage();
        this.setVisible(true);
        return this.exportDir != null;
    }

    public File getExportDir() {
        return this.exportDir;
    }

    public boolean isPeTAL3Mode() {
        return this.petal3RadioButton.isSelected();
    }

    public boolean isExportingBinaries() {
        return this.exportBinariesCheckBox.isSelected();
    }

    private void initComponents() {
        this.exportOptionsPanel = new JPanel();
        this.exportBinariesCheckBox = new JCheckBox();
        this.exportButton = new JButton();
        this.cancelButton = new JButton();
        this.exportNoteLabel = new JLabel();
        this.exportFormatButtonGroup = new ButtonGroup();
        this.petal3RadioButton = new JRadioButton();
        this.petal2RadioButton = new JRadioButton();
        this.exportFormatLabel = new JLabel();
        this.exportBinariesCheckBox.setSelected(true);
        this.exportFormatButtonGroup.add(this.petal3RadioButton);
        this.petal3RadioButton.setSelected(true);
        this.petal3RadioButton.setText("PeTAL 3.0");
        this.exportFormatButtonGroup.add(this.petal2RadioButton);
        this.petal2RadioButton.setText("PeTAL 2.0");
        this.setModal(true);
        this.exportOptionsBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("ExportProjectDialog.1"), 0, 0, new Font("Lucida Grande", 0, 13), Color.blue);
        this.exportOptionsPanel.setBorder(this.exportOptionsBorder);
        GroupLayout exportOptionsPanelLayout = new GroupLayout(this.exportOptionsPanel);
        this.exportOptionsPanel.setLayout(exportOptionsPanelLayout);
        exportOptionsPanelLayout.setHorizontalGroup(exportOptionsPanelLayout.createParallelGroup(1).add(exportOptionsPanelLayout.createSequentialGroup().addContainerGap().add(exportOptionsPanelLayout.createParallelGroup(1).add(exportOptionsPanelLayout.createSequentialGroup().add(this.exportFormatLabel).addPreferredGap(0).add(this.petal3RadioButton).addPreferredGap(0).add(this.petal2RadioButton).addContainerGap(-1, Short.MAX_VALUE)).add(this.exportNoteLabel, -1, 596, Short.MAX_VALUE).add(2, this.exportBinariesCheckBox, -1, -1, Short.MAX_VALUE))));
        exportOptionsPanelLayout.setVerticalGroup(exportOptionsPanelLayout.createParallelGroup(1).add(exportOptionsPanelLayout.createSequentialGroup().add(exportOptionsPanelLayout.createParallelGroup(3).add(this.petal3RadioButton).add(this.petal2RadioButton).add(this.exportFormatLabel)).addPreferredGap(0).add(this.exportBinariesCheckBox).addPreferredGap(1).add(this.exportNoteLabel, -2, 86, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.exportOptionsPanel, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.cancelButton).addPreferredGap(0).add(this.exportButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.exportOptionsPanel, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.exportButton).add(this.cancelButton)).addContainerGap()));
        this.exportButton.setActionCommand("export");
        this.cancelButton.setActionCommand("cancel");
        this.exportDirChooser = new JFileChooser();
        this.exportDirChooser.setFileSelectionMode(1);
        this.exportDirChooser.setMultiSelectionEnabled(false);
        this.exportDirChooser.setFileHidingEnabled(true);
        this.exportDirChooser.setAcceptAllFileFilterUsed(false);
        this.updateLanguage();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("export")) {
            this.exportDirChooser.showDialog(this.parent, Messages.getString("ExportProjectDialog.15"));
            File exportDir = this.exportDirChooser.getSelectedFile();
            if (exportDir != null && !exportDir.exists() && exportDir.getAbsolutePath().lastIndexOf(File.separatorChar) >= 0) {
                exportDir = new File(exportDir.getAbsolutePath().substring(0, exportDir.getAbsolutePath().lastIndexOf(File.separatorChar)));
            }
            this.exportDir = exportDir != null && exportDir.exists() ? exportDir : null;
            if (this.exportDir != null && this.exportDir.exists()) {
                this.setVisible(false);
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("cancel")) {
            this.exportDir = null;
            this.setVisible(false);
        }
    }
}

