/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.Messages;
import org.hyperimage.client.exception.HIWebServiceException;
import org.hyperimage.client.gui.VisualTag;
import org.hyperimage.client.gui.lists.TagListCellRenderer;
import org.hyperimage.client.ws.HiGroup;

public class HIBaseTagsEditorDialog
extends JDialog
implements ActionListener {
    private long baseID;
    private DefaultComboBoxModel tagListModel;
    private ArrayList<HiGroup> baseTags;
    JPanel editorPanel;
    JLabel infoLabel;
    JLabel noTagsInfoLabel;
    JComboBox tagListComboBox;
    JPanel tagPanel;
    JScrollPane tagScroll;

    public HIBaseTagsEditorDialog(Frame parent, long baseID) {
        super(parent);
        try {
            HIRuntime.getGui().startIndicatingServiceActivity();
            this.baseTags = HIRuntime.getManager().getTagsForBaseElement(baseID);
            HIRuntime.getGui().stopIndicatingServiceActivity();
        }
        catch (HIWebServiceException wse) {
            HIRuntime.getGui().stopIndicatingServiceActivity();
            HIRuntime.getGui().reportError(wse, null);
            this.setVisible(false);
            return;
        }
        this.initComponents();
        this.updateLanguage();
        this.baseID = baseID;
        this.tagListModel = new DefaultComboBoxModel();
        this.tagListComboBox.setModel(this.tagListModel);
        this.tagListComboBox.setRenderer(new TagListCellRenderer());
        this.tagListComboBox.addActionListener(this);
        this.populateAvailableTagsList();
    }

    public void updateLanguage() {
        this.setTitle(Messages.getString("HIBaseTagsEditorDialog.title"));
        this.infoLabel.setText(Messages.getString("HIBaseTagsEditorDialog.note"));
        this.noTagsInfoLabel.setText(Messages.getString("HIBaseTagsEditorDialog.notags"));
    }

    private void populateAvailableTagsList() {
        try {
            List<HiGroup> projectTags = HIRuntime.getManager().getTags();
            if (projectTags.size() > 0) {
                this.tagListModel.addElement(Messages.getString("HIBaseTagsEditorDialog.addtag"));
            } else {
                this.tagListModel.addElement(Messages.getString("HIBaseTagsEditorDialog.noprojecttags"));
            }
            for (HiGroup tag : projectTags) {
                boolean tagFound = false;
                for (HiGroup bTag : this.baseTags) {
                    if (bTag.getId() != tag.getId()) continue;
                    tagFound = true;
                    this.tagPanel.add(new VisualTag(tag, this));
                }
                if (tagFound) continue;
                this.tagListModel.addElement(tag);
            }
            this.tagListComboBox.setSelectedIndex(0);
            if (this.tagPanel.getComponentCount() <= 1) {
                this.noTagsInfoLabel.setVisible(true);
            } else {
                this.noTagsInfoLabel.setVisible(false);
            }
        }
        catch (HIWebServiceException ex) {
            Logger.getLogger(HIBaseTagsEditorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int chooseTags() {
        this.setLocationRelativeTo(HIRuntime.getGui());
        this.setVisible(true);
        return this.tagPanel.getComponentCount() - 1;
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.tagListComboBox = new JComboBox();
        this.tagScroll = new JScrollPane();
        this.tagPanel = new JPanel();
        this.noTagsInfoLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Element Tags Bearbeiten");
        this.setModal(true);
        this.editorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Tags", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.tagPanel.setPreferredSize(new Dimension(200, 22));
        this.noTagsInfoLabel.setText("- Keine Tags hinzugef\u00fcgt -");
        this.tagPanel.add(this.noTagsInfoLabel);
        this.tagScroll.setViewportView(this.tagPanel);
        this.infoLabel.setText("Hinweis: \u00c4nderungen werden sofort gespeichert.");
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addContainerGap().addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tagScroll).addComponent(this.infoLabel, -1, 318, Short.MAX_VALUE))).addComponent(this.tagListComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addComponent(this.tagListComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagScroll, -1, 131, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 342, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 217, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean success;
        HiGroup tag;
        if (e.getSource() == this.tagListComboBox && this.tagListComboBox.getSelectedIndex() > 0) {
            tag = (HiGroup)this.tagListModel.getElementAt(this.tagListComboBox.getSelectedIndex());
            this.tagListComboBox.setSelectedIndex(0);
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().addToGroup(this.baseID, tag.getId());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                success = true;
            }
            catch (HIWebServiceException wse) {
                success = false;
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().reportError(wse, null);
            }
            if (success) {
                this.tagListModel.removeElement(tag);
                this.noTagsInfoLabel.setVisible(false);
                this.tagPanel.add(new VisualTag(tag, this));
            }
        }
        if (e.getSource().getClass() == JButton.class) {
            tag = ((VisualTag)((JButton)e.getSource()).getParent()).getModel();
            try {
                HIRuntime.getGui().startIndicatingServiceActivity();
                HIRuntime.getManager().removeFromGroup(this.baseID, tag.getId());
                HIRuntime.getGui().stopIndicatingServiceActivity();
                success = true;
            }
            catch (HIWebServiceException wse) {
                success = false;
                HIRuntime.getGui().stopIndicatingServiceActivity();
                HIRuntime.getGui().reportError(wse, null);
            }
            if (success) {
                this.tagPanel.remove(((JButton)e.getSource()).getParent());
                this.tagListModel.addElement(tag);
                if (this.tagPanel.getComponentCount() <= 1) {
                    this.noTagsInfoLabel.setVisible(true);
                }
                this.tagPanel.repaint();
            }
        }
    }
}

