/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class LoginDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = -1231146231949571153L;
    private JPanel authPanel;
    private JLabel infoLabel;
    private JButton loginButton;
    private JPasswordField passwordField;
    private JPanel passwordPanel;
    private JButton quitButton;
    private JPanel userPanel;
    private JTextField userTextField;
    private JFrame parent;
    private boolean loginButtonClicked = false;

    public LoginDialog(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.initComponents();
        this.userTextField.addActionListener(this);
        this.userTextField.getDocument().addDocumentListener(this);
        this.passwordField.addActionListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.loginButton.addActionListener(this);
        this.quitButton.addActionListener(this);
    }

    public boolean promptLogin(String username) {
        this.userTextField.setText(username);
        this.passwordField.setText("");
        this.loginButtonClicked = false;
        this.setBounds(this.parent.getWidth() / 2 - this.getWidth() / 2, this.parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.updateButtonStatus();
        this.setModal(false);
        this.setVisible(true);
        this.infoLabel.repaint();
        this.setVisible(false);
        this.setModal(true);
        if (this.userTextField.getText().length() == 0) {
            this.userTextField.requestFocusInWindow();
        } else {
            this.passwordField.requestFocusInWindow();
        }
        this.setVisible(true);
        return this.loginButtonClicked;
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public String getPassword() {
        return String.valueOf(this.passwordField.getPassword());
    }

    public void setInfoLabel(String text, Color color) {
        this.infoLabel.setText(text);
        this.infoLabel.setForeground(color);
    }

    private void initComponents() {
        this.authPanel = new JPanel();
        this.loginButton = new JButton();
        this.quitButton = new JButton();
        this.userPanel = new JPanel();
        this.userTextField = new JTextField();
        this.passwordPanel = new JPanel();
        this.passwordField = new JPasswordField();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(1);
        this.loginButton.setText("Login");
        this.loginButton.setFocusCycleRoot(true);
        this.quitButton.setText("Beenden");
        this.userPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Benutzername"));
        GroupLayout userPanelLayout = new GroupLayout(this.userPanel);
        this.userPanel.setLayout(userPanelLayout);
        userPanelLayout.setHorizontalGroup(userPanelLayout.createParallelGroup(1).add(this.userTextField, -1, 237, Short.MAX_VALUE));
        userPanelLayout.setVerticalGroup(userPanelLayout.createParallelGroup(1).add(this.userTextField, -2, -1, -2));
        this.passwordPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Passwort"));
        GroupLayout passwordPanelLayout = new GroupLayout(this.passwordPanel);
        this.passwordPanel.setLayout(passwordPanelLayout);
        passwordPanelLayout.setHorizontalGroup(passwordPanelLayout.createParallelGroup(1).add(this.passwordField, -1, 237, Short.MAX_VALUE));
        passwordPanelLayout.setVerticalGroup(passwordPanelLayout.createParallelGroup(1).add(this.passwordField, -2, -1, -2));
        this.infoLabel.setForeground(Color.blue);
        this.infoLabel.setText("Bitte melden Sie sich an:");
        GroupLayout authPanelLayout = new GroupLayout(this.authPanel);
        this.authPanel.setLayout(authPanelLayout);
        authPanelLayout.setHorizontalGroup(authPanelLayout.createParallelGroup(1).add(2, authPanelLayout.createSequentialGroup().addContainerGap().add(authPanelLayout.createParallelGroup(2).add(authPanelLayout.createSequentialGroup().add(this.loginButton).addPreferredGap(0).add(this.quitButton)).add(1, this.infoLabel, -1, 249, Short.MAX_VALUE).add(1, this.passwordPanel, -1, -1, Short.MAX_VALUE).add(1, this.userPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        authPanelLayout.setVerticalGroup(authPanelLayout.createParallelGroup(1).add(authPanelLayout.createSequentialGroup().addContainerGap().add(this.infoLabel).addPreferredGap(0).add(this.userPanel, -2, -1, -2).addPreferredGap(0).add(this.passwordPanel, -2, -1, -2).addPreferredGap(0).add(authPanelLayout.createParallelGroup(3).add(this.quitButton).add(this.loginButton)).add(50, 50, 50)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.authPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.authPanel, -2, 207, -2));
        this.pack();
        this.setTitle("Yenda Login");
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ((e.getSource() == this.loginButton || e.getSource() == this.passwordField) && this.loginButton.isEnabled()) {
            this.loginButtonClicked = true;
            this.setVisible(false);
        }
        if (e.getSource() == this.quitButton) {
            this.loginButtonClicked = false;
            this.setVisible(false);
        }
        if (e.getSource() == this.userTextField) {
            this.passwordField.requestFocus();
        }
    }

    private void updateButtonStatus() {
        if (this.userTextField.getText().length() > 0 && this.passwordField.getPassword().length > 0) {
            this.loginButton.setEnabled(true);
        } else {
            this.loginButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtonStatus();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtonStatus();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtonStatus();
    }
}

