/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.gui.dialogs.ProjectChooserDialog;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiProject;

public class ProjectChooser
implements MouseListener,
ActionListener,
ListSelectionListener {
    private DefaultListModel projectListModel = new DefaultListModel();
    private ProjectChooserDialog projChooserDialog;
    private JFrame parent;
    private HiProject selectedProject;
    private int selectedIndex;
    private List<HiProject> projects;

    public ProjectChooser(JFrame parent) {
        this.parent = parent;
        this.projChooserDialog = new ProjectChooserDialog(parent);
        this.projChooserDialog.getProjectList().setModel(this.projectListModel);
        this.projChooserDialog.getProjectList().addMouseListener(this);
        this.projChooserDialog.getProjectList().addListSelectionListener(this);
        this.projChooserDialog.getOkButton().addActionListener(this);
        this.projChooserDialog.getCancelButton().addActionListener(this);
    }

    public HiProject selectProject(List<HiProject> projects) {
        this.projects = projects;
        this.selectedIndex = 0;
        this.projectListModel.removeAllElements();
        for (HiProject project : projects) {
            this.projectListModel.addElement(project);
        }
        if (projects.size() > 0) {
            this.projChooserDialog.getProjectList().setSelectedIndex(0);
        }
        this.selectedProject = projects.get(this.selectedIndex);
        this.projChooserDialog.setBounds(this.parent.getWidth() / 2 - this.projChooserDialog.getWidth() / 2, this.parent.getHeight() / 2 - this.projChooserDialog.getHeight() / 2, this.projChooserDialog.getWidth(), this.projChooserDialog.getHeight());
        if (HIRuntime.OAUTHMode && System.getProperty("jnlp.collection") != null) {
            HiProject prProject = null;
            for (HiProject tempProject : projects) {
                if (MetadataHelper.findPreferenceValue(tempProject, "PRCollectionID") == null || MetadataHelper.findPreferenceValue(tempProject, "PRCollectionID").compareTo(System.getProperty("jnlp.collection")) != 0) continue;
                prProject = tempProject;
            }
            if (prProject != null) {
                return prProject;
            }
        }
        if (projects.size() <= 1) {
            return projects.get(0);
        }
        this.projChooserDialog.setVisible(true);
        return this.selectedProject;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.projChooserDialog.setVisible(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selectedProject = e.getActionCommand().equalsIgnoreCase("selectProject") ? this.projects.get(this.selectedIndex) : null;
        this.projChooserDialog.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.projChooserDialog.getProjectList().getSelectedIndex() == -1) {
            this.projChooserDialog.getProjectList().setSelectedIndex(this.selectedIndex);
            return;
        }
        if (this.projChooserDialog.getProjectList().getSelectedIndex() != this.selectedIndex) {
            this.selectedIndex = this.projChooserDialog.getProjectList().getSelectedIndex();
            this.selectedProject = this.projects.get(this.selectedIndex);
        }
    }
}

