/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.hyperimage.client.Messages;
import org.hyperimage.client.util.HIPreferenceManager;
import org.jdesktop.layout.GroupLayout;

public class ServerSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -7224870203298950023L;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    HIPreferenceManager m_prefs = new HIPreferenceManager();
    private static final String CONNECT = "connect";
    private static final String CBEDIT = "comboBoxEdited";
    private static String m_serverURL = "";
    private static String m_strStatus = Messages.getString("ServerDialog.pleasechooseserver");

    public ServerSelectionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pimpComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Server:");
        this.jComboBox1.setEditable(true);
        this.jButton1.setText(Messages.getString("ServerDialog.connecttoserver"));
        this.jButton2.setText(Messages.getString("ServerDialog.cancel"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.jComboBox1, 0, 504, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(145, 145, 145).add(this.jButton1).add(47, 47, 47).add(this.jButton2))).addContainerGap()).add(2, layout.createSequentialGroup().addContainerGap(278, Short.MAX_VALUE).add(this.jLabel2).add(265, 265, 265)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel1).add(this.jComboBox1, -2, -1, -2)).addPreferredGap(0).add(this.jLabel2, -2, 15, Short.MAX_VALUE).add(9, 9, 9).add(layout.createParallelGroup(1).add(this.jButton2, -2, 29, -2).add(this.jButton1)).addContainerGap()));
        this.pack();
    }

    private void pimpComponents() {
        this.jLabel2.setText(m_strStatus);
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerSelectionDialog.this.processConnectionEvent(ae);
            }
        });
        ArrayDeque<String> serverDeq = this.m_prefs.getServerPref();
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(serverDeq.toArray()));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerSelectionDialog.this.processConnectionEvent();
            }
        });
        this.jButton1.requestFocus();
        this.jButton1.getInputMap().put(KeyStroke.getKeyStroke(10, 0), CONNECT);
        this.jButton1.getActionMap().put(CONNECT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerSelectionDialog.this.processConnectionEvent();
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
    }

    protected void processConnectionEvent(ActionEvent ae) {
        String strAC = ae.getActionCommand();
        if (strAC.compareTo(CBEDIT) == 0) {
            JComboBox cb = (JComboBox)ae.getSource();
            m_serverURL = (String)cb.getSelectedItem();
            if (this.isValidURL(m_serverURL)) {
                this.m_prefs.putServerPref(m_serverURL);
                this.dispose();
            } else {
                m_serverURL = "";
                System.out.println("Display error message and allow user to retry");
            }
        }
    }

    protected void processConnectionEvent() {
        m_serverURL = (String)this.jComboBox1.getSelectedItem();
        if (this.isValidURL(m_serverURL)) {
            System.out.println("connect to the server " + this.jComboBox1.getSelectedItem());
            this.m_prefs.putServerPref(m_serverURL);
            this.dispose();
        } else {
            m_serverURL = "";
        }
    }

    private boolean isValidURL(String strURL) {
        boolean bRetVal = true;
        try {
            URL uRL = new URL(strURL);
        }
        catch (MalformedURLException mue) {
            System.out.println("url exception: " + mue.getMessage());
            m_strStatus = mue.getLocalizedMessage();
            this.jLabel2.repaint();
            this.jLabel2.doLayout();
            this.doLayout();
            bRetVal = false;
        }
        return bRetVal;
    }

    public String getURL() {
        return m_serverURL;
    }
}

