/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.hyperimage.client.Messages;
import org.hyperimage.client.xmlimportexport.XMLImporter;

public class XMLImportProjectDialog
extends JDialog {
    private final Frame parent;
    private final JFileChooser importXMLChooser;
    private File importXMLFile = null;
    private static final String PeTAL_Description = "PeTAL 3.0 / 2.0 XML";
    private static final String VRA4_Description = "VRA Core 4 XML";
    private static final String VRA4Hdlbg_Description = "VRA Core 4 XML (extended)";
    private static final FileFilter petalFileFilter = new FileNameExtensionFilter("PeTAL 3.0 / 2.0 XML", "xml");
    private static final FileFilter vra4FileFilter = new FileNameExtensionFilter("VRA Core 4 XML", "xml");
    private static final FileFilter vra4hdlbgFileFilter = new FileNameExtensionFilter("VRA Core 4 XML (extended)", "xml");
    private XMLImporter.XMLFormat chosenFormat = XMLImporter.XMLFormat.UNRECOGNISED;
    private JButton cancelButton;
    private JButton importButton;
    private JPanel importPanel;
    private JLabel infoLabel;

    public XMLImportProjectDialog(Frame parent) {
        super(parent);
        this.parent = parent;
        this.setModal(true);
        this.importXMLChooser = new JFileChooser();
        this.importXMLChooser.setFileSelectionMode(0);
        this.importXMLChooser.setMultiSelectionEnabled(true);
        this.importXMLChooser.setFileHidingEnabled(true);
        this.importXMLChooser.setAcceptAllFileFilterUsed(false);
        this.importXMLChooser.addChoosableFileFilter(petalFileFilter);
        this.importXMLChooser.addChoosableFileFilter(vra4hdlbgFileFilter);
        this.importXMLChooser.setFileFilter(petalFileFilter);
        this.initComponents();
    }

    public boolean displayImportDialog() {
        this.setBounds(this.parent.getWidth() / 2 - this.getWidth() / 2, this.parent.getHeight() / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.importXMLFile = null;
        this.updateLanguage();
        this.setVisible(true);
        return this.importXMLFile != null;
    }

    public File getImportXMLFile() {
        return this.importXMLFile;
    }

    private void updateLanguage() {
        this.setTitle(Messages.getString("XMLImportProjectDialog.0"));
        this.infoLabel.setText("<html>" + Messages.getString("XMLImportProjectDialog.1") + "</html>");
        this.importButton.setText(Messages.getString("XMLImportProjectDialog.2"));
        this.cancelButton.setText(Messages.getString("XMLImportProjectDialog.3"));
        ((TitledBorder)this.importPanel.getBorder()).setTitle(Messages.getString("XMLImportProjectDialog.5"));
    }

    private void initComponents() {
        this.importPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.importButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(Messages.getString("XMLImportProjectDialog.0"));
        this.importPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font("Lucida Grande", 0, 13), Color.blue));
        this.infoLabel.setText(Messages.getString("XMLImportProjectDialog.1"));
        this.infoLabel.setVerticalAlignment(1);
        GroupLayout importPanelLayout = new GroupLayout(this.importPanel);
        this.importPanel.setLayout(importPanelLayout);
        importPanelLayout.setHorizontalGroup(importPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(importPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -2, 634, Short.MAX_VALUE).addContainerGap()));
        importPanelLayout.setVerticalGroup(importPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(importPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -1, 124, Short.MAX_VALUE).addContainerGap()));
        this.importButton.setText(Messages.getString("XMLImportProjectDialog.2"));
        this.importButton.setActionCommand("import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLImportProjectDialog.this.buttonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(Messages.getString("XMLImportProjectDialog.3"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLImportProjectDialog.this.buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.importPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.importPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.importButton)).addContainerGap()));
        this.pack();
    }

    private void buttonActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("cancel")) {
            this.importXMLFile = null;
            this.setVisible(false);
        } else if (evt.getActionCommand().equalsIgnoreCase("import")) {
            this.importXMLChooser.showOpenDialog(this.parent);
            this.importXMLFile = this.importXMLChooser.getSelectedFile();
            String strFileDescription = this.importXMLChooser.getFileFilter().getDescription();
            if (strFileDescription.equals(PeTAL_Description)) {
                this.chosenFormat = XMLImporter.XMLFormat.PETAL_2_0_XML;
            } else if (strFileDescription.equals(VRA4_Description)) {
                this.chosenFormat = XMLImporter.XMLFormat.VRA_4_XML;
            } else if (strFileDescription.equals(VRA4Hdlbg_Description)) {
                this.chosenFormat = XMLImporter.XMLFormat.VRA_4_HDLBG_XML;
            }
            if (this.importXMLFile != null) {
                this.setVisible(false);
            }
        }
    }

    public boolean isPeTAL_Expected() {
        return this.chosenFormat == XMLImporter.XMLFormat.PETAL_2_0_XML;
    }

    public boolean isVRA4_Expected() {
        return this.chosenFormat == XMLImporter.XMLFormat.VRA_4_XML;
    }

    public boolean isVRA4Hdlbg_Expected() {
        return this.chosenFormat == XMLImporter.XMLFormat.VRA_4_HDLBG_XML;
    }
}

