/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.GroupTypes;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiGroup;
import org.hyperimage.client.ws.HiProject;

public class GroupTransferable
implements Transferable {
    public static final DataFlavor groupFlavor = new DataFlavor("application/x-java-jvm-local-objectref;" + HiGroup.class.toString().replaceAll(" ", "="), "HyperImage Group");
    private HiGroup group;

    public GroupTransferable(HiGroup group) {
        this.group = group;
    }

    private String getId() {
        if (this.group == null) {
            return "";
        }
        return "Gruppe G" + this.group.getId();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            if (this.group.getType() == GroupTypes.HIGROUP_IMPORT) {
                return "Import Gruppe";
            }
            if (this.group.getType() == GroupTypes.HIGROUP_TRASH) {
                return "Papierkorb";
            }
            HiProject project = null;
            if (HIRuntime.getManager() != null) {
                project = HIRuntime.getManager().getProject();
            }
            if (project == null) {
                return this.getId();
            }
            String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)this.group, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
            if (title == null || title.length() == 0) {
                return this.getId();
            }
            return title;
        }
        if (flavor == groupFlavor) {
            return this.group;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, groupFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor || flavor == groupFlavor;
    }
}

