/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiProject;

public class LayerTransferable
implements Transferable {
    public static final DataFlavor layerFlavor = new DataFlavor("application/x-java-jvm-local-objectref;" + HILayer.class.toString().replaceAll(" ", "="), "HyperImage Layer");
    private HILayer layer;

    public LayerTransferable(HILayer layer) {
        this.layer = layer;
    }

    private String getId() {
        if (this.layer == null) {
            return "";
        }
        return "Layer L" + this.layer.getModel().getId();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (flavor == DataFlavor.stringFlavor) {
            HiProject project = null;
            if (HIRuntime.getManager() != null) {
                project = HIRuntime.getManager().getProject();
            }
            if (project == null) {
                return this.getId();
            }
            String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)this.layer.getModel(), HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
            if (title == null || title.length() == 0) {
                return this.getId();
            }
            return title;
        }
        if (flavor == layerFlavor) {
            return this.layer;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, layerFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor || flavor == layerFlavor;
    }
}

