/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Locale;
import org.hyperimage.client.util.MetadataHelper;

public class LocaleTransferable
implements Transferable {
    public static final DataFlavor localeFlavor = new DataFlavor("application/x-java-jvm-local-objectref;" + Locale.class.toString().replaceAll(" ", "="), "HyperImage Locale - Project Language");
    private Locale lang;

    public LocaleTransferable(Locale lang) {
        this.lang = lang;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            String title = MetadataHelper.localeToLangID(this.lang);
            return title;
        }
        if (flavor == localeFlavor) {
            return this.lang;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, localeFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor || flavor == localeFlavor;
    }
}

