/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.hyperimage.client.HIRuntime;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiInscription;
import org.hyperimage.client.ws.HiObjectContent;
import org.hyperimage.client.ws.HiProject;

public class ObjectContentTransferable
implements Transferable {
    private HiObjectContent content;
    public static final DataFlavor objecContentFlavor = new DataFlavor("application/x-java-jvm-local-objectref;" + HiObjectContent.class.toString().replaceAll(" ", "="), "HyperImage Object Content");

    public ObjectContentTransferable(HiObjectContent content) {
        this.content = content;
    }

    private String getId() {
        if (this.content instanceof HiInscription) {
            return "Inschrift I" + this.content.getId();
        }
        return "Ansicht V" + this.content.getId();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            HiProject project = null;
            if (HIRuntime.getManager() != null) {
                project = HIRuntime.getManager().getProject();
            }
            if (project == null) {
                return this.getId();
            }
            String title = MetadataHelper.findValue("HIBase", "title", MetadataHelper.getDefaultMetadataRecord((HiBase)this.content, HIRuntime.getManager().getProject().getDefaultLanguage().getLanguageId()));
            if (title == null || title.length() == 0) {
                return this.getId();
            }
            return title;
        }
        if (flavor == objecContentFlavor) {
            return this.content;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, objecContentFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor || flavor == objecContentFlavor;
    }
}

