/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.hyperimage.client.gui.dnd.ContentTransfer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiQuickInfo;

public class QuickInfoTransferable
implements Transferable {
    public static final DataFlavor quickInfoFlavor = new DataFlavor("application/x-java-jvm-local-objectref;" + HiQuickInfo.class.toString().replaceAll(" ", "="), "HyperImage Quick Info");
    private ContentTransfer transfer;

    public QuickInfoTransferable(ContentTransfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            if (this.transfer.getContents().size() == 1) {
                String title = this.transfer.getContents().get(0).getTitle();
                if (title.length() > 0) {
                    return title;
                }
                return "ID " + MetadataHelper.getDisplayableID(this.transfer.getContents().get(0));
            }
            return String.valueOf(this.transfer.getContents().size()) + " Elemente";
        }
        if (flavor == quickInfoFlavor) {
            return this.transfer;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, quickInfoFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor || flavor == quickInfoFlavor;
    }
}

