/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.hyperimage.client.gui.lists.TemplateListCellRenderer;
import org.hyperimage.client.ws.HiFlexMetadataTemplate;

public class TemplateTransferable
implements Transferable {
    public static final DataFlavor templateFlavor = new DataFlavor("application/x-java-jvm-local-objectref;" + HiFlexMetadataTemplate.class.toString().replaceAll(" ", "="), "HyperImage Template");
    private HiFlexMetadataTemplate template;

    public TemplateTransferable(HiFlexMetadataTemplate template) {
        this.template = template;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            String title = TemplateListCellRenderer.getTemplateName(this.template);
            return title;
        }
        if (flavor == templateFlavor) {
            return this.template;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, templateFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor || flavor == templateFlavor;
    }
}

