/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.hyperimage.client.Messages;
import org.hyperimage.client.gui.lists.LayerListCellRenderer;

public class ColorListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 7949103832494614959L;
    private JLabel cellLabel = new JLabel();
    private Vector<Color> projectColors;
    private JComboBox box;

    public ColorListCellRenderer(Vector<Color> projectColors, JComboBox box) {
        this.box = box;
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setBorder(new EmptyBorder(3, 5, 3, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
        this.projectColors = projectColors;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color color = (Color)value;
        color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        if (index == -1 && this.box != null) {
            index = this.box.getSelectedIndex();
        }
        this.cellLabel.setIcon(LayerListCellRenderer.renderColorBarIcon(color));
        if (index < this.projectColors.size() || this.box == null) {
            this.cellLabel.setText(String.valueOf(index + 1) + " (" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")");
        } else {
            this.cellLabel.setText(Messages.getString("LayerPropertyEditorView.50"));
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.setOpaque(true);
        this.cellLabel.setOpaque(true);
        return this;
    }
}

