/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.gui.lists.GroupContentsList;
import org.hyperimage.client.gui.lists.QuickInfoCell;
import org.hyperimage.client.gui.lists.QuickInfoListCell;
import org.hyperimage.client.ws.HiQuickInfo;

public class GroupContentsCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = -1965469051301621847L;
    private GroupContentsList.HI_ListDisplayStyles style = GroupContentsList.HI_ListDisplayStyles.ICON_STYLE;
    private HashMap<HiQuickInfo, QuickInfoCell> cellCache = new HashMap();

    public void updateLanguage() {
        for (QuickInfoCell cell : this.cellCache.values()) {
            cell.updateLanguage();
        }
    }

    public QuickInfoCell getCellForContent(HiQuickInfo info) {
        if (this.style != GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            return null;
        }
        QuickInfoCell cell = this.cellCache.get(info);
        if (cell == null) {
            cell = new QuickInfoCell(info);
            this.cellCache.put(info, cell);
        }
        return cell;
    }

    public void removeContentFromCache(HiQuickInfo info) {
        this.cellCache.remove(info);
    }

    public void clearCache() {
        this.cellCache.clear();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        if (this.style == GroupContentsList.HI_ListDisplayStyles.ICON_STYLE) {
            this.setBackground(Color.LIGHT_GRAY);
            QuickInfoCell cell = this.cellCache.get((HiQuickInfo)list.getModel().getElementAt(index));
            if (cell == null) {
                cell = new QuickInfoCell((HiQuickInfo)list.getModel().getElementAt(index));
                this.cellCache.put((HiQuickInfo)list.getModel().getElementAt(index), cell);
            }
            cell.setOpaque(true);
            cell.setSelected(isSelected);
            this.add(cell);
        } else {
            QuickInfoListCell cell = new QuickInfoListCell((HiQuickInfo)list.getModel().getElementAt(index));
            if (index % 2 != 0) {
                cell.setBackground(new Color(200, 200, 255));
            }
            cell.setOpaque(true);
            cell.setSelected(isSelected);
            this.add((Component)cell, "Center");
        }
        this.setOpaque(true);
        return this;
    }

    public GroupContentsList.HI_ListDisplayStyles getDisplayStyle() {
        return this.style;
    }

    public void setDisplayStyle(GroupContentsList.HI_ListDisplayStyles style) {
        this.style = style;
        if (style == GroupContentsList.HI_ListDisplayStyles.LIST_STYLE) {
            this.setLayout(new BorderLayout());
        } else {
            this.setLayout(new FlowLayout());
        }
    }
}

