/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.Messages;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiGroup;

public class GroupListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 7602833818020929120L;
    private JLabel cellLabel = new JLabel();
    private HiGroup importGroup;
    private HiGroup trashGroup;
    private String defaultLang;
    private JSeparator separator = new JSeparator();
    private int dropIndex = -1;

    public GroupListCellRenderer(HiGroup importGroup, HiGroup trashGroup, String defaultLang) {
        this.importGroup = importGroup;
        this.trashGroup = trashGroup;
        this.defaultLang = defaultLang;
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public void resetGroups(HiGroup importGroup, HiGroup trashGroup) {
        this.importGroup = importGroup;
        this.trashGroup = trashGroup;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HiGroup group = (HiGroup)value;
        this.remove(this.separator);
        if (group.getId() == this.importGroup.getId()) {
            this.add((Component)this.separator, "South");
            this.cellLabel.setText("<html>" + Messages.getString("GroupListCellRenderer.1") + "</html>");
            this.cellLabel.setIcon(null);
            this.cellLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/import-icon.png")));
        } else if (group.getId() == this.trashGroup.getId()) {
            this.add((Component)this.separator, "North");
            this.cellLabel.setText("<html>" + Messages.getString("GroupListCellRenderer.4") + "</html>");
            this.cellLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/trashcan-icon.png")));
        } else {
            HiFlexMetadataRecord record;
            String id = "G" + group.getId();
            if (group.getUUID() != null) {
                id = group.getUUID();
            }
            if ((record = MetadataHelper.getDefaultMetadataRecord((HiBase)group, this.defaultLang)) != null) {
                String title = MetadataHelper.findValue("HIBase", "title", record);
                if (title != null && title.length() > 0) {
                    this.cellLabel.setText(title);
                } else {
                    this.cellLabel.setText(String.valueOf(Messages.getString("GroupListCellRenderer.9")) + " (" + id + ")");
                }
            } else {
                this.cellLabel.setText(String.valueOf(Messages.getString("GroupListCellRenderer.12")) + " (" + id + ")");
            }
            this.cellLabel.setIcon(null);
        }
        if (isSelected) {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (list.getDropLocation() != null && index == list.getDropLocation().getIndex() && !list.getDropLocation().isInsert()) {
            this.cellLabel.setBackground(Color.green);
            this.cellLabel.setForeground(list.getSelectionForeground());
            if (list.getDropLocation() != null && this.dropIndex != list.getDropLocation().getIndex()) {
                this.dropIndex = list.getDropLocation().getIndex();
                list.repaint();
            }
        }
        if (list.getDropLocation() == null && this.dropIndex >= 0) {
            this.dropIndex = -1;
            list.repaint();
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

