/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class LanguageListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 5052209063030507440L;
    private JLabel cellLabel = new JLabel();

    public LanguageListCellRenderer() {
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Locale lang = (Locale)value;
        if (lang != null) {
            String dispLang;
            String langID = lang.getLanguage();
            if (lang.getCountry().length() > 0 && !lang.getCountry().equalsIgnoreCase(langID)) {
                langID = String.valueOf(langID) + "_" + lang.getCountry();
                dispLang = String.valueOf(lang.getDisplayLanguage()) + "-" + lang.getDisplayCountry();
            } else {
                dispLang = lang.getDisplayLanguage();
            }
            langID = langID.toLowerCase();
            this.cellLabel.setText(String.valueOf(dispLang) + " (" + langID + ")");
        } else {
            this.cellLabel.setText("(n. A.)");
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

