/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.client.gui.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.hyperimage.client.Messages;
import org.hyperimage.client.model.HILayer;
import org.hyperimage.client.util.MetadataHelper;
import org.hyperimage.client.ws.HiBase;
import org.hyperimage.client.ws.HiFlexMetadataRecord;
import org.hyperimage.client.ws.HiLayer;

public class LayerListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = -6994190696912376656L;
    private JLabel cellLabel = new JLabel();
    private String defaultLang;

    public LayerListCellRenderer(String defaultLang) {
        this.defaultLang = defaultLang;
        this.cellLabel.setFont(this.cellLabel.getFont().deriveFont(12.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cellLabel, "Center");
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public static ImageIcon renderColorBarIcon(Color color) {
        BufferedImage colorImage = new BufferedImage(15, 10, 1);
        Graphics2D g2d = colorImage.createGraphics();
        g2d.setColor(color);
        g2d.fillRect(0, 0, 15, 10);
        g2d.draw3DRect(0, 0, 15, 10, true);
        return new ImageIcon(colorImage);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HiFlexMetadataRecord record;
        HiLayer layer = null;
        HILayer wrappedLayer = null;
        if (value instanceof HILayer) {
            layer = ((HILayer)value).getModel();
            wrappedLayer = (HILayer)value;
        } else if (value instanceof HiLayer) {
            layer = (HiLayer)value;
        }
        String id = "L" + layer.getId();
        if (layer.getUUID() != null) {
            id = layer.getUUID();
        }
        if ((record = MetadataHelper.getDefaultMetadataRecord((HiBase)layer, this.defaultLang)) != null) {
            String title = MetadataHelper.findValue("HIBase", "title", record);
            if (title == null) {
                this.cellLabel.setText(String.valueOf(Messages.getString("LayerListCellRenderer.layer")) + " (" + id + ")");
            } else if (title.length() == 0) {
                this.cellLabel.setText(String.valueOf(Messages.getString("LayerListCellRenderer.layer")) + " (" + id + ")");
            } else {
                this.cellLabel.setText(title);
            }
        } else {
            this.cellLabel.setText(String.valueOf(Messages.getString("LayerListCellRenderer.layer")) + " (" + id + ")");
        }
        this.cellLabel.setIcon(null);
        if (wrappedLayer == null) {
            this.cellLabel.setIcon(LayerListCellRenderer.renderColorBarIcon(new Color(layer.getRed(), layer.getGreen(), layer.getBlue())));
        } else {
            this.cellLabel.setIcon(LayerListCellRenderer.renderColorBarIcon(wrappedLayer.getSolidColour()));
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.cellLabel.setBackground(list.getSelectionBackground());
            this.cellLabel.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.cellLabel.setBackground(list.getBackground());
            this.cellLabel.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.cellLabel.setEnabled(list.isEnabled());
        this.cellLabel.setOpaque(true);
        this.setOpaque(true);
        return this;
    }
}

